/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import net.minecraft.server.Block;
import net.minecraft.server.CrashReport;
import net.minecraft.server.CrashReportItemName;
import net.minecraft.server.CrashReportSystemDetails;
import net.minecraft.server.EntityHuman;
import net.minecraft.server.IInventory;
import net.minecraft.server.ItemArmor;
import net.minecraft.server.ItemStack;
import net.minecraft.server.NBTTagCompound;
import net.minecraft.server.NBTTagList;
import net.minecraft.server.ReportedException;

public class PlayerInventory
implements IInventory {
    public ItemStack[] items = new ItemStack[36];
    public ItemStack[] armor = new ItemStack[4];
    public int itemInHandIndex;
    public EntityHuman player;
    private ItemStack g;
    public boolean e;

    public PlayerInventory(EntityHuman entityHuman) {
        this.player = entityHuman;
    }

    public ItemStack getItemInHand() {
        if (this.itemInHandIndex < 9 && this.itemInHandIndex >= 0) {
            return this.items[this.itemInHandIndex];
        }
        return null;
    }

    public static int getHotbarSize() {
        return 9;
    }

    private int g(int n) {
        for (int i = 0; i < this.items.length; ++i) {
            if (this.items[i] == null || this.items[i].id != n) continue;
            return i;
        }
        return -1;
    }

    private int firstPartial(ItemStack itemStack) {
        for (int i = 0; i < this.items.length; ++i) {
            if (this.items[i] == null || this.items[i].id != itemStack.id || !this.items[i].isStackable() || this.items[i].count >= this.items[i].getMaxStackSize() || this.items[i].count >= this.getMaxStackSize() || this.items[i].usesData() && this.items[i].getData() != itemStack.getData() || !ItemStack.equals(this.items[i], itemStack)) continue;
            return i;
        }
        return -1;
    }

    public int j() {
        for (int i = 0; i < this.items.length; ++i) {
            if (this.items[i] != null) continue;
            return i;
        }
        return -1;
    }

    public int b(int n, int n2) {
        ItemStack itemStack;
        int n3;
        int n4 = 0;
        for (n3 = 0; n3 < this.items.length; ++n3) {
            itemStack = this.items[n3];
            if (itemStack == null || n > -1 && itemStack.id != n || n2 > -1 && itemStack.getData() != n2) continue;
            n4 += itemStack.count;
            this.items[n3] = null;
        }
        for (n3 = 0; n3 < this.armor.length; ++n3) {
            itemStack = this.armor[n3];
            if (itemStack == null || n > -1 && itemStack.id != n || n2 > -1 && itemStack.getData() != n2) continue;
            n4 += itemStack.count;
            this.armor[n3] = null;
        }
        if (this.g != null) {
            if (n > -1 && this.g.id != n) {
                return n4;
            }
            if (n2 > -1 && this.g.getData() != n2) {
                return n4;
            }
            n4 += this.g.count;
            this.setCarried(null);
        }
        return n4;
    }

    private int e(ItemStack itemStack) {
        int n;
        int n2 = itemStack.id;
        int n3 = itemStack.count;
        if (itemStack.getMaxStackSize() == 1) {
            int n4 = this.j();
            if (n4 < 0) {
                return n3;
            }
            if (this.items[n4] == null) {
                this.items[n4] = ItemStack.b(itemStack);
            }
            return 0;
        }
        int n5 = this.firstPartial(itemStack);
        if (n5 < 0) {
            n5 = this.j();
        }
        if (n5 < 0) {
            return n3;
        }
        if (this.items[n5] == null) {
            this.items[n5] = new ItemStack(n2, 0, itemStack.getData());
            if (itemStack.hasTag()) {
                this.items[n5].setTag((NBTTagCompound)itemStack.getTag().clone());
            }
        }
        if ((n = n3) > this.items[n5].getMaxStackSize() - this.items[n5].count) {
            n = this.items[n5].getMaxStackSize() - this.items[n5].count;
        }
        if (n > this.getMaxStackSize() - this.items[n5].count) {
            n = this.getMaxStackSize() - this.items[n5].count;
        }
        if (n == 0) {
            return n3;
        }
        this.items[n5].count += n;
        this.items[n5].c = 5;
        return n3 -= n;
    }

    public void k() {
        for (int i = 0; i < this.items.length; ++i) {
            if (this.items[i] == null) continue;
            this.items[i].a(this.player.world, this.player, i, this.itemInHandIndex == i);
        }
    }

    public boolean d(int n) {
        int n2 = this.g(n);
        if (n2 < 0) {
            return false;
        }
        if (--this.items[n2].count <= 0) {
            this.items[n2] = null;
        }
        return true;
    }

    public boolean e(int n) {
        int n2 = this.g(n);
        return n2 >= 0;
    }

    public boolean pickup(ItemStack itemStack) {
        if (itemStack == null) {
            return false;
        }
        if (itemStack.count == 0) {
            return false;
        }
        try {
            if (!itemStack.i()) {
                int n;
                do {
                    n = itemStack.count;
                    itemStack.count = this.e(itemStack);
                } while (itemStack.count > 0 && itemStack.count < n);
                if (itemStack.count == n && this.player.abilities.canInstantlyBuild) {
                    itemStack.count = 0;
                    return true;
                }
                return itemStack.count < n;
            }
            int n = this.j();
            if (n >= 0) {
                this.items[n] = ItemStack.b(itemStack);
                this.items[n].c = 5;
                itemStack.count = 0;
                return true;
            }
            if (this.player.abilities.canInstantlyBuild) {
                itemStack.count = 0;
                return true;
            }
            return false;
        }
        catch (Throwable throwable) {
            CrashReport crashReport = CrashReport.a(throwable, "Adding item to inventory");
            CrashReportSystemDetails crashReportSystemDetails = crashReport.a("Item being added");
            crashReportSystemDetails.a("Item ID", itemStack.id);
            crashReportSystemDetails.a("Item data", itemStack.getData());
            crashReportSystemDetails.a("Item name", new CrashReportItemName(this, itemStack));
            throw new ReportedException(crashReport);
        }
    }

    @Override
    public ItemStack splitStack(int n, int n2) {
        ItemStack[] itemStackArray = this.items;
        if (n >= this.items.length) {
            itemStackArray = this.armor;
            n -= this.items.length;
        }
        if (itemStackArray[n] != null) {
            if (itemStackArray[n].count <= n2) {
                ItemStack itemStack = itemStackArray[n];
                itemStackArray[n] = null;
                return itemStack;
            }
            ItemStack itemStack = itemStackArray[n].a(n2);
            if (itemStackArray[n].count == 0) {
                itemStackArray[n] = null;
            }
            return itemStack;
        }
        return null;
    }

    @Override
    public ItemStack splitWithoutUpdate(int n) {
        ItemStack[] itemStackArray = this.items;
        if (n >= this.items.length) {
            itemStackArray = this.armor;
            n -= this.items.length;
        }
        if (itemStackArray[n] != null) {
            ItemStack itemStack = itemStackArray[n];
            itemStackArray[n] = null;
            return itemStack;
        }
        return null;
    }

    @Override
    public void setItem(int n, ItemStack itemStack) {
        ItemStack[] itemStackArray = this.items;
        if (n >= itemStackArray.length) {
            n -= itemStackArray.length;
            itemStackArray = this.armor;
        }
        itemStackArray[n] = itemStack;
    }

    public float a(Block block) {
        float f = 1.0f;
        if (this.items[this.itemInHandIndex] != null) {
            f *= this.items[this.itemInHandIndex].a(block);
        }
        return f;
    }

    public NBTTagList a(NBTTagList nBTTagList) {
        NBTTagCompound nBTTagCompound;
        int n;
        for (n = 0; n < this.items.length; ++n) {
            if (this.items[n] == null) continue;
            nBTTagCompound = new NBTTagCompound();
            nBTTagCompound.setByte("Slot", (byte)n);
            this.items[n].save(nBTTagCompound);
            nBTTagList.add(nBTTagCompound);
        }
        for (n = 0; n < this.armor.length; ++n) {
            if (this.armor[n] == null) continue;
            nBTTagCompound = new NBTTagCompound();
            nBTTagCompound.setByte("Slot", (byte)(n + 100));
            this.armor[n].save(nBTTagCompound);
            nBTTagList.add(nBTTagCompound);
        }
        return nBTTagList;
    }

    public void b(NBTTagList nBTTagList) {
        this.items = new ItemStack[36];
        this.armor = new ItemStack[4];
        for (int i = 0; i < nBTTagList.size(); ++i) {
            NBTTagCompound nBTTagCompound = (NBTTagCompound)nBTTagList.get(i);
            int n = nBTTagCompound.getByte("Slot") & 0xFF;
            ItemStack itemStack = ItemStack.createStack(nBTTagCompound);
            if (itemStack == null) continue;
            if (n >= 0 && n < this.items.length) {
                this.items[n] = itemStack;
            }
            if (n < 100 || n >= this.armor.length + 100) continue;
            this.armor[n - 100] = itemStack;
        }
    }

    @Override
    public int getSize() {
        return this.items.length + 4;
    }

    @Override
    public ItemStack getItem(int n) {
        ItemStack[] itemStackArray = this.items;
        if (n >= itemStackArray.length) {
            n -= itemStackArray.length;
            itemStackArray = this.armor;
        }
        return itemStackArray[n];
    }

    @Override
    public String getName() {
        return "container.inventory";
    }

    @Override
    public boolean c() {
        return false;
    }

    @Override
    public int getMaxStackSize() {
        return 64;
    }

    public boolean b(Block block) {
        if (block.material.isAlwaysDestroyable()) {
            return true;
        }
        ItemStack itemStack = this.getItem(this.itemInHandIndex);
        if (itemStack != null) {
            return itemStack.b(block);
        }
        return false;
    }

    public ItemStack f(int n) {
        return this.armor[n];
    }

    public int l() {
        int n = 0;
        for (int i = 0; i < this.armor.length; ++i) {
            if (this.armor[i] == null || !(this.armor[i].getItem() instanceof ItemArmor)) continue;
            int n2 = ((ItemArmor)this.armor[i].getItem()).c;
            n += n2;
        }
        return n;
    }

    public void a(float f) {
        if ((f /= 4.0f) < 1.0f) {
            f = 1.0f;
        }
        for (int i = 0; i < this.armor.length; ++i) {
            if (this.armor[i] == null || !(this.armor[i].getItem() instanceof ItemArmor)) continue;
            this.armor[i].damage((int)f, this.player);
            if (this.armor[i].count != 0) continue;
            this.armor[i] = null;
        }
    }

    public void m() {
        int n;
        for (n = 0; n < this.items.length; ++n) {
            if (this.items[n] == null) continue;
            this.player.a(this.items[n], true);
            this.items[n] = null;
        }
        for (n = 0; n < this.armor.length; ++n) {
            if (this.armor[n] == null) continue;
            this.player.a(this.armor[n], true);
            this.armor[n] = null;
        }
    }

    @Override
    public void update() {
        this.e = true;
    }

    public void setCarried(ItemStack itemStack) {
        this.g = itemStack;
    }

    public ItemStack getCarried() {
        return this.g;
    }

    @Override
    public boolean a(EntityHuman entityHuman) {
        if (this.player.dead) {
            return false;
        }
        return !(entityHuman.e(this.player) > 64.0);
    }

    public boolean c(ItemStack itemStack) {
        int n;
        for (n = 0; n < this.armor.length; ++n) {
            if (this.armor[n] == null || !this.armor[n].doMaterialsMatch(itemStack)) continue;
            return true;
        }
        for (n = 0; n < this.items.length; ++n) {
            if (this.items[n] == null || !this.items[n].doMaterialsMatch(itemStack)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void startOpen() {
    }

    @Override
    public void g() {
    }

    @Override
    public boolean b(int n, ItemStack itemStack) {
        return true;
    }

    public void b(PlayerInventory playerInventory) {
        int n;
        for (n = 0; n < this.items.length; ++n) {
            this.items[n] = ItemStack.b(playerInventory.items[n]);
        }
        for (n = 0; n < this.armor.length; ++n) {
            this.armor[n] = ItemStack.b(playerInventory.armor[n]);
        }
        this.itemInHandIndex = playerInventory.itemInHandIndex;
    }
}

