/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.server.AxisAlignedBB;
import net.minecraft.server.BanEntry;
import net.minecraft.server.ChatMessage;
import net.minecraft.server.Connection;
import net.minecraft.server.Container;
import net.minecraft.server.ContainerAnvil;
import net.minecraft.server.ContainerBeacon;
import net.minecraft.server.ContainerMerchant;
import net.minecraft.server.CrashReport;
import net.minecraft.server.CrashReportConnectionPacketClass;
import net.minecraft.server.CrashReportConnectionPacketID;
import net.minecraft.server.CrashReportSystemDetails;
import net.minecraft.server.Entity;
import net.minecraft.server.EntityArrow;
import net.minecraft.server.EntityExperienceOrb;
import net.minecraft.server.EntityHorse;
import net.minecraft.server.EntityHuman;
import net.minecraft.server.EntityItem;
import net.minecraft.server.EntityPlayer;
import net.minecraft.server.EnumChatFormat;
import net.minecraft.server.INetworkManager;
import net.minecraft.server.IntHashMap;
import net.minecraft.server.Item;
import net.minecraft.server.ItemBookAndQuill;
import net.minecraft.server.ItemStack;
import net.minecraft.server.ItemWrittenBook;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.NBTTagString;
import net.minecraft.server.Packet;
import net.minecraft.server.Packet0KeepAlive;
import net.minecraft.server.Packet101CloseWindow;
import net.minecraft.server.Packet102WindowClick;
import net.minecraft.server.Packet103SetSlot;
import net.minecraft.server.Packet106Transaction;
import net.minecraft.server.Packet107SetCreativeSlot;
import net.minecraft.server.Packet108ButtonClick;
import net.minecraft.server.Packet10Flying;
import net.minecraft.server.Packet130UpdateSign;
import net.minecraft.server.Packet13PlayerLookMove;
import net.minecraft.server.Packet14BlockDig;
import net.minecraft.server.Packet15Place;
import net.minecraft.server.Packet16BlockItemSwitch;
import net.minecraft.server.Packet18ArmAnimation;
import net.minecraft.server.Packet19EntityAction;
import net.minecraft.server.Packet202Abilities;
import net.minecraft.server.Packet203TabComplete;
import net.minecraft.server.Packet204LocaleAndViewDistance;
import net.minecraft.server.Packet205ClientCommand;
import net.minecraft.server.Packet250CustomPayload;
import net.minecraft.server.Packet255KickDisconnect;
import net.minecraft.server.Packet27PlayerInput;
import net.minecraft.server.Packet3Chat;
import net.minecraft.server.Packet53BlockChange;
import net.minecraft.server.Packet7UseEntity;
import net.minecraft.server.Packet9Respawn;
import net.minecraft.server.PlayerInventory;
import net.minecraft.server.ReportedException;
import net.minecraft.server.SharedConstants;
import net.minecraft.server.Slot;
import net.minecraft.server.TileEntity;
import net.minecraft.server.TileEntityBeacon;
import net.minecraft.server.TileEntityCommand;
import net.minecraft.server.TileEntitySign;
import net.minecraft.server.WorldServer;
import org.apache.commons.lang3.StringUtils;

public class PlayerConnection
extends Connection {
    public final INetworkManager networkManager;
    private final MinecraftServer minecraftServer;
    public boolean disconnected;
    public EntityPlayer player;
    private int e;
    private int f;
    private boolean g;
    private int h;
    private long i;
    private static Random j = new Random();
    private long k;
    private int chatThrottle;
    private int x;
    private double y;
    private double z;
    private double p;
    private boolean checkMovement = true;
    private IntHashMap r = new IntHashMap();

    public PlayerConnection(MinecraftServer minecraftServer, INetworkManager iNetworkManager, EntityPlayer entityPlayer) {
        this.minecraftServer = minecraftServer;
        this.networkManager = iNetworkManager;
        iNetworkManager.a(this);
        this.player = entityPlayer;
        entityPlayer.playerConnection = this;
    }

    public void e() {
        this.g = false;
        ++this.e;
        this.minecraftServer.methodProfiler.a("packetflow");
        this.networkManager.b();
        this.minecraftServer.methodProfiler.c("keepAlive");
        if ((long)this.e - this.k > 20L) {
            this.k = this.e;
            this.i = System.nanoTime() / 1000000L;
            this.h = j.nextInt();
            this.sendPacket(new Packet0KeepAlive(this.h));
        }
        if (this.chatThrottle > 0) {
            --this.chatThrottle;
        }
        if (this.x > 0) {
            --this.x;
        }
        this.minecraftServer.methodProfiler.c("playerTick");
        this.minecraftServer.methodProfiler.b();
    }

    public void disconnect(String string) {
        if (this.disconnected) {
            return;
        }
        this.player.l();
        this.sendPacket(new Packet255KickDisconnect(string));
        this.networkManager.d();
        this.minecraftServer.getPlayerList().sendMessage(ChatMessage.b("multiplayer.player.left", this.player.getScoreboardDisplayName()).a(EnumChatFormat.YELLOW));
        this.minecraftServer.getPlayerList().disconnect(this.player);
        this.disconnected = true;
    }

    @Override
    public void a(Packet27PlayerInput packet27PlayerInput) {
        this.player.a(packet27PlayerInput.d(), packet27PlayerInput.f(), packet27PlayerInput.g(), packet27PlayerInput.h());
    }

    @Override
    public void a(Packet10Flying packet10Flying) {
        double d;
        WorldServer worldServer = this.minecraftServer.getWorldServer(this.player.dimension);
        this.g = true;
        if (this.player.viewingCredits) {
            return;
        }
        if (!this.checkMovement) {
            d = packet10Flying.y - this.z;
            if (packet10Flying.x == this.y && d * d < 0.01 && packet10Flying.z == this.p) {
                this.checkMovement = true;
            }
        }
        if (this.checkMovement) {
            double d2;
            double d3;
            double d4;
            if (this.player.vehicle != null) {
                float f = this.player.yaw;
                float f2 = this.player.pitch;
                this.player.vehicle.W();
                double d5 = this.player.locX;
                double d6 = this.player.locY;
                double d7 = this.player.locZ;
                if (packet10Flying.hasLook) {
                    f = packet10Flying.yaw;
                    f2 = packet10Flying.pitch;
                }
                this.player.onGround = packet10Flying.g;
                this.player.h();
                this.player.X = 0.0f;
                this.player.setLocation(d5, d6, d7, f, f2);
                if (this.player.vehicle != null) {
                    this.player.vehicle.W();
                }
                this.minecraftServer.getPlayerList().d(this.player);
                if (this.checkMovement) {
                    this.y = this.player.locX;
                    this.z = this.player.locY;
                    this.p = this.player.locZ;
                }
                worldServer.playerJoinedWorld(this.player);
                return;
            }
            if (this.player.isSleeping()) {
                this.player.h();
                this.player.setLocation(this.y, this.z, this.p, this.player.yaw, this.player.pitch);
                worldServer.playerJoinedWorld(this.player);
                return;
            }
            d = this.player.locY;
            this.y = this.player.locX;
            this.z = this.player.locY;
            this.p = this.player.locZ;
            double d8 = this.player.locX;
            double d9 = this.player.locY;
            double d10 = this.player.locZ;
            float f = this.player.yaw;
            float f3 = this.player.pitch;
            if (packet10Flying.hasPos && packet10Flying.y == -999.0 && packet10Flying.stance == -999.0) {
                packet10Flying.hasPos = false;
            }
            if (packet10Flying.hasPos) {
                d8 = packet10Flying.x;
                d9 = packet10Flying.y;
                d10 = packet10Flying.z;
                d4 = packet10Flying.stance - packet10Flying.y;
                if (!this.player.isSleeping() && (d4 > 1.65 || d4 < 0.1)) {
                    this.disconnect("Illegal stance");
                    this.minecraftServer.getLogger().warning(this.player.getName() + " had an illegal stance: " + d4);
                    return;
                }
                if (Math.abs(packet10Flying.x) > 3.2E7 || Math.abs(packet10Flying.z) > 3.2E7) {
                    this.disconnect("Illegal position");
                    return;
                }
            }
            if (packet10Flying.hasLook) {
                f = packet10Flying.yaw;
                f3 = packet10Flying.pitch;
            }
            this.player.h();
            this.player.X = 0.0f;
            this.player.setLocation(this.y, this.z, this.p, f, f3);
            if (!this.checkMovement) {
                return;
            }
            d4 = d8 - this.player.locX;
            double d11 = d9 - this.player.locY;
            double d12 = d10 - this.player.locZ;
            double d13 = Math.min(Math.abs(d4), Math.abs(this.player.motX));
            double d14 = d13 * d13 + (d3 = Math.min(Math.abs(d11), Math.abs(this.player.motY))) * d3 + (d2 = Math.min(Math.abs(d12), Math.abs(this.player.motZ))) * d2;
            if (!(!(d14 > 100.0) || this.minecraftServer.K() && this.minecraftServer.J().equals(this.player.getName()))) {
                this.minecraftServer.getLogger().warning(this.player.getName() + " moved too quickly! " + d4 + "," + d11 + "," + d12 + " (" + d13 + ", " + d3 + ", " + d2 + ")");
                this.a(this.y, this.z, this.p, this.player.yaw, this.player.pitch);
                return;
            }
            float f4 = 0.0625f;
            boolean bl = worldServer.getCubes(this.player, this.player.boundingBox.clone().shrink(f4, f4, f4)).isEmpty();
            if (this.player.onGround && !packet10Flying.g && d11 > 0.0) {
                this.player.a(0.2f);
            }
            this.player.move(d4, d11, d12);
            this.player.onGround = packet10Flying.g;
            this.player.checkMovement(d4, d11, d12);
            double d15 = d11;
            d4 = d8 - this.player.locX;
            d11 = d9 - this.player.locY;
            if (d11 > -0.5 || d11 < 0.5) {
                d11 = 0.0;
            }
            d12 = d10 - this.player.locZ;
            d14 = d4 * d4 + d11 * d11 + d12 * d12;
            boolean bl2 = false;
            if (d14 > 0.0625 && !this.player.isSleeping() && !this.player.playerInteractManager.isCreative()) {
                bl2 = true;
                this.minecraftServer.getLogger().warning(this.player.getName() + " moved wrongly!");
            }
            this.player.setLocation(d8, d9, d10, f, f3);
            boolean bl3 = worldServer.getCubes(this.player, this.player.boundingBox.clone().shrink(f4, f4, f4)).isEmpty();
            if (bl && (bl2 || !bl3) && !this.player.isSleeping()) {
                this.a(this.y, this.z, this.p, f, f3);
                return;
            }
            AxisAlignedBB axisAlignedBB = this.player.boundingBox.clone().grow(f4, f4, f4).a(0.0, -0.55, 0.0);
            if (!(this.minecraftServer.getAllowFlight() || this.player.playerInteractManager.isCreative() || worldServer.c(axisAlignedBB))) {
                if (d15 >= -0.03125) {
                    ++this.f;
                    if (this.f > 80) {
                        this.minecraftServer.getLogger().warning(this.player.getName() + " was kicked for floating too long!");
                        this.disconnect("Flying is not enabled on this server");
                        return;
                    }
                }
            } else {
                this.f = 0;
            }
            this.player.onGround = packet10Flying.g;
            this.minecraftServer.getPlayerList().d(this.player);
            this.player.b(this.player.locY - d, packet10Flying.g);
        } else if (this.e % 20 == 0) {
            this.a(this.y, this.z, this.p, this.player.yaw, this.player.pitch);
        }
    }

    public void a(double d, double d2, double d3, float f, float f2) {
        this.checkMovement = false;
        this.y = d;
        this.z = d2;
        this.p = d3;
        this.player.setLocation(d, d2, d3, f, f2);
        this.player.playerConnection.sendPacket(new Packet13PlayerLookMove(d, d2 + (double)1.62f, d2, d3, f, f2, false));
    }

    @Override
    public void a(Packet14BlockDig packet14BlockDig) {
        WorldServer worldServer = this.minecraftServer.getWorldServer(this.player.dimension);
        this.player.u();
        if (packet14BlockDig.e == 4) {
            this.player.a(false);
            return;
        }
        if (packet14BlockDig.e == 3) {
            this.player.a(true);
            return;
        }
        if (packet14BlockDig.e == 5) {
            this.player.bt();
            return;
        }
        boolean bl = false;
        if (packet14BlockDig.e == 0) {
            bl = true;
        }
        if (packet14BlockDig.e == 1) {
            bl = true;
        }
        if (packet14BlockDig.e == 2) {
            bl = true;
        }
        int n = packet14BlockDig.a;
        int n2 = packet14BlockDig.b;
        int n3 = packet14BlockDig.c;
        if (bl) {
            double d = this.player.locX - ((double)n + 0.5);
            double d2 = this.player.locY - ((double)n2 + 0.5) + 1.5;
            double d3 = this.player.locZ - ((double)n3 + 0.5);
            double d4 = d * d + d2 * d2 + d3 * d3;
            if (d4 > 36.0) {
                return;
            }
            if (n2 >= this.minecraftServer.getMaxBuildHeight()) {
                return;
            }
        }
        if (packet14BlockDig.e == 0) {
            if (!this.minecraftServer.a(worldServer, n, n2, n3, this.player)) {
                this.player.playerInteractManager.dig(n, n2, n3, packet14BlockDig.face);
            } else {
                this.player.playerConnection.sendPacket(new Packet53BlockChange(n, n2, n3, worldServer));
            }
        } else if (packet14BlockDig.e == 2) {
            this.player.playerInteractManager.a(n, n2, n3);
            if (worldServer.getTypeId(n, n2, n3) != 0) {
                this.player.playerConnection.sendPacket(new Packet53BlockChange(n, n2, n3, worldServer));
            }
        } else if (packet14BlockDig.e == 1) {
            this.player.playerInteractManager.c(n, n2, n3);
            if (worldServer.getTypeId(n, n2, n3) != 0) {
                this.player.playerConnection.sendPacket(new Packet53BlockChange(n, n2, n3, worldServer));
            }
        }
    }

    @Override
    public void a(Packet15Place packet15Place) {
        WorldServer worldServer = this.minecraftServer.getWorldServer(this.player.dimension);
        ItemStack itemStack = this.player.inventory.getItemInHand();
        boolean bl = false;
        int n = packet15Place.d();
        int n2 = packet15Place.f();
        int n3 = packet15Place.g();
        int n4 = packet15Place.getFace();
        this.player.u();
        if (packet15Place.getFace() == 255) {
            if (itemStack == null) {
                return;
            }
            this.player.playerInteractManager.useItem(this.player, worldServer, itemStack);
        } else if (packet15Place.f() < this.minecraftServer.getMaxBuildHeight() - 1 || packet15Place.getFace() != 1 && packet15Place.f() < this.minecraftServer.getMaxBuildHeight()) {
            if (this.checkMovement && this.player.e((double)n + 0.5, (double)n2 + 0.5, (double)n3 + 0.5) < 64.0 && !this.minecraftServer.a(worldServer, n, n2, n3, this.player)) {
                this.player.playerInteractManager.interact(this.player, worldServer, itemStack, n, n2, n3, n4, packet15Place.j(), packet15Place.k(), packet15Place.l());
            }
            bl = true;
        } else {
            this.player.playerConnection.sendPacket(new Packet3Chat(ChatMessage.b("build.tooHigh", this.minecraftServer.getMaxBuildHeight()).a(EnumChatFormat.RED)));
            bl = true;
        }
        if (bl) {
            this.player.playerConnection.sendPacket(new Packet53BlockChange(n, n2, n3, worldServer));
            if (n4 == 0) {
                --n2;
            }
            if (n4 == 1) {
                ++n2;
            }
            if (n4 == 2) {
                --n3;
            }
            if (n4 == 3) {
                ++n3;
            }
            if (n4 == 4) {
                --n;
            }
            if (n4 == 5) {
                ++n;
            }
            this.player.playerConnection.sendPacket(new Packet53BlockChange(n, n2, n3, worldServer));
        }
        if ((itemStack = this.player.inventory.getItemInHand()) != null && itemStack.count == 0) {
            this.player.inventory.items[this.player.inventory.itemInHandIndex] = null;
            itemStack = null;
        }
        if (itemStack == null || itemStack.n() == 0) {
            this.player.h = true;
            this.player.inventory.items[this.player.inventory.itemInHandIndex] = ItemStack.b(this.player.inventory.items[this.player.inventory.itemInHandIndex]);
            Slot slot = this.player.activeContainer.a(this.player.inventory, this.player.inventory.itemInHandIndex);
            this.player.activeContainer.b();
            this.player.h = false;
            if (!ItemStack.matches(this.player.inventory.getItemInHand(), packet15Place.getItemStack())) {
                this.sendPacket(new Packet103SetSlot(this.player.activeContainer.windowId, slot.g, this.player.inventory.getItemInHand()));
            }
        }
    }

    @Override
    public void a(String string, Object[] objectArray) {
        this.minecraftServer.getLogger().info(this.player.getName() + " lost connection: " + string);
        this.minecraftServer.getPlayerList().sendMessage(ChatMessage.b("multiplayer.player.left", this.player.getScoreboardDisplayName()).a(EnumChatFormat.YELLOW));
        this.minecraftServer.getPlayerList().disconnect(this.player);
        this.disconnected = true;
        if (this.minecraftServer.K() && this.player.getName().equals(this.minecraftServer.J())) {
            this.minecraftServer.getLogger().info("Stopping singleplayer server as player logged out");
            this.minecraftServer.safeShutdown();
        }
    }

    @Override
    public void onUnhandledPacket(Packet packet) {
        this.minecraftServer.getLogger().warning(this.getClass() + " wasn't prepared to deal with a " + packet.getClass());
        this.disconnect("Protocol error, unexpected packet");
    }

    public void sendPacket(Packet packet) {
        if (packet instanceof Packet3Chat) {
            Packet3Chat packet3Chat = (Packet3Chat)packet;
            int n = this.player.getChatFlags();
            if (n == 2) {
                return;
            }
            if (n == 1 && !packet3Chat.isServer()) {
                return;
            }
        }
        try {
            this.networkManager.queue(packet);
        }
        catch (Throwable throwable) {
            CrashReport crashReport = CrashReport.a(throwable, "Sending packet");
            CrashReportSystemDetails crashReportSystemDetails = crashReport.a("Packet being sent");
            crashReportSystemDetails.a("Packet ID", new CrashReportConnectionPacketID(this, packet));
            crashReportSystemDetails.a("Packet class", new CrashReportConnectionPacketClass(this, packet));
            throw new ReportedException(crashReport);
        }
    }

    @Override
    public void a(Packet16BlockItemSwitch packet16BlockItemSwitch) {
        if (packet16BlockItemSwitch.itemInHandIndex < 0 || packet16BlockItemSwitch.itemInHandIndex >= PlayerInventory.getHotbarSize()) {
            this.minecraftServer.getLogger().warning(this.player.getName() + " tried to set an invalid carried item");
            return;
        }
        this.player.inventory.itemInHandIndex = packet16BlockItemSwitch.itemInHandIndex;
        this.player.u();
    }

    @Override
    public void a(Packet3Chat packet3Chat) {
        if (this.player.getChatFlags() == 2) {
            this.sendPacket(new Packet3Chat(ChatMessage.e("chat.cannotSend").a(EnumChatFormat.RED)));
            return;
        }
        this.player.u();
        String string = packet3Chat.message;
        if (string.length() > 100) {
            this.disconnect("Chat message too long");
            return;
        }
        string = StringUtils.normalizeSpace(string);
        for (int i = 0; i < string.length(); ++i) {
            if (SharedConstants.isAllowedChatCharacter(string.charAt(i))) continue;
            this.disconnect("Illegal characters in chat");
            return;
        }
        if (string.startsWith("/")) {
            this.handleCommand(string);
        } else {
            if (this.player.getChatFlags() == 1) {
                this.sendPacket(new Packet3Chat(ChatMessage.e("chat.cannotSend").a(EnumChatFormat.RED)));
                return;
            }
            ChatMessage chatMessage = ChatMessage.b("chat.type.text", this.player.getScoreboardDisplayName(), string);
            this.minecraftServer.getPlayerList().sendMessage(chatMessage, false);
        }
        this.chatThrottle += 20;
        if (this.chatThrottle > 200 && !this.minecraftServer.getPlayerList().isOp(this.player.getName())) {
            this.disconnect("disconnect.spam");
        }
    }

    private void handleCommand(String string) {
        this.minecraftServer.getCommandHandler().a(this.player, string);
    }

    @Override
    public void a(Packet18ArmAnimation packet18ArmAnimation) {
        this.player.u();
        if (packet18ArmAnimation.b == 1) {
            this.player.aV();
        }
    }

    @Override
    public void a(Packet19EntityAction packet19EntityAction) {
        this.player.u();
        if (packet19EntityAction.animation == 1) {
            this.player.setSneaking(true);
        } else if (packet19EntityAction.animation == 2) {
            this.player.setSneaking(false);
        } else if (packet19EntityAction.animation == 4) {
            this.player.setSprinting(true);
        } else if (packet19EntityAction.animation == 5) {
            this.player.setSprinting(false);
        } else if (packet19EntityAction.animation == 3) {
            this.player.a(false, true, true);
            this.checkMovement = false;
        } else if (packet19EntityAction.animation == 6) {
            if (this.player.vehicle != null && this.player.vehicle instanceof EntityHorse) {
                ((EntityHorse)this.player.vehicle).u(packet19EntityAction.c);
            }
        } else if (packet19EntityAction.animation == 7 && this.player.vehicle != null && this.player.vehicle instanceof EntityHorse) {
            ((EntityHorse)this.player.vehicle).f(this.player);
        }
    }

    @Override
    public void a(Packet255KickDisconnect packet255KickDisconnect) {
        this.networkManager.a("disconnect.quitting", new Object[0]);
    }

    public int lowPriorityCount() {
        return this.networkManager.e();
    }

    @Override
    public void a(Packet7UseEntity packet7UseEntity) {
        WorldServer worldServer = this.minecraftServer.getWorldServer(this.player.dimension);
        Entity entity = worldServer.getEntity(packet7UseEntity.target);
        this.player.u();
        if (entity != null) {
            boolean bl = this.player.o(entity);
            double d = 36.0;
            if (!bl) {
                d = 9.0;
            }
            if (this.player.e(entity) < d) {
                if (packet7UseEntity.action == 0) {
                    this.player.p(entity);
                } else if (packet7UseEntity.action == 1) {
                    if (entity instanceof EntityItem || entity instanceof EntityExperienceOrb || entity instanceof EntityArrow || entity == this.player) {
                        this.disconnect("Attempting to attack an invalid entity");
                        this.minecraftServer.warning("Player " + this.player.getName() + " tried to attack an invalid entity");
                        return;
                    }
                    this.player.attack(entity);
                }
            }
        }
    }

    @Override
    public void a(Packet205ClientCommand packet205ClientCommand) {
        this.player.u();
        if (packet205ClientCommand.a == 1) {
            if (this.player.viewingCredits) {
                this.player = this.minecraftServer.getPlayerList().moveToWorld(this.player, 0, true);
            } else if (this.player.p().getWorldData().isHardcore()) {
                if (this.minecraftServer.K() && this.player.getName().equals(this.minecraftServer.J())) {
                    this.player.playerConnection.disconnect("You have died. Game over, man, it's game over!");
                    this.minecraftServer.R();
                } else {
                    BanEntry banEntry = new BanEntry(this.player.getName());
                    banEntry.setReason("Death in Hardcore");
                    this.minecraftServer.getPlayerList().getNameBans().add(banEntry);
                    this.player.playerConnection.disconnect("You have died. Game over, man, it's game over!");
                }
            } else {
                if (this.player.getHealth() > 0.0f) {
                    return;
                }
                this.player = this.minecraftServer.getPlayerList().moveToWorld(this.player, 0, false);
            }
        }
    }

    @Override
    public boolean b() {
        return true;
    }

    @Override
    public void a(Packet9Respawn packet9Respawn) {
    }

    @Override
    public void handleContainerClose(Packet101CloseWindow packet101CloseWindow) {
        this.player.k();
    }

    @Override
    public void a(Packet102WindowClick packet102WindowClick) {
        this.player.u();
        if (this.player.activeContainer.windowId == packet102WindowClick.a && this.player.activeContainer.c(this.player)) {
            ItemStack itemStack = this.player.activeContainer.clickItem(packet102WindowClick.slot, packet102WindowClick.button, packet102WindowClick.shift, this.player);
            if (ItemStack.matches(packet102WindowClick.item, itemStack)) {
                this.player.playerConnection.sendPacket(new Packet106Transaction(packet102WindowClick.a, packet102WindowClick.d, true));
                this.player.h = true;
                this.player.activeContainer.b();
                this.player.broadcastCarriedItem();
                this.player.h = false;
            } else {
                this.r.a(this.player.activeContainer.windowId, packet102WindowClick.d);
                this.player.playerConnection.sendPacket(new Packet106Transaction(packet102WindowClick.a, packet102WindowClick.d, false));
                this.player.activeContainer.a((EntityHuman)this.player, false);
                ArrayList<ItemStack> arrayList = new ArrayList<ItemStack>();
                for (int i = 0; i < this.player.activeContainer.c.size(); ++i) {
                    arrayList.add(((Slot)this.player.activeContainer.c.get(i)).getItem());
                }
                this.player.a(this.player.activeContainer, arrayList);
            }
        }
    }

    @Override
    public void a(Packet108ButtonClick packet108ButtonClick) {
        this.player.u();
        if (this.player.activeContainer.windowId == packet108ButtonClick.a && this.player.activeContainer.c(this.player)) {
            this.player.activeContainer.a((EntityHuman)this.player, packet108ButtonClick.b);
            this.player.activeContainer.b();
        }
    }

    @Override
    public void a(Packet107SetCreativeSlot packet107SetCreativeSlot) {
        if (this.player.playerInteractManager.isCreative()) {
            boolean bl;
            boolean bl2 = packet107SetCreativeSlot.slot < 0;
            ItemStack itemStack = packet107SetCreativeSlot.b;
            boolean bl3 = packet107SetCreativeSlot.slot >= 1 && packet107SetCreativeSlot.slot < 36 + PlayerInventory.getHotbarSize();
            boolean bl4 = itemStack == null || itemStack.id < Item.byId.length && itemStack.id >= 0 && Item.byId[itemStack.id] != null;
            boolean bl5 = bl = itemStack == null || itemStack.getData() >= 0 && itemStack.getData() >= 0 && itemStack.count <= 64 && itemStack.count > 0;
            if (bl3 && bl4 && bl) {
                if (itemStack == null) {
                    this.player.defaultContainer.setItem(packet107SetCreativeSlot.slot, null);
                } else {
                    this.player.defaultContainer.setItem(packet107SetCreativeSlot.slot, itemStack);
                }
                this.player.defaultContainer.a((EntityHuman)this.player, true);
            } else if (bl2 && bl4 && bl && this.x < 200) {
                this.x += 20;
                EntityItem entityItem = this.player.drop(itemStack);
                if (entityItem != null) {
                    entityItem.c();
                }
            }
        }
    }

    @Override
    public void a(Packet106Transaction packet106Transaction) {
        Short s = (Short)this.r.get(this.player.activeContainer.windowId);
        if (s != null && packet106Transaction.b == s && this.player.activeContainer.windowId == packet106Transaction.a && !this.player.activeContainer.c(this.player)) {
            this.player.activeContainer.a((EntityHuman)this.player, true);
        }
    }

    @Override
    public void a(Packet130UpdateSign packet130UpdateSign) {
        this.player.u();
        WorldServer worldServer = this.minecraftServer.getWorldServer(this.player.dimension);
        if (worldServer.isLoaded(packet130UpdateSign.x, packet130UpdateSign.y, packet130UpdateSign.z)) {
            int n;
            int n2;
            int n3;
            TileEntitySign tileEntitySign;
            TileEntity tileEntity = worldServer.getTileEntity(packet130UpdateSign.x, packet130UpdateSign.y, packet130UpdateSign.z);
            if (tileEntity instanceof TileEntitySign && (!(tileEntitySign = (TileEntitySign)tileEntity).a() || tileEntitySign.b() != this.player)) {
                this.minecraftServer.warning("Player " + this.player.getName() + " just tried to change non-editable sign");
                return;
            }
            for (n3 = 0; n3 < 4; ++n3) {
                n2 = 1;
                if (packet130UpdateSign.lines[n3].length() > 15) {
                    n2 = 0;
                } else {
                    for (n = 0; n < packet130UpdateSign.lines[n3].length(); ++n) {
                        if (SharedConstants.allowedCharacters.indexOf(packet130UpdateSign.lines[n3].charAt(n)) >= 0) continue;
                        n2 = 0;
                    }
                }
                if (n2 != 0) continue;
                packet130UpdateSign.lines[n3] = "!?";
            }
            if (tileEntity instanceof TileEntitySign) {
                n3 = packet130UpdateSign.x;
                n2 = packet130UpdateSign.y;
                n = packet130UpdateSign.z;
                TileEntitySign tileEntitySign2 = (TileEntitySign)tileEntity;
                System.arraycopy(packet130UpdateSign.lines, 0, tileEntitySign2.lines, 0, 4);
                tileEntitySign2.update();
                worldServer.notify(n3, n2, n);
            }
        }
    }

    @Override
    public void a(Packet0KeepAlive packet0KeepAlive) {
        if (packet0KeepAlive.a == this.h) {
            int n = (int)(System.nanoTime() / 1000000L - this.i);
            this.player.ping = (this.player.ping * 3 + n) / 4;
        }
    }

    @Override
    public boolean a() {
        return true;
    }

    @Override
    public void a(Packet202Abilities packet202Abilities) {
        this.player.abilities.isFlying = packet202Abilities.f() && this.player.abilities.canFly;
    }

    @Override
    public void a(Packet203TabComplete packet203TabComplete) {
        StringBuilder stringBuilder = new StringBuilder();
        for (String string : this.minecraftServer.a(this.player, packet203TabComplete.d())) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append("\u0000");
            }
            stringBuilder.append(string);
        }
        this.player.playerConnection.sendPacket(new Packet203TabComplete(stringBuilder.toString()));
    }

    @Override
    public void a(Packet204LocaleAndViewDistance packet204LocaleAndViewDistance) {
        this.player.a(packet204LocaleAndViewDistance);
    }

    @Override
    public void a(Packet250CustomPayload packet250CustomPayload) {
        if ("MC|BEdit".equals(packet250CustomPayload.tag)) {
            try {
                DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(packet250CustomPayload.data));
                ItemStack itemStack = Packet.c(dataInputStream);
                if (!ItemBookAndQuill.a(itemStack.getTag())) {
                    throw new IOException("Invalid book tag!");
                }
                ItemStack itemStack2 = this.player.inventory.getItemInHand();
                if (itemStack != null && itemStack.id == Item.BOOK_AND_QUILL.id && itemStack.id == itemStack2.id) {
                    itemStack2.a("pages", itemStack.getTag().getList("pages"));
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        } else if ("MC|BSign".equals(packet250CustomPayload.tag)) {
            try {
                DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(packet250CustomPayload.data));
                ItemStack itemStack = Packet.c(dataInputStream);
                if (!ItemWrittenBook.a(itemStack.getTag())) {
                    throw new IOException("Invalid book tag!");
                }
                ItemStack itemStack3 = this.player.inventory.getItemInHand();
                if (itemStack != null && itemStack.id == Item.WRITTEN_BOOK.id && itemStack3.id == Item.BOOK_AND_QUILL.id) {
                    itemStack3.a("author", new NBTTagString("author", this.player.getName()));
                    itemStack3.a("title", new NBTTagString("title", itemStack.getTag().getString("title")));
                    itemStack3.a("pages", itemStack.getTag().getList("pages"));
                    itemStack3.id = Item.WRITTEN_BOOK.id;
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        } else if ("MC|TrSel".equals(packet250CustomPayload.tag)) {
            try {
                DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(packet250CustomPayload.data));
                int n = dataInputStream.readInt();
                Container container = this.player.activeContainer;
                if (container instanceof ContainerMerchant) {
                    ((ContainerMerchant)container).e(n);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        } else if ("MC|AdvCdm".equals(packet250CustomPayload.tag)) {
            if (!this.minecraftServer.getEnableCommandBlock()) {
                this.player.sendMessage(ChatMessage.e("advMode.notEnabled"));
            } else if (this.player.a(2, "") && this.player.abilities.canInstantlyBuild) {
                try {
                    DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(packet250CustomPayload.data));
                    int n = dataInputStream.readInt();
                    int n2 = dataInputStream.readInt();
                    int n3 = dataInputStream.readInt();
                    String string = Packet.a(dataInputStream, 256);
                    TileEntity tileEntity = this.player.world.getTileEntity(n, n2, n3);
                    if (tileEntity != null && tileEntity instanceof TileEntityCommand) {
                        ((TileEntityCommand)tileEntity).a(string);
                        this.player.world.notify(n, n2, n3);
                        this.player.sendMessage(ChatMessage.b("advMode.setCommand.success", string));
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            } else {
                this.player.sendMessage(ChatMessage.e("advMode.notAllowed"));
            }
        } else if ("MC|Beacon".equals(packet250CustomPayload.tag)) {
            if (this.player.activeContainer instanceof ContainerBeacon) {
                try {
                    DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(packet250CustomPayload.data));
                    int n = dataInputStream.readInt();
                    int n4 = dataInputStream.readInt();
                    ContainerBeacon containerBeacon = (ContainerBeacon)this.player.activeContainer;
                    Slot slot = containerBeacon.getSlot(0);
                    if (slot.e()) {
                        slot.a(1);
                        TileEntityBeacon tileEntityBeacon = containerBeacon.e();
                        tileEntityBeacon.d(n);
                        tileEntityBeacon.e(n4);
                        tileEntityBeacon.update();
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        } else if ("MC|ItemName".equals(packet250CustomPayload.tag) && this.player.activeContainer instanceof ContainerAnvil) {
            ContainerAnvil containerAnvil = (ContainerAnvil)this.player.activeContainer;
            if (packet250CustomPayload.data == null || packet250CustomPayload.data.length < 1) {
                containerAnvil.a("");
            } else {
                String string = SharedConstants.a(new String(packet250CustomPayload.data));
                if (string.length() <= 30) {
                    containerAnvil.a(string);
                }
            }
        }
    }

    @Override
    public boolean c() {
        return this.disconnected;
    }
}

