/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.server.ChunkCoordIntPair;
import net.minecraft.server.EntityPlayer;
import net.minecraft.server.LongHashMap;
import net.minecraft.server.PlayerChunk;
import net.minecraft.server.WorldProvider;
import net.minecraft.server.WorldServer;

public class PlayerChunkMap {
    private final WorldServer world;
    private final List managedPlayers = new ArrayList();
    private final LongHashMap c = new LongHashMap();
    private final List d = new ArrayList();
    private final List e = new ArrayList();
    private final int f;
    private long g;
    private final int[][] h = new int[][]{{1, 0}, {0, 1}, {-1, 0}, {0, -1}};

    public PlayerChunkMap(WorldServer worldServer, int n) {
        if (n > 15) {
            throw new IllegalArgumentException("Too big view radius!");
        }
        if (n < 3) {
            throw new IllegalArgumentException("Too small view radius!");
        }
        this.f = n;
        this.world = worldServer;
    }

    public WorldServer a() {
        return this.world;
    }

    public void flush() {
        WorldProvider worldProvider;
        int n;
        long l = this.world.getTime();
        if (l - this.g > 8000L) {
            this.g = l;
            for (n = 0; n < this.e.size(); ++n) {
                PlayerChunk playerChunk = (PlayerChunk)this.e.get(n);
                playerChunk.b();
                playerChunk.a();
            }
        } else {
            for (n = 0; n < this.d.size(); ++n) {
                PlayerChunk playerChunk = (PlayerChunk)this.d.get(n);
                playerChunk.b();
            }
        }
        this.d.clear();
        if (this.managedPlayers.isEmpty() && !(worldProvider = this.world.worldProvider).e()) {
            this.world.chunkProviderServer.a();
        }
    }

    private PlayerChunk a(int n, int n2, boolean bl) {
        long l = (long)n + Integer.MAX_VALUE | (long)n2 + Integer.MAX_VALUE << 32;
        PlayerChunk playerChunk = (PlayerChunk)this.c.getEntry(l);
        if (playerChunk == null && bl) {
            playerChunk = new PlayerChunk(this, n, n2);
            this.c.put(l, playerChunk);
            this.e.add(playerChunk);
        }
        return playerChunk;
    }

    public void flagDirty(int n, int n2, int n3) {
        int n4 = n >> 4;
        int n5 = n3 >> 4;
        PlayerChunk playerChunk = this.a(n4, n5, false);
        if (playerChunk != null) {
            playerChunk.a(n & 0xF, n2, n3 & 0xF);
        }
    }

    public void addPlayer(EntityPlayer entityPlayer) {
        int n = (int)entityPlayer.locX >> 4;
        int n2 = (int)entityPlayer.locZ >> 4;
        entityPlayer.d = entityPlayer.locX;
        entityPlayer.e = entityPlayer.locZ;
        for (int i = n - this.f; i <= n + this.f; ++i) {
            for (int j = n2 - this.f; j <= n2 + this.f; ++j) {
                this.a(i, j, true).a(entityPlayer);
            }
        }
        this.managedPlayers.add(entityPlayer);
        this.b(entityPlayer);
    }

    public void b(EntityPlayer entityPlayer) {
        int n;
        ArrayList arrayList = new ArrayList(entityPlayer.chunkCoordIntPairQueue);
        int n2 = 0;
        int n3 = this.f;
        int n4 = (int)entityPlayer.locX >> 4;
        int n5 = (int)entityPlayer.locZ >> 4;
        int n6 = 0;
        int n7 = 0;
        ChunkCoordIntPair chunkCoordIntPair = PlayerChunk.a(this.a(n4, n5, true));
        entityPlayer.chunkCoordIntPairQueue.clear();
        if (arrayList.contains(chunkCoordIntPair)) {
            entityPlayer.chunkCoordIntPairQueue.add(chunkCoordIntPair);
        }
        for (n = 1; n <= n3 * 2; ++n) {
            for (int i = 0; i < 2; ++i) {
                int[] nArray = this.h[n2++ % 4];
                for (int j = 0; j < n; ++j) {
                    chunkCoordIntPair = PlayerChunk.a(this.a(n4 + (n6 += nArray[0]), n5 + (n7 += nArray[1]), true));
                    if (!arrayList.contains(chunkCoordIntPair)) continue;
                    entityPlayer.chunkCoordIntPairQueue.add(chunkCoordIntPair);
                }
            }
        }
        n2 %= 4;
        for (n = 0; n < n3 * 2; ++n) {
            chunkCoordIntPair = PlayerChunk.a(this.a(n4 + (n6 += this.h[n2][0]), n5 + (n7 += this.h[n2][1]), true));
            if (!arrayList.contains(chunkCoordIntPair)) continue;
            entityPlayer.chunkCoordIntPairQueue.add(chunkCoordIntPair);
        }
    }

    public void removePlayer(EntityPlayer entityPlayer) {
        int n = (int)entityPlayer.d >> 4;
        int n2 = (int)entityPlayer.e >> 4;
        for (int i = n - this.f; i <= n + this.f; ++i) {
            for (int j = n2 - this.f; j <= n2 + this.f; ++j) {
                PlayerChunk playerChunk = this.a(i, j, false);
                if (playerChunk == null) continue;
                playerChunk.b(entityPlayer);
            }
        }
        this.managedPlayers.remove(entityPlayer);
    }

    private boolean a(int n, int n2, int n3, int n4, int n5) {
        int n6 = n - n3;
        int n7 = n2 - n4;
        if (n6 < -n5 || n6 > n5) {
            return false;
        }
        return n7 >= -n5 && n7 <= n5;
    }

    public void movePlayer(EntityPlayer entityPlayer) {
        int n = (int)entityPlayer.locX >> 4;
        int n2 = (int)entityPlayer.locZ >> 4;
        double d = entityPlayer.d - entityPlayer.locX;
        double d2 = entityPlayer.e - entityPlayer.locZ;
        double d3 = d * d + d2 * d2;
        if (d3 < 64.0) {
            return;
        }
        int n3 = (int)entityPlayer.d >> 4;
        int n4 = (int)entityPlayer.e >> 4;
        int n5 = this.f;
        int n6 = n - n3;
        int n7 = n2 - n4;
        if (n6 == 0 && n7 == 0) {
            return;
        }
        for (int i = n - n5; i <= n + n5; ++i) {
            for (int j = n2 - n5; j <= n2 + n5; ++j) {
                PlayerChunk playerChunk;
                if (!this.a(i, j, n3, n4, n5)) {
                    this.a(i, j, true).a(entityPlayer);
                }
                if (this.a(i - n6, j - n7, n, n2, n5) || (playerChunk = this.a(i - n6, j - n7, false)) == null) continue;
                playerChunk.b(entityPlayer);
            }
        }
        this.b(entityPlayer);
        entityPlayer.d = entityPlayer.locX;
        entityPlayer.e = entityPlayer.locZ;
    }

    public boolean a(EntityPlayer entityPlayer, int n, int n2) {
        PlayerChunk playerChunk = this.a(n, n2, false);
        return playerChunk == null ? false : PlayerChunk.b(playerChunk).contains(entityPlayer) && !entityPlayer.chunkCoordIntPairQueue.contains(PlayerChunk.a(playerChunk));
    }

    public static int getFurthestViewableBlock(int n) {
        return n * 16 - 16;
    }

    static /* synthetic */ WorldServer a(PlayerChunkMap playerChunkMap) {
        return playerChunkMap.world;
    }

    static /* synthetic */ LongHashMap b(PlayerChunkMap playerChunkMap) {
        return playerChunkMap.c;
    }

    static /* synthetic */ List c(PlayerChunkMap playerChunkMap) {
        return playerChunkMap.e;
    }

    static /* synthetic */ List d(PlayerChunkMap playerChunkMap) {
        return playerChunkMap.d;
    }
}

