/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import java.net.InetAddress;
import java.net.Socket;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Random;
import javax.crypto.SecretKey;
import net.minecraft.server.Connection;
import net.minecraft.server.DedicatedServerConnection;
import net.minecraft.server.EntityPlayer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.NetworkManager;
import net.minecraft.server.Packet;
import net.minecraft.server.Packet1Login;
import net.minecraft.server.Packet205ClientCommand;
import net.minecraft.server.Packet252KeyResponse;
import net.minecraft.server.Packet253KeyRequest;
import net.minecraft.server.Packet254GetInfo;
import net.minecraft.server.Packet255KickDisconnect;
import net.minecraft.server.Packet2Handshake;
import net.minecraft.server.PlayerList;
import net.minecraft.server.StripColor;
import net.minecraft.server.ThreadLoginVerifier;

public class PendingConnection
extends Connection {
    private static Random random = new Random();
    private byte[] d;
    private final MinecraftServer server;
    public final NetworkManager networkManager;
    public boolean b;
    private int f;
    private String g;
    private volatile boolean h;
    private String loginKey = "";
    private boolean j;
    private SecretKey k;

    public PendingConnection(MinecraftServer minecraftServer, Socket socket, String string) {
        this.server = minecraftServer;
        this.networkManager = new NetworkManager(minecraftServer.getLogger(), socket, string, this, minecraftServer.H().getPrivate());
        this.networkManager.e = 0;
    }

    public void d() {
        if (this.h) {
            this.e();
        }
        if (this.f++ == 600) {
            this.disconnect("Took too long to log in");
        } else {
            this.networkManager.b();
        }
    }

    public void disconnect(String string) {
        try {
            this.server.getLogger().info("Disconnecting " + this.getName() + ": " + string);
            this.networkManager.queue(new Packet255KickDisconnect(string));
            this.networkManager.d();
            this.b = true;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public void a(Packet2Handshake packet2Handshake) {
        if (this.g != null) {
            this.disconnect("Quit repeating yourself!");
            return;
        }
        this.g = packet2Handshake.f();
        if (!this.g.equals(StripColor.a(this.g))) {
            this.disconnect("Invalid username!");
            return;
        }
        PublicKey publicKey = this.server.H().getPublic();
        if (packet2Handshake.d() != 78) {
            if (packet2Handshake.d() > 78) {
                this.disconnect("Outdated server!");
            } else {
                this.disconnect("Outdated client!");
            }
            return;
        }
        this.loginKey = this.server.getOnlineMode() ? Long.toString(random.nextLong(), 16) : "-";
        this.d = new byte[4];
        random.nextBytes(this.d);
        this.networkManager.queue(new Packet253KeyRequest(this.loginKey, publicKey, this.d));
    }

    @Override
    public void a(Packet252KeyResponse packet252KeyResponse) {
        PrivateKey privateKey = this.server.H().getPrivate();
        this.k = packet252KeyResponse.a(privateKey);
        if (!Arrays.equals(this.d, packet252KeyResponse.b(privateKey))) {
            this.disconnect("Invalid client reply");
        }
        this.networkManager.queue(new Packet252KeyResponse());
    }

    @Override
    public void a(Packet205ClientCommand packet205ClientCommand) {
        if (packet205ClientCommand.a == 0) {
            if (this.j) {
                this.disconnect("Duplicate login");
                return;
            }
            this.j = true;
            if (this.server.getOnlineMode()) {
                new ThreadLoginVerifier(this).start();
            } else {
                this.h = true;
            }
        }
    }

    @Override
    public void a(Packet1Login packet1Login) {
    }

    public void e() {
        String string = this.server.getPlayerList().attemptLogin(this.networkManager.getSocketAddress(), this.g);
        if (string != null) {
            this.disconnect(string);
        } else {
            EntityPlayer entityPlayer = this.server.getPlayerList().processLogin(this.g);
            if (entityPlayer != null) {
                this.server.getPlayerList().a(this.networkManager, entityPlayer);
            }
        }
        this.b = true;
    }

    @Override
    public void a(String string, Object[] objectArray) {
        this.server.getLogger().info(this.getName() + " lost connection");
        this.b = true;
    }

    @Override
    public void a(Packet254GetInfo packet254GetInfo) {
        try {
            Object object;
            PlayerList playerList = this.server.getPlayerList();
            String string = null;
            if (packet254GetInfo.d()) {
                string = this.server.getMotd() + "\u00a7" + playerList.getPlayerCount() + "\u00a7" + playerList.getMaxPlayers();
            } else {
                object = Arrays.asList(1, 78, this.server.getVersion(), this.server.getMotd(), playerList.getPlayerCount(), playerList.getMaxPlayers());
                Iterator iterator = object.iterator();
                while (iterator.hasNext()) {
                    Object e = iterator.next();
                    string = string == null ? "\u00a7" : string + "\u0000";
                    string = string + e.toString().replaceAll("\u0000", "");
                }
            }
            object = null;
            if (this.networkManager.getSocket() != null) {
                object = this.networkManager.getSocket().getInetAddress();
            }
            this.networkManager.queue(new Packet255KickDisconnect(string));
            this.networkManager.d();
            if (object != null && this.server.ag() instanceof DedicatedServerConnection) {
                ((DedicatedServerConnection)this.server.ag()).a((InetAddress)object);
            }
            this.b = true;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public void onUnhandledPacket(Packet packet) {
        this.disconnect("Protocol error");
    }

    public String getName() {
        if (this.g != null) {
            return this.g + " [" + this.networkManager.getSocketAddress().toString() + "]";
        }
        return this.networkManager.getSocketAddress().toString();
    }

    @Override
    public boolean a() {
        return true;
    }

    @Override
    public boolean c() {
        return this.b;
    }

    static /* synthetic */ String a(PendingConnection pendingConnection) {
        return pendingConnection.loginKey;
    }

    static /* synthetic */ MinecraftServer b(PendingConnection pendingConnection) {
        return pendingConnection.server;
    }

    static /* synthetic */ SecretKey c(PendingConnection pendingConnection) {
        return pendingConnection.k;
    }

    static /* synthetic */ String d(PendingConnection pendingConnection) {
        return pendingConnection.g;
    }

    static /* synthetic */ boolean a(PendingConnection pendingConnection, boolean bl) {
        pendingConnection.h = bl;
        return pendingConnection.h;
    }
}

