/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.List;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import java.util.zip.Inflater;
import net.minecraft.server.Chunk;
import net.minecraft.server.ChunkMap;
import net.minecraft.server.Connection;
import net.minecraft.server.Packet;
import net.minecraft.server.Packet51MapChunk;

public class Packet56MapChunkBulk
extends Packet {
    private int[] c;
    private int[] d;
    public int[] a;
    public int[] b;
    private byte[] buffer;
    private byte[][] inflatedBuffers;
    private int size;
    private boolean h;
    private static byte[] buildBuffer = new byte[0];

    public Packet56MapChunkBulk() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Packet56MapChunkBulk(List list) {
        int n = list.size();
        this.c = new int[n];
        this.d = new int[n];
        this.a = new int[n];
        this.b = new int[n];
        this.inflatedBuffers = new byte[n][];
        this.h = !list.isEmpty() && !((Chunk)list.get((int)0)).world.worldProvider.g;
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            Chunk chunk = (Chunk)list.get(i);
            ChunkMap chunkMap = Packet51MapChunk.a(chunk, true, 65535);
            if (buildBuffer.length < n2 + chunkMap.a.length) {
                byte[] byArray = new byte[n2 + chunkMap.a.length];
                System.arraycopy(buildBuffer, 0, byArray, 0, buildBuffer.length);
                buildBuffer = byArray;
            }
            System.arraycopy(chunkMap.a, 0, buildBuffer, n2, chunkMap.a.length);
            n2 += chunkMap.a.length;
            this.c[i] = chunk.x;
            this.d[i] = chunk.z;
            this.a[i] = chunkMap.b;
            this.b[i] = chunkMap.c;
            this.inflatedBuffers[i] = chunkMap.a;
        }
        Deflater deflater = new Deflater(-1);
        try {
            deflater.setInput(buildBuffer, 0, n2);
            deflater.finish();
            this.buffer = new byte[n2];
            this.size = deflater.deflate(this.buffer);
        }
        finally {
            deflater.end();
        }
    }

    @Override
    public void a(DataInput dataInput) {
        int n = dataInput.readShort();
        this.size = dataInput.readInt();
        this.h = dataInput.readBoolean();
        this.c = new int[n];
        this.d = new int[n];
        this.a = new int[n];
        this.b = new int[n];
        this.inflatedBuffers = new byte[n][];
        if (buildBuffer.length < this.size) {
            buildBuffer = new byte[this.size];
        }
        dataInput.readFully(buildBuffer, 0, this.size);
        byte[] byArray = new byte[196864 * n];
        Inflater inflater = new Inflater();
        inflater.setInput(buildBuffer, 0, this.size);
        try {
            inflater.inflate(byArray);
        }
        catch (DataFormatException dataFormatException) {
            throw new IOException("Bad compressed data format");
        }
        finally {
            inflater.end();
        }
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            int n3;
            this.c[i] = dataInput.readInt();
            this.d[i] = dataInput.readInt();
            this.a[i] = dataInput.readShort();
            this.b[i] = dataInput.readShort();
            int n4 = 0;
            int n5 = 0;
            for (n3 = 0; n3 < 16; ++n3) {
                n4 += this.a[i] >> n3 & 1;
                n5 += this.b[i] >> n3 & 1;
            }
            n3 = 2048 * (4 * n4) + 256;
            n3 += 2048 * n5;
            if (this.h) {
                n3 += 2048 * n4;
            }
            this.inflatedBuffers[i] = new byte[n3];
            System.arraycopy(byArray, n2, this.inflatedBuffers[i], 0, n3);
            n2 += n3;
        }
    }

    @Override
    public void a(DataOutput dataOutput) {
        dataOutput.writeShort(this.c.length);
        dataOutput.writeInt(this.size);
        dataOutput.writeBoolean(this.h);
        dataOutput.write(this.buffer, 0, this.size);
        for (int i = 0; i < this.c.length; ++i) {
            dataOutput.writeInt(this.c[i]);
            dataOutput.writeInt(this.d[i]);
            dataOutput.writeShort((short)(this.a[i] & 0xFFFF));
            dataOutput.writeShort((short)(this.b[i] & 0xFFFF));
        }
    }

    @Override
    public void handle(Connection connection) {
        connection.a(this);
    }

    @Override
    public int a() {
        return 6 + this.size + 12 * this.d();
    }

    public int d() {
        return this.c.length;
    }
}

