/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import net.minecraft.server.Chunk;
import net.minecraft.server.Connection;
import net.minecraft.server.Packet;
import net.minecraft.server.World;

public class Packet52MultiBlockChange
extends Packet {
    public int a;
    public int b;
    public byte[] c;
    public int d;
    private static byte[] e = new byte[0];

    public Packet52MultiBlockChange() {
        this.lowPriority = true;
    }

    public Packet52MultiBlockChange(int n, int n2, short[] sArray, int n3, World world) {
        this.lowPriority = true;
        this.a = n;
        this.b = n2;
        this.d = n3;
        int n4 = 4 * n3;
        Chunk chunk = world.getChunkAt(n, n2);
        try {
            if (n3 >= 64) {
                this.m.info("ChunkTilesUpdatePacket compress " + n3);
                if (e.length < n4) {
                    e = new byte[n4];
                }
            } else {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(n4);
                DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
                for (int i = 0; i < n3; ++i) {
                    int n5 = sArray[i] >> 12 & 0xF;
                    int n6 = sArray[i] >> 8 & 0xF;
                    int n7 = sArray[i] & 0xFF;
                    dataOutputStream.writeShort(sArray[i]);
                    dataOutputStream.writeShort((short)((chunk.getTypeId(n5, n7, n6) & 0xFFF) << 4 | chunk.getData(n5, n7, n6) & 0xF));
                }
                this.c = byteArrayOutputStream.toByteArray();
                if (this.c.length != n4) {
                    throw new RuntimeException("Expected length " + n4 + " doesn't match received length " + this.c.length);
                }
            }
        }
        catch (IOException iOException) {
            this.m.severe("Couldn't create chunk packet", iOException);
            this.c = null;
        }
    }

    @Override
    public void a(DataInput dataInput) {
        this.a = dataInput.readInt();
        this.b = dataInput.readInt();
        this.d = dataInput.readShort() & 0xFFFF;
        int n = dataInput.readInt();
        if (n > 0) {
            this.c = new byte[n];
            dataInput.readFully(this.c);
        }
    }

    @Override
    public void a(DataOutput dataOutput) {
        dataOutput.writeInt(this.a);
        dataOutput.writeInt(this.b);
        dataOutput.writeShort((short)this.d);
        if (this.c != null) {
            dataOutput.writeInt(this.c.length);
            dataOutput.write(this.c);
        } else {
            dataOutput.writeInt(0);
        }
    }

    @Override
    public void handle(Connection connection) {
        connection.a(this);
    }

    @Override
    public int a() {
        return 10 + this.d * 4;
    }
}

