/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import java.util.zip.Inflater;
import net.minecraft.server.Chunk;
import net.minecraft.server.ChunkMap;
import net.minecraft.server.ChunkSection;
import net.minecraft.server.Connection;
import net.minecraft.server.Packet;

public class Packet51MapChunk
extends Packet {
    public int a;
    public int b;
    public int c;
    public int d;
    private byte[] buffer;
    private byte[] inflatedBuffer;
    public boolean e;
    private int size;
    private static byte[] buildBuffer = new byte[196864];

    public Packet51MapChunk() {
        this.lowPriority = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Packet51MapChunk(Chunk chunk, boolean bl, int n) {
        this.lowPriority = true;
        this.a = chunk.x;
        this.b = chunk.z;
        this.e = bl;
        ChunkMap chunkMap = Packet51MapChunk.a(chunk, bl, n);
        Deflater deflater = new Deflater(-1);
        this.d = chunkMap.c;
        this.c = chunkMap.b;
        try {
            this.inflatedBuffer = chunkMap.a;
            deflater.setInput(chunkMap.a, 0, chunkMap.a.length);
            deflater.finish();
            this.buffer = new byte[chunkMap.a.length];
            this.size = deflater.deflate(this.buffer);
        }
        finally {
            deflater.end();
        }
    }

    @Override
    public void a(DataInput dataInput) {
        int n;
        this.a = dataInput.readInt();
        this.b = dataInput.readInt();
        this.e = dataInput.readBoolean();
        this.c = dataInput.readShort();
        this.d = dataInput.readShort();
        this.size = dataInput.readInt();
        if (buildBuffer.length < this.size) {
            buildBuffer = new byte[this.size];
        }
        dataInput.readFully(buildBuffer, 0, this.size);
        int n2 = 0;
        for (n = 0; n < 16; ++n) {
            n2 += this.c >> n & 1;
        }
        n = 12288 * n2;
        if (this.e) {
            n += 256;
        }
        this.inflatedBuffer = new byte[n];
        Inflater inflater = new Inflater();
        inflater.setInput(buildBuffer, 0, this.size);
        try {
            inflater.inflate(this.inflatedBuffer);
        }
        catch (DataFormatException dataFormatException) {
            throw new IOException("Bad compressed data format");
        }
        finally {
            inflater.end();
        }
    }

    @Override
    public void a(DataOutput dataOutput) {
        dataOutput.writeInt(this.a);
        dataOutput.writeInt(this.b);
        dataOutput.writeBoolean(this.e);
        dataOutput.writeShort((short)(this.c & 0xFFFF));
        dataOutput.writeShort((short)(this.d & 0xFFFF));
        dataOutput.writeInt(this.size);
        dataOutput.write(this.buffer, 0, this.size);
    }

    @Override
    public void handle(Connection connection) {
        connection.a(this);
    }

    @Override
    public int a() {
        return 17 + this.size;
    }

    public static ChunkMap a(Chunk chunk, boolean bl, int n) {
        Object object;
        int n2;
        int n3 = 0;
        ChunkSection[] chunkSectionArray = chunk.i();
        int n4 = 0;
        ChunkMap chunkMap = new ChunkMap();
        byte[] byArray = buildBuffer;
        if (bl) {
            chunk.seenByPlayer = true;
        }
        for (n2 = 0; n2 < chunkSectionArray.length; ++n2) {
            if (chunkSectionArray[n2] == null || bl && chunkSectionArray[n2].isEmpty() || (n & 1 << n2) == 0) continue;
            chunkMap.b |= 1 << n2;
            if (chunkSectionArray[n2].getExtendedIdArray() == null) continue;
            chunkMap.c |= 1 << n2;
            ++n4;
        }
        for (n2 = 0; n2 < chunkSectionArray.length; ++n2) {
            if (chunkSectionArray[n2] == null || bl && chunkSectionArray[n2].isEmpty() || (n & 1 << n2) == 0) continue;
            object = chunkSectionArray[n2].getIdArray();
            System.arraycopy(object, 0, byArray, n3, ((byte[])object).length);
            n3 += ((byte[])object).length;
        }
        for (n2 = 0; n2 < chunkSectionArray.length; ++n2) {
            if (chunkSectionArray[n2] == null || bl && chunkSectionArray[n2].isEmpty() || (n & 1 << n2) == 0) continue;
            object = chunkSectionArray[n2].getDataArray();
            System.arraycopy(object.a, 0, byArray, n3, object.a.length);
            n3 += object.a.length;
        }
        for (n2 = 0; n2 < chunkSectionArray.length; ++n2) {
            if (chunkSectionArray[n2] == null || bl && chunkSectionArray[n2].isEmpty() || (n & 1 << n2) == 0) continue;
            object = chunkSectionArray[n2].getEmittedLightArray();
            System.arraycopy(object.a, 0, byArray, n3, object.a.length);
            n3 += object.a.length;
        }
        if (!chunk.world.worldProvider.g) {
            for (n2 = 0; n2 < chunkSectionArray.length; ++n2) {
                if (chunkSectionArray[n2] == null || bl && chunkSectionArray[n2].isEmpty() || (n & 1 << n2) == 0) continue;
                object = chunkSectionArray[n2].getSkyLightArray();
                System.arraycopy(object.a, 0, byArray, n3, object.a.length);
                n3 += object.a.length;
            }
        }
        if (n4 > 0) {
            for (n2 = 0; n2 < chunkSectionArray.length; ++n2) {
                if (chunkSectionArray[n2] == null || bl && chunkSectionArray[n2].isEmpty() || chunkSectionArray[n2].getExtendedIdArray() == null || (n & 1 << n2) == 0) continue;
                object = chunkSectionArray[n2].getExtendedIdArray();
                System.arraycopy(object.a, 0, byArray, n3, object.a.length);
                n3 += object.a.length;
            }
        }
        if (bl) {
            byte[] byArray2 = chunk.m();
            System.arraycopy(byArray2, 0, byArray, n3, byArray2.length);
            n3 += byArray2.length;
        }
        chunkMap.a = new byte[n3];
        System.arraycopy(byArray, 0, chunkMap.a, 0, n3);
        return chunkMap;
    }
}

