/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import java.io.DataInput;
import java.io.DataOutput;
import net.minecraft.server.Connection;
import net.minecraft.server.Packet;

public class Packet250CustomPayload
extends Packet {
    public String tag;
    public int length;
    public byte[] data;

    public Packet250CustomPayload() {
    }

    public Packet250CustomPayload(String string, byte[] byArray) {
        this.tag = string;
        this.data = byArray;
        if (byArray != null) {
            this.length = byArray.length;
            if (this.length > Short.MAX_VALUE) {
                throw new IllegalArgumentException("Payload may not be larger than 32k");
            }
        }
    }

    @Override
    public void a(DataInput dataInput) {
        this.tag = Packet250CustomPayload.a(dataInput, 20);
        this.length = dataInput.readShort();
        if (this.length > 0 && this.length < Short.MAX_VALUE) {
            this.data = new byte[this.length];
            dataInput.readFully(this.data);
        }
    }

    @Override
    public void a(DataOutput dataOutput) {
        Packet250CustomPayload.a(this.tag, dataOutput);
        dataOutput.writeShort((short)this.length);
        if (this.data != null) {
            dataOutput.write(this.data);
        }
    }

    @Override
    public void handle(Connection connection) {
        connection.a(this);
    }

    @Override
    public int a() {
        return 2 + this.tag.length() * 2 + 2 + this.length;
    }
}

