/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.EOFException;
import java.io.IOException;
import java.net.Socket;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.server.Connection;
import net.minecraft.server.IConsoleLogManager;
import net.minecraft.server.IntHashMap;
import net.minecraft.server.ItemStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.NBTCompressedStreamTools;
import net.minecraft.server.NBTTagCompound;
import net.minecraft.server.Packet0KeepAlive;
import net.minecraft.server.Packet100OpenWindow;
import net.minecraft.server.Packet101CloseWindow;
import net.minecraft.server.Packet102WindowClick;
import net.minecraft.server.Packet103SetSlot;
import net.minecraft.server.Packet104WindowItems;
import net.minecraft.server.Packet105CraftProgressBar;
import net.minecraft.server.Packet106Transaction;
import net.minecraft.server.Packet107SetCreativeSlot;
import net.minecraft.server.Packet108ButtonClick;
import net.minecraft.server.Packet10Flying;
import net.minecraft.server.Packet11PlayerPosition;
import net.minecraft.server.Packet12PlayerLook;
import net.minecraft.server.Packet130UpdateSign;
import net.minecraft.server.Packet131ItemData;
import net.minecraft.server.Packet132TileEntityData;
import net.minecraft.server.Packet133OpenTileEntity;
import net.minecraft.server.Packet13PlayerLookMove;
import net.minecraft.server.Packet14BlockDig;
import net.minecraft.server.Packet15Place;
import net.minecraft.server.Packet16BlockItemSwitch;
import net.minecraft.server.Packet17EntityLocationAction;
import net.minecraft.server.Packet18ArmAnimation;
import net.minecraft.server.Packet19EntityAction;
import net.minecraft.server.Packet1Login;
import net.minecraft.server.Packet200Statistic;
import net.minecraft.server.Packet201PlayerInfo;
import net.minecraft.server.Packet202Abilities;
import net.minecraft.server.Packet203TabComplete;
import net.minecraft.server.Packet204LocaleAndViewDistance;
import net.minecraft.server.Packet205ClientCommand;
import net.minecraft.server.Packet206SetScoreboardObjective;
import net.minecraft.server.Packet207SetScoreboardScore;
import net.minecraft.server.Packet208SetScoreboardDisplayObjective;
import net.minecraft.server.Packet209SetScoreboardTeam;
import net.minecraft.server.Packet20NamedEntitySpawn;
import net.minecraft.server.Packet22Collect;
import net.minecraft.server.Packet23VehicleSpawn;
import net.minecraft.server.Packet24MobSpawn;
import net.minecraft.server.Packet250CustomPayload;
import net.minecraft.server.Packet252KeyResponse;
import net.minecraft.server.Packet253KeyRequest;
import net.minecraft.server.Packet254GetInfo;
import net.minecraft.server.Packet255KickDisconnect;
import net.minecraft.server.Packet25EntityPainting;
import net.minecraft.server.Packet26AddExpOrb;
import net.minecraft.server.Packet27PlayerInput;
import net.minecraft.server.Packet28EntityVelocity;
import net.minecraft.server.Packet29DestroyEntity;
import net.minecraft.server.Packet2Handshake;
import net.minecraft.server.Packet30Entity;
import net.minecraft.server.Packet31RelEntityMove;
import net.minecraft.server.Packet32EntityLook;
import net.minecraft.server.Packet33RelEntityMoveLook;
import net.minecraft.server.Packet34EntityTeleport;
import net.minecraft.server.Packet35EntityHeadRotation;
import net.minecraft.server.Packet38EntityStatus;
import net.minecraft.server.Packet39AttachEntity;
import net.minecraft.server.Packet3Chat;
import net.minecraft.server.Packet40EntityMetadata;
import net.minecraft.server.Packet41MobEffect;
import net.minecraft.server.Packet42RemoveMobEffect;
import net.minecraft.server.Packet43SetExperience;
import net.minecraft.server.Packet44UpdateAttributes;
import net.minecraft.server.Packet4UpdateTime;
import net.minecraft.server.Packet51MapChunk;
import net.minecraft.server.Packet52MultiBlockChange;
import net.minecraft.server.Packet53BlockChange;
import net.minecraft.server.Packet54PlayNoteBlock;
import net.minecraft.server.Packet55BlockBreakAnimation;
import net.minecraft.server.Packet56MapChunkBulk;
import net.minecraft.server.Packet5EntityEquipment;
import net.minecraft.server.Packet60Explosion;
import net.minecraft.server.Packet61WorldEvent;
import net.minecraft.server.Packet62NamedSoundEffect;
import net.minecraft.server.Packet63WorldParticles;
import net.minecraft.server.Packet6SpawnPosition;
import net.minecraft.server.Packet70Bed;
import net.minecraft.server.Packet71Weather;
import net.minecraft.server.Packet7UseEntity;
import net.minecraft.server.Packet8UpdateHealth;
import net.minecraft.server.Packet9Respawn;
import net.minecraft.server.PacketCounter;

public abstract class Packet {
    public static IntHashMap l = new IntHashMap();
    private static Map a = new HashMap();
    private static Set b = new HashSet();
    private static Set c = new HashSet();
    protected IConsoleLogManager m;
    public final long timestamp = MinecraftServer.aq();
    public static long o;
    public static long p;
    public static long q;
    public static long r;
    public boolean lowPriority;

    static void a(int n, boolean bl, boolean bl2, Class clazz) {
        if (l.b(n)) {
            throw new IllegalArgumentException("Duplicate packet id:" + n);
        }
        if (a.containsKey(clazz)) {
            throw new IllegalArgumentException("Duplicate packet class:" + clazz);
        }
        l.a(n, clazz);
        a.put(clazz, n);
        if (bl) {
            b.add(n);
        }
        if (bl2) {
            c.add(n);
        }
    }

    public static Packet a(IConsoleLogManager iConsoleLogManager, int n) {
        try {
            Class clazz = (Class)l.get(n);
            if (clazz == null) {
                return null;
            }
            return (Packet)clazz.newInstance();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            iConsoleLogManager.severe("Skipping packet with id " + n);
            return null;
        }
    }

    public static void a(DataOutput dataOutput, byte[] byArray) {
        dataOutput.writeShort(byArray.length);
        dataOutput.write(byArray);
    }

    public static byte[] b(DataInput dataInput) {
        short s = dataInput.readShort();
        if (s < 0) {
            throw new IOException("Key was smaller than nothing!  Weird key!");
        }
        byte[] byArray = new byte[s];
        dataInput.readFully(byArray);
        return byArray;
    }

    public final int n() {
        return (Integer)a.get(this.getClass());
    }

    public static Packet a(IConsoleLogManager iConsoleLogManager, DataInput dataInput, boolean bl, Socket socket) {
        int n = 0;
        Packet packet = null;
        int n2 = socket.getSoTimeout();
        try {
            n = dataInput.readUnsignedByte();
            if (bl && !c.contains(n) || !bl && !b.contains(n)) {
                throw new IOException("Bad packet id " + n);
            }
            packet = Packet.a(iConsoleLogManager, n);
            if (packet == null) {
                throw new IOException("Bad packet id " + n);
            }
            packet.m = iConsoleLogManager;
            if (packet instanceof Packet254GetInfo) {
                socket.setSoTimeout(1500);
            }
            packet.a(dataInput);
            ++o;
            p += (long)packet.a();
        }
        catch (EOFException eOFException) {
            iConsoleLogManager.severe("Reached end of stream for " + socket.getInetAddress());
            return null;
        }
        PacketCounter.a(n, packet.a());
        ++o;
        p += (long)packet.a();
        socket.setSoTimeout(n2);
        return packet;
    }

    public static void a(Packet packet, DataOutput dataOutput) {
        dataOutput.write(packet.n());
        packet.a(dataOutput);
        ++q;
        r += (long)packet.a();
    }

    public static void a(String string, DataOutput dataOutput) {
        if (string.length() > Short.MAX_VALUE) {
            throw new IOException("String too big");
        }
        dataOutput.writeShort(string.length());
        dataOutput.writeChars(string);
    }

    public static String a(DataInput dataInput, int n) {
        int n2 = dataInput.readShort();
        if (n2 > n) {
            throw new IOException("Received string length longer than maximum allowed (" + n2 + " > " + n + ")");
        }
        if (n2 < 0) {
            throw new IOException("Received string length is less than zero! Weird string!");
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < n2; ++i) {
            stringBuilder.append(dataInput.readChar());
        }
        return stringBuilder.toString();
    }

    public abstract void a(DataInput var1);

    public abstract void a(DataOutput var1);

    public abstract void handle(Connection var1);

    public abstract int a();

    public boolean e() {
        return false;
    }

    public boolean a(Packet packet) {
        return false;
    }

    public boolean a_() {
        return false;
    }

    public String toString() {
        String string = this.getClass().getSimpleName();
        return string;
    }

    public static ItemStack c(DataInput dataInput) {
        ItemStack itemStack = null;
        short s = dataInput.readShort();
        if (s >= 0) {
            byte by = dataInput.readByte();
            short s2 = dataInput.readShort();
            itemStack = new ItemStack(s, (int)by, (int)s2);
            itemStack.tag = Packet.d(dataInput);
        }
        return itemStack;
    }

    public static void a(ItemStack itemStack, DataOutput dataOutput) {
        if (itemStack == null) {
            dataOutput.writeShort(-1);
        } else {
            dataOutput.writeShort(itemStack.id);
            dataOutput.writeByte(itemStack.count);
            dataOutput.writeShort(itemStack.getData());
            NBTTagCompound nBTTagCompound = null;
            if (itemStack.getItem().usesDurability() || itemStack.getItem().s()) {
                nBTTagCompound = itemStack.tag;
            }
            Packet.a(nBTTagCompound, dataOutput);
        }
    }

    public static NBTTagCompound d(DataInput dataInput) {
        short s = dataInput.readShort();
        if (s < 0) {
            return null;
        }
        byte[] byArray = new byte[s];
        dataInput.readFully(byArray);
        return NBTCompressedStreamTools.a(byArray);
    }

    protected static void a(NBTTagCompound nBTTagCompound, DataOutput dataOutput) {
        if (nBTTagCompound == null) {
            dataOutput.writeShort(-1);
        } else {
            byte[] byArray = NBTCompressedStreamTools.a(nBTTagCompound);
            dataOutput.writeShort((short)byArray.length);
            dataOutput.write(byArray);
        }
    }

    static {
        Packet.a(0, true, true, Packet0KeepAlive.class);
        Packet.a(1, true, true, Packet1Login.class);
        Packet.a(2, false, true, Packet2Handshake.class);
        Packet.a(3, true, true, Packet3Chat.class);
        Packet.a(4, true, false, Packet4UpdateTime.class);
        Packet.a(5, true, false, Packet5EntityEquipment.class);
        Packet.a(6, true, false, Packet6SpawnPosition.class);
        Packet.a(7, false, true, Packet7UseEntity.class);
        Packet.a(8, true, false, Packet8UpdateHealth.class);
        Packet.a(9, true, true, Packet9Respawn.class);
        Packet.a(10, true, true, Packet10Flying.class);
        Packet.a(11, true, true, Packet11PlayerPosition.class);
        Packet.a(12, true, true, Packet12PlayerLook.class);
        Packet.a(13, true, true, Packet13PlayerLookMove.class);
        Packet.a(14, false, true, Packet14BlockDig.class);
        Packet.a(15, false, true, Packet15Place.class);
        Packet.a(16, true, true, Packet16BlockItemSwitch.class);
        Packet.a(17, true, false, Packet17EntityLocationAction.class);
        Packet.a(18, true, true, Packet18ArmAnimation.class);
        Packet.a(19, false, true, Packet19EntityAction.class);
        Packet.a(20, true, false, Packet20NamedEntitySpawn.class);
        Packet.a(22, true, false, Packet22Collect.class);
        Packet.a(23, true, false, Packet23VehicleSpawn.class);
        Packet.a(24, true, false, Packet24MobSpawn.class);
        Packet.a(25, true, false, Packet25EntityPainting.class);
        Packet.a(26, true, false, Packet26AddExpOrb.class);
        Packet.a(27, false, true, Packet27PlayerInput.class);
        Packet.a(28, true, false, Packet28EntityVelocity.class);
        Packet.a(29, true, false, Packet29DestroyEntity.class);
        Packet.a(30, true, false, Packet30Entity.class);
        Packet.a(31, true, false, Packet31RelEntityMove.class);
        Packet.a(32, true, false, Packet32EntityLook.class);
        Packet.a(33, true, false, Packet33RelEntityMoveLook.class);
        Packet.a(34, true, false, Packet34EntityTeleport.class);
        Packet.a(35, true, false, Packet35EntityHeadRotation.class);
        Packet.a(38, true, false, Packet38EntityStatus.class);
        Packet.a(39, true, false, Packet39AttachEntity.class);
        Packet.a(40, true, false, Packet40EntityMetadata.class);
        Packet.a(41, true, false, Packet41MobEffect.class);
        Packet.a(42, true, false, Packet42RemoveMobEffect.class);
        Packet.a(43, true, false, Packet43SetExperience.class);
        Packet.a(44, true, false, Packet44UpdateAttributes.class);
        Packet.a(51, true, false, Packet51MapChunk.class);
        Packet.a(52, true, false, Packet52MultiBlockChange.class);
        Packet.a(53, true, false, Packet53BlockChange.class);
        Packet.a(54, true, false, Packet54PlayNoteBlock.class);
        Packet.a(55, true, false, Packet55BlockBreakAnimation.class);
        Packet.a(56, true, false, Packet56MapChunkBulk.class);
        Packet.a(60, true, false, Packet60Explosion.class);
        Packet.a(61, true, false, Packet61WorldEvent.class);
        Packet.a(62, true, false, Packet62NamedSoundEffect.class);
        Packet.a(63, true, false, Packet63WorldParticles.class);
        Packet.a(70, true, false, Packet70Bed.class);
        Packet.a(71, true, false, Packet71Weather.class);
        Packet.a(100, true, false, Packet100OpenWindow.class);
        Packet.a(101, true, true, Packet101CloseWindow.class);
        Packet.a(102, false, true, Packet102WindowClick.class);
        Packet.a(103, true, false, Packet103SetSlot.class);
        Packet.a(104, true, false, Packet104WindowItems.class);
        Packet.a(105, true, false, Packet105CraftProgressBar.class);
        Packet.a(106, true, true, Packet106Transaction.class);
        Packet.a(107, true, true, Packet107SetCreativeSlot.class);
        Packet.a(108, false, true, Packet108ButtonClick.class);
        Packet.a(130, true, true, Packet130UpdateSign.class);
        Packet.a(131, true, false, Packet131ItemData.class);
        Packet.a(132, true, false, Packet132TileEntityData.class);
        Packet.a(133, true, false, Packet133OpenTileEntity.class);
        Packet.a(200, true, false, Packet200Statistic.class);
        Packet.a(201, true, false, Packet201PlayerInfo.class);
        Packet.a(202, true, true, Packet202Abilities.class);
        Packet.a(203, true, true, Packet203TabComplete.class);
        Packet.a(204, false, true, Packet204LocaleAndViewDistance.class);
        Packet.a(205, false, true, Packet205ClientCommand.class);
        Packet.a(206, true, false, Packet206SetScoreboardObjective.class);
        Packet.a(207, true, false, Packet207SetScoreboardScore.class);
        Packet.a(208, true, false, Packet208SetScoreboardDisplayObjective.class);
        Packet.a(209, true, false, Packet209SetScoreboardTeam.class);
        Packet.a(250, true, true, Packet250CustomPayload.class);
        Packet.a(252, true, true, Packet252KeyResponse.class);
        Packet.a(253, true, false, Packet253KeyRequest.class);
        Packet.a(254, false, true, Packet254GetInfo.class);
        Packet.a(255, true, true, Packet255KickDisconnect.class);
    }
}

