/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import java.io.DataInput;
import java.io.DataOutput;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.server.NBTBase;

public class NBTTagList
extends NBTBase {
    private List list = new ArrayList();
    private byte type;

    public NBTTagList() {
        super("");
    }

    public NBTTagList(String string) {
        super(string);
    }

    @Override
    void write(DataOutput dataOutput) {
        this.type = !this.list.isEmpty() ? ((NBTBase)this.list.get(0)).getTypeId() : (byte)1;
        dataOutput.writeByte(this.type);
        dataOutput.writeInt(this.list.size());
        for (int i = 0; i < this.list.size(); ++i) {
            ((NBTBase)this.list.get(i)).write(dataOutput);
        }
    }

    @Override
    void load(DataInput dataInput, int n) {
        if (n > 512) {
            throw new RuntimeException("Tried to read NBT tag with too high complexity, depth > 512");
        }
        this.type = dataInput.readByte();
        int n2 = dataInput.readInt();
        this.list = new ArrayList();
        for (int i = 0; i < n2; ++i) {
            NBTBase nBTBase = NBTBase.createTag(this.type, null);
            nBTBase.load(dataInput, n + 1);
            this.list.add(nBTBase);
        }
    }

    @Override
    public byte getTypeId() {
        return 9;
    }

    public String toString() {
        return "" + this.list.size() + " entries of type " + NBTBase.getTagName(this.type);
    }

    public void add(NBTBase nBTBase) {
        this.type = nBTBase.getTypeId();
        this.list.add(nBTBase);
    }

    public NBTBase get(int n) {
        return (NBTBase)this.list.get(n);
    }

    public int size() {
        return this.list.size();
    }

    @Override
    public NBTBase clone() {
        NBTTagList nBTTagList = new NBTTagList(this.getName());
        nBTTagList.type = this.type;
        for (NBTBase nBTBase : this.list) {
            NBTBase nBTBase2 = nBTBase.clone();
            nBTTagList.list.add(nBTBase2);
        }
        return nBTTagList;
    }

    @Override
    public boolean equals(Object object) {
        if (super.equals(object)) {
            NBTTagList nBTTagList = (NBTTagList)object;
            if (this.type == nBTTagList.type) {
                return ((Object)this.list).equals(nBTTagList.list);
            }
        }
        return false;
    }

    @Override
    public int hashCode() {
        return super.hashCode() ^ ((Object)this.list).hashCode();
    }
}

