/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import java.io.DataInput;
import java.io.DataOutput;
import java.util.Arrays;
import net.minecraft.server.NBTBase;

public class NBTTagIntArray
extends NBTBase {
    public int[] data;

    public NBTTagIntArray(String string) {
        super(string);
    }

    public NBTTagIntArray(String string, int[] nArray) {
        super(string);
        this.data = nArray;
    }

    @Override
    void write(DataOutput dataOutput) {
        dataOutput.writeInt(this.data.length);
        for (int i = 0; i < this.data.length; ++i) {
            dataOutput.writeInt(this.data[i]);
        }
    }

    @Override
    void load(DataInput dataInput, int n) {
        int n2 = dataInput.readInt();
        this.data = new int[n2];
        for (int i = 0; i < n2; ++i) {
            this.data[i] = dataInput.readInt();
        }
    }

    @Override
    public byte getTypeId() {
        return 11;
    }

    public String toString() {
        return "[" + this.data.length + " bytes]";
    }

    @Override
    public NBTBase clone() {
        int[] nArray = new int[this.data.length];
        System.arraycopy(this.data, 0, nArray, 0, this.data.length);
        return new NBTTagIntArray(this.getName(), nArray);
    }

    @Override
    public boolean equals(Object object) {
        if (super.equals(object)) {
            NBTTagIntArray nBTTagIntArray = (NBTTagIntArray)object;
            return this.data == null && nBTTagIntArray.data == null || this.data != null && Arrays.equals(this.data, nBTTagIntArray.data);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return super.hashCode() ^ Arrays.hashCode(this.data);
    }
}

