/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import java.io.DataInput;
import java.io.DataOutput;
import net.minecraft.server.NBTBase;

public class NBTTagFloat
extends NBTBase {
    public float data;

    public NBTTagFloat(String string) {
        super(string);
    }

    public NBTTagFloat(String string, float f) {
        super(string);
        this.data = f;
    }

    @Override
    void write(DataOutput dataOutput) {
        dataOutput.writeFloat(this.data);
    }

    @Override
    void load(DataInput dataInput, int n) {
        this.data = dataInput.readFloat();
    }

    @Override
    public byte getTypeId() {
        return 5;
    }

    public String toString() {
        return "" + this.data;
    }

    @Override
    public NBTBase clone() {
        return new NBTTagFloat(this.getName(), this.data);
    }

    @Override
    public boolean equals(Object object) {
        if (super.equals(object)) {
            NBTTagFloat nBTTagFloat = (NBTTagFloat)object;
            return this.data == nBTTagFloat.data;
        }
        return false;
    }

    @Override
    public int hashCode() {
        return super.hashCode() ^ Float.floatToIntBits(this.data);
    }
}

