/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import java.io.DataInput;
import java.io.DataOutput;
import net.minecraft.server.NBTBase;

public class NBTTagDouble
extends NBTBase {
    public double data;

    public NBTTagDouble(String string) {
        super(string);
    }

    public NBTTagDouble(String string, double d) {
        super(string);
        this.data = d;
    }

    @Override
    void write(DataOutput dataOutput) {
        dataOutput.writeDouble(this.data);
    }

    @Override
    void load(DataInput dataInput, int n) {
        this.data = dataInput.readDouble();
    }

    @Override
    public byte getTypeId() {
        return 6;
    }

    public String toString() {
        return "" + this.data;
    }

    @Override
    public NBTBase clone() {
        return new NBTTagDouble(this.getName(), this.data);
    }

    @Override
    public boolean equals(Object object) {
        if (super.equals(object)) {
            NBTTagDouble nBTTagDouble = (NBTTagDouble)object;
            return this.data == nBTTagDouble.data;
        }
        return false;
    }

    @Override
    public int hashCode() {
        long l = Double.doubleToLongBits(this.data);
        return super.hashCode() ^ (int)(l ^ l >>> 32);
    }
}

