/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import java.io.DataInput;
import java.io.DataOutput;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.server.CrashReport;
import net.minecraft.server.CrashReportCorruptNBTTag;
import net.minecraft.server.CrashReportCorruptNBTTag2;
import net.minecraft.server.CrashReportSystemDetails;
import net.minecraft.server.NBTBase;
import net.minecraft.server.NBTTagByte;
import net.minecraft.server.NBTTagByteArray;
import net.minecraft.server.NBTTagDouble;
import net.minecraft.server.NBTTagFloat;
import net.minecraft.server.NBTTagInt;
import net.minecraft.server.NBTTagIntArray;
import net.minecraft.server.NBTTagList;
import net.minecraft.server.NBTTagLong;
import net.minecraft.server.NBTTagShort;
import net.minecraft.server.NBTTagString;
import net.minecraft.server.ReportedException;

public class NBTTagCompound
extends NBTBase {
    private Map map = new HashMap();

    public NBTTagCompound() {
        super("");
    }

    public NBTTagCompound(String string) {
        super(string);
    }

    @Override
    void write(DataOutput dataOutput) {
        for (NBTBase nBTBase : this.map.values()) {
            NBTBase.a(nBTBase, dataOutput);
        }
        dataOutput.writeByte(0);
    }

    @Override
    void load(DataInput dataInput, int n) {
        NBTBase nBTBase;
        if (n > 512) {
            throw new RuntimeException("Tried to read NBT tag with too high complexity, depth > 512");
        }
        this.map.clear();
        while ((nBTBase = NBTBase.b(dataInput, n + 1)).getTypeId() != 0) {
            this.map.put(nBTBase.getName(), nBTBase);
        }
    }

    public Collection c() {
        return this.map.values();
    }

    @Override
    public byte getTypeId() {
        return 10;
    }

    public void set(String string, NBTBase nBTBase) {
        this.map.put(string, nBTBase.setName(string));
    }

    public void setByte(String string, byte by) {
        this.map.put(string, new NBTTagByte(string, by));
    }

    public void setShort(String string, short s) {
        this.map.put(string, new NBTTagShort(string, s));
    }

    public void setInt(String string, int n) {
        this.map.put(string, new NBTTagInt(string, n));
    }

    public void setLong(String string, long l) {
        this.map.put(string, new NBTTagLong(string, l));
    }

    public void setFloat(String string, float f) {
        this.map.put(string, new NBTTagFloat(string, f));
    }

    public void setDouble(String string, double d) {
        this.map.put(string, new NBTTagDouble(string, d));
    }

    public void setString(String string, String string2) {
        this.map.put(string, new NBTTagString(string, string2));
    }

    public void setByteArray(String string, byte[] byArray) {
        this.map.put(string, new NBTTagByteArray(string, byArray));
    }

    public void setIntArray(String string, int[] nArray) {
        this.map.put(string, new NBTTagIntArray(string, nArray));
    }

    public void setCompound(String string, NBTTagCompound nBTTagCompound) {
        this.map.put(string, nBTTagCompound.setName(string));
    }

    public void setBoolean(String string, boolean bl) {
        this.setByte(string, bl ? (byte)1 : 0);
    }

    public NBTBase get(String string) {
        return (NBTBase)this.map.get(string);
    }

    public boolean hasKey(String string) {
        return this.map.containsKey(string);
    }

    public byte getByte(String string) {
        try {
            if (!this.map.containsKey(string)) {
                return 0;
            }
            return ((NBTTagByte)this.map.get((Object)string)).data;
        }
        catch (ClassCastException classCastException) {
            throw new ReportedException(this.a(string, 1, classCastException));
        }
    }

    public short getShort(String string) {
        try {
            if (!this.map.containsKey(string)) {
                return 0;
            }
            return ((NBTTagShort)this.map.get((Object)string)).data;
        }
        catch (ClassCastException classCastException) {
            throw new ReportedException(this.a(string, 2, classCastException));
        }
    }

    public int getInt(String string) {
        try {
            if (!this.map.containsKey(string)) {
                return 0;
            }
            return ((NBTTagInt)this.map.get((Object)string)).data;
        }
        catch (ClassCastException classCastException) {
            throw new ReportedException(this.a(string, 3, classCastException));
        }
    }

    public long getLong(String string) {
        try {
            if (!this.map.containsKey(string)) {
                return 0L;
            }
            return ((NBTTagLong)this.map.get((Object)string)).data;
        }
        catch (ClassCastException classCastException) {
            throw new ReportedException(this.a(string, 4, classCastException));
        }
    }

    public float getFloat(String string) {
        try {
            if (!this.map.containsKey(string)) {
                return 0.0f;
            }
            return ((NBTTagFloat)this.map.get((Object)string)).data;
        }
        catch (ClassCastException classCastException) {
            throw new ReportedException(this.a(string, 5, classCastException));
        }
    }

    public double getDouble(String string) {
        try {
            if (!this.map.containsKey(string)) {
                return 0.0;
            }
            return ((NBTTagDouble)this.map.get((Object)string)).data;
        }
        catch (ClassCastException classCastException) {
            throw new ReportedException(this.a(string, 6, classCastException));
        }
    }

    public String getString(String string) {
        try {
            if (!this.map.containsKey(string)) {
                return "";
            }
            return ((NBTTagString)this.map.get((Object)string)).data;
        }
        catch (ClassCastException classCastException) {
            throw new ReportedException(this.a(string, 8, classCastException));
        }
    }

    public byte[] getByteArray(String string) {
        try {
            if (!this.map.containsKey(string)) {
                return new byte[0];
            }
            return ((NBTTagByteArray)this.map.get((Object)string)).data;
        }
        catch (ClassCastException classCastException) {
            throw new ReportedException(this.a(string, 7, classCastException));
        }
    }

    public int[] getIntArray(String string) {
        try {
            if (!this.map.containsKey(string)) {
                return new int[0];
            }
            return ((NBTTagIntArray)this.map.get((Object)string)).data;
        }
        catch (ClassCastException classCastException) {
            throw new ReportedException(this.a(string, 11, classCastException));
        }
    }

    public NBTTagCompound getCompound(String string) {
        try {
            if (!this.map.containsKey(string)) {
                return new NBTTagCompound(string);
            }
            return (NBTTagCompound)this.map.get(string);
        }
        catch (ClassCastException classCastException) {
            throw new ReportedException(this.a(string, 10, classCastException));
        }
    }

    public NBTTagList getList(String string) {
        try {
            if (!this.map.containsKey(string)) {
                return new NBTTagList(string);
            }
            return (NBTTagList)this.map.get(string);
        }
        catch (ClassCastException classCastException) {
            throw new ReportedException(this.a(string, 9, classCastException));
        }
    }

    public boolean getBoolean(String string) {
        return this.getByte(string) != 0;
    }

    public void remove(String string) {
        this.map.remove(string);
    }

    public String toString() {
        String string = this.getName() + ":[";
        for (String string2 : this.map.keySet()) {
            string = string + string2 + ":" + this.map.get(string2) + ",";
        }
        return string + "]";
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    private CrashReport a(String string, int n, ClassCastException classCastException) {
        CrashReport crashReport = CrashReport.a(classCastException, "Reading NBT data");
        CrashReportSystemDetails crashReportSystemDetails = crashReport.a("Corrupt NBT tag", 1);
        crashReportSystemDetails.a("Tag type found", new CrashReportCorruptNBTTag(this, string));
        crashReportSystemDetails.a("Tag type expected", new CrashReportCorruptNBTTag2(this, n));
        crashReportSystemDetails.a("Tag name", string);
        if (this.getName() != null && this.getName().length() > 0) {
            crashReportSystemDetails.a("Tag parent", this.getName());
        }
        return crashReport;
    }

    @Override
    public NBTBase clone() {
        NBTTagCompound nBTTagCompound = new NBTTagCompound(this.getName());
        for (String string : this.map.keySet()) {
            nBTTagCompound.set(string, ((NBTBase)this.map.get(string)).clone());
        }
        return nBTTagCompound;
    }

    @Override
    public boolean equals(Object object) {
        if (super.equals(object)) {
            NBTTagCompound nBTTagCompound = (NBTTagCompound)object;
            return ((Object)this.map.entrySet()).equals(nBTTagCompound.map.entrySet());
        }
        return false;
    }

    @Override
    public int hashCode() {
        return super.hashCode() ^ ((Object)this.map).hashCode();
    }

    static /* synthetic */ Map a(NBTTagCompound nBTTagCompound) {
        return nBTTagCompound.map;
    }
}

