/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import java.io.DataInput;
import java.io.DataOutput;
import java.util.Arrays;
import net.minecraft.server.NBTBase;

public class NBTTagByteArray
extends NBTBase {
    public byte[] data;

    public NBTTagByteArray(String string) {
        super(string);
    }

    public NBTTagByteArray(String string, byte[] byArray) {
        super(string);
        this.data = byArray;
    }

    @Override
    void write(DataOutput dataOutput) {
        dataOutput.writeInt(this.data.length);
        dataOutput.write(this.data);
    }

    @Override
    void load(DataInput dataInput, int n) {
        int n2 = dataInput.readInt();
        this.data = new byte[n2];
        dataInput.readFully(this.data);
    }

    @Override
    public byte getTypeId() {
        return 7;
    }

    public String toString() {
        return "[" + this.data.length + " bytes]";
    }

    @Override
    public NBTBase clone() {
        byte[] byArray = new byte[this.data.length];
        System.arraycopy(this.data, 0, byArray, 0, this.data.length);
        return new NBTTagByteArray(this.getName(), byArray);
    }

    @Override
    public boolean equals(Object object) {
        if (super.equals(object)) {
            return Arrays.equals(this.data, ((NBTTagByteArray)object).data);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return super.hashCode() ^ Arrays.hashCode(this.data);
    }
}

