/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import net.minecraft.server.CrashReport;
import net.minecraft.server.CrashReportSystemDetails;
import net.minecraft.server.NBTTagByte;
import net.minecraft.server.NBTTagByteArray;
import net.minecraft.server.NBTTagCompound;
import net.minecraft.server.NBTTagDouble;
import net.minecraft.server.NBTTagEnd;
import net.minecraft.server.NBTTagFloat;
import net.minecraft.server.NBTTagInt;
import net.minecraft.server.NBTTagIntArray;
import net.minecraft.server.NBTTagList;
import net.minecraft.server.NBTTagLong;
import net.minecraft.server.NBTTagShort;
import net.minecraft.server.NBTTagString;
import net.minecraft.server.ReportedException;

public abstract class NBTBase {
    public static final String[] b = new String[]{"END", "BYTE", "SHORT", "INT", "LONG", "FLOAT", "DOUBLE", "BYTE[]", "STRING", "LIST", "COMPOUND", "INT[]"};
    private String name;

    abstract void write(DataOutput var1);

    abstract void load(DataInput var1, int var2);

    public abstract byte getTypeId();

    protected NBTBase(String string) {
        this.name = string == null ? "" : string;
    }

    public NBTBase setName(String string) {
        this.name = string == null ? "" : string;
        return this;
    }

    public String getName() {
        if (this.name == null) {
            return "";
        }
        return this.name;
    }

    public static NBTBase a(DataInput dataInput) {
        return NBTBase.b(dataInput, 0);
    }

    public static NBTBase b(DataInput dataInput, int n) {
        byte by = dataInput.readByte();
        if (by == 0) {
            return new NBTTagEnd();
        }
        String string = dataInput.readUTF();
        NBTBase nBTBase = NBTBase.createTag(by, string);
        try {
            nBTBase.load(dataInput, n);
        }
        catch (IOException iOException) {
            CrashReport crashReport = CrashReport.a(iOException, "Loading NBT data");
            CrashReportSystemDetails crashReportSystemDetails = crashReport.a("NBT Tag");
            crashReportSystemDetails.a("Tag name", string);
            crashReportSystemDetails.a("Tag type", by);
            throw new ReportedException(crashReport);
        }
        return nBTBase;
    }

    public static void a(NBTBase nBTBase, DataOutput dataOutput) {
        dataOutput.writeByte(nBTBase.getTypeId());
        if (nBTBase.getTypeId() == 0) {
            return;
        }
        dataOutput.writeUTF(nBTBase.getName());
        nBTBase.write(dataOutput);
    }

    public static NBTBase createTag(byte by, String string) {
        switch (by) {
            case 0: {
                return new NBTTagEnd();
            }
            case 1: {
                return new NBTTagByte(string);
            }
            case 2: {
                return new NBTTagShort(string);
            }
            case 3: {
                return new NBTTagInt(string);
            }
            case 4: {
                return new NBTTagLong(string);
            }
            case 5: {
                return new NBTTagFloat(string);
            }
            case 6: {
                return new NBTTagDouble(string);
            }
            case 7: {
                return new NBTTagByteArray(string);
            }
            case 11: {
                return new NBTTagIntArray(string);
            }
            case 8: {
                return new NBTTagString(string);
            }
            case 9: {
                return new NBTTagList(string);
            }
            case 10: {
                return new NBTTagCompound(string);
            }
        }
        return null;
    }

    public static String getTagName(byte by) {
        switch (by) {
            case 0: {
                return "TAG_End";
            }
            case 1: {
                return "TAG_Byte";
            }
            case 2: {
                return "TAG_Short";
            }
            case 3: {
                return "TAG_Int";
            }
            case 4: {
                return "TAG_Long";
            }
            case 5: {
                return "TAG_Float";
            }
            case 6: {
                return "TAG_Double";
            }
            case 7: {
                return "TAG_Byte_Array";
            }
            case 11: {
                return "TAG_Int_Array";
            }
            case 8: {
                return "TAG_String";
            }
            case 9: {
                return "TAG_List";
            }
            case 10: {
                return "TAG_Compound";
            }
        }
        return "UNKNOWN";
    }

    public abstract NBTBase clone();

    public boolean equals(Object object) {
        if (!(object instanceof NBTBase)) {
            return false;
        }
        NBTBase nBTBase = (NBTBase)object;
        if (this.getTypeId() != nBTBase.getTypeId()) {
            return false;
        }
        if (this.name == null && nBTBase.name != null || this.name != null && nBTBase.name == null) {
            return false;
        }
        return this.name == null || this.name.equals(nBTBase.name);
    }

    public int hashCode() {
        return this.name.hashCode() ^ this.getTypeId();
    }
}

