/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.server.AxisAlignedBB;
import net.minecraft.server.Entity;
import net.minecraft.server.EntityInsentient;
import net.minecraft.server.EntityLiving;
import net.minecraft.server.EntityTypes;
import net.minecraft.server.GroupDataEntity;
import net.minecraft.server.NBTBase;
import net.minecraft.server.NBTTagCompound;
import net.minecraft.server.NBTTagList;
import net.minecraft.server.TileEntityMobSpawnerData;
import net.minecraft.server.WeightedRandom;
import net.minecraft.server.World;

public abstract class MobSpawnerAbstract {
    public int spawnDelay = 20;
    private String mobName = "Pig";
    private List mobs;
    private TileEntityMobSpawnerData spawnData;
    public double c;
    public double d;
    private int minSpawnDelay = 200;
    private int maxSpawnDelay = 800;
    private int spawnCount = 4;
    private Entity j;
    private int maxNearbyEntities = 6;
    private int requiredPlayerRange = 16;
    private int spawnRange = 4;

    public String getMobName() {
        if (this.i() == null) {
            if (this.mobName.equals("Minecart")) {
                this.mobName = "MinecartRideable";
            }
            return this.mobName;
        }
        return this.i().c;
    }

    public void a(String string) {
        this.mobName = string;
    }

    public boolean f() {
        return this.a().findNearbyPlayer((double)this.b() + 0.5, (double)this.c() + 0.5, (double)this.d() + 0.5, this.requiredPlayerRange) != null;
    }

    public void g() {
        if (!this.f()) {
            return;
        }
        if (this.a().isStatic) {
            double d = (float)this.b() + this.a().random.nextFloat();
            double d2 = (float)this.c() + this.a().random.nextFloat();
            double d3 = (float)this.d() + this.a().random.nextFloat();
            this.a().addParticle("smoke", d, d2, d3, 0.0, 0.0, 0.0);
            this.a().addParticle("flame", d, d2, d3, 0.0, 0.0, 0.0);
            if (this.spawnDelay > 0) {
                --this.spawnDelay;
            }
            this.d = this.c;
            this.c = (this.c + (double)(1000.0f / ((float)this.spawnDelay + 200.0f))) % 360.0;
        } else {
            if (this.spawnDelay == -1) {
                this.j();
            }
            if (this.spawnDelay > 0) {
                --this.spawnDelay;
                return;
            }
            boolean bl = false;
            for (int i = 0; i < this.spawnCount; ++i) {
                Entity entity = EntityTypes.createEntityByName(this.getMobName(), this.a());
                if (entity == null) {
                    return;
                }
                int n = this.a().a(entity.getClass(), AxisAlignedBB.a().a(this.b(), this.c(), this.d(), this.b() + 1, this.c() + 1, this.d() + 1).grow(this.spawnRange * 2, 4.0, this.spawnRange * 2)).size();
                if (n >= this.maxNearbyEntities) {
                    this.j();
                    return;
                }
                double d = (double)this.b() + (this.a().random.nextDouble() - this.a().random.nextDouble()) * (double)this.spawnRange;
                double d4 = this.c() + this.a().random.nextInt(3) - 1;
                double d5 = (double)this.d() + (this.a().random.nextDouble() - this.a().random.nextDouble()) * (double)this.spawnRange;
                EntityInsentient entityInsentient = entity instanceof EntityInsentient ? (EntityInsentient)entity : null;
                entity.setPositionRotation(d, d4, d5, this.a().random.nextFloat() * 360.0f, 0.0f);
                if (entityInsentient != null && !entityInsentient.canSpawn()) continue;
                this.a(entity);
                this.a().triggerEffect(2004, this.b(), this.c(), this.d(), 0);
                if (entityInsentient != null) {
                    entityInsentient.q();
                }
                bl = true;
            }
            if (bl) {
                this.j();
            }
        }
    }

    public Entity a(Entity entity) {
        if (this.i() != null) {
            NBTBase nBTBase = new NBTTagCompound();
            entity.d((NBTTagCompound)nBTBase);
            for (NBTBase nBTBase2 : this.i().b.c()) {
                nBTBase.set(nBTBase2.getName(), nBTBase2.clone());
            }
            entity.f((NBTTagCompound)nBTBase);
            if (entity.world != null) {
                entity.world.addEntity(entity);
            }
            Object object = entity;
            while (nBTBase.hasKey("Riding")) {
                NBTBase nBTBase2;
                nBTBase2 = nBTBase.getCompound("Riding");
                Entity entity2 = EntityTypes.createEntityByName(((NBTTagCompound)nBTBase2).getString("id"), entity.world);
                if (entity2 != null) {
                    NBTTagCompound nBTTagCompound = new NBTTagCompound();
                    entity2.d(nBTTagCompound);
                    for (NBTBase nBTBase3 : ((NBTTagCompound)nBTBase2).c()) {
                        nBTTagCompound.set(nBTBase3.getName(), nBTBase3.clone());
                    }
                    entity2.f(nBTTagCompound);
                    entity2.setPositionRotation(((Entity)object).locX, ((Entity)object).locY, ((Entity)object).locZ, ((Entity)object).yaw, ((Entity)object).pitch);
                    if (entity.world != null) {
                        entity.world.addEntity(entity2);
                    }
                    ((Entity)object).mount(entity2);
                }
                object = entity2;
                nBTBase = nBTBase2;
            }
        } else if (entity instanceof EntityLiving && entity.world != null) {
            ((EntityInsentient)entity).a((GroupDataEntity)null);
            this.a().addEntity(entity);
        }
        return entity;
    }

    private void j() {
        this.spawnDelay = this.maxSpawnDelay <= this.minSpawnDelay ? this.minSpawnDelay : this.minSpawnDelay + this.a().random.nextInt(this.maxSpawnDelay - this.minSpawnDelay);
        if (this.mobs != null && this.mobs.size() > 0) {
            this.a((TileEntityMobSpawnerData)WeightedRandom.a(this.a().random, this.mobs));
        }
        this.a(1);
    }

    public void a(NBTTagCompound nBTTagCompound) {
        this.mobName = nBTTagCompound.getString("EntityId");
        this.spawnDelay = nBTTagCompound.getShort("Delay");
        if (nBTTagCompound.hasKey("SpawnPotentials")) {
            this.mobs = new ArrayList();
            NBTTagList nBTTagList = nBTTagCompound.getList("SpawnPotentials");
            for (int i = 0; i < nBTTagList.size(); ++i) {
                this.mobs.add(new TileEntityMobSpawnerData(this, (NBTTagCompound)nBTTagList.get(i)));
            }
        } else {
            this.mobs = null;
        }
        if (nBTTagCompound.hasKey("SpawnData")) {
            this.a(new TileEntityMobSpawnerData(this, nBTTagCompound.getCompound("SpawnData"), this.mobName));
        } else {
            this.a((TileEntityMobSpawnerData)null);
        }
        if (nBTTagCompound.hasKey("MinSpawnDelay")) {
            this.minSpawnDelay = nBTTagCompound.getShort("MinSpawnDelay");
            this.maxSpawnDelay = nBTTagCompound.getShort("MaxSpawnDelay");
            this.spawnCount = nBTTagCompound.getShort("SpawnCount");
        }
        if (nBTTagCompound.hasKey("MaxNearbyEntities")) {
            this.maxNearbyEntities = nBTTagCompound.getShort("MaxNearbyEntities");
            this.requiredPlayerRange = nBTTagCompound.getShort("RequiredPlayerRange");
        }
        if (nBTTagCompound.hasKey("SpawnRange")) {
            this.spawnRange = nBTTagCompound.getShort("SpawnRange");
        }
        if (this.a() != null && this.a().isStatic) {
            this.j = null;
        }
    }

    public void b(NBTTagCompound nBTTagCompound) {
        nBTTagCompound.setString("EntityId", this.getMobName());
        nBTTagCompound.setShort("Delay", (short)this.spawnDelay);
        nBTTagCompound.setShort("MinSpawnDelay", (short)this.minSpawnDelay);
        nBTTagCompound.setShort("MaxSpawnDelay", (short)this.maxSpawnDelay);
        nBTTagCompound.setShort("SpawnCount", (short)this.spawnCount);
        nBTTagCompound.setShort("MaxNearbyEntities", (short)this.maxNearbyEntities);
        nBTTagCompound.setShort("RequiredPlayerRange", (short)this.requiredPlayerRange);
        nBTTagCompound.setShort("SpawnRange", (short)this.spawnRange);
        if (this.i() != null) {
            nBTTagCompound.setCompound("SpawnData", (NBTTagCompound)this.i().b.clone());
        }
        if (this.i() != null || this.mobs != null && this.mobs.size() > 0) {
            NBTTagList nBTTagList = new NBTTagList();
            if (this.mobs != null && this.mobs.size() > 0) {
                for (TileEntityMobSpawnerData tileEntityMobSpawnerData : this.mobs) {
                    nBTTagList.add(tileEntityMobSpawnerData.a());
                }
            } else {
                nBTTagList.add(this.i().a());
            }
            nBTTagCompound.set("SpawnPotentials", nBTTagList);
        }
    }

    public boolean b(int n) {
        if (n == 1 && this.a().isStatic) {
            this.spawnDelay = this.minSpawnDelay;
            return true;
        }
        return false;
    }

    public TileEntityMobSpawnerData i() {
        return this.spawnData;
    }

    public void a(TileEntityMobSpawnerData tileEntityMobSpawnerData) {
        this.spawnData = tileEntityMobSpawnerData;
    }

    public abstract void a(int var1);

    public abstract World a();

    public abstract int b();

    public abstract int c();

    public abstract int d();
}

