/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import com.google.common.collect.Maps;
import java.util.Map;
import java.util.UUID;
import net.minecraft.server.AttributeInstance;
import net.minecraft.server.AttributeMapBase;
import net.minecraft.server.AttributeModifier;
import net.minecraft.server.DamageSource;
import net.minecraft.server.EntityHuman;
import net.minecraft.server.EntityLiving;
import net.minecraft.server.GenericAttributes;
import net.minecraft.server.IAttribute;
import net.minecraft.server.InstantMobEffect;
import net.minecraft.server.MobEffectAbsorption;
import net.minecraft.server.MobEffectAttackDamage;
import net.minecraft.server.MobEffectHealthBoost;

public class MobEffectList {
    public static final MobEffectList[] byId = new MobEffectList[32];
    public static final MobEffectList b = null;
    public static final MobEffectList FASTER_MOVEMENT = new MobEffectList(1, false, 8171462).b("potion.moveSpeed").b(0, 0).a(GenericAttributes.d, "91AEAA56-376B-4498-935B-2F7F68070635", 0.2f, 2);
    public static final MobEffectList SLOWER_MOVEMENT = new MobEffectList(2, true, 5926017).b("potion.moveSlowdown").b(1, 0).a(GenericAttributes.d, "7107DE5E-7CE8-4030-940E-514C1F160890", -0.15f, 2);
    public static final MobEffectList FASTER_DIG = new MobEffectList(3, false, 14270531).b("potion.digSpeed").b(2, 0).a(1.5);
    public static final MobEffectList SLOWER_DIG = new MobEffectList(4, true, 4866583).b("potion.digSlowDown").b(3, 0);
    public static final MobEffectList INCREASE_DAMAGE = new MobEffectAttackDamage(5, false, 9643043).b("potion.damageBoost").b(4, 0).a(GenericAttributes.e, "648D7064-6A60-4F59-8ABE-C2C23A6DD7A9", 3.0, 2);
    public static final MobEffectList HEAL = new InstantMobEffect(6, false, 16262179).b("potion.heal");
    public static final MobEffectList HARM = new InstantMobEffect(7, true, 4393481).b("potion.harm");
    public static final MobEffectList JUMP = new MobEffectList(8, false, 7889559).b("potion.jump").b(2, 1);
    public static final MobEffectList CONFUSION = new MobEffectList(9, true, 5578058).b("potion.confusion").b(3, 1).a(0.25);
    public static final MobEffectList REGENERATION = new MobEffectList(10, false, 13458603).b("potion.regeneration").b(7, 0).a(0.25);
    public static final MobEffectList RESISTANCE = new MobEffectList(11, false, 10044730).b("potion.resistance").b(6, 1);
    public static final MobEffectList FIRE_RESISTANCE = new MobEffectList(12, false, 14981690).b("potion.fireResistance").b(7, 1);
    public static final MobEffectList WATER_BREATHING = new MobEffectList(13, false, 3035801).b("potion.waterBreathing").b(0, 2);
    public static final MobEffectList INVISIBILITY = new MobEffectList(14, false, 8356754).b("potion.invisibility").b(0, 1);
    public static final MobEffectList BLINDNESS = new MobEffectList(15, true, 2039587).b("potion.blindness").b(5, 1).a(0.25);
    public static final MobEffectList NIGHT_VISION = new MobEffectList(16, false, 0x1F1FA1).b("potion.nightVision").b(4, 1);
    public static final MobEffectList HUNGER = new MobEffectList(17, true, 5797459).b("potion.hunger").b(1, 1);
    public static final MobEffectList WEAKNESS = new MobEffectAttackDamage(18, true, 0x484D48).b("potion.weakness").b(5, 0).a(GenericAttributes.e, "22653B89-116E-49DC-9B6B-9971489B5BE5", 2.0, 0);
    public static final MobEffectList POISON = new MobEffectList(19, true, 5149489).b("potion.poison").b(6, 0).a(0.25);
    public static final MobEffectList WITHER = new MobEffectList(20, true, 3484199).b("potion.wither").b(1, 2).a(0.25);
    public static final MobEffectList HEALTH_BOOST = new MobEffectHealthBoost(21, false, 16284963).b("potion.healthBoost").b(2, 2).a(GenericAttributes.a, "5D6F0BA2-1186-46AC-B896-C61C5CEE99CC", 4.0, 0);
    public static final MobEffectList ABSORPTION = new MobEffectAbsorption(22, false, 0x2552A5).b("potion.absorption").b(2, 2);
    public static final MobEffectList SATURATION = new InstantMobEffect(23, false, 16262179).b("potion.saturation");
    public static final MobEffectList z = null;
    public static final MobEffectList A = null;
    public static final MobEffectList B = null;
    public static final MobEffectList C = null;
    public static final MobEffectList D = null;
    public static final MobEffectList E = null;
    public static final MobEffectList F = null;
    public static final MobEffectList G = null;
    public final int id;
    private final Map I = Maps.newHashMap();
    private final boolean J;
    private final int K;
    private String L = "";
    private int M = -1;
    private double N;
    private boolean O;

    protected MobEffectList(int n, boolean bl, int n2) {
        this.id = n;
        MobEffectList.byId[n] = this;
        this.J = bl;
        this.N = bl ? 0.5 : 1.0;
        this.K = n2;
    }

    protected MobEffectList b(int n, int n2) {
        this.M = n + n2 * 8;
        return this;
    }

    public int getId() {
        return this.id;
    }

    public void tick(EntityLiving entityLiving, int n) {
        if (this.id == MobEffectList.REGENERATION.id) {
            if (entityLiving.getHealth() < entityLiving.getMaxHealth()) {
                entityLiving.heal(1.0f);
            }
        } else if (this.id == MobEffectList.POISON.id) {
            if (entityLiving.getHealth() > 1.0f) {
                entityLiving.damageEntity(DamageSource.MAGIC, 1.0f);
            }
        } else if (this.id == MobEffectList.WITHER.id) {
            entityLiving.damageEntity(DamageSource.WITHER, 1.0f);
        } else if (this.id == MobEffectList.HUNGER.id && entityLiving instanceof EntityHuman) {
            ((EntityHuman)entityLiving).a(0.025f * (float)(n + 1));
        } else if (this.id == MobEffectList.SATURATION.id && entityLiving instanceof EntityHuman) {
            if (!entityLiving.world.isStatic) {
                ((EntityHuman)entityLiving).getFoodData().eat(n + 1, 1.0f);
            }
        } else if (this.id == MobEffectList.HEAL.id && !entityLiving.aM() || this.id == MobEffectList.HARM.id && entityLiving.aM()) {
            entityLiving.heal(Math.max(4 << n, 0));
        } else if (this.id == MobEffectList.HARM.id && !entityLiving.aM() || this.id == MobEffectList.HEAL.id && entityLiving.aM()) {
            entityLiving.damageEntity(DamageSource.MAGIC, 6 << n);
        }
    }

    public void applyInstantEffect(EntityLiving entityLiving, EntityLiving entityLiving2, int n, double d) {
        if (this.id == MobEffectList.HEAL.id && !entityLiving2.aM() || this.id == MobEffectList.HARM.id && entityLiving2.aM()) {
            int n2 = (int)(d * (double)(4 << n) + 0.5);
            entityLiving2.heal(n2);
        } else if (this.id == MobEffectList.HARM.id && !entityLiving2.aM() || this.id == MobEffectList.HEAL.id && entityLiving2.aM()) {
            int n3 = (int)(d * (double)(6 << n) + 0.5);
            if (entityLiving == null) {
                entityLiving2.damageEntity(DamageSource.MAGIC, n3);
            } else {
                entityLiving2.damageEntity(DamageSource.b(entityLiving2, entityLiving), n3);
            }
        }
    }

    public boolean isInstant() {
        return false;
    }

    public boolean a(int n, int n2) {
        if (this.id == MobEffectList.REGENERATION.id) {
            int n3 = 50 >> n2;
            if (n3 > 0) {
                return n % n3 == 0;
            }
            return true;
        }
        if (this.id == MobEffectList.POISON.id) {
            int n4 = 25 >> n2;
            if (n4 > 0) {
                return n % n4 == 0;
            }
            return true;
        }
        if (this.id == MobEffectList.WITHER.id) {
            int n5 = 40 >> n2;
            if (n5 > 0) {
                return n % n5 == 0;
            }
            return true;
        }
        return this.id == MobEffectList.HUNGER.id;
    }

    public MobEffectList b(String string) {
        this.L = string;
        return this;
    }

    public String a() {
        return this.L;
    }

    protected MobEffectList a(double d) {
        this.N = d;
        return this;
    }

    public double getDurationModifier() {
        return this.N;
    }

    public boolean i() {
        return this.O;
    }

    public int j() {
        return this.K;
    }

    public MobEffectList a(IAttribute iAttribute, String string, double d, int n) {
        AttributeModifier attributeModifier = new AttributeModifier(UUID.fromString(string), this.a(), d, n);
        this.I.put(iAttribute, attributeModifier);
        return this;
    }

    public void a(EntityLiving entityLiving, AttributeMapBase attributeMapBase, int n) {
        for (Map.Entry entry : this.I.entrySet()) {
            AttributeInstance attributeInstance = attributeMapBase.a((IAttribute)entry.getKey());
            if (attributeInstance == null) continue;
            attributeInstance.b((AttributeModifier)entry.getValue());
        }
    }

    public void b(EntityLiving entityLiving, AttributeMapBase attributeMapBase, int n) {
        for (Map.Entry entry : this.I.entrySet()) {
            AttributeInstance attributeInstance = attributeMapBase.a((IAttribute)entry.getKey());
            if (attributeInstance == null) continue;
            AttributeModifier attributeModifier = (AttributeModifier)entry.getValue();
            attributeInstance.b(attributeModifier);
            attributeInstance.a(new AttributeModifier(attributeModifier.a(), this.a() + " " + n, this.a(n, attributeModifier), attributeModifier.c()));
        }
    }

    public double a(int n, AttributeModifier attributeModifier) {
        return attributeModifier.d() * (double)(n + 1);
    }
}

