/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import net.minecraft.server.EntityLiving;
import net.minecraft.server.MobEffectList;
import net.minecraft.server.NBTTagCompound;

public class MobEffect {
    private int effectId;
    private int duration;
    private int amplification;
    private boolean splash;
    private boolean ambient;

    public MobEffect(int n, int n2) {
        this(n, n2, 0);
    }

    public MobEffect(int n, int n2, int n3) {
        this(n, n2, n3, false);
    }

    public MobEffect(int n, int n2, int n3, boolean bl) {
        this.effectId = n;
        this.duration = n2;
        this.amplification = n3;
        this.ambient = bl;
    }

    public MobEffect(MobEffect mobEffect) {
        this.effectId = mobEffect.effectId;
        this.duration = mobEffect.duration;
        this.amplification = mobEffect.amplification;
    }

    public void a(MobEffect mobEffect) {
        if (this.effectId != mobEffect.effectId) {
            System.err.println("This method should only be called for matching effects!");
        }
        if (mobEffect.amplification > this.amplification) {
            this.amplification = mobEffect.amplification;
            this.duration = mobEffect.duration;
        } else if (mobEffect.amplification == this.amplification && this.duration < mobEffect.duration) {
            this.duration = mobEffect.duration;
        } else if (!mobEffect.ambient && this.ambient) {
            this.ambient = mobEffect.ambient;
        }
    }

    public int getEffectId() {
        return this.effectId;
    }

    public int getDuration() {
        return this.duration;
    }

    public int getAmplifier() {
        return this.amplification;
    }

    public void setSplash(boolean bl) {
        this.splash = bl;
    }

    public boolean isAmbient() {
        return this.ambient;
    }

    public boolean tick(EntityLiving entityLiving) {
        if (this.duration > 0) {
            if (MobEffectList.byId[this.effectId].a(this.duration, this.amplification)) {
                this.b(entityLiving);
            }
            this.h();
        }
        return this.duration > 0;
    }

    private int h() {
        return --this.duration;
    }

    public void b(EntityLiving entityLiving) {
        if (this.duration > 0) {
            MobEffectList.byId[this.effectId].tick(entityLiving, this.amplification);
        }
    }

    public String f() {
        return MobEffectList.byId[this.effectId].a();
    }

    public int hashCode() {
        return this.effectId;
    }

    public String toString() {
        String string = "";
        string = this.getAmplifier() > 0 ? this.f() + " x " + (this.getAmplifier() + 1) + ", Duration: " + this.getDuration() : this.f() + ", Duration: " + this.getDuration();
        if (this.splash) {
            string = string + ", Splash: true";
        }
        if (MobEffectList.byId[this.effectId].i()) {
            return "(" + string + ")";
        }
        return string;
    }

    public boolean equals(Object object) {
        if (!(object instanceof MobEffect)) {
            return false;
        }
        MobEffect mobEffect = (MobEffect)object;
        return this.effectId == mobEffect.effectId && this.amplification == mobEffect.amplification && this.duration == mobEffect.duration && this.splash == mobEffect.splash && this.ambient == mobEffect.ambient;
    }

    public NBTTagCompound a(NBTTagCompound nBTTagCompound) {
        nBTTagCompound.setByte("Id", (byte)this.getEffectId());
        nBTTagCompound.setByte("Amplifier", (byte)this.getAmplifier());
        nBTTagCompound.setInt("Duration", this.getDuration());
        nBTTagCompound.setBoolean("Ambient", this.isAmbient());
        return nBTTagCompound;
    }

    public static MobEffect b(NBTTagCompound nBTTagCompound) {
        byte by = nBTTagCompound.getByte("Id");
        byte by2 = nBTTagCompound.getByte("Amplifier");
        int n = nBTTagCompound.getInt("Duration");
        boolean bl = nBTTagCompound.getBoolean("Ambient");
        return new MobEffect(by, n, by2, bl);
    }
}

