/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import java.awt.GraphicsEnvironment;
import java.io.File;
import java.net.Proxy;
import java.security.KeyPair;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.minecraft.server.AxisAlignedBB;
import net.minecraft.server.ChatMessage;
import net.minecraft.server.ChunkCoordinates;
import net.minecraft.server.CommandAbstract;
import net.minecraft.server.CommandDispatcher;
import net.minecraft.server.ConvertProgressUpdater;
import net.minecraft.server.Convertable;
import net.minecraft.server.CrashReport;
import net.minecraft.server.CrashReportPlayerCount;
import net.minecraft.server.CrashReportProfilerPosition;
import net.minecraft.server.CrashReportVec3DPoolSize;
import net.minecraft.server.DedicatedServer;
import net.minecraft.server.DemoWorldServer;
import net.minecraft.server.DispenserRegistry;
import net.minecraft.server.EntityHuman;
import net.minecraft.server.EnumGamemode;
import net.minecraft.server.ExceptionWorldConflict;
import net.minecraft.server.ICommandHandler;
import net.minecraft.server.ICommandListener;
import net.minecraft.server.IConsoleLogManager;
import net.minecraft.server.IDataManager;
import net.minecraft.server.IMojangStatistics;
import net.minecraft.server.IUpdatePlayerListBox;
import net.minecraft.server.MathHelper;
import net.minecraft.server.MethodProfiler;
import net.minecraft.server.MojangStatisticsGenerator;
import net.minecraft.server.Packet;
import net.minecraft.server.Packet4UpdateTime;
import net.minecraft.server.PlayerList;
import net.minecraft.server.RemoteControlCommandListener;
import net.minecraft.server.ReportedException;
import net.minecraft.server.SecondaryWorldServer;
import net.minecraft.server.ServerConnection;
import net.minecraft.server.StatisticList;
import net.minecraft.server.ThreadServerApplication;
import net.minecraft.server.ThreadShutdown;
import net.minecraft.server.World;
import net.minecraft.server.WorldData;
import net.minecraft.server.WorldLoaderServer;
import net.minecraft.server.WorldManager;
import net.minecraft.server.WorldServer;
import net.minecraft.server.WorldSettings;
import net.minecraft.server.WorldType;

public abstract class MinecraftServer
implements ICommandListener,
Runnable,
IMojangStatistics {
    private static MinecraftServer l;
    private final Convertable convertable;
    private final MojangStatisticsGenerator n = new MojangStatisticsGenerator("server", this, MinecraftServer.aq());
    private final File universe;
    private final List p = new ArrayList();
    private final ICommandHandler q;
    public final MethodProfiler methodProfiler = new MethodProfiler();
    private String serverIp;
    private int s = -1;
    public WorldServer[] worldServer;
    private PlayerList t;
    private boolean isRunning = true;
    private boolean isStopped;
    private int ticks;
    protected Proxy c = Proxy.NO_PROXY;
    public String d;
    public int e;
    private boolean onlineMode;
    private boolean spawnAnimals;
    private boolean spawnNPCs;
    private boolean pvpMode;
    private boolean allowFlight;
    private String motd;
    private int D;
    private int E = 0;
    private long F;
    private long G;
    private long H;
    private long I;
    public final long[] f = new long[100];
    public final long[] g = new long[100];
    public final long[] h = new long[100];
    public final long[] i = new long[100];
    public final long[] j = new long[100];
    public long[][] k;
    private KeyPair J;
    private String K;
    private String L;
    private boolean demoMode;
    private boolean O;
    private boolean P;
    private String Q = "";
    private boolean R;
    private long S;
    private String T;
    private boolean U;
    private boolean V;

    public MinecraftServer(File file) {
        l = this;
        this.universe = file;
        this.q = new CommandDispatcher();
        this.convertable = new WorldLoaderServer(file);
        this.as();
    }

    private void as() {
        DispenserRegistry.a();
    }

    protected abstract boolean init();

    protected void a(String string) {
        if (this.getConvertable().isConvertable(string)) {
            this.getLogger().info("Converting map!");
            this.b("menu.convertingLevel");
            this.getConvertable().convert(string, new ConvertProgressUpdater(this));
        }
    }

    protected synchronized void b(String string) {
        this.T = string;
    }

    protected void a(String string, String string2, long l, WorldType worldType, String string3) {
        WorldSettings worldSettings;
        this.a(string);
        this.b("menu.loadingLevel");
        this.worldServer = new WorldServer[3];
        this.k = new long[this.worldServer.length][100];
        IDataManager iDataManager = this.convertable.a(string, true);
        WorldData worldData = iDataManager.getWorldData();
        if (worldData == null) {
            worldSettings = new WorldSettings(l, this.getGamemode(), this.getGenerateStructures(), this.isHardcore(), worldType);
            worldSettings.a(string3);
        } else {
            worldSettings = new WorldSettings(worldData);
        }
        if (this.O) {
            worldSettings.a();
        }
        for (int i = 0; i < this.worldServer.length; ++i) {
            int n = 0;
            if (i == 1) {
                n = -1;
            }
            if (i == 2) {
                n = 1;
            }
            this.worldServer[i] = i == 0 ? (this.O() ? new DemoWorldServer(this, iDataManager, string2, n, this.methodProfiler, this.getLogger()) : new WorldServer(this, iDataManager, string2, n, worldSettings, this.methodProfiler, this.getLogger())) : new SecondaryWorldServer(this, iDataManager, string2, n, worldSettings, this.worldServer[0], this.methodProfiler, this.getLogger());
            this.worldServer[i].addIWorldAccess(new WorldManager(this, this.worldServer[i]));
            if (!this.K()) {
                this.worldServer[i].getWorldData().setGameType(this.getGamemode());
            }
            this.t.setPlayerFileData(this.worldServer);
        }
        this.c(this.getDifficulty());
        this.f();
    }

    protected void f() {
        int n = 16;
        int n2 = 4;
        int n3 = 192;
        int n4 = 625;
        int n5 = 0;
        this.b("menu.generatingTerrain");
        int n6 = 0;
        this.getLogger().info("Preparing start region for level " + n6);
        WorldServer worldServer = this.worldServer[n6];
        ChunkCoordinates chunkCoordinates = worldServer.getSpawn();
        long l = MinecraftServer.aq();
        for (int i = -192; i <= 192 && this.isRunning(); i += 16) {
            for (int j = -192; j <= 192 && this.isRunning(); j += 16) {
                long l2 = MinecraftServer.aq();
                if (l2 - l > 1000L) {
                    this.a_("Preparing spawn area", n5 * 100 / 625);
                    l = l2;
                }
                ++n5;
                worldServer.chunkProviderServer.getChunkAt(chunkCoordinates.x + i >> 4, chunkCoordinates.z + j >> 4);
            }
        }
        this.l();
    }

    public abstract boolean getGenerateStructures();

    public abstract EnumGamemode getGamemode();

    public abstract int getDifficulty();

    public abstract boolean isHardcore();

    public abstract int k();

    protected void a_(String string, int n) {
        this.d = string;
        this.e = n;
        this.getLogger().info(string + ": " + n + "%");
    }

    protected void l() {
        this.d = null;
        this.e = 0;
    }

    protected void saveChunks(boolean bl) {
        if (this.P) {
            return;
        }
        for (WorldServer worldServer : this.worldServer) {
            if (worldServer == null) continue;
            if (!bl) {
                this.getLogger().info("Saving chunks for level '" + worldServer.getWorldData().getName() + "'/" + worldServer.worldProvider.getName());
            }
            try {
                worldServer.save(true, null);
            }
            catch (ExceptionWorldConflict exceptionWorldConflict) {
                this.getLogger().warning(exceptionWorldConflict.getMessage());
            }
        }
    }

    public void stop() {
        if (this.P) {
            return;
        }
        this.getLogger().info("Stopping server");
        if (this.ag() != null) {
            this.ag().a();
        }
        if (this.t != null) {
            this.getLogger().info("Saving players");
            this.t.savePlayers();
            this.t.r();
        }
        this.getLogger().info("Saving worlds");
        this.saveChunks(false);
        for (int i = 0; i < this.worldServer.length; ++i) {
            WorldServer worldServer = this.worldServer[i];
            worldServer.saveLevel();
        }
        if (this.n != null && this.n.d()) {
            this.n.e();
        }
    }

    public String getServerIp() {
        return this.serverIp;
    }

    public void c(String string) {
        this.serverIp = string;
    }

    public boolean isRunning() {
        return this.isRunning;
    }

    public void safeShutdown() {
        this.isRunning = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            if (this.init()) {
                long l = MinecraftServer.aq();
                long l2 = 0L;
                while (this.isRunning) {
                    long l3 = MinecraftServer.aq();
                    long l4 = l3 - l;
                    if (l4 > 2000L && l - this.S >= 15000L) {
                        this.getLogger().warning("Can't keep up! Did the system time change, or is the server overloaded?");
                        l4 = 2000L;
                        this.S = l;
                    }
                    if (l4 < 0L) {
                        this.getLogger().warning("Time ran backwards! Did the system time change?");
                        l4 = 0L;
                    }
                    l2 += l4;
                    l = l3;
                    if (this.worldServer[0].everyoneDeeplySleeping()) {
                        this.s();
                        l2 = 0L;
                    } else {
                        while (l2 > 50L) {
                            l2 -= 50L;
                            this.s();
                        }
                    }
                    Thread.sleep(1L);
                    this.R = true;
                }
            } else {
                this.a((CrashReport)null);
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            this.getLogger().severe("Encountered an unexpected exception " + throwable.getClass().getSimpleName(), throwable);
            CrashReport crashReport = null;
            crashReport = throwable instanceof ReportedException ? this.b(((ReportedException)throwable).a()) : this.b(new CrashReport("Exception in server tick loop", throwable));
            File file = new File(new File(this.q(), "crash-reports"), "crash-" + new SimpleDateFormat("yyyy-MM-dd_HH.mm.ss").format(new Date()) + "-server.txt");
            if (crashReport.a(file, this.getLogger())) {
                this.getLogger().severe("This crash report has been saved to: " + file.getAbsolutePath());
            } else {
                this.getLogger().severe("We were unable to save this crash report to disk.");
            }
            this.a(crashReport);
        }
        finally {
            try {
                this.stop();
                this.isStopped = true;
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
            finally {
                this.r();
            }
        }
    }

    protected File q() {
        return new File(".");
    }

    protected void a(CrashReport crashReport) {
    }

    protected void r() {
    }

    protected void s() {
        long l = System.nanoTime();
        AxisAlignedBB.a().a();
        ++this.ticks;
        if (this.U) {
            this.U = false;
            this.methodProfiler.a = true;
            this.methodProfiler.a();
        }
        this.methodProfiler.a("root");
        this.t();
        if (this.ticks % 900 == 0) {
            this.methodProfiler.a("save");
            this.t.savePlayers();
            this.saveChunks(true);
            this.methodProfiler.b();
        }
        this.methodProfiler.a("tallying");
        this.j[this.ticks % 100] = System.nanoTime() - l;
        this.f[this.ticks % 100] = Packet.q - this.F;
        this.F = Packet.q;
        this.g[this.ticks % 100] = Packet.r - this.G;
        this.G = Packet.r;
        this.h[this.ticks % 100] = Packet.o - this.H;
        this.H = Packet.o;
        this.i[this.ticks % 100] = Packet.p - this.I;
        this.I = Packet.p;
        this.methodProfiler.b();
        this.methodProfiler.a("snooper");
        if (!this.n.d() && this.ticks > 100) {
            this.n.a();
        }
        if (this.ticks % 6000 == 0) {
            this.n.b();
        }
        this.methodProfiler.b();
        this.methodProfiler.b();
    }

    public void t() {
        int n;
        this.methodProfiler.a("levels");
        for (n = 0; n < this.worldServer.length; ++n) {
            long l = System.nanoTime();
            if (n == 0 || this.getAllowNether()) {
                WorldServer worldServer = this.worldServer[n];
                this.methodProfiler.a(worldServer.getWorldData().getName());
                this.methodProfiler.a("pools");
                worldServer.getVec3DPool().a();
                this.methodProfiler.b();
                if (this.ticks % 20 == 0) {
                    this.methodProfiler.a("timeSync");
                    this.t.a(new Packet4UpdateTime(worldServer.getTime(), worldServer.getDayTime(), worldServer.getGameRules().getBoolean("doDaylightCycle")), worldServer.worldProvider.dimension);
                    this.methodProfiler.b();
                }
                this.methodProfiler.a("tick");
                try {
                    worldServer.doTick();
                }
                catch (Throwable throwable) {
                    CrashReport crashReport = CrashReport.a(throwable, "Exception ticking world");
                    worldServer.a(crashReport);
                    throw new ReportedException(crashReport);
                }
                try {
                    worldServer.tickEntities();
                }
                catch (Throwable throwable) {
                    CrashReport crashReport = CrashReport.a(throwable, "Exception ticking world entities");
                    worldServer.a(crashReport);
                    throw new ReportedException(crashReport);
                }
                this.methodProfiler.b();
                this.methodProfiler.a("tracker");
                worldServer.getTracker().updatePlayers();
                this.methodProfiler.b();
                this.methodProfiler.b();
            }
            this.k[n][this.ticks % 100] = System.nanoTime() - l;
        }
        this.methodProfiler.c("connection");
        this.ag().b();
        this.methodProfiler.c("players");
        this.t.tick();
        this.methodProfiler.c("tickables");
        for (n = 0; n < this.p.size(); ++n) {
            ((IUpdatePlayerListBox)this.p.get(n)).a();
        }
        this.methodProfiler.b();
    }

    public boolean getAllowNether() {
        return true;
    }

    public void a(IUpdatePlayerListBox iUpdatePlayerListBox) {
        this.p.add(iUpdatePlayerListBox);
    }

    public static void main(String[] stringArray) {
        StatisticList.a();
        IConsoleLogManager iConsoleLogManager = null;
        try {
            boolean bl = !GraphicsEnvironment.isHeadless();
            String string = null;
            String string2 = ".";
            String string3 = null;
            boolean bl2 = false;
            boolean bl3 = false;
            int n = -1;
            for (int i = 0; i < stringArray.length; ++i) {
                String string4 = stringArray[i];
                String string5 = i == stringArray.length - 1 ? null : stringArray[i + 1];
                boolean bl4 = false;
                if (string4.equals("nogui") || string4.equals("--nogui")) {
                    bl = false;
                } else if (string4.equals("--port") && string5 != null) {
                    bl4 = true;
                    try {
                        n = Integer.parseInt(string5);
                    }
                    catch (NumberFormatException numberFormatException) {}
                } else if (string4.equals("--singleplayer") && string5 != null) {
                    bl4 = true;
                    string = string5;
                } else if (string4.equals("--universe") && string5 != null) {
                    bl4 = true;
                    string2 = string5;
                } else if (string4.equals("--world") && string5 != null) {
                    bl4 = true;
                    string3 = string5;
                } else if (string4.equals("--demo")) {
                    bl2 = true;
                } else if (string4.equals("--bonusChest")) {
                    bl3 = true;
                }
                if (!bl4) continue;
                ++i;
            }
            DedicatedServer dedicatedServer = new DedicatedServer(new File(string2));
            iConsoleLogManager = dedicatedServer.getLogger();
            if (string != null) {
                dedicatedServer.j(string);
            }
            if (string3 != null) {
                dedicatedServer.k(string3);
            }
            if (n >= 0) {
                dedicatedServer.setPort(n);
            }
            if (bl2) {
                dedicatedServer.b(true);
            }
            if (bl3) {
                dedicatedServer.c(true);
            }
            if (bl) {
                dedicatedServer.au();
            }
            dedicatedServer.v();
            Runtime.getRuntime().addShutdownHook(new ThreadShutdown(dedicatedServer));
        }
        catch (Exception exception) {
            if (iConsoleLogManager != null) {
                iConsoleLogManager.severe("Failed to start the minecraft server", exception);
            }
            Logger.getAnonymousLogger().log(Level.SEVERE, "Failed to start the minecraft server", exception);
        }
    }

    public void v() {
        new ThreadServerApplication(this, "Server thread").start();
    }

    public File d(String string) {
        return new File(this.q(), string);
    }

    public void info(String string) {
        this.getLogger().info(string);
    }

    public void warning(String string) {
        this.getLogger().warning(string);
    }

    public WorldServer getWorldServer(int n) {
        if (n == -1) {
            return this.worldServer[1];
        }
        if (n == 1) {
            return this.worldServer[2];
        }
        return this.worldServer[0];
    }

    public String w() {
        return this.serverIp;
    }

    public int x() {
        return this.s;
    }

    public String y() {
        return this.motd;
    }

    public String getVersion() {
        return "1.6.4";
    }

    public int A() {
        return this.t.getPlayerCount();
    }

    public int B() {
        return this.t.getMaxPlayers();
    }

    public String[] getPlayers() {
        return this.t.d();
    }

    public String getPlugins() {
        return "";
    }

    public String g(String string) {
        RemoteControlCommandListener.instance.d();
        this.q.a(RemoteControlCommandListener.instance, string);
        return RemoteControlCommandListener.instance.e();
    }

    public boolean isDebugging() {
        return false;
    }

    public void h(String string) {
        this.getLogger().severe(string);
    }

    public void i(String string) {
        if (this.isDebugging()) {
            this.getLogger().info(string);
        }
    }

    public String getServerModName() {
        return "vanilla";
    }

    public CrashReport b(CrashReport crashReport) {
        crashReport.g().a("Profiler Position", new CrashReportProfilerPosition(this));
        if (this.worldServer != null && this.worldServer.length > 0 && this.worldServer[0] != null) {
            crashReport.g().a("Vec3 Pool Size", new CrashReportVec3DPoolSize(this));
        }
        if (this.t != null) {
            crashReport.g().a("Player Count", new CrashReportPlayerCount(this));
        }
        return crashReport;
    }

    public List a(ICommandListener iCommandListener, String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (string.startsWith("/")) {
            boolean bl = !(string = string.substring(1)).contains(" ");
            List list = this.q.b(iCommandListener, string);
            if (list != null) {
                for (String string2 : list) {
                    if (bl) {
                        arrayList.add("/" + string2);
                        continue;
                    }
                    arrayList.add(string2);
                }
            }
            return arrayList;
        }
        String[] stringArray = string.split(" ", -1);
        String string3 = stringArray[stringArray.length - 1];
        for (String string4 : this.t.d()) {
            if (!CommandAbstract.a(string3, string4)) continue;
            arrayList.add(string4);
        }
        return arrayList;
    }

    public static MinecraftServer getServer() {
        return l;
    }

    @Override
    public String getName() {
        return "Server";
    }

    @Override
    public void sendMessage(ChatMessage chatMessage) {
        this.getLogger().info(chatMessage.toString());
    }

    @Override
    public boolean a(int n, String string) {
        return true;
    }

    public ICommandHandler getCommandHandler() {
        return this.q;
    }

    public KeyPair H() {
        return this.J;
    }

    public int I() {
        return this.s;
    }

    public void setPort(int n) {
        this.s = n;
    }

    public String J() {
        return this.K;
    }

    public void j(String string) {
        this.K = string;
    }

    public boolean K() {
        return this.K != null;
    }

    public String L() {
        return this.L;
    }

    public void k(String string) {
        this.L = string;
    }

    public void a(KeyPair keyPair) {
        this.J = keyPair;
    }

    public void c(int n) {
        for (int i = 0; i < this.worldServer.length; ++i) {
            WorldServer worldServer = this.worldServer[i];
            if (worldServer == null) continue;
            if (worldServer.getWorldData().isHardcore()) {
                worldServer.difficulty = 3;
                worldServer.setSpawnFlags(true, true);
                continue;
            }
            if (this.K()) {
                worldServer.difficulty = n;
                worldServer.setSpawnFlags(worldServer.difficulty > 0, true);
                continue;
            }
            worldServer.difficulty = n;
            worldServer.setSpawnFlags(this.getSpawnMonsters(), this.spawnAnimals);
        }
    }

    protected boolean getSpawnMonsters() {
        return true;
    }

    public boolean O() {
        return this.demoMode;
    }

    public void b(boolean bl) {
        this.demoMode = bl;
    }

    public void c(boolean bl) {
        this.O = bl;
    }

    public Convertable getConvertable() {
        return this.convertable;
    }

    public void R() {
        this.P = true;
        this.getConvertable().d();
        for (int i = 0; i < this.worldServer.length; ++i) {
            WorldServer worldServer = this.worldServer[i];
            if (worldServer == null) continue;
            worldServer.saveLevel();
        }
        this.getConvertable().e(this.worldServer[0].getDataManager().g());
        this.safeShutdown();
    }

    public String getTexturePack() {
        return this.Q;
    }

    public void setTexturePack(String string) {
        this.Q = string;
    }

    @Override
    public void a(MojangStatisticsGenerator mojangStatisticsGenerator) {
        mojangStatisticsGenerator.a("whitelist_enabled", false);
        mojangStatisticsGenerator.a("whitelist_count", 0);
        mojangStatisticsGenerator.a("players_current", this.A());
        mojangStatisticsGenerator.a("players_max", this.B());
        mojangStatisticsGenerator.a("players_seen", this.t.getSeenPlayers().length);
        mojangStatisticsGenerator.a("uses_auth", this.onlineMode);
        mojangStatisticsGenerator.a("gui_state", this.ai() ? "enabled" : "disabled");
        mojangStatisticsGenerator.a("run_time", (MinecraftServer.aq() - mojangStatisticsGenerator.g()) / 60L * 1000L);
        mojangStatisticsGenerator.a("avg_tick_ms", (int)(MathHelper.a(this.j) * 1.0E-6));
        mojangStatisticsGenerator.a("avg_sent_packet_count", (int)MathHelper.a(this.f));
        mojangStatisticsGenerator.a("avg_sent_packet_size", (int)MathHelper.a(this.g));
        mojangStatisticsGenerator.a("avg_rec_packet_count", (int)MathHelper.a(this.h));
        mojangStatisticsGenerator.a("avg_rec_packet_size", (int)MathHelper.a(this.i));
        int n = 0;
        for (int i = 0; i < this.worldServer.length; ++i) {
            if (this.worldServer[i] == null) continue;
            WorldServer worldServer = this.worldServer[i];
            WorldData worldData = worldServer.getWorldData();
            mojangStatisticsGenerator.a("world[" + n + "][dimension]", worldServer.worldProvider.dimension);
            mojangStatisticsGenerator.a("world[" + n + "][mode]", (Object)worldData.getGameType());
            mojangStatisticsGenerator.a("world[" + n + "][difficulty]", worldServer.difficulty);
            mojangStatisticsGenerator.a("world[" + n + "][hardcore]", worldData.isHardcore());
            mojangStatisticsGenerator.a("world[" + n + "][generator_name]", worldData.getType().name());
            mojangStatisticsGenerator.a("world[" + n + "][generator_version]", worldData.getType().getVersion());
            mojangStatisticsGenerator.a("world[" + n + "][height]", this.D);
            mojangStatisticsGenerator.a("world[" + n + "][chunks_loaded]", worldServer.L().getLoadedChunks());
            ++n;
        }
        mojangStatisticsGenerator.a("worlds", n);
    }

    @Override
    public void b(MojangStatisticsGenerator mojangStatisticsGenerator) {
        mojangStatisticsGenerator.a("singleplayer", this.K());
        mojangStatisticsGenerator.a("server_brand", this.getServerModName());
        mojangStatisticsGenerator.a("gui_supported", GraphicsEnvironment.isHeadless() ? "headless" : "supported");
        mojangStatisticsGenerator.a("dedicated", this.V());
    }

    @Override
    public boolean getSnooperEnabled() {
        return true;
    }

    public int U() {
        return 16;
    }

    public abstract boolean V();

    public boolean getOnlineMode() {
        return this.onlineMode;
    }

    public void setOnlineMode(boolean bl) {
        this.onlineMode = bl;
    }

    public boolean getSpawnAnimals() {
        return this.spawnAnimals;
    }

    public void setSpawnAnimals(boolean bl) {
        this.spawnAnimals = bl;
    }

    public boolean getSpawnNPCs() {
        return this.spawnNPCs;
    }

    public void setSpawnNPCs(boolean bl) {
        this.spawnNPCs = bl;
    }

    public boolean getPvP() {
        return this.pvpMode;
    }

    public void setPvP(boolean bl) {
        this.pvpMode = bl;
    }

    public boolean getAllowFlight() {
        return this.allowFlight;
    }

    public void setAllowFlight(boolean bl) {
        this.allowFlight = bl;
    }

    public abstract boolean getEnableCommandBlock();

    public String getMotd() {
        return this.motd;
    }

    public void setMotd(String string) {
        this.motd = string;
    }

    public int getMaxBuildHeight() {
        return this.D;
    }

    public void d(int n) {
        this.D = n;
    }

    public boolean isStopped() {
        return this.isStopped;
    }

    public PlayerList getPlayerList() {
        return this.t;
    }

    public void a(PlayerList playerList) {
        this.t = playerList;
    }

    public void a(EnumGamemode enumGamemode) {
        for (int i = 0; i < this.worldServer.length; ++i) {
            MinecraftServer.getServer().worldServer[i].getWorldData().setGameType(enumGamemode);
        }
    }

    public abstract ServerConnection ag();

    public boolean ai() {
        return false;
    }

    public abstract String a(EnumGamemode var1, boolean var2);

    public int aj() {
        return this.ticks;
    }

    public void ak() {
        this.U = true;
    }

    @Override
    public ChunkCoordinates b() {
        return new ChunkCoordinates(0, 0, 0);
    }

    @Override
    public World f_() {
        return this.worldServer[0];
    }

    public int getSpawnProtection() {
        return 16;
    }

    public boolean a(World world, int n, int n2, int n3, EntityHuman entityHuman) {
        return false;
    }

    @Override
    public abstract IConsoleLogManager getLogger();

    public void setForceGamemode(boolean bl) {
        this.V = bl;
    }

    public boolean getForceGamemode() {
        return this.V;
    }

    public Proxy ap() {
        return this.c;
    }

    public static long aq() {
        return System.currentTimeMillis();
    }

    public int ar() {
        return this.E;
    }

    public void e(int n) {
        this.E = n;
    }

    public static /* synthetic */ PlayerList a(MinecraftServer minecraftServer) {
        return minecraftServer.t;
    }
}

