/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.text.DecimalFormat;
import java.util.Random;
import net.minecraft.server.AttributeModifier;
import net.minecraft.server.Block;
import net.minecraft.server.Enchantment;
import net.minecraft.server.EnchantmentDurability;
import net.minecraft.server.EnchantmentManager;
import net.minecraft.server.Entity;
import net.minecraft.server.EntityHuman;
import net.minecraft.server.EntityItemFrame;
import net.minecraft.server.EntityLiving;
import net.minecraft.server.EnumAnimation;
import net.minecraft.server.GenericAttributes;
import net.minecraft.server.Item;
import net.minecraft.server.ItemBow;
import net.minecraft.server.NBTBase;
import net.minecraft.server.NBTTagCompound;
import net.minecraft.server.NBTTagList;
import net.minecraft.server.StatisticList;
import net.minecraft.server.World;

public final class ItemStack {
    public static final DecimalFormat a = new DecimalFormat("#.###");
    public int count;
    public int c;
    public int id;
    public NBTTagCompound tag;
    private int damage;
    private EntityItemFrame g;

    public ItemStack(Block block) {
        this(block, 1);
    }

    public ItemStack(Block block, int n) {
        this(block.id, n, 0);
    }

    public ItemStack(Block block, int n, int n2) {
        this(block.id, n, n2);
    }

    public ItemStack(Item item) {
        this(item.id, 1, 0);
    }

    public ItemStack(Item item, int n) {
        this(item.id, n, 0);
    }

    public ItemStack(Item item, int n, int n2) {
        this(item.id, n, n2);
    }

    public ItemStack(int n, int n2, int n3) {
        this.id = n;
        this.count = n2;
        this.damage = n3;
        if (this.damage < 0) {
            this.damage = 0;
        }
    }

    public static ItemStack createStack(NBTTagCompound nBTTagCompound) {
        ItemStack itemStack = new ItemStack();
        itemStack.c(nBTTagCompound);
        return itemStack.getItem() != null ? itemStack : null;
    }

    private ItemStack() {
    }

    public ItemStack a(int n) {
        ItemStack itemStack = new ItemStack(this.id, n, this.damage);
        if (this.tag != null) {
            itemStack.tag = (NBTTagCompound)this.tag.clone();
        }
        this.count -= n;
        return itemStack;
    }

    public Item getItem() {
        return Item.byId[this.id];
    }

    public boolean placeItem(EntityHuman entityHuman, World world, int n, int n2, int n3, int n4, float f, float f2, float f3) {
        boolean bl = this.getItem().interactWith(this, entityHuman, world, n, n2, n3, n4, f, f2, f3);
        if (bl) {
            entityHuman.a(StatisticList.E[this.id], 1);
        }
        return bl;
    }

    public float a(Block block) {
        return this.getItem().getDestroySpeed(this, block);
    }

    public ItemStack a(World world, EntityHuman entityHuman) {
        return this.getItem().a(this, world, entityHuman);
    }

    public ItemStack b(World world, EntityHuman entityHuman) {
        return this.getItem().b(this, world, entityHuman);
    }

    public NBTTagCompound save(NBTTagCompound nBTTagCompound) {
        nBTTagCompound.setShort("id", (short)this.id);
        nBTTagCompound.setByte("Count", (byte)this.count);
        nBTTagCompound.setShort("Damage", (short)this.damage);
        if (this.tag != null) {
            nBTTagCompound.set("tag", this.tag);
        }
        return nBTTagCompound;
    }

    public void c(NBTTagCompound nBTTagCompound) {
        this.id = nBTTagCompound.getShort("id");
        this.count = nBTTagCompound.getByte("Count");
        this.damage = nBTTagCompound.getShort("Damage");
        if (this.damage < 0) {
            this.damage = 0;
        }
        if (nBTTagCompound.hasKey("tag")) {
            this.tag = nBTTagCompound.getCompound("tag");
        }
    }

    public int getMaxStackSize() {
        return this.getItem().getMaxStackSize();
    }

    public boolean isStackable() {
        return this.getMaxStackSize() > 1 && (!this.g() || !this.i());
    }

    public boolean g() {
        return Item.byId[this.id].getMaxDurability() > 0;
    }

    public boolean usesData() {
        return Item.byId[this.id].n();
    }

    public boolean i() {
        return this.g() && this.damage > 0;
    }

    public int j() {
        return this.damage;
    }

    public int getData() {
        return this.damage;
    }

    public void setData(int n) {
        this.damage = n;
        if (this.damage < 0) {
            this.damage = 0;
        }
    }

    public int l() {
        return Item.byId[this.id].getMaxDurability();
    }

    public boolean isDamaged(int n, Random random) {
        if (!this.g()) {
            return false;
        }
        if (n > 0) {
            int n2 = EnchantmentManager.getEnchantmentLevel(Enchantment.DURABILITY.id, this);
            int n3 = 0;
            for (int i = 0; n2 > 0 && i < n; ++i) {
                if (!EnchantmentDurability.a(this, n2, random)) continue;
                ++n3;
            }
            if ((n -= n3) <= 0) {
                return false;
            }
        }
        this.damage += n;
        return this.damage > this.l();
    }

    public void damage(int n, EntityLiving entityLiving) {
        if (entityLiving instanceof EntityHuman && ((EntityHuman)entityLiving).abilities.canInstantlyBuild) {
            return;
        }
        if (!this.g()) {
            return;
        }
        if (this.isDamaged(n, entityLiving.aD())) {
            entityLiving.a(this);
            --this.count;
            if (entityLiving instanceof EntityHuman) {
                EntityHuman entityHuman = (EntityHuman)entityLiving;
                entityHuman.a(StatisticList.F[this.id], 1);
                if (this.count == 0 && this.getItem() instanceof ItemBow) {
                    entityHuman.bz();
                }
            }
            if (this.count < 0) {
                this.count = 0;
            }
            this.damage = 0;
        }
    }

    public void a(EntityLiving entityLiving, EntityHuman entityHuman) {
        boolean bl = Item.byId[this.id].a(this, entityLiving, (EntityLiving)entityHuman);
        if (bl) {
            entityHuman.a(StatisticList.E[this.id], 1);
        }
    }

    public void a(World world, int n, int n2, int n3, int n4, EntityHuman entityHuman) {
        boolean bl = Item.byId[this.id].a(this, world, n, n2, n3, n4, entityHuman);
        if (bl) {
            entityHuman.a(StatisticList.E[this.id], 1);
        }
    }

    public boolean b(Block block) {
        return Item.byId[this.id].canDestroySpecialBlock(block);
    }

    public boolean a(EntityHuman entityHuman, EntityLiving entityLiving) {
        return Item.byId[this.id].a(this, entityHuman, entityLiving);
    }

    public ItemStack cloneItemStack() {
        ItemStack itemStack = new ItemStack(this.id, this.count, this.damage);
        if (this.tag != null) {
            itemStack.tag = (NBTTagCompound)this.tag.clone();
        }
        return itemStack;
    }

    public static boolean equals(ItemStack itemStack, ItemStack itemStack2) {
        if (itemStack == null && itemStack2 == null) {
            return true;
        }
        if (itemStack == null || itemStack2 == null) {
            return false;
        }
        if (itemStack.tag == null && itemStack2.tag != null) {
            return false;
        }
        return itemStack.tag == null || itemStack.tag.equals(itemStack2.tag);
    }

    public static boolean matches(ItemStack itemStack, ItemStack itemStack2) {
        if (itemStack == null && itemStack2 == null) {
            return true;
        }
        if (itemStack == null || itemStack2 == null) {
            return false;
        }
        return itemStack.d(itemStack2);
    }

    private boolean d(ItemStack itemStack) {
        if (this.count != itemStack.count) {
            return false;
        }
        if (this.id != itemStack.id) {
            return false;
        }
        if (this.damage != itemStack.damage) {
            return false;
        }
        if (this.tag == null && itemStack.tag != null) {
            return false;
        }
        return this.tag == null || this.tag.equals(itemStack.tag);
    }

    public boolean doMaterialsMatch(ItemStack itemStack) {
        return this.id == itemStack.id && this.damage == itemStack.damage;
    }

    public String a() {
        return Item.byId[this.id].d(this);
    }

    public static ItemStack b(ItemStack itemStack) {
        return itemStack == null ? null : itemStack.cloneItemStack();
    }

    public String toString() {
        return this.count + "x" + Item.byId[this.id].getName() + "@" + this.damage;
    }

    public void a(World world, Entity entity, int n, boolean bl) {
        if (this.c > 0) {
            --this.c;
        }
        Item.byId[this.id].a(this, world, entity, n, bl);
    }

    public void a(World world, EntityHuman entityHuman, int n) {
        entityHuman.a(StatisticList.D[this.id], n);
        Item.byId[this.id].d(this, world, entityHuman);
    }

    public int n() {
        return this.getItem().d_(this);
    }

    public EnumAnimation o() {
        return this.getItem().c_(this);
    }

    public void b(World world, EntityHuman entityHuman, int n) {
        this.getItem().a(this, world, entityHuman, n);
    }

    public boolean hasTag() {
        return this.tag != null;
    }

    public NBTTagCompound getTag() {
        return this.tag;
    }

    public NBTTagList getEnchantments() {
        if (this.tag == null) {
            return null;
        }
        return (NBTTagList)this.tag.get("ench");
    }

    public void setTag(NBTTagCompound nBTTagCompound) {
        this.tag = nBTTagCompound;
    }

    public String getName() {
        NBTTagCompound nBTTagCompound;
        String string = this.getItem().l(this);
        if (this.tag != null && this.tag.hasKey("display") && (nBTTagCompound = this.tag.getCompound("display")).hasKey("Name")) {
            string = nBTTagCompound.getString("Name");
        }
        return string;
    }

    public void c(String string) {
        if (this.tag == null) {
            this.tag = new NBTTagCompound("tag");
        }
        if (!this.tag.hasKey("display")) {
            this.tag.setCompound("display", new NBTTagCompound());
        }
        this.tag.getCompound("display").setString("Name", string);
    }

    public void t() {
        if (this.tag == null) {
            return;
        }
        if (!this.tag.hasKey("display")) {
            return;
        }
        NBTTagCompound nBTTagCompound = this.tag.getCompound("display");
        nBTTagCompound.remove("Name");
        if (nBTTagCompound.isEmpty()) {
            this.tag.remove("display");
            if (this.tag.isEmpty()) {
                this.setTag(null);
            }
        }
    }

    public boolean hasName() {
        if (this.tag == null) {
            return false;
        }
        if (!this.tag.hasKey("display")) {
            return false;
        }
        return this.tag.getCompound("display").hasKey("Name");
    }

    public boolean x() {
        if (!this.getItem().e_(this)) {
            return false;
        }
        return !this.hasEnchantments();
    }

    public void addEnchantment(Enchantment enchantment, int n) {
        if (this.tag == null) {
            this.setTag(new NBTTagCompound());
        }
        if (!this.tag.hasKey("ench")) {
            this.tag.set("ench", new NBTTagList("ench"));
        }
        NBTTagList nBTTagList = (NBTTagList)this.tag.get("ench");
        NBTTagCompound nBTTagCompound = new NBTTagCompound();
        nBTTagCompound.setShort("id", (short)enchantment.id);
        nBTTagCompound.setShort("lvl", (byte)n);
        nBTTagList.add(nBTTagCompound);
    }

    public boolean hasEnchantments() {
        return this.tag != null && this.tag.hasKey("ench");
    }

    public void a(String string, NBTBase nBTBase) {
        if (this.tag == null) {
            this.setTag(new NBTTagCompound());
        }
        this.tag.set(string, nBTBase);
    }

    public boolean z() {
        return this.getItem().z();
    }

    public boolean A() {
        return this.g != null;
    }

    public void a(EntityItemFrame entityItemFrame) {
        this.g = entityItemFrame;
    }

    public EntityItemFrame B() {
        return this.g;
    }

    public int getRepairCost() {
        if (this.hasTag() && this.tag.hasKey("RepairCost")) {
            return this.tag.getInt("RepairCost");
        }
        return 0;
    }

    public void setRepairCost(int n) {
        if (!this.hasTag()) {
            this.tag = new NBTTagCompound("tag");
        }
        this.tag.setInt("RepairCost", n);
    }

    public Multimap D() {
        HashMultimap<String, AttributeModifier> hashMultimap;
        if (this.hasTag() && this.tag.hasKey("AttributeModifiers")) {
            hashMultimap = HashMultimap.create();
            NBTTagList nBTTagList = this.tag.getList("AttributeModifiers");
            for (int i = 0; i < nBTTagList.size(); ++i) {
                NBTTagCompound nBTTagCompound = (NBTTagCompound)nBTTagList.get(i);
                AttributeModifier attributeModifier = GenericAttributes.a(nBTTagCompound);
                if (attributeModifier.a().getLeastSignificantBits() == 0L || attributeModifier.a().getMostSignificantBits() == 0L) continue;
                hashMultimap.put(nBTTagCompound.getString("AttributeName"), attributeModifier);
            }
        } else {
            hashMultimap = this.getItem().h();
        }
        return hashMultimap;
    }
}

