/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import net.minecraft.server.Block;
import net.minecraft.server.BlockSkull;
import net.minecraft.server.CreativeModeTab;
import net.minecraft.server.EntityHuman;
import net.minecraft.server.Item;
import net.minecraft.server.ItemStack;
import net.minecraft.server.LocaleI18n;
import net.minecraft.server.MathHelper;
import net.minecraft.server.TileEntity;
import net.minecraft.server.TileEntitySkull;
import net.minecraft.server.World;

public class ItemSkull
extends Item {
    private static final String[] b = new String[]{"skeleton", "wither", "zombie", "char", "creeper"};
    public static final String[] a = new String[]{"skeleton", "wither", "zombie", "steve", "creeper"};

    public ItemSkull(int n) {
        super(n);
        this.a(CreativeModeTab.c);
        this.setMaxDurability(0);
        this.a(true);
    }

    @Override
    public boolean interactWith(ItemStack itemStack, EntityHuman entityHuman, World world, int n, int n2, int n3, int n4, float f, float f2, float f3) {
        TileEntity tileEntity;
        if (n4 == 0) {
            return false;
        }
        if (!world.getMaterial(n, n2, n3).isBuildable()) {
            return false;
        }
        if (n4 == 1) {
            ++n2;
        }
        if (n4 == 2) {
            --n3;
        }
        if (n4 == 3) {
            ++n3;
        }
        if (n4 == 4) {
            --n;
        }
        if (n4 == 5) {
            ++n;
        }
        if (!entityHuman.a(n, n2, n3, n4, itemStack)) {
            return false;
        }
        if (!Block.SKULL.canPlace(world, n, n2, n3)) {
            return false;
        }
        world.setTypeIdAndData(n, n2, n3, Block.SKULL.id, n4, 2);
        int n5 = 0;
        if (n4 == 1) {
            n5 = MathHelper.floor((double)(entityHuman.yaw * 16.0f / 360.0f) + 0.5) & 0xF;
        }
        if ((tileEntity = world.getTileEntity(n, n2, n3)) != null && tileEntity instanceof TileEntitySkull) {
            String string = "";
            if (itemStack.hasTag() && itemStack.getTag().hasKey("SkullOwner")) {
                string = itemStack.getTag().getString("SkullOwner");
            }
            ((TileEntitySkull)tileEntity).setSkullType(itemStack.getData(), string);
            ((TileEntitySkull)tileEntity).setRotation(n5);
            ((BlockSkull)Block.SKULL).a(world, n, n2, n3, (TileEntitySkull)tileEntity);
        }
        --itemStack.count;
        return true;
    }

    @Override
    public int filterData(int n) {
        return n;
    }

    @Override
    public String d(ItemStack itemStack) {
        int n = itemStack.getData();
        if (n < 0 || n >= b.length) {
            n = 0;
        }
        return super.getName() + "." + b[n];
    }

    @Override
    public String l(ItemStack itemStack) {
        if (itemStack.getData() == 3 && itemStack.hasTag() && itemStack.getTag().hasKey("SkullOwner")) {
            return LocaleI18n.get("item.skull.player.name", itemStack.getTag().getString("SkullOwner"));
        }
        return super.l(itemStack);
    }
}

