/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import java.util.Collection;
import java.util.UUID;
import net.minecraft.server.AttributeInstance;
import net.minecraft.server.AttributeMapBase;
import net.minecraft.server.AttributeModifier;
import net.minecraft.server.AttributeRanged;
import net.minecraft.server.IAttribute;
import net.minecraft.server.IConsoleLogManager;
import net.minecraft.server.NBTTagCompound;
import net.minecraft.server.NBTTagList;

public class GenericAttributes {
    public static final IAttribute a = new AttributeRanged("generic.maxHealth", 20.0, 0.0, Double.MAX_VALUE).a("Max Health").a(true);
    public static final IAttribute b = new AttributeRanged("generic.followRange", 32.0, 0.0, 2048.0).a("Follow Range");
    public static final IAttribute c = new AttributeRanged("generic.knockbackResistance", 0.0, 0.0, 1.0).a("Knockback Resistance");
    public static final IAttribute d = new AttributeRanged("generic.movementSpeed", 0.7f, 0.0, Double.MAX_VALUE).a("Movement Speed").a(true);
    public static final IAttribute e = new AttributeRanged("generic.attackDamage", 2.0, 0.0, Double.MAX_VALUE);

    public static NBTTagList a(AttributeMapBase attributeMapBase) {
        NBTTagList nBTTagList = new NBTTagList();
        for (AttributeInstance attributeInstance : attributeMapBase.a()) {
            nBTTagList.add(GenericAttributes.a(attributeInstance));
        }
        return nBTTagList;
    }

    private static NBTTagCompound a(AttributeInstance attributeInstance) {
        NBTTagCompound nBTTagCompound = new NBTTagCompound();
        IAttribute iAttribute = attributeInstance.a();
        nBTTagCompound.setString("Name", iAttribute.a());
        nBTTagCompound.setDouble("Base", attributeInstance.b());
        Collection collection = attributeInstance.c();
        if (collection != null && !collection.isEmpty()) {
            NBTTagList nBTTagList = new NBTTagList();
            for (AttributeModifier attributeModifier : collection) {
                if (!attributeModifier.e()) continue;
                nBTTagList.add(GenericAttributes.a(attributeModifier));
            }
            nBTTagCompound.set("Modifiers", nBTTagList);
        }
        return nBTTagCompound;
    }

    private static NBTTagCompound a(AttributeModifier attributeModifier) {
        NBTTagCompound nBTTagCompound = new NBTTagCompound();
        nBTTagCompound.setString("Name", attributeModifier.b());
        nBTTagCompound.setDouble("Amount", attributeModifier.d());
        nBTTagCompound.setInt("Operation", attributeModifier.c());
        nBTTagCompound.setLong("UUIDMost", attributeModifier.a().getMostSignificantBits());
        nBTTagCompound.setLong("UUIDLeast", attributeModifier.a().getLeastSignificantBits());
        return nBTTagCompound;
    }

    public static void a(AttributeMapBase attributeMapBase, NBTTagList nBTTagList, IConsoleLogManager iConsoleLogManager) {
        for (int i = 0; i < nBTTagList.size(); ++i) {
            NBTTagCompound nBTTagCompound = (NBTTagCompound)nBTTagList.get(i);
            AttributeInstance attributeInstance = attributeMapBase.a(nBTTagCompound.getString("Name"));
            if (attributeInstance != null) {
                GenericAttributes.a(attributeInstance, nBTTagCompound);
                continue;
            }
            if (iConsoleLogManager == null) continue;
            iConsoleLogManager.warning("Ignoring unknown attribute '" + nBTTagCompound.getString("Name") + "'");
        }
    }

    private static void a(AttributeInstance attributeInstance, NBTTagCompound nBTTagCompound) {
        attributeInstance.setValue(nBTTagCompound.getDouble("Base"));
        if (nBTTagCompound.hasKey("Modifiers")) {
            NBTTagList nBTTagList = nBTTagCompound.getList("Modifiers");
            for (int i = 0; i < nBTTagList.size(); ++i) {
                AttributeModifier attributeModifier = GenericAttributes.a((NBTTagCompound)nBTTagList.get(i));
                AttributeModifier attributeModifier2 = attributeInstance.a(attributeModifier.a());
                if (attributeModifier2 != null) {
                    attributeInstance.b(attributeModifier2);
                }
                attributeInstance.a(attributeModifier);
            }
        }
    }

    public static AttributeModifier a(NBTTagCompound nBTTagCompound) {
        UUID uUID = new UUID(nBTTagCompound.getLong("UUIDMost"), nBTTagCompound.getLong("UUIDLeast"));
        return new AttributeModifier(uUID, nBTTagCompound.getString("Name"), nBTTagCompound.getDouble("Amount"), nBTTagCompound.getInt("Operation"));
    }
}

