/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import java.util.Calendar;
import java.util.UUID;
import net.minecraft.server.AttributeInstance;
import net.minecraft.server.AttributeModifier;
import net.minecraft.server.AttributeRanged;
import net.minecraft.server.Block;
import net.minecraft.server.DamageSource;
import net.minecraft.server.Entity;
import net.minecraft.server.EntityHuman;
import net.minecraft.server.EntityLiving;
import net.minecraft.server.EntityMonster;
import net.minecraft.server.EntityVillager;
import net.minecraft.server.EnumMonsterType;
import net.minecraft.server.GenericAttributes;
import net.minecraft.server.GroupDataEntity;
import net.minecraft.server.GroupDataZombie;
import net.minecraft.server.IAttribute;
import net.minecraft.server.Item;
import net.minecraft.server.ItemStack;
import net.minecraft.server.MathHelper;
import net.minecraft.server.MobEffect;
import net.minecraft.server.MobEffectList;
import net.minecraft.server.NBTTagCompound;
import net.minecraft.server.PathfinderGoalBreakDoor;
import net.minecraft.server.PathfinderGoalFloat;
import net.minecraft.server.PathfinderGoalHurtByTarget;
import net.minecraft.server.PathfinderGoalLookAtPlayer;
import net.minecraft.server.PathfinderGoalMeleeAttack;
import net.minecraft.server.PathfinderGoalMoveThroughVillage;
import net.minecraft.server.PathfinderGoalMoveTowardsRestriction;
import net.minecraft.server.PathfinderGoalNearestAttackableTarget;
import net.minecraft.server.PathfinderGoalRandomLookaround;
import net.minecraft.server.PathfinderGoalRandomStroll;
import net.minecraft.server.World;

public class EntityZombie
extends EntityMonster {
    protected static final IAttribute bp = new AttributeRanged("zombie.spawnReinforcements", 0.0, 0.0, 1.0).a("Spawn Reinforcements Chance");
    private static final UUID bq = UUID.fromString("B9766B59-9566-4402-BC1F-2EE2A276D836");
    private static final AttributeModifier br = new AttributeModifier(bq, "Baby speed boost", 0.5, 1);
    private int bs;

    public EntityZombie(World world) {
        super(world);
        this.getNavigation().b(true);
        this.goalSelector.a(0, new PathfinderGoalFloat(this));
        this.goalSelector.a(1, new PathfinderGoalBreakDoor(this));
        this.goalSelector.a(2, new PathfinderGoalMeleeAttack(this, EntityHuman.class, 1.0, false));
        this.goalSelector.a(3, new PathfinderGoalMeleeAttack(this, EntityVillager.class, 1.0, true));
        this.goalSelector.a(4, new PathfinderGoalMoveTowardsRestriction(this, 1.0));
        this.goalSelector.a(5, new PathfinderGoalMoveThroughVillage(this, 1.0, false));
        this.goalSelector.a(6, new PathfinderGoalRandomStroll(this, 1.0));
        this.goalSelector.a(7, new PathfinderGoalLookAtPlayer(this, EntityHuman.class, 8.0f));
        this.goalSelector.a(7, new PathfinderGoalRandomLookaround(this));
        this.targetSelector.a(1, new PathfinderGoalHurtByTarget(this, true));
        this.targetSelector.a(2, new PathfinderGoalNearestAttackableTarget(this, EntityHuman.class, 0, true));
        this.targetSelector.a(2, new PathfinderGoalNearestAttackableTarget(this, EntityVillager.class, 0, false));
    }

    @Override
    protected void az() {
        super.az();
        this.getAttributeInstance(GenericAttributes.b).setValue(40.0);
        this.getAttributeInstance(GenericAttributes.d).setValue(0.23f);
        this.getAttributeInstance(GenericAttributes.e).setValue(3.0);
        this.aX().b(bp).setValue(this.random.nextDouble() * (double)0.1f);
    }

    @Override
    protected void a() {
        super.a();
        this.getDataWatcher().a(12, (Object)0);
        this.getDataWatcher().a(13, (Object)0);
        this.getDataWatcher().a(14, (Object)0);
    }

    @Override
    public int aQ() {
        int n = super.aQ() + 2;
        if (n > 20) {
            n = 20;
        }
        return n;
    }

    @Override
    protected boolean bf() {
        return true;
    }

    @Override
    public boolean isBaby() {
        return this.getDataWatcher().getByte(12) == 1;
    }

    public void setBaby(boolean bl) {
        this.getDataWatcher().watch(12, (byte)(bl ? 1 : 0));
        if (this.world != null && !this.world.isStatic) {
            AttributeInstance attributeInstance = this.getAttributeInstance(GenericAttributes.d);
            attributeInstance.b(br);
            if (bl) {
                attributeInstance.a(br);
            }
        }
    }

    public boolean isVillager() {
        return this.getDataWatcher().getByte(13) == 1;
    }

    public void setVillager(boolean bl) {
        this.getDataWatcher().watch(13, (byte)(bl ? 1 : 0));
    }

    @Override
    public void c() {
        float f;
        if (this.world.v() && !this.world.isStatic && !this.isBaby() && (f = this.d(1.0f)) > 0.5f && this.random.nextFloat() * 30.0f < (f - 0.4f) * 2.0f && this.world.l(MathHelper.floor(this.locX), MathHelper.floor(this.locY), MathHelper.floor(this.locZ))) {
            boolean bl = true;
            ItemStack itemStack = this.getEquipment(4);
            if (itemStack != null) {
                if (itemStack.g()) {
                    itemStack.setData(itemStack.j() + this.random.nextInt(2));
                    if (itemStack.j() >= itemStack.l()) {
                        this.a(itemStack);
                        this.setEquipment(4, null);
                    }
                }
                bl = false;
            }
            if (bl) {
                this.setOnFire(8);
            }
        }
        super.c();
    }

    @Override
    public boolean damageEntity(DamageSource damageSource, float f) {
        if (super.damageEntity(damageSource, f)) {
            EntityLiving entityLiving = this.getGoalTarget();
            if (entityLiving == null && this.bN() instanceof EntityLiving) {
                entityLiving = (EntityLiving)this.bN();
            }
            if (entityLiving == null && damageSource.getEntity() instanceof EntityLiving) {
                entityLiving = (EntityLiving)damageSource.getEntity();
            }
            if (entityLiving != null && this.world.difficulty >= 3 && (double)this.random.nextFloat() < this.getAttributeInstance(bp).getValue()) {
                int n = MathHelper.floor(this.locX);
                int n2 = MathHelper.floor(this.locY);
                int n3 = MathHelper.floor(this.locZ);
                EntityZombie entityZombie = new EntityZombie(this.world);
                for (int i = 0; i < 50; ++i) {
                    int n4;
                    int n5;
                    int n6 = n + MathHelper.nextInt(this.random, 7, 40) * MathHelper.nextInt(this.random, -1, 1);
                    if (!this.world.w(n6, (n5 = n2 + MathHelper.nextInt(this.random, 7, 40) * MathHelper.nextInt(this.random, -1, 1)) - 1, n4 = n3 + MathHelper.nextInt(this.random, 7, 40) * MathHelper.nextInt(this.random, -1, 1)) || this.world.getLightLevel(n6, n5, n4) >= 10) continue;
                    entityZombie.setPosition(n6, n5, n4);
                    if (!this.world.b(entityZombie.boundingBox) || !this.world.getCubes(entityZombie, entityZombie.boundingBox).isEmpty() || this.world.containsLiquid(entityZombie.boundingBox)) continue;
                    this.world.addEntity(entityZombie);
                    entityZombie.setGoalTarget(entityLiving);
                    entityZombie.a((GroupDataEntity)null);
                    this.getAttributeInstance(bp).a(new AttributeModifier("Zombie reinforcement caller charge", -0.05f, 0));
                    entityZombie.getAttributeInstance(bp).a(new AttributeModifier("Zombie reinforcement callee charge", -0.05f, 0));
                    break;
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public void l_() {
        if (!this.world.isStatic && this.bV()) {
            int n = this.bX();
            this.bs -= n;
            if (this.bs <= 0) {
                this.bW();
            }
        }
        super.l_();
    }

    @Override
    public boolean m(Entity entity) {
        boolean bl = super.m(entity);
        if (bl && this.aZ() == null && this.isBurning() && this.random.nextFloat() < (float)this.world.difficulty * 0.3f) {
            entity.setOnFire(2 * this.world.difficulty);
        }
        return bl;
    }

    @Override
    protected String r() {
        return "mob.zombie.say";
    }

    @Override
    protected String aO() {
        return "mob.zombie.hurt";
    }

    @Override
    protected String aP() {
        return "mob.zombie.death";
    }

    @Override
    protected void a(int n, int n2, int n3, int n4) {
        this.makeSound("mob.zombie.step", 0.15f, 1.0f);
    }

    @Override
    protected int getLootId() {
        return Item.ROTTEN_FLESH.id;
    }

    @Override
    public EnumMonsterType getMonsterType() {
        return EnumMonsterType.UNDEAD;
    }

    @Override
    protected void l(int n) {
        switch (this.random.nextInt(3)) {
            case 0: {
                this.b(Item.IRON_INGOT.id, 1);
                break;
            }
            case 1: {
                this.b(Item.CARROT.id, 1);
                break;
            }
            case 2: {
                this.b(Item.POTATO.id, 1);
            }
        }
    }

    @Override
    protected void bw() {
        super.bw();
        float f = this.random.nextFloat();
        float f2 = this.world.difficulty == 3 ? 0.05f : 0.01f;
        if (f < f2) {
            int n = this.random.nextInt(3);
            if (n == 0) {
                this.setEquipment(0, new ItemStack(Item.IRON_SWORD));
            } else {
                this.setEquipment(0, new ItemStack(Item.IRON_SPADE));
            }
        }
    }

    @Override
    public void b(NBTTagCompound nBTTagCompound) {
        super.b(nBTTagCompound);
        if (this.isBaby()) {
            nBTTagCompound.setBoolean("IsBaby", true);
        }
        if (this.isVillager()) {
            nBTTagCompound.setBoolean("IsVillager", true);
        }
        nBTTagCompound.setInt("ConversionTime", this.bV() ? this.bs : -1);
    }

    @Override
    public void a(NBTTagCompound nBTTagCompound) {
        super.a(nBTTagCompound);
        if (nBTTagCompound.getBoolean("IsBaby")) {
            this.setBaby(true);
        }
        if (nBTTagCompound.getBoolean("IsVillager")) {
            this.setVillager(true);
        }
        if (nBTTagCompound.hasKey("ConversionTime") && nBTTagCompound.getInt("ConversionTime") > -1) {
            this.a(nBTTagCompound.getInt("ConversionTime"));
        }
    }

    @Override
    public void a(EntityLiving entityLiving) {
        super.a(entityLiving);
        if (this.world.difficulty >= 2 && entityLiving instanceof EntityVillager) {
            if (this.world.difficulty == 2 && this.random.nextBoolean()) {
                return;
            }
            EntityZombie entityZombie = new EntityZombie(this.world);
            entityZombie.j(entityLiving);
            this.world.kill(entityLiving);
            entityZombie.a((GroupDataEntity)null);
            entityZombie.setVillager(true);
            if (entityLiving.isBaby()) {
                entityZombie.setBaby(true);
            }
            this.world.addEntity(entityZombie);
            this.world.a(null, 1016, (int)this.locX, (int)this.locY, (int)this.locZ, 0);
        }
    }

    @Override
    public GroupDataEntity a(GroupDataEntity groupDataEntity) {
        Object object;
        groupDataEntity = super.a(groupDataEntity);
        float f = this.world.b(this.locX, this.locY, this.locZ);
        this.h(this.random.nextFloat() < 0.55f * f);
        if (groupDataEntity == null) {
            groupDataEntity = new GroupDataZombie(this, this.world.random.nextFloat() < 0.05f, this.world.random.nextFloat() < 0.05f, null);
        }
        if (groupDataEntity instanceof GroupDataZombie) {
            object = (GroupDataZombie)groupDataEntity;
            if (((GroupDataZombie)object).b) {
                this.setVillager(true);
            }
            if (((GroupDataZombie)object).a) {
                this.setBaby(true);
            }
        }
        this.bw();
        this.bx();
        if (this.getEquipment(4) == null && ((Calendar)(object = this.world.W())).get(2) + 1 == 10 && ((Calendar)object).get(5) == 31 && this.random.nextFloat() < 0.25f) {
            this.setEquipment(4, new ItemStack(this.random.nextFloat() < 0.1f ? Block.JACK_O_LANTERN : Block.PUMPKIN));
            this.dropChances[4] = 0.0f;
        }
        this.getAttributeInstance(GenericAttributes.c).a(new AttributeModifier("Random spawn bonus", this.random.nextDouble() * (double)0.05f, 0));
        this.getAttributeInstance(GenericAttributes.b).a(new AttributeModifier("Random zombie-spawn bonus", this.random.nextDouble() * 1.5, 2));
        if (this.random.nextFloat() < f * 0.05f) {
            this.getAttributeInstance(bp).a(new AttributeModifier("Leader zombie bonus", this.random.nextDouble() * 0.25 + 0.5, 0));
            this.getAttributeInstance(GenericAttributes.a).a(new AttributeModifier("Leader zombie bonus", this.random.nextDouble() * 3.0 + 1.0, 2));
        }
        return groupDataEntity;
    }

    @Override
    public boolean a(EntityHuman entityHuman) {
        ItemStack itemStack = entityHuman.by();
        if (itemStack != null && itemStack.getItem() == Item.GOLDEN_APPLE && itemStack.getData() == 0 && this.isVillager() && this.hasEffect(MobEffectList.WEAKNESS)) {
            if (!entityHuman.abilities.canInstantlyBuild) {
                --itemStack.count;
            }
            if (itemStack.count <= 0) {
                entityHuman.inventory.setItem(entityHuman.inventory.itemInHandIndex, null);
            }
            if (!this.world.isStatic) {
                this.a(this.random.nextInt(2401) + 3600);
            }
            return true;
        }
        return false;
    }

    protected void a(int n) {
        this.bs = n;
        this.getDataWatcher().watch(14, (byte)1);
        this.k(MobEffectList.WEAKNESS.id);
        this.addEffect(new MobEffect(MobEffectList.INCREASE_DAMAGE.id, n, Math.min(this.world.difficulty - 1, 0)));
        this.world.broadcastEntityEffect(this, (byte)16);
    }

    @Override
    protected boolean isTypeNotPersistent() {
        return !this.bV();
    }

    public boolean bV() {
        return this.getDataWatcher().getByte(14) == 1;
    }

    protected void bW() {
        EntityVillager entityVillager = new EntityVillager(this.world);
        entityVillager.j(this);
        entityVillager.a((GroupDataEntity)null);
        entityVillager.bX();
        if (this.isBaby()) {
            entityVillager.setAge(-24000);
        }
        this.world.kill(this);
        this.world.addEntity(entityVillager);
        entityVillager.addEffect(new MobEffect(MobEffectList.CONFUSION.id, 200, 0));
        this.world.a(null, 1017, (int)this.locX, (int)this.locY, (int)this.locZ, 0);
    }

    protected int bX() {
        int n = 1;
        if (this.random.nextFloat() < 0.01f) {
            int n2 = 0;
            for (int i = (int)this.locX - 4; i < (int)this.locX + 4 && n2 < 14; ++i) {
                for (int j = (int)this.locY - 4; j < (int)this.locY + 4 && n2 < 14; ++j) {
                    for (int k = (int)this.locZ - 4; k < (int)this.locZ + 4 && n2 < 14; ++k) {
                        int n3 = this.world.getTypeId(i, j, k);
                        if (n3 != Block.IRON_FENCE.id && n3 != Block.BED.id) continue;
                        if (this.random.nextFloat() < 0.3f) {
                            ++n;
                        }
                        ++n2;
                    }
                }
            }
        }
        return n;
    }
}

