/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import net.minecraft.server.BlockCloth;
import net.minecraft.server.DamageSource;
import net.minecraft.server.Entity;
import net.minecraft.server.EntityAgeable;
import net.minecraft.server.EntityAnimal;
import net.minecraft.server.EntityArrow;
import net.minecraft.server.EntityCreeper;
import net.minecraft.server.EntityGhast;
import net.minecraft.server.EntityHorse;
import net.minecraft.server.EntityHuman;
import net.minecraft.server.EntityLiving;
import net.minecraft.server.EntitySheep;
import net.minecraft.server.EntityTameableAnimal;
import net.minecraft.server.GenericAttributes;
import net.minecraft.server.Item;
import net.minecraft.server.ItemFood;
import net.minecraft.server.ItemStack;
import net.minecraft.server.MathHelper;
import net.minecraft.server.NBTTagCompound;
import net.minecraft.server.PathfinderGoalBeg;
import net.minecraft.server.PathfinderGoalBreed;
import net.minecraft.server.PathfinderGoalFloat;
import net.minecraft.server.PathfinderGoalFollowOwner;
import net.minecraft.server.PathfinderGoalHurtByTarget;
import net.minecraft.server.PathfinderGoalLeapAtTarget;
import net.minecraft.server.PathfinderGoalLookAtPlayer;
import net.minecraft.server.PathfinderGoalMeleeAttack;
import net.minecraft.server.PathfinderGoalOwnerHurtByTarget;
import net.minecraft.server.PathfinderGoalOwnerHurtTarget;
import net.minecraft.server.PathfinderGoalRandomLookaround;
import net.minecraft.server.PathfinderGoalRandomStroll;
import net.minecraft.server.PathfinderGoalRandomTargetNonTamed;
import net.minecraft.server.World;

public class EntityWolf
extends EntityTameableAnimal {
    private float bq;
    private float br;
    private boolean bs;
    private boolean bt;
    private float bu;
    private float bv;

    public EntityWolf(World world) {
        super(world);
        this.a(0.6f, 0.8f);
        this.getNavigation().a(true);
        this.goalSelector.a(1, new PathfinderGoalFloat(this));
        this.goalSelector.a(2, this.bp);
        this.goalSelector.a(3, new PathfinderGoalLeapAtTarget(this, 0.4f));
        this.goalSelector.a(4, new PathfinderGoalMeleeAttack(this, 1.0, true));
        this.goalSelector.a(5, new PathfinderGoalFollowOwner(this, 1.0, 10.0f, 2.0f));
        this.goalSelector.a(6, new PathfinderGoalBreed(this, 1.0));
        this.goalSelector.a(7, new PathfinderGoalRandomStroll(this, 1.0));
        this.goalSelector.a(8, new PathfinderGoalBeg(this, 8.0f));
        this.goalSelector.a(9, new PathfinderGoalLookAtPlayer(this, EntityHuman.class, 8.0f));
        this.goalSelector.a(9, new PathfinderGoalRandomLookaround(this));
        this.targetSelector.a(1, new PathfinderGoalOwnerHurtByTarget(this));
        this.targetSelector.a(2, new PathfinderGoalOwnerHurtTarget(this));
        this.targetSelector.a(3, new PathfinderGoalHurtByTarget(this, true));
        this.targetSelector.a(4, new PathfinderGoalRandomTargetNonTamed(this, EntitySheep.class, 200, false));
        this.setTamed(false);
    }

    @Override
    protected void az() {
        super.az();
        this.getAttributeInstance(GenericAttributes.d).setValue(0.3f);
        if (this.isTamed()) {
            this.getAttributeInstance(GenericAttributes.a).setValue(20.0);
        } else {
            this.getAttributeInstance(GenericAttributes.a).setValue(8.0);
        }
    }

    @Override
    public boolean bf() {
        return true;
    }

    @Override
    public void setGoalTarget(EntityLiving entityLiving) {
        super.setGoalTarget(entityLiving);
        if (entityLiving == null) {
            this.setAngry(false);
        } else if (!this.isTamed()) {
            this.setAngry(true);
        }
    }

    @Override
    protected void bk() {
        this.datawatcher.watch(18, Float.valueOf(this.getHealth()));
    }

    @Override
    protected void a() {
        super.a();
        this.datawatcher.a(18, new Float(this.getHealth()));
        this.datawatcher.a(19, new Byte(0));
        this.datawatcher.a(20, new Byte((byte)BlockCloth.j_(1)));
    }

    @Override
    protected void a(int n, int n2, int n3, int n4) {
        this.makeSound("mob.wolf.step", 0.15f, 1.0f);
    }

    @Override
    public void b(NBTTagCompound nBTTagCompound) {
        super.b(nBTTagCompound);
        nBTTagCompound.setBoolean("Angry", this.isAngry());
        nBTTagCompound.setByte("CollarColor", (byte)this.getCollarColor());
    }

    @Override
    public void a(NBTTagCompound nBTTagCompound) {
        super.a(nBTTagCompound);
        this.setAngry(nBTTagCompound.getBoolean("Angry"));
        if (nBTTagCompound.hasKey("CollarColor")) {
            this.setCollarColor(nBTTagCompound.getByte("CollarColor"));
        }
    }

    @Override
    protected String r() {
        if (this.isAngry()) {
            return "mob.wolf.growl";
        }
        if (this.random.nextInt(3) == 0) {
            if (this.isTamed() && this.datawatcher.getFloat(18) < 10.0f) {
                return "mob.wolf.whine";
            }
            return "mob.wolf.panting";
        }
        return "mob.wolf.bark";
    }

    @Override
    protected String aO() {
        return "mob.wolf.hurt";
    }

    @Override
    protected String aP() {
        return "mob.wolf.death";
    }

    @Override
    protected float ba() {
        return 0.4f;
    }

    @Override
    protected int getLootId() {
        return -1;
    }

    @Override
    public void c() {
        super.c();
        if (!this.world.isStatic && this.bs && !this.bt && !this.bM() && this.onGround) {
            this.bt = true;
            this.bu = 0.0f;
            this.bv = 0.0f;
            this.world.broadcastEntityEffect(this, (byte)8);
        }
    }

    @Override
    public void l_() {
        super.l_();
        this.br = this.bq;
        this.bq = this.ce() ? (this.bq += (1.0f - this.bq) * 0.4f) : (this.bq += (0.0f - this.bq) * 0.4f);
        if (this.ce()) {
            this.g = 10;
        }
        if (this.G()) {
            this.bs = true;
            this.bt = false;
            this.bu = 0.0f;
            this.bv = 0.0f;
        } else if ((this.bs || this.bt) && this.bt) {
            if (this.bu == 0.0f) {
                this.makeSound("mob.wolf.shake", this.ba(), (this.random.nextFloat() - this.random.nextFloat()) * 0.2f + 1.0f);
            }
            this.bv = this.bu;
            this.bu += 0.05f;
            if (this.bv >= 2.0f) {
                this.bs = false;
                this.bt = false;
                this.bv = 0.0f;
                this.bu = 0.0f;
            }
            if (this.bu > 0.4f) {
                float f = (float)this.boundingBox.b;
                int n = (int)(MathHelper.sin((this.bu - 0.4f) * (float)Math.PI) * 7.0f);
                for (int i = 0; i < n; ++i) {
                    float f2 = (this.random.nextFloat() * 2.0f - 1.0f) * this.width * 0.5f;
                    float f3 = (this.random.nextFloat() * 2.0f - 1.0f) * this.width * 0.5f;
                    this.world.addParticle("splash", this.locX + (double)f2, f + 0.8f, this.locZ + (double)f3, this.motX, this.motY, this.motZ);
                }
            }
        }
    }

    @Override
    public float getHeadHeight() {
        return this.length * 0.8f;
    }

    @Override
    public int bp() {
        if (this.isSitting()) {
            return 20;
        }
        return super.bp();
    }

    @Override
    public boolean damageEntity(DamageSource damageSource, float f) {
        if (this.isInvulnerable()) {
            return false;
        }
        Entity entity = damageSource.getEntity();
        this.bp.setSitting(false);
        if (entity != null && !(entity instanceof EntityHuman) && !(entity instanceof EntityArrow)) {
            f = (f + 1.0f) / 2.0f;
        }
        return super.damageEntity(damageSource, f);
    }

    @Override
    public boolean m(Entity entity) {
        int n = this.isTamed() ? 4 : 2;
        return entity.damageEntity(DamageSource.mobAttack(this), n);
    }

    @Override
    public void setTamed(boolean bl) {
        super.setTamed(bl);
        if (bl) {
            this.getAttributeInstance(GenericAttributes.a).setValue(20.0);
        } else {
            this.getAttributeInstance(GenericAttributes.a).setValue(8.0);
        }
    }

    @Override
    public boolean a(EntityHuman entityHuman) {
        ItemStack itemStack = entityHuman.inventory.getItemInHand();
        if (this.isTamed()) {
            if (itemStack != null) {
                int n;
                if (Item.byId[itemStack.id] instanceof ItemFood) {
                    ItemFood itemFood = (ItemFood)Item.byId[itemStack.id];
                    if (itemFood.j() && this.datawatcher.getFloat(18) < 20.0f) {
                        if (!entityHuman.abilities.canInstantlyBuild) {
                            --itemStack.count;
                        }
                        this.heal(itemFood.getNutrition());
                        if (itemStack.count <= 0) {
                            entityHuman.inventory.setItem(entityHuman.inventory.itemInHandIndex, null);
                        }
                        return true;
                    }
                } else if (itemStack.id == Item.INK_SACK.id && (n = BlockCloth.j_(itemStack.getData())) != this.getCollarColor()) {
                    this.setCollarColor(n);
                    if (!entityHuman.abilities.canInstantlyBuild && --itemStack.count <= 0) {
                        entityHuman.inventory.setItem(entityHuman.inventory.itemInHandIndex, null);
                    }
                    return true;
                }
            }
            if (entityHuman.getName().equalsIgnoreCase(this.getOwnerName()) && !this.world.isStatic && !this.c(itemStack)) {
                this.bp.setSitting(!this.isSitting());
                this.bd = false;
                this.setPathEntity(null);
                this.setTarget(null);
                this.setGoalTarget(null);
            }
        } else if (itemStack != null && itemStack.id == Item.BONE.id && !this.isAngry()) {
            if (!entityHuman.abilities.canInstantlyBuild) {
                --itemStack.count;
            }
            if (itemStack.count <= 0) {
                entityHuman.inventory.setItem(entityHuman.inventory.itemInHandIndex, null);
            }
            if (!this.world.isStatic) {
                if (this.random.nextInt(3) == 0) {
                    this.setTamed(true);
                    this.setPathEntity(null);
                    this.setGoalTarget(null);
                    this.bp.setSitting(true);
                    this.setHealth(20.0f);
                    this.setOwnerName(entityHuman.getName());
                    this.i(true);
                    this.world.broadcastEntityEffect(this, (byte)7);
                } else {
                    this.i(false);
                    this.world.broadcastEntityEffect(this, (byte)6);
                }
            }
            return true;
        }
        return super.a(entityHuman);
    }

    @Override
    public boolean c(ItemStack itemStack) {
        if (itemStack == null) {
            return false;
        }
        if (!(Item.byId[itemStack.id] instanceof ItemFood)) {
            return false;
        }
        return ((ItemFood)Item.byId[itemStack.id]).j();
    }

    @Override
    public int bv() {
        return 8;
    }

    public boolean isAngry() {
        return (this.datawatcher.getByte(16) & 2) != 0;
    }

    public void setAngry(boolean bl) {
        byte by = this.datawatcher.getByte(16);
        if (bl) {
            this.datawatcher.watch(16, (byte)(by | 2));
        } else {
            this.datawatcher.watch(16, (byte)(by & 0xFFFFFFFD));
        }
    }

    public int getCollarColor() {
        return this.datawatcher.getByte(20) & 0xF;
    }

    public void setCollarColor(int n) {
        this.datawatcher.watch(20, (byte)(n & 0xF));
    }

    public EntityWolf b(EntityAgeable entityAgeable) {
        EntityWolf entityWolf = new EntityWolf(this.world);
        String string = this.getOwnerName();
        if (string != null && string.trim().length() > 0) {
            entityWolf.setOwnerName(string);
            entityWolf.setTamed(true);
        }
        return entityWolf;
    }

    public void m(boolean bl) {
        if (bl) {
            this.datawatcher.watch(19, (byte)1);
        } else {
            this.datawatcher.watch(19, (byte)0);
        }
    }

    @Override
    public boolean mate(EntityAnimal entityAnimal) {
        if (entityAnimal == this) {
            return false;
        }
        if (!this.isTamed()) {
            return false;
        }
        if (!(entityAnimal instanceof EntityWolf)) {
            return false;
        }
        EntityWolf entityWolf = (EntityWolf)entityAnimal;
        if (!entityWolf.isTamed()) {
            return false;
        }
        if (entityWolf.isSitting()) {
            return false;
        }
        return this.bY() && entityWolf.bY();
    }

    public boolean ce() {
        return this.datawatcher.getByte(19) == 1;
    }

    @Override
    protected boolean isTypeNotPersistent() {
        return !this.isTamed() && this.ticksLived > 2400;
    }

    @Override
    public boolean a(EntityLiving entityLiving, EntityLiving entityLiving2) {
        EntityWolf entityWolf;
        if (entityLiving instanceof EntityCreeper || entityLiving instanceof EntityGhast) {
            return false;
        }
        if (entityLiving instanceof EntityWolf && (entityWolf = (EntityWolf)entityLiving).isTamed() && entityWolf.getOwner() == entityLiving2) {
            return false;
        }
        if (entityLiving instanceof EntityHuman && entityLiving2 instanceof EntityHuman && !((EntityHuman)entityLiving2).a((EntityHuman)entityLiving)) {
            return false;
        }
        return !(entityLiving instanceof EntityHorse) || !((EntityHorse)entityLiving).isTame();
    }

    @Override
    public /* synthetic */ EntityAgeable createChild(EntityAgeable entityAgeable) {
        return this.b(entityAgeable);
    }
}

