/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import net.minecraft.server.Block;
import net.minecraft.server.DamageSource;
import net.minecraft.server.EntityFireball;
import net.minecraft.server.EntityLiving;
import net.minecraft.server.Explosion;
import net.minecraft.server.MobEffect;
import net.minecraft.server.MobEffectList;
import net.minecraft.server.MovingObjectPosition;
import net.minecraft.server.World;

public class EntityWitherSkull
extends EntityFireball {
    public EntityWitherSkull(World world) {
        super(world);
        this.a(0.3125f, 0.3125f);
    }

    public EntityWitherSkull(World world, EntityLiving entityLiving, double d, double d2, double d3) {
        super(world, entityLiving, d, d2, d3);
        this.a(0.3125f, 0.3125f);
    }

    @Override
    protected float c() {
        return this.d() ? 0.73f : super.c();
    }

    @Override
    public boolean isBurning() {
        return false;
    }

    @Override
    public float a(Explosion explosion, World world, int n, int n2, int n3, Block block) {
        float f = super.a(explosion, world, n, n2, n3, block);
        if (this.d() && block != Block.BEDROCK && block != Block.ENDER_PORTAL && block != Block.ENDER_PORTAL_FRAME) {
            f = Math.min(0.8f, f);
        }
        return f;
    }

    @Override
    protected void a(MovingObjectPosition movingObjectPosition) {
        if (!this.world.isStatic) {
            if (movingObjectPosition.entity != null) {
                if (this.shooter != null) {
                    if (movingObjectPosition.entity.damageEntity(DamageSource.mobAttack(this.shooter), 8.0f) && !movingObjectPosition.entity.isAlive()) {
                        this.shooter.heal(5.0f);
                    }
                } else {
                    movingObjectPosition.entity.damageEntity(DamageSource.MAGIC, 5.0f);
                }
                if (movingObjectPosition.entity instanceof EntityLiving) {
                    int n = 0;
                    if (this.world.difficulty > 1) {
                        if (this.world.difficulty == 2) {
                            n = 10;
                        } else if (this.world.difficulty == 3) {
                            n = 40;
                        }
                    }
                    if (n > 0) {
                        ((EntityLiving)movingObjectPosition.entity).addEffect(new MobEffect(MobEffectList.WITHER.id, 20 * n, 1));
                    }
                }
            }
            this.world.createExplosion(this, this.locX, this.locY, this.locZ, 1.0f, false, this.world.getGameRules().getBoolean("mobGriefing"));
            this.die();
        }
    }

    @Override
    public boolean L() {
        return false;
    }

    @Override
    public boolean damageEntity(DamageSource damageSource, float f) {
        return false;
    }

    @Override
    protected void a() {
        this.datawatcher.a(10, (Object)0);
    }

    public boolean d() {
        return this.datawatcher.getByte(10) == 1;
    }

    public void a(boolean bl) {
        this.datawatcher.watch(10, bl ? (byte)1 : 0);
    }
}

