/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import net.minecraft.server.Block;
import net.minecraft.server.DamageSource;
import net.minecraft.server.Entity;
import net.minecraft.server.EntityArrow;
import net.minecraft.server.EntityHuman;
import net.minecraft.server.EntityInsentient;
import net.minecraft.server.EntityLiving;
import net.minecraft.server.EntityMonster;
import net.minecraft.server.EntitySelectorNotUndead;
import net.minecraft.server.EntityWitherSkull;
import net.minecraft.server.EnumMonsterType;
import net.minecraft.server.GenericAttributes;
import net.minecraft.server.IEntitySelector;
import net.minecraft.server.IRangedEntity;
import net.minecraft.server.Item;
import net.minecraft.server.MathHelper;
import net.minecraft.server.MobEffect;
import net.minecraft.server.NBTTagCompound;
import net.minecraft.server.PathfinderGoalArrowAttack;
import net.minecraft.server.PathfinderGoalFloat;
import net.minecraft.server.PathfinderGoalHurtByTarget;
import net.minecraft.server.PathfinderGoalLookAtPlayer;
import net.minecraft.server.PathfinderGoalNearestAttackableTarget;
import net.minecraft.server.PathfinderGoalRandomLookaround;
import net.minecraft.server.PathfinderGoalRandomStroll;
import net.minecraft.server.World;

public class EntityWither
extends EntityMonster
implements IRangedEntity {
    private float[] bp = new float[2];
    private float[] bq = new float[2];
    private float[] br = new float[2];
    private float[] bs = new float[2];
    private int[] bt = new int[2];
    private int[] bu = new int[2];
    private int bv;
    private static final IEntitySelector bw = new EntitySelectorNotUndead();

    public EntityWither(World world) {
        super(world);
        this.setHealth(this.getMaxHealth());
        this.a(0.9f, 4.0f);
        this.fireProof = true;
        this.getNavigation().e(true);
        this.goalSelector.a(0, new PathfinderGoalFloat(this));
        this.goalSelector.a(2, new PathfinderGoalArrowAttack(this, 1.0, 40, 20.0f));
        this.goalSelector.a(5, new PathfinderGoalRandomStroll(this, 1.0));
        this.goalSelector.a(6, new PathfinderGoalLookAtPlayer(this, EntityHuman.class, 8.0f));
        this.goalSelector.a(7, new PathfinderGoalRandomLookaround(this));
        this.targetSelector.a(1, new PathfinderGoalHurtByTarget(this, false));
        this.targetSelector.a(2, new PathfinderGoalNearestAttackableTarget(this, EntityInsentient.class, 0, false, false, bw));
        this.b = 50;
    }

    @Override
    protected void a() {
        super.a();
        this.datawatcher.a(17, new Integer(0));
        this.datawatcher.a(18, new Integer(0));
        this.datawatcher.a(19, new Integer(0));
        this.datawatcher.a(20, new Integer(0));
    }

    @Override
    public void b(NBTTagCompound nBTTagCompound) {
        super.b(nBTTagCompound);
        nBTTagCompound.setInt("Invul", this.bU());
    }

    @Override
    public void a(NBTTagCompound nBTTagCompound) {
        super.a(nBTTagCompound);
        this.p(nBTTagCompound.getInt("Invul"));
    }

    @Override
    protected String r() {
        return "mob.wither.idle";
    }

    @Override
    protected String aO() {
        return "mob.wither.hurt";
    }

    @Override
    protected String aP() {
        return "mob.wither.death";
    }

    @Override
    public void c() {
        int n;
        int n2;
        double d;
        double d2;
        double d3;
        Entity entity;
        this.motY *= (double)0.6f;
        if (!this.world.isStatic && this.q(0) > 0 && (entity = this.world.getEntity(this.q(0))) != null) {
            double d4;
            if (this.locY < entity.locY || !this.bV() && this.locY < entity.locY + 5.0) {
                if (this.motY < 0.0) {
                    this.motY = 0.0;
                }
                this.motY += (0.5 - this.motY) * (double)0.6f;
            }
            if ((d3 = (d4 = entity.locX - this.locX) * d4 + (d2 = entity.locZ - this.locZ) * d2) > 9.0) {
                d = MathHelper.sqrt(d3);
                this.motX += (d4 / d * 0.5 - this.motX) * (double)0.6f;
                this.motZ += (d2 / d * 0.5 - this.motZ) * (double)0.6f;
            }
        }
        if (this.motX * this.motX + this.motZ * this.motZ > (double)0.05f) {
            this.yaw = (float)Math.atan2(this.motZ, this.motX) * 57.295776f - 90.0f;
        }
        super.c();
        for (n2 = 0; n2 < 2; ++n2) {
            this.bs[n2] = this.bq[n2];
            this.br[n2] = this.bp[n2];
        }
        for (n2 = 0; n2 < 2; ++n2) {
            n = this.q(n2 + 1);
            Entity entity2 = null;
            if (n > 0) {
                entity2 = this.world.getEntity(n);
            }
            if (entity2 != null) {
                d2 = this.r(n2 + 1);
                d3 = this.s(n2 + 1);
                d = this.t(n2 + 1);
                double d5 = entity2.locX - d2;
                double d6 = entity2.locY + (double)entity2.getHeadHeight() - d3;
                double d7 = entity2.locZ - d;
                double d8 = MathHelper.sqrt(d5 * d5 + d7 * d7);
                float f = (float)(Math.atan2(d7, d5) * 180.0 / 3.1415927410125732) - 90.0f;
                float f2 = (float)(-(Math.atan2(d6, d8) * 180.0 / 3.1415927410125732));
                this.bp[n2] = this.b(this.bp[n2], f2, 40.0f);
                this.bq[n2] = this.b(this.bq[n2], f, 10.0f);
                continue;
            }
            this.bq[n2] = this.b(this.bq[n2], this.aN, 10.0f);
        }
        n2 = this.bV() ? 1 : 0;
        for (n = 0; n < 3; ++n) {
            double d9 = this.r(n);
            double d10 = this.s(n);
            double d11 = this.t(n);
            this.world.addParticle("smoke", d9 + this.random.nextGaussian() * (double)0.3f, d10 + this.random.nextGaussian() * (double)0.3f, d11 + this.random.nextGaussian() * (double)0.3f, 0.0, 0.0, 0.0);
            if (n2 == 0 || this.world.random.nextInt(4) != 0) continue;
            this.world.addParticle("mobSpell", d9 + this.random.nextGaussian() * (double)0.3f, d10 + this.random.nextGaussian() * (double)0.3f, d11 + this.random.nextGaussian() * (double)0.3f, 0.7f, 0.7f, 0.5);
        }
        if (this.bU() > 0) {
            for (n = 0; n < 3; ++n) {
                this.world.addParticle("mobSpell", this.locX + this.random.nextGaussian() * 1.0, this.locY + (double)(this.random.nextFloat() * 3.3f), this.locZ + this.random.nextGaussian() * 1.0, 0.7f, 0.7f, 0.9f);
            }
        }
    }

    @Override
    protected void bi() {
        int n;
        int n2;
        int n3;
        if (this.bU() > 0) {
            int n4 = this.bU() - 1;
            if (n4 <= 0) {
                this.world.createExplosion(this, this.locX, this.locY + (double)this.getHeadHeight(), this.locZ, 7.0f, false, this.world.getGameRules().getBoolean("mobGriefing"));
                this.world.d(1013, (int)this.locX, (int)this.locY, (int)this.locZ, 0);
            }
            this.p(n4);
            if (this.ticksLived % 10 == 0) {
                this.heal(10.0f);
            }
            return;
        }
        super.bi();
        block0: for (n3 = 1; n3 < 3; ++n3) {
            Object object;
            if (this.ticksLived < this.bt[n3 - 1]) continue;
            this.bt[n3 - 1] = this.ticksLived + 10 + this.random.nextInt(10);
            if (this.world.difficulty >= 2) {
                int n5 = n3 - 1;
                int n6 = this.bu[n5];
                this.bu[n5] = n6 + 1;
                if (n6 > 15) {
                    float f = 10.0f;
                    float f2 = 5.0f;
                    double d = MathHelper.a(this.random, this.locX - (double)f, this.locX + (double)f);
                    double d2 = MathHelper.a(this.random, this.locY - (double)f2, this.locY + (double)f2);
                    double d3 = MathHelper.a(this.random, this.locZ - (double)f, this.locZ + (double)f);
                    this.a(n3 + 1, d, d2, d3, true);
                    this.bu[n3 - 1] = 0;
                }
            }
            if ((n2 = this.q(n3)) > 0) {
                object = this.world.getEntity(n2);
                if (object == null || !((Entity)object).isAlive() || this.e((Entity)object) > 900.0 || !this.o((Entity)object)) {
                    this.c(n3, 0);
                    continue;
                }
                this.a(n3 + 1, (EntityLiving)object);
                this.bt[n3 - 1] = this.ticksLived + 40 + this.random.nextInt(20);
                this.bu[n3 - 1] = 0;
                continue;
            }
            object = this.world.a(EntityLiving.class, this.boundingBox.grow(20.0, 8.0, 20.0), bw);
            for (n = 0; n < 10 && !object.isEmpty(); ++n) {
                EntityLiving entityLiving = (EntityLiving)object.get(this.random.nextInt(object.size()));
                if (entityLiving != this && entityLiving.isAlive() && this.o(entityLiving)) {
                    if (entityLiving instanceof EntityHuman) {
                        if (((EntityHuman)entityLiving).abilities.isInvulnerable) continue block0;
                        this.c(n3, entityLiving.id);
                        continue block0;
                    }
                    this.c(n3, entityLiving.id);
                    continue block0;
                }
                object.remove(entityLiving);
            }
        }
        if (this.getGoalTarget() != null) {
            this.c(0, this.getGoalTarget().id);
        } else {
            this.c(0, 0);
        }
        if (this.bv > 0) {
            --this.bv;
            if (this.bv == 0 && this.world.getGameRules().getBoolean("mobGriefing")) {
                n3 = MathHelper.floor(this.locY);
                n2 = MathHelper.floor(this.locX);
                int n7 = MathHelper.floor(this.locZ);
                n = 0;
                for (int i = -1; i <= 1; ++i) {
                    for (int j = -1; j <= 1; ++j) {
                        for (int k = 0; k <= 3; ++k) {
                            int n8 = n2 + i;
                            int n9 = n3 + k;
                            int n10 = n7 + j;
                            int n11 = this.world.getTypeId(n8, n9, n10);
                            if (n11 <= 0 || n11 == Block.BEDROCK.id || n11 == Block.ENDER_PORTAL.id || n11 == Block.ENDER_PORTAL_FRAME.id) continue;
                            n = this.world.setAir(n8, n9, n10, true) || n != 0 ? 1 : 0;
                        }
                    }
                }
                if (n != 0) {
                    this.world.a(null, 1012, (int)this.locX, (int)this.locY, (int)this.locZ, 0);
                }
            }
        }
        if (this.ticksLived % 20 == 0) {
            this.heal(1.0f);
        }
    }

    public void bT() {
        this.p(220);
        this.setHealth(this.getMaxHealth() / 3.0f);
    }

    @Override
    public void am() {
    }

    @Override
    public int aQ() {
        return 4;
    }

    private double r(int n) {
        if (n <= 0) {
            return this.locX;
        }
        float f = (this.aN + (float)(180 * (n - 1))) / 180.0f * (float)Math.PI;
        float f2 = MathHelper.cos(f);
        return this.locX + (double)f2 * 1.3;
    }

    private double s(int n) {
        if (n <= 0) {
            return this.locY + 3.0;
        }
        return this.locY + 2.2;
    }

    private double t(int n) {
        if (n <= 0) {
            return this.locZ;
        }
        float f = (this.aN + (float)(180 * (n - 1))) / 180.0f * (float)Math.PI;
        float f2 = MathHelper.sin(f);
        return this.locZ + (double)f2 * 1.3;
    }

    private float b(float f, float f2, float f3) {
        float f4 = MathHelper.g(f2 - f);
        if (f4 > f3) {
            f4 = f3;
        }
        if (f4 < -f3) {
            f4 = -f3;
        }
        return f + f4;
    }

    private void a(int n, EntityLiving entityLiving) {
        this.a(n, entityLiving.locX, entityLiving.locY + (double)entityLiving.getHeadHeight() * 0.5, entityLiving.locZ, n == 0 && this.random.nextFloat() < 0.001f);
    }

    private void a(int n, double d, double d2, double d3, boolean bl) {
        this.world.a(null, 1014, (int)this.locX, (int)this.locY, (int)this.locZ, 0);
        double d4 = this.r(n);
        double d5 = this.s(n);
        double d6 = this.t(n);
        double d7 = d - d4;
        double d8 = d2 - d5;
        double d9 = d3 - d6;
        EntityWitherSkull entityWitherSkull = new EntityWitherSkull(this.world, this, d7, d8, d9);
        if (bl) {
            entityWitherSkull.a(true);
        }
        entityWitherSkull.locY = d5;
        entityWitherSkull.locX = d4;
        entityWitherSkull.locZ = d6;
        this.world.addEntity(entityWitherSkull);
    }

    @Override
    public void a(EntityLiving entityLiving, float f) {
        this.a(0, entityLiving);
    }

    @Override
    public boolean damageEntity(DamageSource damageSource, float f) {
        Entity entity;
        if (this.isInvulnerable()) {
            return false;
        }
        if (damageSource == DamageSource.DROWN) {
            return false;
        }
        if (this.bU() > 0) {
            return false;
        }
        if (this.bV() && (entity = damageSource.h()) instanceof EntityArrow) {
            return false;
        }
        entity = damageSource.getEntity();
        if (entity != null && !(entity instanceof EntityHuman) && entity instanceof EntityLiving && ((EntityLiving)entity).getMonsterType() == this.getMonsterType()) {
            return false;
        }
        if (this.bv <= 0) {
            this.bv = 20;
        }
        int n = 0;
        while (n < this.bu.length) {
            int n2 = n++;
            this.bu[n2] = this.bu[n2] + 3;
        }
        return super.damageEntity(damageSource, f);
    }

    @Override
    protected void dropDeathLoot(boolean bl, int n) {
        this.b(Item.NETHER_STAR.id, 1);
    }

    @Override
    protected void u() {
        this.aV = 0;
    }

    @Override
    public boolean L() {
        return !this.dead;
    }

    @Override
    protected void b(float f) {
    }

    @Override
    public void addEffect(MobEffect mobEffect) {
    }

    @Override
    protected boolean bf() {
        return true;
    }

    @Override
    protected void az() {
        super.az();
        this.getAttributeInstance(GenericAttributes.a).setValue(300.0);
        this.getAttributeInstance(GenericAttributes.d).setValue(0.6f);
        this.getAttributeInstance(GenericAttributes.b).setValue(40.0);
    }

    public int bU() {
        return this.datawatcher.getInt(20);
    }

    public void p(int n) {
        this.datawatcher.watch(20, n);
    }

    public int q(int n) {
        return this.datawatcher.getInt(17 + n);
    }

    public void c(int n, int n2) {
        this.datawatcher.watch(17 + n, n2);
    }

    public boolean bV() {
        return this.getHealth() <= this.getMaxHealth() / 2.0f;
    }

    @Override
    public EnumMonsterType getMonsterType() {
        return EnumMonsterType.UNDEAD;
    }

    @Override
    public void mount(Entity entity) {
        this.vehicle = null;
    }
}

