/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import java.util.List;
import java.util.UUID;
import net.minecraft.server.AttributeInstance;
import net.minecraft.server.AttributeModifier;
import net.minecraft.server.DamageSource;
import net.minecraft.server.EntityHuman;
import net.minecraft.server.EntityLiving;
import net.minecraft.server.EntityMonster;
import net.minecraft.server.EntityPotion;
import net.minecraft.server.GenericAttributes;
import net.minecraft.server.IRangedEntity;
import net.minecraft.server.Item;
import net.minecraft.server.ItemStack;
import net.minecraft.server.MathHelper;
import net.minecraft.server.MobEffect;
import net.minecraft.server.MobEffectList;
import net.minecraft.server.PathfinderGoalArrowAttack;
import net.minecraft.server.PathfinderGoalFloat;
import net.minecraft.server.PathfinderGoalHurtByTarget;
import net.minecraft.server.PathfinderGoalLookAtPlayer;
import net.minecraft.server.PathfinderGoalNearestAttackableTarget;
import net.minecraft.server.PathfinderGoalRandomLookaround;
import net.minecraft.server.PathfinderGoalRandomStroll;
import net.minecraft.server.World;

public class EntityWitch
extends EntityMonster
implements IRangedEntity {
    private static final UUID bp = UUID.fromString("5CD17E52-A79A-43D3-A529-90FDE04B181E");
    private static final AttributeModifier bq = new AttributeModifier(bp, "Drinking speed penalty", -0.25, 0).a(false);
    private static final int[] br = new int[]{Item.GLOWSTONE_DUST.id, Item.SUGAR.id, Item.REDSTONE.id, Item.SPIDER_EYE.id, Item.GLASS_BOTTLE.id, Item.SULPHUR.id, Item.STICK.id, Item.STICK.id};
    private int bs;

    public EntityWitch(World world) {
        super(world);
        this.goalSelector.a(1, new PathfinderGoalFloat(this));
        this.goalSelector.a(2, new PathfinderGoalArrowAttack(this, 1.0, 60, 10.0f));
        this.goalSelector.a(2, new PathfinderGoalRandomStroll(this, 1.0));
        this.goalSelector.a(3, new PathfinderGoalLookAtPlayer(this, EntityHuman.class, 8.0f));
        this.goalSelector.a(3, new PathfinderGoalRandomLookaround(this));
        this.targetSelector.a(1, new PathfinderGoalHurtByTarget(this, false));
        this.targetSelector.a(2, new PathfinderGoalNearestAttackableTarget(this, EntityHuman.class, 0, true));
    }

    @Override
    protected void a() {
        super.a();
        this.getDataWatcher().a(21, (Object)0);
    }

    @Override
    protected String r() {
        return "mob.witch.idle";
    }

    @Override
    protected String aO() {
        return "mob.witch.hurt";
    }

    @Override
    protected String aP() {
        return "mob.witch.death";
    }

    public void a(boolean bl) {
        this.getDataWatcher().watch(21, bl ? (byte)1 : 0);
    }

    public boolean bT() {
        return this.getDataWatcher().getByte(21) == 1;
    }

    @Override
    protected void az() {
        super.az();
        this.getAttributeInstance(GenericAttributes.a).setValue(26.0);
        this.getAttributeInstance(GenericAttributes.d).setValue(0.25);
    }

    @Override
    public boolean bf() {
        return true;
    }

    @Override
    public void c() {
        if (!this.world.isStatic) {
            if (this.bT()) {
                if (this.bs-- <= 0) {
                    List list;
                    this.a(false);
                    ItemStack itemStack = this.aZ();
                    this.setEquipment(0, null);
                    if (itemStack != null && itemStack.id == Item.POTION.id && (list = Item.POTION.g(itemStack)) != null) {
                        for (MobEffect mobEffect : list) {
                            this.addEffect(new MobEffect(mobEffect));
                        }
                    }
                    this.getAttributeInstance(GenericAttributes.d).b(bq);
                }
            } else {
                int n = -1;
                if (this.random.nextFloat() < 0.15f && this.isBurning() && !this.hasEffect(MobEffectList.FIRE_RESISTANCE)) {
                    n = 16307;
                } else if (this.random.nextFloat() < 0.05f && this.getHealth() < this.getMaxHealth()) {
                    n = 16341;
                } else if (this.random.nextFloat() < 0.25f && this.getGoalTarget() != null && !this.hasEffect(MobEffectList.FASTER_MOVEMENT) && this.getGoalTarget().e(this) > 121.0) {
                    n = 16274;
                } else if (this.random.nextFloat() < 0.25f && this.getGoalTarget() != null && !this.hasEffect(MobEffectList.FASTER_MOVEMENT) && this.getGoalTarget().e(this) > 121.0) {
                    n = 16274;
                }
                if (n > -1) {
                    this.setEquipment(0, new ItemStack(Item.POTION, 1, n));
                    this.bs = this.aZ().n();
                    this.a(true);
                    AttributeInstance attributeInstance = this.getAttributeInstance(GenericAttributes.d);
                    attributeInstance.b(bq);
                    attributeInstance.a(bq);
                }
            }
            if (this.random.nextFloat() < 7.5E-4f) {
                this.world.broadcastEntityEffect(this, (byte)15);
            }
        }
        super.c();
    }

    @Override
    protected float c(DamageSource damageSource, float f) {
        f = super.c(damageSource, f);
        if (damageSource.getEntity() == this) {
            f = 0.0f;
        }
        if (damageSource.q()) {
            f = (float)((double)f * 0.15);
        }
        return f;
    }

    @Override
    protected void dropDeathLoot(boolean bl, int n) {
        int n2 = this.random.nextInt(3) + 1;
        for (int i = 0; i < n2; ++i) {
            int n3 = this.random.nextInt(3);
            int n4 = br[this.random.nextInt(br.length)];
            if (n > 0) {
                n3 += this.random.nextInt(n + 1);
            }
            for (int j = 0; j < n3; ++j) {
                this.b(n4, 1);
            }
        }
    }

    @Override
    public void a(EntityLiving entityLiving, float f) {
        if (this.bT()) {
            return;
        }
        EntityPotion entityPotion = new EntityPotion(this.world, (EntityLiving)this, 32732);
        entityPotion.pitch -= -20.0f;
        double d = entityLiving.locX + entityLiving.motX - this.locX;
        double d2 = entityLiving.locY + (double)entityLiving.getHeadHeight() - (double)1.1f - this.locY;
        double d3 = entityLiving.locZ + entityLiving.motZ - this.locZ;
        float f2 = MathHelper.sqrt(d * d + d3 * d3);
        if (f2 >= 8.0f && !entityLiving.hasEffect(MobEffectList.SLOWER_MOVEMENT)) {
            entityPotion.setPotionValue(32698);
        } else if (entityLiving.getHealth() >= 8.0f && !entityLiving.hasEffect(MobEffectList.POISON)) {
            entityPotion.setPotionValue(32660);
        } else if (f2 <= 3.0f && !entityLiving.hasEffect(MobEffectList.WEAKNESS) && this.random.nextFloat() < 0.25f) {
            entityPotion.setPotionValue(32696);
        }
        entityPotion.shoot(d, d2 + (double)(f2 * 0.2f), d3, 0.75f, 8.0f);
        this.world.addEntity(entityPotion);
    }
}

