/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import net.minecraft.server.Block;
import net.minecraft.server.ChunkCoordinates;
import net.minecraft.server.DamageSource;
import net.minecraft.server.Enchantment;
import net.minecraft.server.EnchantmentInstance;
import net.minecraft.server.EnchantmentManager;
import net.minecraft.server.Entity;
import net.minecraft.server.EntityAgeable;
import net.minecraft.server.EntityHuman;
import net.minecraft.server.EntityInsentient;
import net.minecraft.server.EntityLiving;
import net.minecraft.server.EntityZombie;
import net.minecraft.server.GenericAttributes;
import net.minecraft.server.GroupDataEntity;
import net.minecraft.server.IMerchant;
import net.minecraft.server.IMonster;
import net.minecraft.server.Item;
import net.minecraft.server.ItemStack;
import net.minecraft.server.MathHelper;
import net.minecraft.server.MerchantRecipe;
import net.minecraft.server.MerchantRecipeList;
import net.minecraft.server.MobEffect;
import net.minecraft.server.MobEffectList;
import net.minecraft.server.NBTTagCompound;
import net.minecraft.server.NPC;
import net.minecraft.server.PathfinderGoalAvoidPlayer;
import net.minecraft.server.PathfinderGoalFloat;
import net.minecraft.server.PathfinderGoalInteract;
import net.minecraft.server.PathfinderGoalLookAtPlayer;
import net.minecraft.server.PathfinderGoalLookAtTradingPlayer;
import net.minecraft.server.PathfinderGoalMakeLove;
import net.minecraft.server.PathfinderGoalMoveIndoors;
import net.minecraft.server.PathfinderGoalMoveTowardsRestriction;
import net.minecraft.server.PathfinderGoalOpenDoor;
import net.minecraft.server.PathfinderGoalPlay;
import net.minecraft.server.PathfinderGoalRandomStroll;
import net.minecraft.server.PathfinderGoalRestrictOpenDoor;
import net.minecraft.server.PathfinderGoalTakeFlower;
import net.minecraft.server.PathfinderGoalTradeWithPlayer;
import net.minecraft.server.Tuple;
import net.minecraft.server.Village;
import net.minecraft.server.World;

public class EntityVillager
extends EntityAgeable
implements IMerchant,
NPC {
    private int profession;
    private boolean br;
    private boolean bs;
    Village village;
    private EntityHuman tradingPlayer;
    private MerchantRecipeList bu;
    private int bv;
    private boolean bw;
    private int riches;
    private String by;
    private boolean bz;
    private float bA;
    private static final Map bB = new HashMap();
    private static final Map bC = new HashMap();

    public EntityVillager(World world) {
        this(world, 0);
    }

    public EntityVillager(World world, int n) {
        super(world);
        this.setProfession(n);
        this.a(0.6f, 1.8f);
        this.getNavigation().b(true);
        this.getNavigation().a(true);
        this.goalSelector.a(0, new PathfinderGoalFloat(this));
        this.goalSelector.a(1, new PathfinderGoalAvoidPlayer(this, EntityZombie.class, 8.0f, 0.6, 0.6));
        this.goalSelector.a(1, new PathfinderGoalTradeWithPlayer(this));
        this.goalSelector.a(1, new PathfinderGoalLookAtTradingPlayer(this));
        this.goalSelector.a(2, new PathfinderGoalMoveIndoors(this));
        this.goalSelector.a(3, new PathfinderGoalRestrictOpenDoor(this));
        this.goalSelector.a(4, new PathfinderGoalOpenDoor(this, true));
        this.goalSelector.a(5, new PathfinderGoalMoveTowardsRestriction(this, 0.6));
        this.goalSelector.a(6, new PathfinderGoalMakeLove(this));
        this.goalSelector.a(7, new PathfinderGoalTakeFlower(this));
        this.goalSelector.a(8, new PathfinderGoalPlay(this, 0.32));
        this.goalSelector.a(9, new PathfinderGoalInteract(this, EntityHuman.class, 3.0f, 1.0f));
        this.goalSelector.a(9, new PathfinderGoalInteract(this, EntityVillager.class, 5.0f, 0.02f));
        this.goalSelector.a(9, new PathfinderGoalRandomStroll(this, 0.6));
        this.goalSelector.a(10, new PathfinderGoalLookAtPlayer(this, EntityInsentient.class, 8.0f));
    }

    @Override
    protected void az() {
        super.az();
        this.getAttributeInstance(GenericAttributes.d).setValue(0.5);
    }

    @Override
    public boolean bf() {
        return true;
    }

    @Override
    protected void bk() {
        if (--this.profession <= 0) {
            this.world.villages.a(MathHelper.floor(this.locX), MathHelper.floor(this.locY), MathHelper.floor(this.locZ));
            this.profession = 70 + this.random.nextInt(50);
            this.village = this.world.villages.getClosestVillage(MathHelper.floor(this.locX), MathHelper.floor(this.locY), MathHelper.floor(this.locZ), 32);
            if (this.village == null) {
                this.bR();
            } else {
                ChunkCoordinates chunkCoordinates = this.village.getCenter();
                this.b(chunkCoordinates.x, chunkCoordinates.y, chunkCoordinates.z, (int)((float)this.village.getSize() * 0.6f));
                if (this.bz) {
                    this.bz = false;
                    this.village.b(5);
                }
            }
        }
        if (!this.bW() && this.bv > 0) {
            --this.bv;
            if (this.bv <= 0) {
                if (this.bw) {
                    if (this.bu.size() > 1) {
                        for (MerchantRecipe merchantRecipe : this.bu) {
                            if (!merchantRecipe.g()) continue;
                            merchantRecipe.a(this.random.nextInt(6) + this.random.nextInt(6) + 2);
                        }
                    }
                    this.q(1);
                    this.bw = false;
                    if (this.village != null && this.by != null) {
                        this.world.broadcastEntityEffect(this, (byte)14);
                        this.village.a(this.by, 1);
                    }
                }
                this.addEffect(new MobEffect(MobEffectList.REGENERATION.id, 200, 0));
            }
        }
        super.bk();
    }

    @Override
    public boolean a(EntityHuman entityHuman) {
        boolean bl;
        ItemStack itemStack = entityHuman.inventory.getItemInHand();
        boolean bl2 = bl = itemStack != null && itemStack.id == Item.MONSTER_EGG.id;
        if (!bl && this.isAlive() && !this.bW() && !this.isBaby()) {
            if (!this.world.isStatic) {
                this.a_(entityHuman);
                entityHuman.openTrade(this, this.getCustomName());
            }
            return true;
        }
        return super.a(entityHuman);
    }

    @Override
    protected void a() {
        super.a();
        this.datawatcher.a(16, (Object)0);
    }

    @Override
    public void b(NBTTagCompound nBTTagCompound) {
        super.b(nBTTagCompound);
        nBTTagCompound.setInt("Profession", this.getProfession());
        nBTTagCompound.setInt("Riches", this.riches);
        if (this.bu != null) {
            nBTTagCompound.setCompound("Offers", this.bu.a());
        }
    }

    @Override
    public void a(NBTTagCompound nBTTagCompound) {
        super.a(nBTTagCompound);
        this.setProfession(nBTTagCompound.getInt("Profession"));
        this.riches = nBTTagCompound.getInt("Riches");
        if (nBTTagCompound.hasKey("Offers")) {
            NBTTagCompound nBTTagCompound2 = nBTTagCompound.getCompound("Offers");
            this.bu = new MerchantRecipeList(nBTTagCompound2);
        }
    }

    @Override
    protected boolean isTypeNotPersistent() {
        return false;
    }

    @Override
    protected String r() {
        if (this.bW()) {
            return "mob.villager.haggle";
        }
        return "mob.villager.idle";
    }

    @Override
    protected String aO() {
        return "mob.villager.hit";
    }

    @Override
    protected String aP() {
        return "mob.villager.death";
    }

    public void setProfession(int n) {
        this.datawatcher.watch(16, n);
    }

    public int getProfession() {
        return this.datawatcher.getInt(16);
    }

    public boolean bU() {
        return this.br;
    }

    public void i(boolean bl) {
        this.br = bl;
    }

    public void j(boolean bl) {
        this.bs = bl;
    }

    public boolean bV() {
        return this.bs;
    }

    @Override
    public void b(EntityLiving entityLiving) {
        super.b(entityLiving);
        if (this.village != null && entityLiving != null) {
            this.village.a(entityLiving);
            if (entityLiving instanceof EntityHuman) {
                int n = -1;
                if (this.isBaby()) {
                    n = -3;
                }
                this.village.a(((EntityHuman)entityLiving).getName(), n);
                if (this.isAlive()) {
                    this.world.broadcastEntityEffect(this, (byte)13);
                }
            }
        }
    }

    @Override
    public void die(DamageSource damageSource) {
        if (this.village != null) {
            EntityHuman entityHuman;
            Entity entity = damageSource.getEntity();
            if (entity != null) {
                if (entity instanceof EntityHuman) {
                    this.village.a(((EntityHuman)entity).getName(), -2);
                } else if (entity instanceof IMonster) {
                    this.village.h();
                }
            } else if (entity == null && (entityHuman = this.world.findNearbyPlayer(this, 16.0)) != null) {
                this.village.h();
            }
        }
        super.die(damageSource);
    }

    @Override
    public void a_(EntityHuman entityHuman) {
        this.tradingPlayer = entityHuman;
    }

    @Override
    public EntityHuman m_() {
        return this.tradingPlayer;
    }

    public boolean bW() {
        return this.tradingPlayer != null;
    }

    @Override
    public void a(MerchantRecipe merchantRecipe) {
        merchantRecipe.f();
        this.a_ = -this.o();
        this.makeSound("mob.villager.yes", this.ba(), this.bb());
        if (merchantRecipe.a((MerchantRecipe)this.bu.get(this.bu.size() - 1))) {
            this.bv = 40;
            this.bw = true;
            this.by = this.tradingPlayer != null ? this.tradingPlayer.getName() : null;
        }
        if (merchantRecipe.getBuyItem1().id == Item.EMERALD.id) {
            this.riches += merchantRecipe.getBuyItem1().count;
        }
    }

    @Override
    public void a_(ItemStack itemStack) {
        if (!this.world.isStatic && this.a_ > -this.o() + 20) {
            this.a_ = -this.o();
            if (itemStack != null) {
                this.makeSound("mob.villager.yes", this.ba(), this.bb());
            } else {
                this.makeSound("mob.villager.no", this.ba(), this.bb());
            }
        }
    }

    @Override
    public MerchantRecipeList getOffers(EntityHuman entityHuman) {
        if (this.bu == null) {
            this.q(1);
        }
        return this.bu;
    }

    private float p(float f) {
        float f2 = f + this.bA;
        if (f2 > 0.9f) {
            return 0.9f - (f2 - 0.9f);
        }
        return f2;
    }

    private void q(int n) {
        this.bA = this.bu != null ? MathHelper.c(this.bu.size()) * 0.2f : 0.0f;
        MerchantRecipeList merchantRecipeList = new MerchantRecipeList();
        switch (this.getProfession()) {
            case 0: {
                EntityVillager.a(merchantRecipeList, Item.WHEAT.id, this.random, this.p(0.9f));
                EntityVillager.a(merchantRecipeList, Block.WOOL.id, this.random, this.p(0.5f));
                EntityVillager.a(merchantRecipeList, Item.RAW_CHICKEN.id, this.random, this.p(0.5f));
                EntityVillager.a(merchantRecipeList, Item.COOKED_FISH.id, this.random, this.p(0.4f));
                EntityVillager.b(merchantRecipeList, Item.BREAD.id, this.random, this.p(0.9f));
                EntityVillager.b(merchantRecipeList, Item.MELON.id, this.random, this.p(0.3f));
                EntityVillager.b(merchantRecipeList, Item.APPLE.id, this.random, this.p(0.3f));
                EntityVillager.b(merchantRecipeList, Item.COOKIE.id, this.random, this.p(0.3f));
                EntityVillager.b(merchantRecipeList, Item.SHEARS.id, this.random, this.p(0.3f));
                EntityVillager.b(merchantRecipeList, Item.FLINT_AND_STEEL.id, this.random, this.p(0.3f));
                EntityVillager.b(merchantRecipeList, Item.COOKED_CHICKEN.id, this.random, this.p(0.3f));
                EntityVillager.b(merchantRecipeList, Item.ARROW.id, this.random, this.p(0.5f));
                if (!(this.random.nextFloat() < this.p(0.5f))) break;
                merchantRecipeList.add(new MerchantRecipe(new ItemStack(Block.GRAVEL, 10), new ItemStack(Item.EMERALD), new ItemStack(Item.FLINT.id, 4 + this.random.nextInt(2), 0)));
                break;
            }
            case 4: {
                EntityVillager.a(merchantRecipeList, Item.COAL.id, this.random, this.p(0.7f));
                EntityVillager.a(merchantRecipeList, Item.PORK.id, this.random, this.p(0.5f));
                EntityVillager.a(merchantRecipeList, Item.RAW_BEEF.id, this.random, this.p(0.5f));
                EntityVillager.b(merchantRecipeList, Item.SADDLE.id, this.random, this.p(0.1f));
                EntityVillager.b(merchantRecipeList, Item.LEATHER_CHESTPLATE.id, this.random, this.p(0.3f));
                EntityVillager.b(merchantRecipeList, Item.LEATHER_BOOTS.id, this.random, this.p(0.3f));
                EntityVillager.b(merchantRecipeList, Item.LEATHER_HELMET.id, this.random, this.p(0.3f));
                EntityVillager.b(merchantRecipeList, Item.LEATHER_LEGGINGS.id, this.random, this.p(0.3f));
                EntityVillager.b(merchantRecipeList, Item.GRILLED_PORK.id, this.random, this.p(0.3f));
                EntityVillager.b(merchantRecipeList, Item.COOKED_BEEF.id, this.random, this.p(0.3f));
                break;
            }
            case 3: {
                EntityVillager.a(merchantRecipeList, Item.COAL.id, this.random, this.p(0.7f));
                EntityVillager.a(merchantRecipeList, Item.IRON_INGOT.id, this.random, this.p(0.5f));
                EntityVillager.a(merchantRecipeList, Item.GOLD_INGOT.id, this.random, this.p(0.5f));
                EntityVillager.a(merchantRecipeList, Item.DIAMOND.id, this.random, this.p(0.5f));
                EntityVillager.b(merchantRecipeList, Item.IRON_SWORD.id, this.random, this.p(0.5f));
                EntityVillager.b(merchantRecipeList, Item.DIAMOND_SWORD.id, this.random, this.p(0.5f));
                EntityVillager.b(merchantRecipeList, Item.IRON_AXE.id, this.random, this.p(0.3f));
                EntityVillager.b(merchantRecipeList, Item.DIAMOND_AXE.id, this.random, this.p(0.3f));
                EntityVillager.b(merchantRecipeList, Item.IRON_PICKAXE.id, this.random, this.p(0.5f));
                EntityVillager.b(merchantRecipeList, Item.DIAMOND_PICKAXE.id, this.random, this.p(0.5f));
                EntityVillager.b(merchantRecipeList, Item.IRON_SPADE.id, this.random, this.p(0.2f));
                EntityVillager.b(merchantRecipeList, Item.DIAMOND_SPADE.id, this.random, this.p(0.2f));
                EntityVillager.b(merchantRecipeList, Item.IRON_HOE.id, this.random, this.p(0.2f));
                EntityVillager.b(merchantRecipeList, Item.DIAMOND_HOE.id, this.random, this.p(0.2f));
                EntityVillager.b(merchantRecipeList, Item.IRON_BOOTS.id, this.random, this.p(0.2f));
                EntityVillager.b(merchantRecipeList, Item.DIAMOND_BOOTS.id, this.random, this.p(0.2f));
                EntityVillager.b(merchantRecipeList, Item.IRON_HELMET.id, this.random, this.p(0.2f));
                EntityVillager.b(merchantRecipeList, Item.DIAMOND_HELMET.id, this.random, this.p(0.2f));
                EntityVillager.b(merchantRecipeList, Item.IRON_CHESTPLATE.id, this.random, this.p(0.2f));
                EntityVillager.b(merchantRecipeList, Item.DIAMOND_CHESTPLATE.id, this.random, this.p(0.2f));
                EntityVillager.b(merchantRecipeList, Item.IRON_LEGGINGS.id, this.random, this.p(0.2f));
                EntityVillager.b(merchantRecipeList, Item.DIAMOND_LEGGINGS.id, this.random, this.p(0.2f));
                EntityVillager.b(merchantRecipeList, Item.CHAINMAIL_BOOTS.id, this.random, this.p(0.1f));
                EntityVillager.b(merchantRecipeList, Item.CHAINMAIL_HELMET.id, this.random, this.p(0.1f));
                EntityVillager.b(merchantRecipeList, Item.CHAINMAIL_CHESTPLATE.id, this.random, this.p(0.1f));
                EntityVillager.b(merchantRecipeList, Item.CHAINMAIL_LEGGINGS.id, this.random, this.p(0.1f));
                break;
            }
            case 1: {
                EntityVillager.a(merchantRecipeList, Item.PAPER.id, this.random, this.p(0.8f));
                EntityVillager.a(merchantRecipeList, Item.BOOK.id, this.random, this.p(0.8f));
                EntityVillager.a(merchantRecipeList, Item.WRITTEN_BOOK.id, this.random, this.p(0.3f));
                EntityVillager.b(merchantRecipeList, Block.BOOKSHELF.id, this.random, this.p(0.8f));
                EntityVillager.b(merchantRecipeList, Block.GLASS.id, this.random, this.p(0.2f));
                EntityVillager.b(merchantRecipeList, Item.COMPASS.id, this.random, this.p(0.2f));
                EntityVillager.b(merchantRecipeList, Item.WATCH.id, this.random, this.p(0.2f));
                if (!(this.random.nextFloat() < this.p(0.07f))) break;
                Object object = Enchantment.c[this.random.nextInt(Enchantment.c.length)];
                int n2 = MathHelper.nextInt(this.random, ((Enchantment)object).getStartLevel(), ((Enchantment)object).getMaxLevel());
                ItemStack itemStack = Item.ENCHANTED_BOOK.a(new EnchantmentInstance((Enchantment)object, n2));
                int n3 = 2 + this.random.nextInt(5 + n2 * 10) + 3 * n2;
                merchantRecipeList.add(new MerchantRecipe(new ItemStack(Item.BOOK), new ItemStack(Item.EMERALD, n3), itemStack));
                break;
            }
            case 2: {
                Object object;
                EntityVillager.b(merchantRecipeList, Item.EYE_OF_ENDER.id, this.random, this.p(0.3f));
                EntityVillager.b(merchantRecipeList, Item.EXP_BOTTLE.id, this.random, this.p(0.2f));
                EntityVillager.b(merchantRecipeList, Item.REDSTONE.id, this.random, this.p(0.4f));
                EntityVillager.b(merchantRecipeList, Block.GLOWSTONE.id, this.random, this.p(0.3f));
                for (Object object2 : object = (Object)new int[]{Item.IRON_SWORD.id, Item.DIAMOND_SWORD.id, Item.IRON_CHESTPLATE.id, Item.DIAMOND_CHESTPLATE.id, Item.IRON_AXE.id, Item.DIAMOND_AXE.id, Item.IRON_PICKAXE.id, Item.DIAMOND_PICKAXE.id}) {
                    if (!(this.random.nextFloat() < this.p(0.05f))) continue;
                    merchantRecipeList.add(new MerchantRecipe(new ItemStack((int)object2, 1, 0), new ItemStack(Item.EMERALD, 2 + this.random.nextInt(3), 0), EnchantmentManager.a(this.random, new ItemStack((int)object2, 1, 0), 5 + this.random.nextInt(15))));
                }
                break;
            }
        }
        if (merchantRecipeList.isEmpty()) {
            EntityVillager.a(merchantRecipeList, Item.GOLD_INGOT.id, this.random, 1.0f);
        }
        Collections.shuffle(merchantRecipeList);
        if (this.bu == null) {
            this.bu = new MerchantRecipeList();
        }
        for (int i = 0; i < n && i < merchantRecipeList.size(); ++i) {
            this.bu.a((MerchantRecipe)merchantRecipeList.get(i));
        }
    }

    private static void a(MerchantRecipeList merchantRecipeList, int n, Random random, float f) {
        if (random.nextFloat() < f) {
            merchantRecipeList.add(new MerchantRecipe(EntityVillager.a(n, random), Item.EMERALD));
        }
    }

    private static ItemStack a(int n, Random random) {
        return new ItemStack(n, EntityVillager.b(n, random), 0);
    }

    private static int b(int n, Random random) {
        Tuple tuple = (Tuple)bB.get(n);
        if (tuple == null) {
            return 1;
        }
        if ((Integer)tuple.a() >= (Integer)tuple.b()) {
            return (Integer)tuple.a();
        }
        return (Integer)tuple.a() + random.nextInt((Integer)tuple.b() - (Integer)tuple.a());
    }

    private static void b(MerchantRecipeList merchantRecipeList, int n, Random random, float f) {
        if (random.nextFloat() < f) {
            ItemStack itemStack;
            ItemStack itemStack2;
            int n2 = EntityVillager.c(n, random);
            if (n2 < 0) {
                itemStack2 = new ItemStack(Item.EMERALD.id, 1, 0);
                itemStack = new ItemStack(n, -n2, 0);
            } else {
                itemStack2 = new ItemStack(Item.EMERALD.id, n2, 0);
                itemStack = new ItemStack(n, 1, 0);
            }
            merchantRecipeList.add(new MerchantRecipe(itemStack2, itemStack));
        }
    }

    private static int c(int n, Random random) {
        Tuple tuple = (Tuple)bC.get(n);
        if (tuple == null) {
            return 1;
        }
        if ((Integer)tuple.a() >= (Integer)tuple.b()) {
            return (Integer)tuple.a();
        }
        return (Integer)tuple.a() + random.nextInt((Integer)tuple.b() - (Integer)tuple.a());
    }

    @Override
    public GroupDataEntity a(GroupDataEntity groupDataEntity) {
        groupDataEntity = super.a(groupDataEntity);
        this.setProfession(this.world.random.nextInt(5));
        return groupDataEntity;
    }

    public void bX() {
        this.bz = true;
    }

    public EntityVillager b(EntityAgeable entityAgeable) {
        EntityVillager entityVillager = new EntityVillager(this.world);
        entityVillager.a((GroupDataEntity)null);
        return entityVillager;
    }

    @Override
    public boolean bG() {
        return false;
    }

    @Override
    public /* synthetic */ EntityAgeable createChild(EntityAgeable entityAgeable) {
        return this.b(entityAgeable);
    }

    static {
        bB.put(Item.COAL.id, new Tuple(16, 24));
        bB.put(Item.IRON_INGOT.id, new Tuple(8, 10));
        bB.put(Item.GOLD_INGOT.id, new Tuple(8, 10));
        bB.put(Item.DIAMOND.id, new Tuple(4, 6));
        bB.put(Item.PAPER.id, new Tuple(24, 36));
        bB.put(Item.BOOK.id, new Tuple(11, 13));
        bB.put(Item.WRITTEN_BOOK.id, new Tuple(1, 1));
        bB.put(Item.ENDER_PEARL.id, new Tuple(3, 4));
        bB.put(Item.EYE_OF_ENDER.id, new Tuple(2, 3));
        bB.put(Item.PORK.id, new Tuple(14, 18));
        bB.put(Item.RAW_BEEF.id, new Tuple(14, 18));
        bB.put(Item.RAW_CHICKEN.id, new Tuple(14, 18));
        bB.put(Item.COOKED_FISH.id, new Tuple(9, 13));
        bB.put(Item.SEEDS.id, new Tuple(34, 48));
        bB.put(Item.MELON_SEEDS.id, new Tuple(30, 38));
        bB.put(Item.PUMPKIN_SEEDS.id, new Tuple(30, 38));
        bB.put(Item.WHEAT.id, new Tuple(18, 22));
        bB.put(Block.WOOL.id, new Tuple(14, 22));
        bB.put(Item.ROTTEN_FLESH.id, new Tuple(36, 64));
        bC.put(Item.FLINT_AND_STEEL.id, new Tuple(3, 4));
        bC.put(Item.SHEARS.id, new Tuple(3, 4));
        bC.put(Item.IRON_SWORD.id, new Tuple(7, 11));
        bC.put(Item.DIAMOND_SWORD.id, new Tuple(12, 14));
        bC.put(Item.IRON_AXE.id, new Tuple(6, 8));
        bC.put(Item.DIAMOND_AXE.id, new Tuple(9, 12));
        bC.put(Item.IRON_PICKAXE.id, new Tuple(7, 9));
        bC.put(Item.DIAMOND_PICKAXE.id, new Tuple(10, 12));
        bC.put(Item.IRON_SPADE.id, new Tuple(4, 6));
        bC.put(Item.DIAMOND_SPADE.id, new Tuple(7, 8));
        bC.put(Item.IRON_HOE.id, new Tuple(4, 6));
        bC.put(Item.DIAMOND_HOE.id, new Tuple(7, 8));
        bC.put(Item.IRON_BOOTS.id, new Tuple(4, 6));
        bC.put(Item.DIAMOND_BOOTS.id, new Tuple(7, 8));
        bC.put(Item.IRON_HELMET.id, new Tuple(4, 6));
        bC.put(Item.DIAMOND_HELMET.id, new Tuple(7, 8));
        bC.put(Item.IRON_CHESTPLATE.id, new Tuple(10, 14));
        bC.put(Item.DIAMOND_CHESTPLATE.id, new Tuple(16, 19));
        bC.put(Item.IRON_LEGGINGS.id, new Tuple(8, 10));
        bC.put(Item.DIAMOND_LEGGINGS.id, new Tuple(11, 14));
        bC.put(Item.CHAINMAIL_BOOTS.id, new Tuple(5, 7));
        bC.put(Item.CHAINMAIL_HELMET.id, new Tuple(5, 7));
        bC.put(Item.CHAINMAIL_CHESTPLATE.id, new Tuple(11, 15));
        bC.put(Item.CHAINMAIL_LEGGINGS.id, new Tuple(9, 11));
        bC.put(Item.BREAD.id, new Tuple(-4, -2));
        bC.put(Item.MELON.id, new Tuple(-8, -4));
        bC.put(Item.APPLE.id, new Tuple(-8, -4));
        bC.put(Item.COOKIE.id, new Tuple(-10, -7));
        bC.put(Block.GLASS.id, new Tuple(-5, -3));
        bC.put(Block.BOOKSHELF.id, new Tuple(3, 4));
        bC.put(Item.LEATHER_CHESTPLATE.id, new Tuple(4, 5));
        bC.put(Item.LEATHER_BOOTS.id, new Tuple(2, 4));
        bC.put(Item.LEATHER_HELMET.id, new Tuple(2, 4));
        bC.put(Item.LEATHER_LEGGINGS.id, new Tuple(2, 4));
        bC.put(Item.SADDLE.id, new Tuple(6, 8));
        bC.put(Item.EXP_BOTTLE.id, new Tuple(-4, -1));
        bC.put(Item.REDSTONE.id, new Tuple(-4, -1));
        bC.put(Item.COMPASS.id, new Tuple(10, 12));
        bC.put(Item.WATCH.id, new Tuple(10, 12));
        bC.put(Block.GLOWSTONE.id, new Tuple(-3, -1));
        bC.put(Item.GRILLED_PORK.id, new Tuple(-7, -5));
        bC.put(Item.COOKED_BEEF.id, new Tuple(-7, -5));
        bC.put(Item.COOKED_CHICKEN.id, new Tuple(-8, -6));
        bC.put(Item.EYE_OF_ENDER.id, new Tuple(7, 11));
        bC.put(Item.ARROW.id, new Tuple(-12, -8));
    }
}

