/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.server.AttributeMapServer;
import net.minecraft.server.DataWatcher;
import net.minecraft.server.Entity;
import net.minecraft.server.EntityArrow;
import net.minecraft.server.EntityBoat;
import net.minecraft.server.EntityEgg;
import net.minecraft.server.EntityEnderCrystal;
import net.minecraft.server.EntityEnderDragon;
import net.minecraft.server.EntityEnderPearl;
import net.minecraft.server.EntityEnderSignal;
import net.minecraft.server.EntityExperienceOrb;
import net.minecraft.server.EntityFallingBlock;
import net.minecraft.server.EntityFireball;
import net.minecraft.server.EntityFireworks;
import net.minecraft.server.EntityFishingHook;
import net.minecraft.server.EntityHuman;
import net.minecraft.server.EntityInsentient;
import net.minecraft.server.EntityItem;
import net.minecraft.server.EntityItemFrame;
import net.minecraft.server.EntityLeash;
import net.minecraft.server.EntityLiving;
import net.minecraft.server.EntityMinecartAbstract;
import net.minecraft.server.EntityPainting;
import net.minecraft.server.EntityPlayer;
import net.minecraft.server.EntityPotion;
import net.minecraft.server.EntitySmallFireball;
import net.minecraft.server.EntitySnowball;
import net.minecraft.server.EntityTNTPrimed;
import net.minecraft.server.EntityThrownExpBottle;
import net.minecraft.server.EntityWitherSkull;
import net.minecraft.server.IAnimal;
import net.minecraft.server.Item;
import net.minecraft.server.ItemStack;
import net.minecraft.server.ItemWorldMap;
import net.minecraft.server.MathHelper;
import net.minecraft.server.MobEffect;
import net.minecraft.server.Packet;
import net.minecraft.server.Packet17EntityLocationAction;
import net.minecraft.server.Packet20NamedEntitySpawn;
import net.minecraft.server.Packet23VehicleSpawn;
import net.minecraft.server.Packet24MobSpawn;
import net.minecraft.server.Packet25EntityPainting;
import net.minecraft.server.Packet26AddExpOrb;
import net.minecraft.server.Packet28EntityVelocity;
import net.minecraft.server.Packet31RelEntityMove;
import net.minecraft.server.Packet32EntityLook;
import net.minecraft.server.Packet33RelEntityMoveLook;
import net.minecraft.server.Packet34EntityTeleport;
import net.minecraft.server.Packet35EntityHeadRotation;
import net.minecraft.server.Packet39AttachEntity;
import net.minecraft.server.Packet40EntityMetadata;
import net.minecraft.server.Packet41MobEffect;
import net.minecraft.server.Packet44UpdateAttributes;
import net.minecraft.server.Packet5EntityEquipment;
import net.minecraft.server.WorldMap;

public class EntityTrackerEntry {
    public Entity tracker;
    public int b;
    public int c;
    public int xLoc;
    public int yLoc;
    public int zLoc;
    public int yRot;
    public int xRot;
    public int i;
    public double j;
    public double k;
    public double l;
    public int m;
    private double p;
    private double q;
    private double r;
    private boolean s;
    private boolean isMoving;
    private int u;
    private Entity v;
    private boolean w;
    public boolean n;
    public Set trackedPlayers = new HashSet();

    public EntityTrackerEntry(Entity entity, int n, int n2, boolean bl) {
        this.tracker = entity;
        this.b = n;
        this.c = n2;
        this.isMoving = bl;
        this.xLoc = MathHelper.floor(entity.locX * 32.0);
        this.yLoc = MathHelper.floor(entity.locY * 32.0);
        this.zLoc = MathHelper.floor(entity.locZ * 32.0);
        this.yRot = MathHelper.d(entity.yaw * 256.0f / 360.0f);
        this.xRot = MathHelper.d(entity.pitch * 256.0f / 360.0f);
        this.i = MathHelper.d(entity.getHeadRotation() * 256.0f / 360.0f);
    }

    public boolean equals(Object object) {
        if (object instanceof EntityTrackerEntry) {
            return ((EntityTrackerEntry)object).tracker.id == this.tracker.id;
        }
        return false;
    }

    public int hashCode() {
        return this.tracker.id;
    }

    public void track(List list) {
        this.n = false;
        if (!this.s || this.tracker.e(this.p, this.q, this.r) > 16.0) {
            this.p = this.tracker.locX;
            this.q = this.tracker.locY;
            this.r = this.tracker.locZ;
            this.s = true;
            this.n = true;
            this.scanPlayers(list);
        }
        if (this.v != this.tracker.vehicle || this.tracker.vehicle != null && this.m % 60 == 0) {
            this.v = this.tracker.vehicle;
            this.broadcast(new Packet39AttachEntity(0, this.tracker, this.tracker.vehicle));
        }
        if (this.tracker instanceof EntityItemFrame && this.m % 10 == 0) {
            EntityItemFrame entityItemFrame = (EntityItemFrame)this.tracker;
            ItemStack itemStack = entityItemFrame.getItem();
            if (itemStack != null && itemStack.getItem() instanceof ItemWorldMap) {
                WorldMap worldMap = Item.MAP.getSavedMap(itemStack, this.tracker.world);
                for (EntityHuman entityHuman : list) {
                    Packet packet;
                    EntityPlayer entityPlayer = (EntityPlayer)entityHuman;
                    worldMap.a(entityPlayer, itemStack);
                    if (entityPlayer.playerConnection.lowPriorityCount() > 5 || (packet = Item.MAP.c(itemStack, this.tracker.world, entityPlayer)) == null) continue;
                    entityPlayer.playerConnection.sendPacket(packet);
                }
            }
            this.b();
        } else if (this.m % this.c == 0 || this.tracker.an || this.tracker.getDataWatcher().a()) {
            int n;
            if (this.tracker.vehicle == null) {
                double d;
                double d2;
                double d3;
                double d4;
                double d5;
                boolean bl;
                ++this.u;
                n = this.tracker.at.a(this.tracker.locX);
                int n2 = MathHelper.floor(this.tracker.locY * 32.0);
                int n3 = this.tracker.at.a(this.tracker.locZ);
                int n4 = MathHelper.d(this.tracker.yaw * 256.0f / 360.0f);
                int n5 = MathHelper.d(this.tracker.pitch * 256.0f / 360.0f);
                int n6 = n - this.xLoc;
                int n7 = n2 - this.yLoc;
                int n8 = n3 - this.zLoc;
                Packet packet = null;
                boolean bl2 = Math.abs(n6) >= 4 || Math.abs(n7) >= 4 || Math.abs(n8) >= 4 || this.m % 60 == 0;
                boolean bl3 = bl = Math.abs(n4 - this.yRot) >= 4 || Math.abs(n5 - this.xRot) >= 4;
                if (this.m > 0 || this.tracker instanceof EntityArrow) {
                    if (n6 < -128 || n6 >= 128 || n7 < -128 || n7 >= 128 || n8 < -128 || n8 >= 128 || this.u > 400 || this.w) {
                        this.u = 0;
                        packet = new Packet34EntityTeleport(this.tracker.id, n, n2, n3, (byte)n4, (byte)n5);
                    } else if (bl2 && bl) {
                        packet = new Packet33RelEntityMoveLook(this.tracker.id, (byte)n6, (byte)n7, (byte)n8, (byte)n4, (byte)n5);
                    } else if (bl2) {
                        packet = new Packet31RelEntityMove(this.tracker.id, (byte)n6, (byte)n7, (byte)n8);
                    } else if (bl) {
                        packet = new Packet32EntityLook(this.tracker.id, (byte)n4, (byte)n5);
                    }
                }
                if (this.isMoving && ((d5 = (d4 = this.tracker.motX - this.j) * d4 + (d3 = this.tracker.motY - this.k) * d3 + (d2 = this.tracker.motZ - this.l) * d2) > (d = 0.02) * d || d5 > 0.0 && this.tracker.motX == 0.0 && this.tracker.motY == 0.0 && this.tracker.motZ == 0.0)) {
                    this.j = this.tracker.motX;
                    this.k = this.tracker.motY;
                    this.l = this.tracker.motZ;
                    this.broadcast(new Packet28EntityVelocity(this.tracker.id, this.j, this.k, this.l));
                }
                if (packet != null) {
                    this.broadcast(packet);
                }
                this.b();
                if (bl2) {
                    this.xLoc = n;
                    this.yLoc = n2;
                    this.zLoc = n3;
                }
                if (bl) {
                    this.yRot = n4;
                    this.xRot = n5;
                }
                this.w = false;
            } else {
                boolean bl;
                n = MathHelper.d(this.tracker.yaw * 256.0f / 360.0f);
                int n9 = MathHelper.d(this.tracker.pitch * 256.0f / 360.0f);
                boolean bl4 = bl = Math.abs(n - this.yRot) >= 4 || Math.abs(n9 - this.xRot) >= 4;
                if (bl) {
                    this.broadcast(new Packet32EntityLook(this.tracker.id, (byte)n, (byte)n9));
                    this.yRot = n;
                    this.xRot = n9;
                }
                this.xLoc = this.tracker.at.a(this.tracker.locX);
                this.yLoc = MathHelper.floor(this.tracker.locY * 32.0);
                this.zLoc = this.tracker.at.a(this.tracker.locZ);
                this.b();
                this.w = true;
            }
            n = MathHelper.d(this.tracker.getHeadRotation() * 256.0f / 360.0f);
            if (Math.abs(n - this.i) >= 4) {
                this.broadcast(new Packet35EntityHeadRotation(this.tracker.id, (byte)n));
                this.i = n;
            }
            this.tracker.an = false;
        }
        ++this.m;
        if (this.tracker.velocityChanged) {
            this.broadcastIncludingSelf(new Packet28EntityVelocity(this.tracker));
            this.tracker.velocityChanged = false;
        }
    }

    private void b() {
        DataWatcher dataWatcher = this.tracker.getDataWatcher();
        if (dataWatcher.a()) {
            this.broadcastIncludingSelf(new Packet40EntityMetadata(this.tracker.id, dataWatcher, false));
        }
        if (this.tracker instanceof EntityLiving) {
            AttributeMapServer attributeMapServer = (AttributeMapServer)((EntityLiving)this.tracker).aX();
            Set set = attributeMapServer.b();
            if (!set.isEmpty()) {
                this.broadcastIncludingSelf(new Packet44UpdateAttributes(this.tracker.id, set));
            }
            set.clear();
        }
    }

    public void broadcast(Packet packet) {
        for (EntityPlayer entityPlayer : this.trackedPlayers) {
            entityPlayer.playerConnection.sendPacket(packet);
        }
    }

    public void broadcastIncludingSelf(Packet packet) {
        this.broadcast(packet);
        if (this.tracker instanceof EntityPlayer) {
            ((EntityPlayer)this.tracker).playerConnection.sendPacket(packet);
        }
    }

    public void a() {
        for (EntityPlayer entityPlayer : this.trackedPlayers) {
            entityPlayer.removeQueue.add(this.tracker.id);
        }
    }

    public void a(EntityPlayer entityPlayer) {
        if (this.trackedPlayers.contains(entityPlayer)) {
            entityPlayer.removeQueue.add(this.tracker.id);
            this.trackedPlayers.remove(entityPlayer);
        }
    }

    public void updatePlayer(EntityPlayer entityPlayer) {
        if (entityPlayer == this.tracker) {
            return;
        }
        double d = entityPlayer.locX - (double)(this.xLoc / 32);
        double d2 = entityPlayer.locZ - (double)(this.zLoc / 32);
        if (d >= (double)(-this.b) && d <= (double)this.b && d2 >= (double)(-this.b) && d2 <= (double)this.b) {
            if (!this.trackedPlayers.contains(entityPlayer) && (this.d(entityPlayer) || this.tracker.p)) {
                Object object;
                Object object2;
                this.trackedPlayers.add(entityPlayer);
                Packet packet = this.c();
                entityPlayer.playerConnection.sendPacket(packet);
                if (!this.tracker.getDataWatcher().d()) {
                    entityPlayer.playerConnection.sendPacket(new Packet40EntityMetadata(this.tracker.id, this.tracker.getDataWatcher(), true));
                }
                if (this.tracker instanceof EntityLiving && !(object2 = ((AttributeMapServer)(object = (AttributeMapServer)((EntityLiving)this.tracker).aX())).c()).isEmpty()) {
                    entityPlayer.playerConnection.sendPacket(new Packet44UpdateAttributes(this.tracker.id, (Collection)object2));
                }
                this.j = this.tracker.motX;
                this.k = this.tracker.motY;
                this.l = this.tracker.motZ;
                if (this.isMoving && !(packet instanceof Packet24MobSpawn)) {
                    entityPlayer.playerConnection.sendPacket(new Packet28EntityVelocity(this.tracker.id, this.tracker.motX, this.tracker.motY, this.tracker.motZ));
                }
                if (this.tracker.vehicle != null) {
                    entityPlayer.playerConnection.sendPacket(new Packet39AttachEntity(0, this.tracker, this.tracker.vehicle));
                }
                if (this.tracker instanceof EntityInsentient && ((EntityInsentient)this.tracker).getLeashHolder() != null) {
                    entityPlayer.playerConnection.sendPacket(new Packet39AttachEntity(1, this.tracker, ((EntityInsentient)this.tracker).getLeashHolder()));
                }
                if (this.tracker instanceof EntityLiving) {
                    for (int i = 0; i < 5; ++i) {
                        object2 = ((EntityLiving)this.tracker).getEquipment(i);
                        if (object2 == null) continue;
                        entityPlayer.playerConnection.sendPacket(new Packet5EntityEquipment(this.tracker.id, i, (ItemStack)object2));
                    }
                }
                if (this.tracker instanceof EntityHuman && ((EntityHuman)(object = (EntityHuman)this.tracker)).isSleeping()) {
                    entityPlayer.playerConnection.sendPacket(new Packet17EntityLocationAction(this.tracker, 0, MathHelper.floor(this.tracker.locX), MathHelper.floor(this.tracker.locY), MathHelper.floor(this.tracker.locZ)));
                }
                if (this.tracker instanceof EntityLiving) {
                    object = (EntityLiving)this.tracker;
                    for (MobEffect mobEffect : ((EntityLiving)object).getEffects()) {
                        entityPlayer.playerConnection.sendPacket(new Packet41MobEffect(this.tracker.id, mobEffect));
                    }
                }
            }
        } else if (this.trackedPlayers.contains(entityPlayer)) {
            this.trackedPlayers.remove(entityPlayer);
            entityPlayer.removeQueue.add(this.tracker.id);
        }
    }

    private boolean d(EntityPlayer entityPlayer) {
        return entityPlayer.p().getPlayerChunkMap().a(entityPlayer, this.tracker.aj, this.tracker.al);
    }

    public void scanPlayers(List list) {
        for (int i = 0; i < list.size(); ++i) {
            this.updatePlayer((EntityPlayer)list.get(i));
        }
    }

    private Packet c() {
        if (this.tracker.dead) {
            this.tracker.world.getLogger().warning("Fetching addPacket for removed entity");
        }
        if (this.tracker instanceof EntityItem) {
            return new Packet23VehicleSpawn(this.tracker, 2, 1);
        }
        if (this.tracker instanceof EntityPlayer) {
            return new Packet20NamedEntitySpawn((EntityHuman)this.tracker);
        }
        if (this.tracker instanceof EntityMinecartAbstract) {
            EntityMinecartAbstract entityMinecartAbstract = (EntityMinecartAbstract)this.tracker;
            return new Packet23VehicleSpawn(this.tracker, 10, entityMinecartAbstract.getType());
        }
        if (this.tracker instanceof EntityBoat) {
            return new Packet23VehicleSpawn(this.tracker, 1);
        }
        if (this.tracker instanceof IAnimal || this.tracker instanceof EntityEnderDragon) {
            this.i = MathHelper.d(this.tracker.getHeadRotation() * 256.0f / 360.0f);
            return new Packet24MobSpawn((EntityLiving)this.tracker);
        }
        if (this.tracker instanceof EntityFishingHook) {
            EntityHuman entityHuman = ((EntityFishingHook)this.tracker).owner;
            return new Packet23VehicleSpawn(this.tracker, 90, entityHuman != null ? entityHuman.id : this.tracker.id);
        }
        if (this.tracker instanceof EntityArrow) {
            Entity entity = ((EntityArrow)this.tracker).shooter;
            return new Packet23VehicleSpawn(this.tracker, 60, entity != null ? entity.id : this.tracker.id);
        }
        if (this.tracker instanceof EntitySnowball) {
            return new Packet23VehicleSpawn(this.tracker, 61);
        }
        if (this.tracker instanceof EntityPotion) {
            return new Packet23VehicleSpawn(this.tracker, 73, ((EntityPotion)this.tracker).getPotionValue());
        }
        if (this.tracker instanceof EntityThrownExpBottle) {
            return new Packet23VehicleSpawn(this.tracker, 75);
        }
        if (this.tracker instanceof EntityEnderPearl) {
            return new Packet23VehicleSpawn(this.tracker, 65);
        }
        if (this.tracker instanceof EntityEnderSignal) {
            return new Packet23VehicleSpawn(this.tracker, 72);
        }
        if (this.tracker instanceof EntityFireworks) {
            return new Packet23VehicleSpawn(this.tracker, 76);
        }
        if (this.tracker instanceof EntityFireball) {
            EntityFireball entityFireball = (EntityFireball)this.tracker;
            Packet23VehicleSpawn packet23VehicleSpawn = null;
            int n = 63;
            if (this.tracker instanceof EntitySmallFireball) {
                n = 64;
            } else if (this.tracker instanceof EntityWitherSkull) {
                n = 66;
            }
            packet23VehicleSpawn = entityFireball.shooter != null ? new Packet23VehicleSpawn(this.tracker, n, ((EntityFireball)this.tracker).shooter.id) : new Packet23VehicleSpawn(this.tracker, n, 0);
            packet23VehicleSpawn.e = (int)(entityFireball.dirX * 8000.0);
            packet23VehicleSpawn.f = (int)(entityFireball.dirY * 8000.0);
            packet23VehicleSpawn.g = (int)(entityFireball.dirZ * 8000.0);
            return packet23VehicleSpawn;
        }
        if (this.tracker instanceof EntityEgg) {
            return new Packet23VehicleSpawn(this.tracker, 62);
        }
        if (this.tracker instanceof EntityTNTPrimed) {
            return new Packet23VehicleSpawn(this.tracker, 50);
        }
        if (this.tracker instanceof EntityEnderCrystal) {
            return new Packet23VehicleSpawn(this.tracker, 51);
        }
        if (this.tracker instanceof EntityFallingBlock) {
            EntityFallingBlock entityFallingBlock = (EntityFallingBlock)this.tracker;
            return new Packet23VehicleSpawn(this.tracker, 70, entityFallingBlock.id | entityFallingBlock.data << 16);
        }
        if (this.tracker instanceof EntityPainting) {
            return new Packet25EntityPainting((EntityPainting)this.tracker);
        }
        if (this.tracker instanceof EntityItemFrame) {
            EntityItemFrame entityItemFrame = (EntityItemFrame)this.tracker;
            Packet23VehicleSpawn packet23VehicleSpawn = new Packet23VehicleSpawn(this.tracker, 71, entityItemFrame.direction);
            packet23VehicleSpawn.b = MathHelper.d(entityItemFrame.x * 32);
            packet23VehicleSpawn.c = MathHelper.d(entityItemFrame.y * 32);
            packet23VehicleSpawn.d = MathHelper.d(entityItemFrame.z * 32);
            return packet23VehicleSpawn;
        }
        if (this.tracker instanceof EntityLeash) {
            EntityLeash entityLeash = (EntityLeash)this.tracker;
            Packet23VehicleSpawn packet23VehicleSpawn = new Packet23VehicleSpawn(this.tracker, 77);
            packet23VehicleSpawn.b = MathHelper.d(entityLeash.x * 32);
            packet23VehicleSpawn.c = MathHelper.d(entityLeash.y * 32);
            packet23VehicleSpawn.d = MathHelper.d(entityLeash.z * 32);
            return packet23VehicleSpawn;
        }
        if (this.tracker instanceof EntityExperienceOrb) {
            return new Packet26AddExpOrb((EntityExperienceOrb)this.tracker);
        }
        throw new IllegalArgumentException("Don't know how to add " + this.tracker.getClass() + "!");
    }

    public void clear(EntityPlayer entityPlayer) {
        if (this.trackedPlayers.contains(entityPlayer)) {
            this.trackedPlayers.remove(entityPlayer);
            entityPlayer.removeQueue.add(this.tracker.id);
        }
    }
}

