/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import net.minecraft.server.Entity;
import net.minecraft.server.EntityAnimal;
import net.minecraft.server.EntityLiving;
import net.minecraft.server.EntityOwnable;
import net.minecraft.server.NBTTagCompound;
import net.minecraft.server.PathfinderGoalSit;
import net.minecraft.server.ScoreboardTeamBase;
import net.minecraft.server.World;

public abstract class EntityTameableAnimal
extends EntityAnimal
implements EntityOwnable {
    protected PathfinderGoalSit bp = new PathfinderGoalSit(this);

    public EntityTameableAnimal(World world) {
        super(world);
    }

    @Override
    protected void a() {
        super.a();
        this.datawatcher.a(16, (Object)0);
        this.datawatcher.a(17, "");
    }

    @Override
    public void b(NBTTagCompound nBTTagCompound) {
        super.b(nBTTagCompound);
        if (this.getOwnerName() == null) {
            nBTTagCompound.setString("Owner", "");
        } else {
            nBTTagCompound.setString("Owner", this.getOwnerName());
        }
        nBTTagCompound.setBoolean("Sitting", this.isSitting());
    }

    @Override
    public void a(NBTTagCompound nBTTagCompound) {
        super.a(nBTTagCompound);
        String string = nBTTagCompound.getString("Owner");
        if (string.length() > 0) {
            this.setOwnerName(string);
            this.setTamed(true);
        }
        this.bp.setSitting(nBTTagCompound.getBoolean("Sitting"));
        this.setSitting(nBTTagCompound.getBoolean("Sitting"));
    }

    protected void i(boolean bl) {
        String string = "heart";
        if (!bl) {
            string = "smoke";
        }
        for (int i = 0; i < 7; ++i) {
            double d = this.random.nextGaussian() * 0.02;
            double d2 = this.random.nextGaussian() * 0.02;
            double d3 = this.random.nextGaussian() * 0.02;
            this.world.addParticle(string, this.locX + (double)(this.random.nextFloat() * this.width * 2.0f) - (double)this.width, this.locY + 0.5 + (double)(this.random.nextFloat() * this.length), this.locZ + (double)(this.random.nextFloat() * this.width * 2.0f) - (double)this.width, d, d2, d3);
        }
    }

    public boolean isTamed() {
        return (this.datawatcher.getByte(16) & 4) != 0;
    }

    public void setTamed(boolean bl) {
        byte by = this.datawatcher.getByte(16);
        if (bl) {
            this.datawatcher.watch(16, (byte)(by | 4));
        } else {
            this.datawatcher.watch(16, (byte)(by & 0xFFFFFFFB));
        }
    }

    public boolean isSitting() {
        return (this.datawatcher.getByte(16) & 1) != 0;
    }

    public void setSitting(boolean bl) {
        byte by = this.datawatcher.getByte(16);
        if (bl) {
            this.datawatcher.watch(16, (byte)(by | 1));
        } else {
            this.datawatcher.watch(16, (byte)(by & 0xFFFFFFFE));
        }
    }

    @Override
    public String getOwnerName() {
        return this.datawatcher.getString(17);
    }

    public void setOwnerName(String string) {
        this.datawatcher.watch(17, string);
    }

    @Override
    public EntityLiving getOwner() {
        return this.world.a(this.getOwnerName());
    }

    public PathfinderGoalSit getGoalSit() {
        return this.bp;
    }

    public boolean a(EntityLiving entityLiving, EntityLiving entityLiving2) {
        return true;
    }

    @Override
    public ScoreboardTeamBase getScoreboardTeam() {
        EntityLiving entityLiving;
        if (this.isTamed() && (entityLiving = this.getOwner()) != null) {
            return entityLiving.getScoreboardTeam();
        }
        return super.getScoreboardTeam();
    }

    @Override
    public boolean c(EntityLiving entityLiving) {
        if (this.isTamed()) {
            EntityLiving entityLiving2 = this.getOwner();
            if (entityLiving == entityLiving2) {
                return true;
            }
            if (entityLiving2 != null) {
                return entityLiving2.c(entityLiving);
            }
        }
        return super.c(entityLiving);
    }

    @Override
    public /* synthetic */ Entity getOwner() {
        return this.getOwner();
    }
}

