/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import net.minecraft.server.Entity;
import net.minecraft.server.EntityMonster;
import net.minecraft.server.EntitySkeleton;
import net.minecraft.server.EnumMonsterType;
import net.minecraft.server.GenericAttributes;
import net.minecraft.server.GroupDataEntity;
import net.minecraft.server.GroupDataSpider;
import net.minecraft.server.Item;
import net.minecraft.server.MathHelper;
import net.minecraft.server.MobEffect;
import net.minecraft.server.MobEffectList;
import net.minecraft.server.World;

public class EntitySpider
extends EntityMonster {
    public EntitySpider(World world) {
        super(world);
        this.a(1.4f, 0.9f);
    }

    @Override
    protected void a() {
        super.a();
        this.datawatcher.a(16, new Byte(0));
    }

    @Override
    public void l_() {
        super.l_();
        if (!this.world.isStatic) {
            this.a(this.positionChanged);
        }
    }

    @Override
    protected void az() {
        super.az();
        this.getAttributeInstance(GenericAttributes.a).setValue(16.0);
        this.getAttributeInstance(GenericAttributes.d).setValue(0.8f);
    }

    @Override
    protected Entity findTarget() {
        float f = this.d(1.0f);
        if (f < 0.5f) {
            double d = 16.0;
            return this.world.findNearbyVulnerablePlayer(this, d);
        }
        return null;
    }

    @Override
    protected String r() {
        return "mob.spider.say";
    }

    @Override
    protected String aO() {
        return "mob.spider.say";
    }

    @Override
    protected String aP() {
        return "mob.spider.death";
    }

    @Override
    protected void a(int n, int n2, int n3, int n4) {
        this.makeSound("mob.spider.step", 0.15f, 1.0f);
    }

    @Override
    protected void a(Entity entity, float f) {
        float f2 = this.d(1.0f);
        if (f2 > 0.5f && this.random.nextInt(100) == 0) {
            this.target = null;
            return;
        }
        if (f > 2.0f && f < 6.0f && this.random.nextInt(10) == 0) {
            if (this.onGround) {
                double d = entity.locX - this.locX;
                double d2 = entity.locZ - this.locZ;
                float f3 = MathHelper.sqrt(d * d + d2 * d2);
                this.motX = d / (double)f3 * 0.5 * (double)0.8f + this.motX * (double)0.2f;
                this.motZ = d2 / (double)f3 * 0.5 * (double)0.8f + this.motZ * (double)0.2f;
                this.motY = 0.4f;
            }
        } else {
            super.a(entity, f);
        }
    }

    @Override
    protected int getLootId() {
        return Item.STRING.id;
    }

    @Override
    protected void dropDeathLoot(boolean bl, int n) {
        super.dropDeathLoot(bl, n);
        if (bl && (this.random.nextInt(3) == 0 || this.random.nextInt(1 + n) > 0)) {
            this.b(Item.SPIDER_EYE.id, 1);
        }
    }

    @Override
    public boolean e() {
        return this.bT();
    }

    @Override
    public void am() {
    }

    @Override
    public EnumMonsterType getMonsterType() {
        return EnumMonsterType.ARTHROPOD;
    }

    @Override
    public boolean d(MobEffect mobEffect) {
        if (mobEffect.getEffectId() == MobEffectList.POISON.id) {
            return false;
        }
        return super.d(mobEffect);
    }

    public boolean bT() {
        return (this.datawatcher.getByte(16) & 1) != 0;
    }

    public void a(boolean bl) {
        byte by = this.datawatcher.getByte(16);
        by = bl ? (byte)(by | 1) : (byte)(by & 0xFFFFFFFE);
        this.datawatcher.watch(16, by);
    }

    @Override
    public GroupDataEntity a(GroupDataEntity groupDataEntity) {
        int n;
        groupDataEntity = super.a(groupDataEntity);
        if (this.world.random.nextInt(100) == 0) {
            EntitySkeleton entitySkeleton = new EntitySkeleton(this.world);
            entitySkeleton.setPositionRotation(this.locX, this.locY, this.locZ, this.yaw, 0.0f);
            entitySkeleton.a((GroupDataEntity)null);
            this.world.addEntity(entitySkeleton);
            entitySkeleton.mount(this);
        }
        if (groupDataEntity == null) {
            groupDataEntity = new GroupDataSpider();
            if (this.world.difficulty > 2 && this.world.random.nextFloat() < 0.1f * this.world.b(this.locX, this.locY, this.locZ)) {
                ((GroupDataSpider)groupDataEntity).a(this.world.random);
            }
        }
        if (groupDataEntity instanceof GroupDataSpider && (n = ((GroupDataSpider)groupDataEntity).a) > 0 && MobEffectList.byId[n] != null) {
            this.addEffect(new MobEffect(n, Integer.MAX_VALUE));
        }
        return groupDataEntity;
    }
}

