/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import net.minecraft.server.Block;
import net.minecraft.server.DamageSource;
import net.minecraft.server.EntityGolem;
import net.minecraft.server.EntityHuman;
import net.minecraft.server.EntityInsentient;
import net.minecraft.server.EntityLiving;
import net.minecraft.server.EntitySnowball;
import net.minecraft.server.GenericAttributes;
import net.minecraft.server.IMonster;
import net.minecraft.server.IRangedEntity;
import net.minecraft.server.Item;
import net.minecraft.server.MathHelper;
import net.minecraft.server.PathfinderGoalArrowAttack;
import net.minecraft.server.PathfinderGoalLookAtPlayer;
import net.minecraft.server.PathfinderGoalNearestAttackableTarget;
import net.minecraft.server.PathfinderGoalRandomLookaround;
import net.minecraft.server.PathfinderGoalRandomStroll;
import net.minecraft.server.World;

public class EntitySnowman
extends EntityGolem
implements IRangedEntity {
    public EntitySnowman(World world) {
        super(world);
        this.a(0.4f, 1.8f);
        this.getNavigation().a(true);
        this.goalSelector.a(1, new PathfinderGoalArrowAttack(this, 1.25, 20, 10.0f));
        this.goalSelector.a(2, new PathfinderGoalRandomStroll(this, 1.0));
        this.goalSelector.a(3, new PathfinderGoalLookAtPlayer(this, EntityHuman.class, 6.0f));
        this.goalSelector.a(4, new PathfinderGoalRandomLookaround(this));
        this.targetSelector.a(1, new PathfinderGoalNearestAttackableTarget(this, EntityInsentient.class, 0, true, false, IMonster.a));
    }

    @Override
    public boolean bf() {
        return true;
    }

    @Override
    protected void az() {
        super.az();
        this.getAttributeInstance(GenericAttributes.a).setValue(4.0);
        this.getAttributeInstance(GenericAttributes.d).setValue(0.2f);
    }

    @Override
    public void c() {
        int n;
        int n2;
        super.c();
        if (this.G()) {
            this.damageEntity(DamageSource.DROWN, 1.0f);
        }
        if (this.world.getBiome(n2 = MathHelper.floor(this.locX), n = MathHelper.floor(this.locZ)).j() > 1.0f) {
            this.damageEntity(DamageSource.BURN, 1.0f);
        }
        for (n2 = 0; n2 < 4; ++n2) {
            int n3;
            int n4;
            n = MathHelper.floor(this.locX + (double)((float)(n2 % 2 * 2 - 1) * 0.25f));
            if (this.world.getTypeId(n, n4 = MathHelper.floor(this.locY), n3 = MathHelper.floor(this.locZ + (double)((float)(n2 / 2 % 2 * 2 - 1) * 0.25f))) != 0 || !(this.world.getBiome(n, n3).j() < 0.8f) || !Block.SNOW.canPlace(this.world, n, n4, n3)) continue;
            this.world.setTypeIdUpdate(n, n4, n3, Block.SNOW.id);
        }
    }

    @Override
    protected int getLootId() {
        return Item.SNOW_BALL.id;
    }

    @Override
    protected void dropDeathLoot(boolean bl, int n) {
        int n2 = this.random.nextInt(16);
        for (int i = 0; i < n2; ++i) {
            this.b(Item.SNOW_BALL.id, 1);
        }
    }

    @Override
    public void a(EntityLiving entityLiving, float f) {
        EntitySnowball entitySnowball = new EntitySnowball(this.world, this);
        double d = entityLiving.locX - this.locX;
        double d2 = entityLiving.locY + (double)entityLiving.getHeadHeight() - (double)1.1f - entitySnowball.locY;
        double d3 = entityLiving.locZ - this.locZ;
        float f2 = MathHelper.sqrt(d * d + d3 * d3) * 0.2f;
        entitySnowball.shoot(d, d2 + (double)f2, d3, 1.6f, 12.0f);
        this.makeSound("random.bow", 1.0f, 1.0f / (this.aD().nextFloat() * 0.4f + 0.8f));
        this.world.addEntity(entitySnowball);
    }
}

