/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import net.minecraft.server.BiomeBase;
import net.minecraft.server.Chunk;
import net.minecraft.server.DamageSource;
import net.minecraft.server.EntityHuman;
import net.minecraft.server.EntityInsentient;
import net.minecraft.server.GenericAttributes;
import net.minecraft.server.IMonster;
import net.minecraft.server.Item;
import net.minecraft.server.MathHelper;
import net.minecraft.server.NBTTagCompound;
import net.minecraft.server.World;
import net.minecraft.server.WorldType;

public class EntitySlime
extends EntityInsentient
implements IMonster {
    public float h;
    public float i;
    public float j;
    private int jumpDelay;

    public EntitySlime(World world) {
        super(world);
        int n = 1 << this.random.nextInt(3);
        this.height = 0.0f;
        this.jumpDelay = this.random.nextInt(20) + 10;
        this.setSize(n);
    }

    @Override
    protected void a() {
        super.a();
        this.datawatcher.a(16, new Byte(1));
    }

    protected void setSize(int n) {
        this.datawatcher.watch(16, new Byte((byte)n));
        this.a(0.6f * (float)n, 0.6f * (float)n);
        this.setPosition(this.locX, this.locY, this.locZ);
        this.getAttributeInstance(GenericAttributes.a).setValue(n * n);
        this.setHealth(this.getMaxHealth());
        this.b = n;
    }

    public int getSize() {
        return this.datawatcher.getByte(16);
    }

    @Override
    public void b(NBTTagCompound nBTTagCompound) {
        super.b(nBTTagCompound);
        nBTTagCompound.setInt("Size", this.getSize() - 1);
    }

    @Override
    public void a(NBTTagCompound nBTTagCompound) {
        super.a(nBTTagCompound);
        this.setSize(nBTTagCompound.getInt("Size") + 1);
    }

    protected String bJ() {
        return "slime";
    }

    protected String bP() {
        return "mob.slime." + (this.getSize() > 1 ? "big" : "small");
    }

    @Override
    public void l_() {
        int n;
        if (!this.world.isStatic && this.world.difficulty == 0 && this.getSize() > 0) {
            this.dead = true;
        }
        this.i += (this.h - this.i) * 0.5f;
        this.j = this.i;
        boolean bl = this.onGround;
        super.l_();
        if (this.onGround && !bl) {
            n = this.getSize();
            for (int i = 0; i < n * 8; ++i) {
                float f = this.random.nextFloat() * (float)Math.PI * 2.0f;
                float f2 = this.random.nextFloat() * 0.5f + 0.5f;
                float f3 = MathHelper.sin(f) * (float)n * 0.5f * f2;
                float f4 = MathHelper.cos(f) * (float)n * 0.5f * f2;
                this.world.addParticle(this.bJ(), this.locX + (double)f3, this.boundingBox.b, this.locZ + (double)f4, 0.0, 0.0, 0.0);
            }
            if (this.bQ()) {
                this.makeSound(this.bP(), this.ba(), ((this.random.nextFloat() - this.random.nextFloat()) * 0.2f + 1.0f) / 0.8f);
            }
            this.h = -0.5f;
        } else if (!this.onGround && bl) {
            this.h = 1.0f;
        }
        this.bM();
        if (this.world.isStatic) {
            n = this.getSize();
            this.a(0.6f * (float)n, 0.6f * (float)n);
        }
    }

    @Override
    protected void bl() {
        this.u();
        EntityHuman entityHuman = this.world.findNearbyVulnerablePlayer(this, 16.0);
        if (entityHuman != null) {
            this.a(entityHuman, 10.0f, 20.0f);
        }
        if (this.onGround && this.jumpDelay-- <= 0) {
            this.jumpDelay = this.bL();
            if (entityHuman != null) {
                this.jumpDelay /= 3;
            }
            this.bd = true;
            if (this.bS()) {
                this.makeSound(this.bP(), this.ba(), ((this.random.nextFloat() - this.random.nextFloat()) * 0.2f + 1.0f) * 0.8f);
            }
            this.be = 1.0f - this.random.nextFloat() * 2.0f;
            this.bf = 1 * this.getSize();
        } else {
            this.bd = false;
            if (this.onGround) {
                this.bf = 0.0f;
                this.be = 0.0f;
            }
        }
    }

    protected void bM() {
        this.h *= 0.6f;
    }

    protected int bL() {
        return this.random.nextInt(20) + 10;
    }

    protected EntitySlime bK() {
        return new EntitySlime(this.world);
    }

    @Override
    public void die() {
        int n = this.getSize();
        if (!this.world.isStatic && n > 1 && this.getHealth() <= 0.0f) {
            int n2 = 2 + this.random.nextInt(3);
            for (int i = 0; i < n2; ++i) {
                float f = ((float)(i % 2) - 0.5f) * (float)n / 4.0f;
                float f2 = ((float)(i / 2) - 0.5f) * (float)n / 4.0f;
                EntitySlime entitySlime = this.bK();
                entitySlime.setSize(n / 2);
                entitySlime.setPositionRotation(this.locX + (double)f, this.locY + 0.5, this.locZ + (double)f2, this.random.nextFloat() * 360.0f, 0.0f);
                this.world.addEntity(entitySlime);
            }
        }
        super.die();
    }

    @Override
    public void b_(EntityHuman entityHuman) {
        if (this.bN()) {
            int n = this.getSize();
            if (this.o(entityHuman) && this.e(entityHuman) < 0.6 * (double)n * (0.6 * (double)n) && entityHuman.damageEntity(DamageSource.mobAttack(this), this.bO())) {
                this.makeSound("mob.attack", 1.0f, (this.random.nextFloat() - this.random.nextFloat()) * 0.2f + 1.0f);
            }
        }
    }

    protected boolean bN() {
        return this.getSize() > 1;
    }

    protected int bO() {
        return this.getSize();
    }

    @Override
    protected String aO() {
        return "mob.slime." + (this.getSize() > 1 ? "big" : "small");
    }

    @Override
    protected String aP() {
        return "mob.slime." + (this.getSize() > 1 ? "big" : "small");
    }

    @Override
    protected int getLootId() {
        if (this.getSize() == 1) {
            return Item.SLIME_BALL.id;
        }
        return 0;
    }

    @Override
    public boolean canSpawn() {
        Chunk chunk = this.world.getChunkAtWorldCoords(MathHelper.floor(this.locX), MathHelper.floor(this.locZ));
        if (this.world.getWorldData().getType() == WorldType.FLAT && this.random.nextInt(4) != 1) {
            return false;
        }
        if (this.getSize() == 1 || this.world.difficulty > 0) {
            BiomeBase biomeBase = this.world.getBiome(MathHelper.floor(this.locX), MathHelper.floor(this.locZ));
            if (biomeBase == BiomeBase.SWAMPLAND && this.locY > 50.0 && this.locY < 70.0 && this.random.nextFloat() < 0.5f && this.random.nextFloat() < this.world.x() && this.world.getLightLevel(MathHelper.floor(this.locX), MathHelper.floor(this.locY), MathHelper.floor(this.locZ)) <= this.random.nextInt(8)) {
                return super.canSpawn();
            }
            if (this.random.nextInt(10) == 0 && chunk.a(987234911L).nextInt(10) == 0 && this.locY < 40.0) {
                return super.canSpawn();
            }
        }
        return false;
    }

    @Override
    protected float ba() {
        return 0.4f * (float)this.getSize();
    }

    @Override
    public int bp() {
        return 0;
    }

    protected boolean bS() {
        return this.getSize() > 0;
    }

    protected boolean bQ() {
        return this.getSize() > 2;
    }
}

