/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import java.util.Calendar;
import net.minecraft.server.AchievementList;
import net.minecraft.server.Block;
import net.minecraft.server.DamageSource;
import net.minecraft.server.Enchantment;
import net.minecraft.server.EnchantmentManager;
import net.minecraft.server.Entity;
import net.minecraft.server.EntityArrow;
import net.minecraft.server.EntityCreature;
import net.minecraft.server.EntityHuman;
import net.minecraft.server.EntityLiving;
import net.minecraft.server.EntityMonster;
import net.minecraft.server.EnumMonsterType;
import net.minecraft.server.GenericAttributes;
import net.minecraft.server.GroupDataEntity;
import net.minecraft.server.IRangedEntity;
import net.minecraft.server.Item;
import net.minecraft.server.ItemStack;
import net.minecraft.server.MathHelper;
import net.minecraft.server.MobEffect;
import net.minecraft.server.MobEffectList;
import net.minecraft.server.NBTTagCompound;
import net.minecraft.server.PathfinderGoalArrowAttack;
import net.minecraft.server.PathfinderGoalFleeSun;
import net.minecraft.server.PathfinderGoalFloat;
import net.minecraft.server.PathfinderGoalHurtByTarget;
import net.minecraft.server.PathfinderGoalLookAtPlayer;
import net.minecraft.server.PathfinderGoalMeleeAttack;
import net.minecraft.server.PathfinderGoalNearestAttackableTarget;
import net.minecraft.server.PathfinderGoalRandomLookaround;
import net.minecraft.server.PathfinderGoalRandomStroll;
import net.minecraft.server.PathfinderGoalRestrictSun;
import net.minecraft.server.World;
import net.minecraft.server.WorldProviderHell;

public class EntitySkeleton
extends EntityMonster
implements IRangedEntity {
    private PathfinderGoalArrowAttack bp = new PathfinderGoalArrowAttack(this, 1.0, 20, 60, 15.0f);
    private PathfinderGoalMeleeAttack bq = new PathfinderGoalMeleeAttack(this, EntityHuman.class, 1.2, false);

    public EntitySkeleton(World world) {
        super(world);
        this.goalSelector.a(1, new PathfinderGoalFloat(this));
        this.goalSelector.a(2, new PathfinderGoalRestrictSun(this));
        this.goalSelector.a(3, new PathfinderGoalFleeSun(this, 1.0));
        this.goalSelector.a(5, new PathfinderGoalRandomStroll(this, 1.0));
        this.goalSelector.a(6, new PathfinderGoalLookAtPlayer(this, EntityHuman.class, 8.0f));
        this.goalSelector.a(6, new PathfinderGoalRandomLookaround(this));
        this.targetSelector.a(1, new PathfinderGoalHurtByTarget(this, false));
        this.targetSelector.a(2, new PathfinderGoalNearestAttackableTarget(this, EntityHuman.class, 0, true));
        if (world != null && !world.isStatic) {
            this.bT();
        }
    }

    @Override
    protected void az() {
        super.az();
        this.getAttributeInstance(GenericAttributes.d).setValue(0.25);
    }

    @Override
    protected void a() {
        super.a();
        this.datawatcher.a(13, new Byte(0));
    }

    @Override
    public boolean bf() {
        return true;
    }

    @Override
    protected String r() {
        return "mob.skeleton.say";
    }

    @Override
    protected String aO() {
        return "mob.skeleton.hurt";
    }

    @Override
    protected String aP() {
        return "mob.skeleton.death";
    }

    @Override
    protected void a(int n, int n2, int n3, int n4) {
        this.makeSound("mob.skeleton.step", 0.15f, 1.0f);
    }

    @Override
    public boolean m(Entity entity) {
        if (super.m(entity)) {
            if (this.getSkeletonType() == 1 && entity instanceof EntityLiving) {
                ((EntityLiving)entity).addEffect(new MobEffect(MobEffectList.WITHER.id, 200));
            }
            return true;
        }
        return false;
    }

    @Override
    public EnumMonsterType getMonsterType() {
        return EnumMonsterType.UNDEAD;
    }

    @Override
    public void c() {
        float f;
        if (this.world.v() && !this.world.isStatic && (f = this.d(1.0f)) > 0.5f && this.random.nextFloat() * 30.0f < (f - 0.4f) * 2.0f && this.world.l(MathHelper.floor(this.locX), MathHelper.floor(this.locY), MathHelper.floor(this.locZ))) {
            boolean bl = true;
            ItemStack itemStack = this.getEquipment(4);
            if (itemStack != null) {
                if (itemStack.g()) {
                    itemStack.setData(itemStack.j() + this.random.nextInt(2));
                    if (itemStack.j() >= itemStack.l()) {
                        this.a(itemStack);
                        this.setEquipment(4, null);
                    }
                }
                bl = false;
            }
            if (bl) {
                this.setOnFire(8);
            }
        }
        if (this.world.isStatic && this.getSkeletonType() == 1) {
            this.a(0.72f, 2.34f);
        }
        super.c();
    }

    @Override
    public void V() {
        super.V();
        if (this.vehicle instanceof EntityCreature) {
            EntityCreature entityCreature = (EntityCreature)this.vehicle;
            this.aN = entityCreature.aN;
        }
    }

    @Override
    public void die(DamageSource damageSource) {
        super.die(damageSource);
        if (damageSource.h() instanceof EntityArrow && damageSource.getEntity() instanceof EntityHuman) {
            EntityHuman entityHuman = (EntityHuman)damageSource.getEntity();
            double d = entityHuman.locX - this.locX;
            double d2 = entityHuman.locZ - this.locZ;
            if (d * d + d2 * d2 >= 2500.0) {
                entityHuman.a(AchievementList.v);
            }
        }
    }

    @Override
    protected int getLootId() {
        return Item.ARROW.id;
    }

    @Override
    protected void dropDeathLoot(boolean bl, int n) {
        int n2;
        int n3;
        if (this.getSkeletonType() == 1) {
            n3 = this.random.nextInt(3 + n) - 1;
            for (n2 = 0; n2 < n3; ++n2) {
                this.b(Item.COAL.id, 1);
            }
        } else {
            n3 = this.random.nextInt(3 + n);
            for (n2 = 0; n2 < n3; ++n2) {
                this.b(Item.ARROW.id, 1);
            }
        }
        n3 = this.random.nextInt(3 + n);
        for (n2 = 0; n2 < n3; ++n2) {
            this.b(Item.BONE.id, 1);
        }
    }

    @Override
    protected void l(int n) {
        if (this.getSkeletonType() == 1) {
            this.a(new ItemStack(Item.SKULL.id, 1, 1), 0.0f);
        }
    }

    @Override
    protected void bw() {
        super.bw();
        this.setEquipment(0, new ItemStack(Item.BOW));
    }

    @Override
    public GroupDataEntity a(GroupDataEntity groupDataEntity) {
        Calendar calendar;
        groupDataEntity = super.a(groupDataEntity);
        if (this.world.worldProvider instanceof WorldProviderHell && this.aD().nextInt(5) > 0) {
            this.goalSelector.a(4, this.bq);
            this.setSkeletonType(1);
            this.setEquipment(0, new ItemStack(Item.STONE_SWORD));
            this.getAttributeInstance(GenericAttributes.e).setValue(4.0);
        } else {
            this.goalSelector.a(4, this.bp);
            this.bw();
            this.bx();
        }
        this.h(this.random.nextFloat() < 0.55f * this.world.b(this.locX, this.locY, this.locZ));
        if (this.getEquipment(4) == null && (calendar = this.world.W()).get(2) + 1 == 10 && calendar.get(5) == 31 && this.random.nextFloat() < 0.25f) {
            this.setEquipment(4, new ItemStack(this.random.nextFloat() < 0.1f ? Block.JACK_O_LANTERN : Block.PUMPKIN));
            this.dropChances[4] = 0.0f;
        }
        return groupDataEntity;
    }

    public void bT() {
        this.goalSelector.a(this.bq);
        this.goalSelector.a(this.bp);
        ItemStack itemStack = this.aZ();
        if (itemStack != null && itemStack.id == Item.BOW.id) {
            this.goalSelector.a(4, this.bp);
        } else {
            this.goalSelector.a(4, this.bq);
        }
    }

    @Override
    public void a(EntityLiving entityLiving, float f) {
        EntityArrow entityArrow = new EntityArrow(this.world, this, entityLiving, 1.6f, 14 - this.world.difficulty * 4);
        int n = EnchantmentManager.getEnchantmentLevel(Enchantment.ARROW_DAMAGE.id, this.aZ());
        int n2 = EnchantmentManager.getEnchantmentLevel(Enchantment.ARROW_KNOCKBACK.id, this.aZ());
        entityArrow.b((double)(f * 2.0f) + (this.random.nextGaussian() * 0.25 + (double)((float)this.world.difficulty * 0.11f)));
        if (n > 0) {
            entityArrow.b(entityArrow.c() + (double)n * 0.5 + 0.5);
        }
        if (n2 > 0) {
            entityArrow.a(n2);
        }
        if (EnchantmentManager.getEnchantmentLevel(Enchantment.ARROW_FIRE.id, this.aZ()) > 0 || this.getSkeletonType() == 1) {
            entityArrow.setOnFire(100);
        }
        this.makeSound("random.bow", 1.0f, 1.0f / (this.aD().nextFloat() * 0.4f + 0.8f));
        this.world.addEntity(entityArrow);
    }

    public int getSkeletonType() {
        return this.datawatcher.getByte(13);
    }

    public void setSkeletonType(int n) {
        this.datawatcher.watch(13, (byte)n);
        boolean bl = this.fireProof = n == 1;
        if (n == 1) {
            this.a(0.72f, 2.34f);
        } else {
            this.a(0.6f, 1.8f);
        }
    }

    @Override
    public void a(NBTTagCompound nBTTagCompound) {
        super.a(nBTTagCompound);
        if (nBTTagCompound.hasKey("SkeletonType")) {
            byte by = nBTTagCompound.getByte("SkeletonType");
            this.setSkeletonType(by);
        }
        this.bT();
    }

    @Override
    public void b(NBTTagCompound nBTTagCompound) {
        super.b(nBTTagCompound);
        nBTTagCompound.setByte("SkeletonType", (byte)this.getSkeletonType());
    }

    @Override
    public void setEquipment(int n, ItemStack itemStack) {
        super.setEquipment(n, itemStack);
        if (!this.world.isStatic && n == 0) {
            this.bT();
        }
    }

    @Override
    public double X() {
        return super.X() - 0.5;
    }
}

