/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import net.minecraft.server.Block;
import net.minecraft.server.BlockMonsterEggs;
import net.minecraft.server.DamageSource;
import net.minecraft.server.Entity;
import net.minecraft.server.EntityDamageSource;
import net.minecraft.server.EntityHuman;
import net.minecraft.server.EntityMonster;
import net.minecraft.server.EnumMonsterType;
import net.minecraft.server.Facing;
import net.minecraft.server.GenericAttributes;
import net.minecraft.server.MathHelper;
import net.minecraft.server.World;

public class EntitySilverfish
extends EntityMonster {
    private int bp;

    public EntitySilverfish(World world) {
        super(world);
        this.a(0.3f, 0.7f);
    }

    @Override
    protected void az() {
        super.az();
        this.getAttributeInstance(GenericAttributes.a).setValue(8.0);
        this.getAttributeInstance(GenericAttributes.d).setValue(0.6f);
        this.getAttributeInstance(GenericAttributes.e).setValue(1.0);
    }

    @Override
    protected boolean e_() {
        return false;
    }

    @Override
    protected Entity findTarget() {
        double d = 8.0;
        return this.world.findNearbyVulnerablePlayer(this, d);
    }

    @Override
    protected String r() {
        return "mob.silverfish.say";
    }

    @Override
    protected String aO() {
        return "mob.silverfish.hit";
    }

    @Override
    protected String aP() {
        return "mob.silverfish.kill";
    }

    @Override
    public boolean damageEntity(DamageSource damageSource, float f) {
        if (this.isInvulnerable()) {
            return false;
        }
        if (this.bp <= 0 && (damageSource instanceof EntityDamageSource || damageSource == DamageSource.MAGIC)) {
            this.bp = 20;
        }
        return super.damageEntity(damageSource, f);
    }

    @Override
    protected void a(Entity entity, float f) {
        if (this.attackTicks <= 0 && f < 1.2f && entity.boundingBox.e > this.boundingBox.b && entity.boundingBox.b < this.boundingBox.e) {
            this.attackTicks = 20;
            this.m(entity);
        }
    }

    @Override
    protected void a(int n, int n2, int n3, int n4) {
        this.makeSound("mob.silverfish.step", 0.15f, 1.0f);
    }

    @Override
    protected int getLootId() {
        return 0;
    }

    @Override
    public void l_() {
        this.aN = this.yaw;
        super.l_();
    }

    @Override
    protected void bl() {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        super.bl();
        if (this.world.isStatic) {
            return;
        }
        if (this.bp > 0) {
            --this.bp;
            if (this.bp == 0) {
                n5 = MathHelper.floor(this.locX);
                n4 = MathHelper.floor(this.locY);
                n3 = MathHelper.floor(this.locZ);
                n2 = 0;
                n = 0;
                while (n2 == 0 && n <= 5 && n >= -5) {
                    int n6 = 0;
                    while (n2 == 0 && n6 <= 10 && n6 >= -10) {
                        int n7 = 0;
                        while (n2 == 0 && n7 <= 10 && n7 >= -10) {
                            int n8 = this.world.getTypeId(n5 + n6, n4 + n, n3 + n7);
                            if (n8 == Block.MONSTER_EGGS.id) {
                                if (!this.world.getGameRules().getBoolean("mobGriefing")) {
                                    int n9 = this.world.getData(n5 + n6, n4 + n, n3 + n7);
                                    Block block = Block.STONE;
                                    if (n9 == 1) {
                                        block = Block.COBBLESTONE;
                                    }
                                    if (n9 == 2) {
                                        block = Block.SMOOTH_BRICK;
                                    }
                                    this.world.setTypeIdAndData(n5 + n6, n4 + n, n3 + n7, block.id, 0, 3);
                                } else {
                                    this.world.setAir(n5 + n6, n4 + n, n3 + n7, false);
                                }
                                Block.MONSTER_EGGS.postBreak(this.world, n5 + n6, n4 + n, n3 + n7, 0);
                                if (this.random.nextBoolean()) {
                                    n2 = 1;
                                    break;
                                }
                            }
                            n7 = n7 <= 0 ? 1 - n7 : 0 - n7;
                        }
                        n6 = n6 <= 0 ? 1 - n6 : 0 - n6;
                    }
                    n = n <= 0 ? 1 - n : 0 - n;
                }
            }
        }
        if (this.target == null && !this.bM()) {
            n5 = MathHelper.floor(this.locX);
            n4 = MathHelper.floor(this.locY + 0.5);
            n3 = MathHelper.floor(this.locZ);
            n2 = this.random.nextInt(6);
            n = this.world.getTypeId(n5 + Facing.b[n2], n4 + Facing.c[n2], n3 + Facing.d[n2]);
            if (BlockMonsterEggs.d(n)) {
                this.world.setTypeIdAndData(n5 + Facing.b[n2], n4 + Facing.c[n2], n3 + Facing.d[n2], Block.MONSTER_EGGS.id, BlockMonsterEggs.e(n), 3);
                this.q();
                this.die();
            } else {
                this.bK();
            }
        } else if (this.target != null && !this.bM()) {
            this.target = null;
        }
    }

    @Override
    public float a(int n, int n2, int n3) {
        if (this.world.getTypeId(n, n2 - 1, n3) == Block.STONE.id) {
            return 10.0f;
        }
        return super.a(n, n2, n3);
    }

    @Override
    protected boolean i_() {
        return true;
    }

    @Override
    public boolean canSpawn() {
        if (super.canSpawn()) {
            EntityHuman entityHuman = this.world.findNearbyPlayer(this, 5.0);
            return entityHuman == null;
        }
        return false;
    }

    @Override
    public EnumMonsterType getMonsterType() {
        return EnumMonsterType.ARTHROPOD;
    }
}

