/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import java.util.Random;
import net.minecraft.server.Block;
import net.minecraft.server.ContainerSheepBreed;
import net.minecraft.server.CraftingManager;
import net.minecraft.server.EntityAgeable;
import net.minecraft.server.EntityAnimal;
import net.minecraft.server.EntityHuman;
import net.minecraft.server.EntityItem;
import net.minecraft.server.GenericAttributes;
import net.minecraft.server.GroupDataEntity;
import net.minecraft.server.InventoryCrafting;
import net.minecraft.server.Item;
import net.minecraft.server.ItemStack;
import net.minecraft.server.NBTTagCompound;
import net.minecraft.server.PathfinderGoalBreed;
import net.minecraft.server.PathfinderGoalEatTile;
import net.minecraft.server.PathfinderGoalFloat;
import net.minecraft.server.PathfinderGoalFollowParent;
import net.minecraft.server.PathfinderGoalLookAtPlayer;
import net.minecraft.server.PathfinderGoalPanic;
import net.minecraft.server.PathfinderGoalRandomLookaround;
import net.minecraft.server.PathfinderGoalRandomStroll;
import net.minecraft.server.PathfinderGoalTempt;
import net.minecraft.server.World;

public class EntitySheep
extends EntityAnimal {
    private final InventoryCrafting bq = new InventoryCrafting(new ContainerSheepBreed(this), 2, 1);
    public static final float[][] bp = new float[][]{{1.0f, 1.0f, 1.0f}, {0.85f, 0.5f, 0.2f}, {0.7f, 0.3f, 0.85f}, {0.4f, 0.6f, 0.85f}, {0.9f, 0.9f, 0.2f}, {0.5f, 0.8f, 0.1f}, {0.95f, 0.5f, 0.65f}, {0.3f, 0.3f, 0.3f}, {0.6f, 0.6f, 0.6f}, {0.3f, 0.5f, 0.6f}, {0.5f, 0.25f, 0.7f}, {0.2f, 0.3f, 0.7f}, {0.4f, 0.3f, 0.2f}, {0.4f, 0.5f, 0.2f}, {0.6f, 0.2f, 0.2f}, {0.1f, 0.1f, 0.1f}};
    private int br;
    private PathfinderGoalEatTile bs = new PathfinderGoalEatTile(this);

    public EntitySheep(World world) {
        super(world);
        this.a(0.9f, 1.3f);
        this.getNavigation().a(true);
        this.goalSelector.a(0, new PathfinderGoalFloat(this));
        this.goalSelector.a(1, new PathfinderGoalPanic(this, 1.25));
        this.goalSelector.a(2, new PathfinderGoalBreed(this, 1.0));
        this.goalSelector.a(3, new PathfinderGoalTempt(this, 1.1, Item.WHEAT.id, false));
        this.goalSelector.a(4, new PathfinderGoalFollowParent(this, 1.1));
        this.goalSelector.a(5, this.bs);
        this.goalSelector.a(6, new PathfinderGoalRandomStroll(this, 1.0));
        this.goalSelector.a(7, new PathfinderGoalLookAtPlayer(this, EntityHuman.class, 6.0f));
        this.goalSelector.a(8, new PathfinderGoalRandomLookaround(this));
        this.bq.setItem(0, new ItemStack(Item.INK_SACK, 1, 0));
        this.bq.setItem(1, new ItemStack(Item.INK_SACK, 1, 0));
    }

    @Override
    protected boolean bf() {
        return true;
    }

    @Override
    protected void bi() {
        this.br = this.bs.f();
        super.bi();
    }

    @Override
    public void c() {
        if (this.world.isStatic) {
            this.br = Math.max(0, this.br - 1);
        }
        super.c();
    }

    @Override
    protected void az() {
        super.az();
        this.getAttributeInstance(GenericAttributes.a).setValue(8.0);
        this.getAttributeInstance(GenericAttributes.d).setValue(0.23f);
    }

    @Override
    protected void a() {
        super.a();
        this.datawatcher.a(16, new Byte(0));
    }

    @Override
    protected void dropDeathLoot(boolean bl, int n) {
        if (!this.isSheared()) {
            this.a(new ItemStack(Block.WOOL.id, 1, this.getColor()), 0.0f);
        }
    }

    @Override
    protected int getLootId() {
        return Block.WOOL.id;
    }

    @Override
    public boolean a(EntityHuman entityHuman) {
        ItemStack itemStack = entityHuman.inventory.getItemInHand();
        if (itemStack != null && itemStack.id == Item.SHEARS.id && !this.isSheared() && !this.isBaby()) {
            if (!this.world.isStatic) {
                this.setSheared(true);
                int n = 1 + this.random.nextInt(3);
                for (int i = 0; i < n; ++i) {
                    EntityItem entityItem = this.a(new ItemStack(Block.WOOL.id, 1, this.getColor()), 1.0f);
                    entityItem.motY += (double)(this.random.nextFloat() * 0.05f);
                    entityItem.motX += (double)((this.random.nextFloat() - this.random.nextFloat()) * 0.1f);
                    entityItem.motZ += (double)((this.random.nextFloat() - this.random.nextFloat()) * 0.1f);
                }
            }
            itemStack.damage(1, entityHuman);
            this.makeSound("mob.sheep.shear", 1.0f, 1.0f);
        }
        return super.a(entityHuman);
    }

    @Override
    public void b(NBTTagCompound nBTTagCompound) {
        super.b(nBTTagCompound);
        nBTTagCompound.setBoolean("Sheared", this.isSheared());
        nBTTagCompound.setByte("Color", (byte)this.getColor());
    }

    @Override
    public void a(NBTTagCompound nBTTagCompound) {
        super.a(nBTTagCompound);
        this.setSheared(nBTTagCompound.getBoolean("Sheared"));
        this.setColor(nBTTagCompound.getByte("Color"));
    }

    @Override
    protected String r() {
        return "mob.sheep.say";
    }

    @Override
    protected String aO() {
        return "mob.sheep.say";
    }

    @Override
    protected String aP() {
        return "mob.sheep.say";
    }

    @Override
    protected void a(int n, int n2, int n3, int n4) {
        this.makeSound("mob.sheep.step", 0.15f, 1.0f);
    }

    public int getColor() {
        return this.datawatcher.getByte(16) & 0xF;
    }

    public void setColor(int n) {
        byte by = this.datawatcher.getByte(16);
        this.datawatcher.watch(16, (byte)(by & 0xF0 | n & 0xF));
    }

    public boolean isSheared() {
        return (this.datawatcher.getByte(16) & 0x10) != 0;
    }

    public void setSheared(boolean bl) {
        byte by = this.datawatcher.getByte(16);
        if (bl) {
            this.datawatcher.watch(16, (byte)(by | 0x10));
        } else {
            this.datawatcher.watch(16, (byte)(by & 0xFFFFFFEF));
        }
    }

    public static int a(Random random) {
        int n = random.nextInt(100);
        if (n < 5) {
            return 15;
        }
        if (n < 10) {
            return 7;
        }
        if (n < 15) {
            return 8;
        }
        if (n < 18) {
            return 12;
        }
        if (random.nextInt(500) == 0) {
            return 6;
        }
        return 0;
    }

    public EntitySheep b(EntityAgeable entityAgeable) {
        EntitySheep entitySheep = (EntitySheep)entityAgeable;
        EntitySheep entitySheep2 = new EntitySheep(this.world);
        int n = this.a(this, entitySheep);
        entitySheep2.setColor(15 - n);
        return entitySheep2;
    }

    @Override
    public void n() {
        this.setSheared(false);
        if (this.isBaby()) {
            this.a(60);
        }
    }

    @Override
    public GroupDataEntity a(GroupDataEntity groupDataEntity) {
        groupDataEntity = super.a(groupDataEntity);
        this.setColor(EntitySheep.a(this.world.random));
        return groupDataEntity;
    }

    private int a(EntityAnimal entityAnimal, EntityAnimal entityAnimal2) {
        int n = this.b(entityAnimal);
        int n2 = this.b(entityAnimal2);
        this.bq.getItem(0).setData(n);
        this.bq.getItem(1).setData(n2);
        ItemStack itemStack = CraftingManager.getInstance().craft(this.bq, ((EntitySheep)entityAnimal).world);
        int n3 = itemStack != null && itemStack.getItem().id == Item.INK_SACK.id ? itemStack.getData() : (this.world.random.nextBoolean() ? n : n2);
        return n3;
    }

    private int b(EntityAnimal entityAnimal) {
        return 15 - ((EntitySheep)entityAnimal).getColor();
    }

    @Override
    public /* synthetic */ EntityAgeable createChild(EntityAgeable entityAgeable) {
        return this.b(entityAgeable);
    }
}

