/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import java.util.List;
import net.minecraft.server.AxisAlignedBB;
import net.minecraft.server.Block;
import net.minecraft.server.Entity;
import net.minecraft.server.EntityHuman;
import net.minecraft.server.EntityLiving;
import net.minecraft.server.EnumMovingObjectType;
import net.minecraft.server.IProjectile;
import net.minecraft.server.MathHelper;
import net.minecraft.server.MovingObjectPosition;
import net.minecraft.server.NBTTagCompound;
import net.minecraft.server.Vec3D;
import net.minecraft.server.World;

public abstract class EntityProjectile
extends Entity
implements IProjectile {
    private int blockX = -1;
    private int blockY = -1;
    private int blockZ = -1;
    private int inBlockId;
    protected boolean inGround;
    public int shake;
    private EntityLiving shooter;
    private String shooterName;
    private int i;
    private int j;

    public EntityProjectile(World world) {
        super(world);
        this.a(0.25f, 0.25f);
    }

    @Override
    protected void a() {
    }

    public EntityProjectile(World world, EntityLiving entityLiving) {
        super(world);
        this.shooter = entityLiving;
        this.a(0.25f, 0.25f);
        this.setPositionRotation(entityLiving.locX, entityLiving.locY + (double)entityLiving.getHeadHeight(), entityLiving.locZ, entityLiving.yaw, entityLiving.pitch);
        this.locX -= (double)(MathHelper.cos(this.yaw / 180.0f * (float)Math.PI) * 0.16f);
        this.locY -= (double)0.1f;
        this.locZ -= (double)(MathHelper.sin(this.yaw / 180.0f * (float)Math.PI) * 0.16f);
        this.setPosition(this.locX, this.locY, this.locZ);
        this.height = 0.0f;
        float f = 0.4f;
        this.motX = -MathHelper.sin(this.yaw / 180.0f * (float)Math.PI) * MathHelper.cos(this.pitch / 180.0f * (float)Math.PI) * f;
        this.motZ = MathHelper.cos(this.yaw / 180.0f * (float)Math.PI) * MathHelper.cos(this.pitch / 180.0f * (float)Math.PI) * f;
        this.motY = -MathHelper.sin((this.pitch + this.d()) / 180.0f * (float)Math.PI) * f;
        this.shoot(this.motX, this.motY, this.motZ, this.c(), 1.0f);
    }

    public EntityProjectile(World world, double d, double d2, double d3) {
        super(world);
        this.i = 0;
        this.a(0.25f, 0.25f);
        this.setPosition(d, d2, d3);
        this.height = 0.0f;
    }

    protected float c() {
        return 1.5f;
    }

    protected float d() {
        return 0.0f;
    }

    @Override
    public void shoot(double d, double d2, double d3, float f, float f2) {
        float f3 = MathHelper.sqrt(d * d + d2 * d2 + d3 * d3);
        d /= (double)f3;
        d2 /= (double)f3;
        d3 /= (double)f3;
        d += this.random.nextGaussian() * (double)0.0075f * (double)f2;
        d2 += this.random.nextGaussian() * (double)0.0075f * (double)f2;
        d3 += this.random.nextGaussian() * (double)0.0075f * (double)f2;
        this.motX = d *= (double)f;
        this.motY = d2 *= (double)f;
        this.motZ = d3 *= (double)f;
        float f4 = MathHelper.sqrt(d * d + d3 * d3);
        this.lastYaw = this.yaw = (float)(Math.atan2(d, d3) * 180.0 / 3.1415927410125732);
        this.lastPitch = this.pitch = (float)(Math.atan2(d2, f4) * 180.0 / 3.1415927410125732);
        this.i = 0;
    }

    @Override
    public void l_() {
        this.U = this.locX;
        this.V = this.locY;
        this.W = this.locZ;
        super.l_();
        if (this.shake > 0) {
            --this.shake;
        }
        if (this.inGround) {
            int n = this.world.getTypeId(this.blockX, this.blockY, this.blockZ);
            if (n == this.inBlockId) {
                ++this.i;
                if (this.i == 1200) {
                    this.die();
                }
                return;
            }
            this.inGround = false;
            this.motX *= (double)(this.random.nextFloat() * 0.2f);
            this.motY *= (double)(this.random.nextFloat() * 0.2f);
            this.motZ *= (double)(this.random.nextFloat() * 0.2f);
            this.i = 0;
            this.j = 0;
        } else {
            ++this.j;
        }
        Vec3D vec3D = this.world.getVec3DPool().create(this.locX, this.locY, this.locZ);
        Vec3D vec3D2 = this.world.getVec3DPool().create(this.locX + this.motX, this.locY + this.motY, this.locZ + this.motZ);
        MovingObjectPosition movingObjectPosition = this.world.a(vec3D, vec3D2);
        vec3D = this.world.getVec3DPool().create(this.locX, this.locY, this.locZ);
        vec3D2 = this.world.getVec3DPool().create(this.locX + this.motX, this.locY + this.motY, this.locZ + this.motZ);
        if (movingObjectPosition != null) {
            vec3D2 = this.world.getVec3DPool().create(movingObjectPosition.pos.c, movingObjectPosition.pos.d, movingObjectPosition.pos.e);
        }
        if (!this.world.isStatic) {
            Entity entity = null;
            List list = this.world.getEntities(this, this.boundingBox.a(this.motX, this.motY, this.motZ).grow(1.0, 1.0, 1.0));
            double d = 0.0;
            EntityLiving entityLiving = this.getShooter();
            for (int i = 0; i < list.size(); ++i) {
                double d2;
                float f;
                AxisAlignedBB axisAlignedBB;
                MovingObjectPosition movingObjectPosition2;
                Entity entity2 = (Entity)list.get(i);
                if (!entity2.L() || entity2 == entityLiving && this.j < 5 || (movingObjectPosition2 = (axisAlignedBB = entity2.boundingBox.grow(f = 0.3f, f, f)).a(vec3D, vec3D2)) == null || !((d2 = vec3D.d(movingObjectPosition2.pos)) < d) && d != 0.0) continue;
                entity = entity2;
                d = d2;
            }
            if (entity != null) {
                movingObjectPosition = new MovingObjectPosition(entity);
            }
        }
        if (movingObjectPosition != null) {
            if (movingObjectPosition.type == EnumMovingObjectType.TILE && this.world.getTypeId(movingObjectPosition.b, movingObjectPosition.c, movingObjectPosition.d) == Block.PORTAL.id) {
                this.ab();
            } else {
                this.a(movingObjectPosition);
            }
        }
        this.locX += this.motX;
        this.locY += this.motY;
        this.locZ += this.motZ;
        float f = MathHelper.sqrt(this.motX * this.motX + this.motZ * this.motZ);
        this.yaw = (float)(Math.atan2(this.motX, this.motZ) * 180.0 / 3.1415927410125732);
        this.pitch = (float)(Math.atan2(this.motY, f) * 180.0 / 3.1415927410125732);
        while (this.pitch - this.lastPitch < -180.0f) {
            this.lastPitch -= 360.0f;
        }
        while (this.pitch - this.lastPitch >= 180.0f) {
            this.lastPitch += 360.0f;
        }
        while (this.yaw - this.lastYaw < -180.0f) {
            this.lastYaw -= 360.0f;
        }
        while (this.yaw - this.lastYaw >= 180.0f) {
            this.lastYaw += 360.0f;
        }
        this.pitch = this.lastPitch + (this.pitch - this.lastPitch) * 0.2f;
        this.yaw = this.lastYaw + (this.yaw - this.lastYaw) * 0.2f;
        float f2 = 0.99f;
        float f3 = this.e();
        if (this.H()) {
            for (int i = 0; i < 4; ++i) {
                float f4 = 0.25f;
                this.world.addParticle("bubble", this.locX - this.motX * (double)f4, this.locY - this.motY * (double)f4, this.locZ - this.motZ * (double)f4, this.motX, this.motY, this.motZ);
            }
            f2 = 0.8f;
        }
        this.motX *= (double)f2;
        this.motY *= (double)f2;
        this.motZ *= (double)f2;
        this.motY -= (double)f3;
        this.setPosition(this.locX, this.locY, this.locZ);
    }

    protected float e() {
        return 0.03f;
    }

    protected abstract void a(MovingObjectPosition var1);

    @Override
    public void b(NBTTagCompound nBTTagCompound) {
        nBTTagCompound.setShort("xTile", (short)this.blockX);
        nBTTagCompound.setShort("yTile", (short)this.blockY);
        nBTTagCompound.setShort("zTile", (short)this.blockZ);
        nBTTagCompound.setByte("inTile", (byte)this.inBlockId);
        nBTTagCompound.setByte("shake", (byte)this.shake);
        nBTTagCompound.setByte("inGround", (byte)(this.inGround ? 1 : 0));
        if ((this.shooterName == null || this.shooterName.length() == 0) && this.shooter != null && this.shooter instanceof EntityHuman) {
            this.shooterName = this.shooter.getLocalizedName();
        }
        nBTTagCompound.setString("ownerName", this.shooterName == null ? "" : this.shooterName);
    }

    @Override
    public void a(NBTTagCompound nBTTagCompound) {
        this.blockX = nBTTagCompound.getShort("xTile");
        this.blockY = nBTTagCompound.getShort("yTile");
        this.blockZ = nBTTagCompound.getShort("zTile");
        this.inBlockId = nBTTagCompound.getByte("inTile") & 0xFF;
        this.shake = nBTTagCompound.getByte("shake") & 0xFF;
        this.inGround = nBTTagCompound.getByte("inGround") == 1;
        this.shooterName = nBTTagCompound.getString("ownerName");
        if (this.shooterName != null && this.shooterName.length() == 0) {
            this.shooterName = null;
        }
    }

    public EntityLiving getShooter() {
        if (this.shooter == null && this.shooterName != null && this.shooterName.length() > 0) {
            this.shooter = this.world.a(this.shooterName);
        }
        return this.shooter;
    }
}

