/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import java.util.List;
import net.minecraft.server.AxisAlignedBB;
import net.minecraft.server.EntityLiving;
import net.minecraft.server.EntityProjectile;
import net.minecraft.server.Item;
import net.minecraft.server.ItemStack;
import net.minecraft.server.MobEffect;
import net.minecraft.server.MobEffectList;
import net.minecraft.server.MovingObjectPosition;
import net.minecraft.server.NBTTagCompound;
import net.minecraft.server.World;

public class EntityPotion
extends EntityProjectile {
    private ItemStack item;

    public EntityPotion(World world) {
        super(world);
    }

    public EntityPotion(World world, EntityLiving entityLiving, int n) {
        this(world, entityLiving, new ItemStack(Item.POTION, 1, n));
    }

    public EntityPotion(World world, EntityLiving entityLiving, ItemStack itemStack) {
        super(world, entityLiving);
        this.item = itemStack;
    }

    public EntityPotion(World world, double d, double d2, double d3, ItemStack itemStack) {
        super(world, d, d2, d3);
        this.item = itemStack;
    }

    @Override
    protected float e() {
        return 0.05f;
    }

    @Override
    protected float c() {
        return 0.5f;
    }

    @Override
    protected float d() {
        return -20.0f;
    }

    public void setPotionValue(int n) {
        if (this.item == null) {
            this.item = new ItemStack(Item.POTION, 1, 0);
        }
        this.item.setData(n);
    }

    public int getPotionValue() {
        if (this.item == null) {
            this.item = new ItemStack(Item.POTION, 1, 0);
        }
        return this.item.getData();
    }

    @Override
    protected void a(MovingObjectPosition movingObjectPosition) {
        if (!this.world.isStatic) {
            AxisAlignedBB axisAlignedBB;
            List list;
            List list2 = Item.POTION.g(this.item);
            if (list2 != null && !list2.isEmpty() && (list = this.world.a(EntityLiving.class, axisAlignedBB = this.boundingBox.grow(4.0, 2.0, 4.0))) != null && !list.isEmpty()) {
                for (EntityLiving entityLiving : list) {
                    double d = this.e(entityLiving);
                    if (!(d < 16.0)) continue;
                    double d2 = 1.0 - Math.sqrt(d) / 4.0;
                    if (entityLiving == movingObjectPosition.entity) {
                        d2 = 1.0;
                    }
                    for (MobEffect mobEffect : list2) {
                        int n = mobEffect.getEffectId();
                        if (MobEffectList.byId[n].isInstant()) {
                            MobEffectList.byId[n].applyInstantEffect(this.getShooter(), entityLiving, mobEffect.getAmplifier(), d2);
                            continue;
                        }
                        int n2 = (int)(d2 * (double)mobEffect.getDuration() + 0.5);
                        if (n2 <= 20) continue;
                        entityLiving.addEffect(new MobEffect(n, n2, mobEffect.getAmplifier()));
                    }
                }
            }
            this.world.triggerEffect(2002, (int)Math.round(this.locX), (int)Math.round(this.locY), (int)Math.round(this.locZ), this.getPotionValue());
            this.die();
        }
    }

    @Override
    public void a(NBTTagCompound nBTTagCompound) {
        super.a(nBTTagCompound);
        if (nBTTagCompound.hasKey("Potion")) {
            this.item = ItemStack.createStack(nBTTagCompound.getCompound("Potion"));
        } else {
            this.setPotionValue(nBTTagCompound.getInt("potionValue"));
        }
        if (this.item == null) {
            this.die();
        }
    }

    @Override
    public void b(NBTTagCompound nBTTagCompound) {
        super.b(nBTTagCompound);
        if (this.item != null) {
            nBTTagCompound.setCompound("Potion", this.item.save(new NBTTagCompound()));
        }
    }
}

