/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.server.AchievementList;
import net.minecraft.server.ChatMessage;
import net.minecraft.server.Chunk;
import net.minecraft.server.ChunkCoordIntPair;
import net.minecraft.server.ChunkCoordinates;
import net.minecraft.server.Container;
import net.minecraft.server.ContainerAnvil;
import net.minecraft.server.ContainerBeacon;
import net.minecraft.server.ContainerBrewingStand;
import net.minecraft.server.ContainerChest;
import net.minecraft.server.ContainerDispenser;
import net.minecraft.server.ContainerEnchantTable;
import net.minecraft.server.ContainerFurnace;
import net.minecraft.server.ContainerHopper;
import net.minecraft.server.ContainerHorse;
import net.minecraft.server.ContainerMerchant;
import net.minecraft.server.ContainerWorkbench;
import net.minecraft.server.CrashReport;
import net.minecraft.server.CrashReportSystemDetails;
import net.minecraft.server.DamageSource;
import net.minecraft.server.Entity;
import net.minecraft.server.EntityArrow;
import net.minecraft.server.EntityDamageSource;
import net.minecraft.server.EntityHorse;
import net.minecraft.server.EntityHuman;
import net.minecraft.server.EntityLiving;
import net.minecraft.server.EntityMinecartHopper;
import net.minecraft.server.EnumAnimation;
import net.minecraft.server.EnumBedResult;
import net.minecraft.server.EnumGamemode;
import net.minecraft.server.ICrafting;
import net.minecraft.server.IInventory;
import net.minecraft.server.IMerchant;
import net.minecraft.server.IScoreboardCriteria;
import net.minecraft.server.InventoryMerchant;
import net.minecraft.server.Item;
import net.minecraft.server.ItemStack;
import net.minecraft.server.ItemWorldMapBase;
import net.minecraft.server.MathHelper;
import net.minecraft.server.MerchantRecipeList;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.MobEffect;
import net.minecraft.server.NBTTagCompound;
import net.minecraft.server.Packet;
import net.minecraft.server.Packet100OpenWindow;
import net.minecraft.server.Packet101CloseWindow;
import net.minecraft.server.Packet103SetSlot;
import net.minecraft.server.Packet104WindowItems;
import net.minecraft.server.Packet105CraftProgressBar;
import net.minecraft.server.Packet133OpenTileEntity;
import net.minecraft.server.Packet17EntityLocationAction;
import net.minecraft.server.Packet18ArmAnimation;
import net.minecraft.server.Packet200Statistic;
import net.minecraft.server.Packet202Abilities;
import net.minecraft.server.Packet204LocaleAndViewDistance;
import net.minecraft.server.Packet250CustomPayload;
import net.minecraft.server.Packet29DestroyEntity;
import net.minecraft.server.Packet38EntityStatus;
import net.minecraft.server.Packet39AttachEntity;
import net.minecraft.server.Packet3Chat;
import net.minecraft.server.Packet41MobEffect;
import net.minecraft.server.Packet42RemoveMobEffect;
import net.minecraft.server.Packet43SetExperience;
import net.minecraft.server.Packet56MapChunkBulk;
import net.minecraft.server.Packet70Bed;
import net.minecraft.server.Packet8UpdateHealth;
import net.minecraft.server.PlayerConnection;
import net.minecraft.server.PlayerInteractManager;
import net.minecraft.server.ReportedException;
import net.minecraft.server.ScoreboardObjective;
import net.minecraft.server.ScoreboardScore;
import net.minecraft.server.SlotResult;
import net.minecraft.server.Statistic;
import net.minecraft.server.StatisticList;
import net.minecraft.server.TileEntity;
import net.minecraft.server.TileEntityBeacon;
import net.minecraft.server.TileEntityBrewingStand;
import net.minecraft.server.TileEntityDispenser;
import net.minecraft.server.TileEntityDropper;
import net.minecraft.server.TileEntityFurnace;
import net.minecraft.server.TileEntityHopper;
import net.minecraft.server.TileEntitySign;
import net.minecraft.server.World;
import net.minecraft.server.WorldServer;

public class EntityPlayer
extends EntityHuman
implements ICrafting {
    private String locale = "en_US";
    public PlayerConnection playerConnection;
    public MinecraftServer server;
    public PlayerInteractManager playerInteractManager;
    public double d;
    public double e;
    public final List chunkCoordIntPairQueue = new LinkedList();
    public final List removeQueue = new LinkedList();
    private float bO = Float.MIN_VALUE;
    private float bP = -1.0E8f;
    private int bQ = -99999999;
    private boolean bR = true;
    private int lastSentExp = -99999999;
    private int invulnerableTicks = 60;
    private int bU;
    private int bV;
    private boolean bW = true;
    private long bX = 0L;
    private int containerCounter;
    public boolean h;
    public int ping;
    public boolean viewingCredits;

    public EntityPlayer(MinecraftServer minecraftServer, World world, String string, PlayerInteractManager playerInteractManager) {
        super(world, string);
        playerInteractManager.player = this;
        this.playerInteractManager = playerInteractManager;
        this.bU = minecraftServer.getPlayerList().o();
        ChunkCoordinates chunkCoordinates = world.getSpawn();
        int n = chunkCoordinates.x;
        int n2 = chunkCoordinates.z;
        int n3 = chunkCoordinates.y;
        if (!world.worldProvider.g && world.getWorldData().getGameType() != EnumGamemode.ADVENTURE) {
            int n4 = Math.max(5, minecraftServer.getSpawnProtection() - 6);
            n3 = world.i(n += this.random.nextInt(n4 * 2) - n4, n2 += this.random.nextInt(n4 * 2) - n4);
        }
        this.server = minecraftServer;
        this.Y = 0.0f;
        this.height = 0.0f;
        this.setPositionRotation((double)n + 0.5, n3, (double)n2 + 0.5, 0.0f, 0.0f);
        while (!world.getCubes(this, this.boundingBox).isEmpty()) {
            this.setPosition(this.locX, this.locY + 1.0, this.locZ);
        }
    }

    @Override
    public void a(NBTTagCompound nBTTagCompound) {
        super.a(nBTTagCompound);
        if (nBTTagCompound.hasKey("playerGameType")) {
            if (MinecraftServer.getServer().getForceGamemode()) {
                this.playerInteractManager.setGameMode(MinecraftServer.getServer().getGamemode());
            } else {
                this.playerInteractManager.setGameMode(EnumGamemode.a(nBTTagCompound.getInt("playerGameType")));
            }
        }
    }

    @Override
    public void b(NBTTagCompound nBTTagCompound) {
        super.b(nBTTagCompound);
        nBTTagCompound.setInt("playerGameType", this.playerInteractManager.getGameMode().a());
    }

    @Override
    public void levelDown(int n) {
        super.levelDown(n);
        this.lastSentExp = -1;
    }

    public void syncInventory() {
        this.activeContainer.addSlotListener(this);
    }

    @Override
    protected void d_() {
        this.height = 0.0f;
    }

    @Override
    public float getHeadHeight() {
        return 1.62f;
    }

    @Override
    public void l_() {
        Object object;
        Object object2;
        this.playerInteractManager.a();
        --this.invulnerableTicks;
        this.activeContainer.b();
        if (!this.world.isStatic && !this.activeContainer.a(this)) {
            this.closeInventory();
            this.activeContainer = this.defaultContainer;
        }
        while (!this.removeQueue.isEmpty()) {
            int n = Math.min(this.removeQueue.size(), 127);
            object2 = new int[n];
            object = this.removeQueue.iterator();
            int n2 = 0;
            while (object.hasNext() && n2 < n) {
                object2[n2++] = (Integer)object.next();
                object.remove();
            }
            this.playerConnection.sendPacket(new Packet29DestroyEntity((int[])object2));
        }
        if (!this.chunkCoordIntPairQueue.isEmpty()) {
            ArrayList<Chunk> arrayList = new ArrayList<Chunk>();
            object2 = this.chunkCoordIntPairQueue.iterator();
            object = new ArrayList();
            while (object2.hasNext() && arrayList.size() < 5) {
                ChunkCoordIntPair chunkCoordIntPair = (ChunkCoordIntPair)object2.next();
                object2.remove();
                if (chunkCoordIntPair == null || !this.world.isLoaded(chunkCoordIntPair.x << 4, 0, chunkCoordIntPair.z << 4)) continue;
                arrayList.add(this.world.getChunkAt(chunkCoordIntPair.x, chunkCoordIntPair.z));
                object.addAll(((WorldServer)this.world).getTileEntities(chunkCoordIntPair.x * 16, 0, chunkCoordIntPair.z * 16, chunkCoordIntPair.x * 16 + 16, 256, chunkCoordIntPair.z * 16 + 16));
            }
            if (!arrayList.isEmpty()) {
                this.playerConnection.sendPacket(new Packet56MapChunkBulk(arrayList));
                Iterator iterator = object.iterator();
                while (iterator.hasNext()) {
                    TileEntity object3 = (TileEntity)iterator.next();
                    this.b(object3);
                }
                for (Chunk chunk : arrayList) {
                    this.p().getTracker().a(this, chunk);
                }
            }
        }
        if (this.bX > 0L && this.server.ar() > 0 && MinecraftServer.aq() - this.bX > (long)(this.server.ar() * 1000 * 60)) {
            this.playerConnection.disconnect("You have been idle for too long!");
        }
    }

    public void h() {
        try {
            super.l_();
            for (int i = 0; i < this.inventory.getSize(); ++i) {
                Object object;
                ItemStack itemStack = this.inventory.getItem(i);
                if (itemStack == null || !Item.byId[itemStack.id].f() || this.playerConnection.lowPriorityCount() > 5 || (object = ((ItemWorldMapBase)Item.byId[itemStack.id]).c(itemStack, this.world, this)) == null) continue;
                this.playerConnection.sendPacket((Packet)object);
            }
            if (this.getHealth() != this.bP || this.bQ != this.foodData.a() || this.foodData.e() == 0.0f != this.bR) {
                this.playerConnection.sendPacket(new Packet8UpdateHealth(this.getHealth(), this.foodData.a(), this.foodData.e()));
                this.bP = this.getHealth();
                this.bQ = this.foodData.a();
                boolean bl = this.bR = this.foodData.e() == 0.0f;
            }
            if (this.getHealth() + this.bn() != this.bO) {
                this.bO = this.getHealth() + this.bn();
                Collection collection = this.getScoreboard().getObjectivesForCriteria(IScoreboardCriteria.f);
                for (Object object : collection) {
                    this.getScoreboard().getPlayerScoreForObjective(this.getLocalizedName(), (ScoreboardObjective)object).updateForList(Arrays.asList(this));
                }
            }
            if (this.expTotal != this.lastSentExp) {
                this.lastSentExp = this.expTotal;
                this.playerConnection.sendPacket(new Packet43SetExperience(this.exp, this.expTotal, this.expLevel));
            }
        }
        catch (Throwable throwable) {
            CrashReport crashReport = CrashReport.a(throwable, "Ticking player");
            CrashReportSystemDetails crashReportSystemDetails = crashReport.a("Player being ticked");
            this.a(crashReportSystemDetails);
            throw new ReportedException(crashReport);
        }
    }

    @Override
    public void die(DamageSource damageSource) {
        this.server.getPlayerList().sendMessage(this.aR().b());
        if (!this.world.getGameRules().getBoolean("keepInventory")) {
            this.inventory.m();
        }
        Collection collection = this.world.getScoreboard().getObjectivesForCriteria(IScoreboardCriteria.c);
        for (ScoreboardObjective scoreboardObjective : collection) {
            ScoreboardScore scoreboardScore = this.getScoreboard().getPlayerScoreForObjective(this.getLocalizedName(), scoreboardObjective);
            scoreboardScore.incrementScore();
        }
        EntityLiving entityLiving = this.aS();
        if (entityLiving != null) {
            entityLiving.b(this, this.bb);
        }
        this.a(StatisticList.y, 1);
    }

    @Override
    public boolean damageEntity(DamageSource damageSource, float f) {
        boolean bl;
        if (this.isInvulnerable()) {
            return false;
        }
        boolean bl2 = bl = this.server.V() && this.server.getPvP() && "fall".equals(damageSource.translationIndex);
        if (!bl && this.invulnerableTicks > 0 && damageSource != DamageSource.OUT_OF_WORLD) {
            return false;
        }
        if (damageSource instanceof EntityDamageSource) {
            Entity entity = damageSource.getEntity();
            if (entity instanceof EntityHuman && !this.a((EntityHuman)entity)) {
                return false;
            }
            if (entity instanceof EntityArrow) {
                EntityArrow entityArrow = (EntityArrow)entity;
                if (entityArrow.shooter instanceof EntityHuman && !this.a((EntityHuman)entityArrow.shooter)) {
                    return false;
                }
            }
        }
        return super.damageEntity(damageSource, f);
    }

    @Override
    public boolean a(EntityHuman entityHuman) {
        if (!this.server.getPvP()) {
            return false;
        }
        return super.a(entityHuman);
    }

    @Override
    public void b(int n) {
        if (this.dimension == 1 && n == 1) {
            this.a(AchievementList.C);
            this.world.kill(this);
            this.viewingCredits = true;
            this.playerConnection.sendPacket(new Packet70Bed(4, 0));
        } else {
            if (this.dimension == 0 && n == 1) {
                this.a(AchievementList.B);
                ChunkCoordinates chunkCoordinates = this.server.getWorldServer(n).getDimensionSpawn();
                if (chunkCoordinates != null) {
                    this.playerConnection.a(chunkCoordinates.x, chunkCoordinates.y, chunkCoordinates.z, 0.0f, 0.0f);
                }
                n = 1;
            } else {
                this.a(AchievementList.x);
            }
            this.server.getPlayerList().changeDimension(this, n);
            this.lastSentExp = -1;
            this.bP = -1.0f;
            this.bQ = -1;
        }
    }

    private void b(TileEntity tileEntity) {
        Packet packet;
        if (tileEntity != null && (packet = tileEntity.getUpdatePacket()) != null) {
            this.playerConnection.sendPacket(packet);
        }
    }

    @Override
    public void receive(Entity entity, int n) {
        super.receive(entity, n);
        this.activeContainer.b();
    }

    @Override
    public EnumBedResult a(int n, int n2, int n3) {
        EnumBedResult enumBedResult = super.a(n, n2, n3);
        if (enumBedResult == EnumBedResult.OK) {
            Packet17EntityLocationAction packet17EntityLocationAction = new Packet17EntityLocationAction(this, 0, n, n2, n3);
            this.p().getTracker().a((Entity)this, packet17EntityLocationAction);
            this.playerConnection.a(this.locX, this.locY, this.locZ, this.yaw, this.pitch);
            this.playerConnection.sendPacket(packet17EntityLocationAction);
        }
        return enumBedResult;
    }

    @Override
    public void a(boolean bl, boolean bl2, boolean bl3) {
        if (this.isSleeping()) {
            this.p().getTracker().sendPacketToEntity(this, new Packet18ArmAnimation(this, 3));
        }
        super.a(bl, bl2, bl3);
        if (this.playerConnection != null) {
            this.playerConnection.a(this.locX, this.locY, this.locZ, this.yaw, this.pitch);
        }
    }

    @Override
    public void mount(Entity entity) {
        super.mount(entity);
        this.playerConnection.sendPacket(new Packet39AttachEntity(0, this, this.vehicle));
        this.playerConnection.a(this.locX, this.locY, this.locZ, this.yaw, this.pitch);
    }

    @Override
    protected void a(double d, boolean bl) {
    }

    public void b(double d, boolean bl) {
        super.a(d, bl);
    }

    @Override
    public void a(TileEntity tileEntity) {
        if (tileEntity instanceof TileEntitySign) {
            ((TileEntitySign)tileEntity).a(this);
            this.playerConnection.sendPacket(new Packet133OpenTileEntity(0, tileEntity.x, tileEntity.y, tileEntity.z));
        }
    }

    private void nextContainerCounter() {
        this.containerCounter = this.containerCounter % 100 + 1;
    }

    @Override
    public void startCrafting(int n, int n2, int n3) {
        this.nextContainerCounter();
        this.playerConnection.sendPacket(new Packet100OpenWindow(this.containerCounter, 1, "Crafting", 9, true));
        this.activeContainer = new ContainerWorkbench(this.inventory, this.world, n, n2, n3);
        this.activeContainer.windowId = this.containerCounter;
        this.activeContainer.addSlotListener(this);
    }

    @Override
    public void startEnchanting(int n, int n2, int n3, String string) {
        this.nextContainerCounter();
        this.playerConnection.sendPacket(new Packet100OpenWindow(this.containerCounter, 4, string == null ? "" : string, 9, string != null));
        this.activeContainer = new ContainerEnchantTable(this.inventory, this.world, n, n2, n3);
        this.activeContainer.windowId = this.containerCounter;
        this.activeContainer.addSlotListener(this);
    }

    @Override
    public void openAnvil(int n, int n2, int n3) {
        this.nextContainerCounter();
        this.playerConnection.sendPacket(new Packet100OpenWindow(this.containerCounter, 8, "Repairing", 9, true));
        this.activeContainer = new ContainerAnvil(this.inventory, this.world, n, n2, n3, this);
        this.activeContainer.windowId = this.containerCounter;
        this.activeContainer.addSlotListener(this);
    }

    @Override
    public void openContainer(IInventory iInventory) {
        if (this.activeContainer != this.defaultContainer) {
            this.closeInventory();
        }
        this.nextContainerCounter();
        this.playerConnection.sendPacket(new Packet100OpenWindow(this.containerCounter, 0, iInventory.getName(), iInventory.getSize(), iInventory.c()));
        this.activeContainer = new ContainerChest(this.inventory, iInventory);
        this.activeContainer.windowId = this.containerCounter;
        this.activeContainer.addSlotListener(this);
    }

    @Override
    public void openHopper(TileEntityHopper tileEntityHopper) {
        this.nextContainerCounter();
        this.playerConnection.sendPacket(new Packet100OpenWindow(this.containerCounter, 9, tileEntityHopper.getName(), tileEntityHopper.getSize(), tileEntityHopper.c()));
        this.activeContainer = new ContainerHopper(this.inventory, tileEntityHopper);
        this.activeContainer.windowId = this.containerCounter;
        this.activeContainer.addSlotListener(this);
    }

    @Override
    public void openMinecartHopper(EntityMinecartHopper entityMinecartHopper) {
        this.nextContainerCounter();
        this.playerConnection.sendPacket(new Packet100OpenWindow(this.containerCounter, 9, entityMinecartHopper.getName(), entityMinecartHopper.getSize(), entityMinecartHopper.c()));
        this.activeContainer = new ContainerHopper(this.inventory, entityMinecartHopper);
        this.activeContainer.windowId = this.containerCounter;
        this.activeContainer.addSlotListener(this);
    }

    @Override
    public void openFurnace(TileEntityFurnace tileEntityFurnace) {
        this.nextContainerCounter();
        this.playerConnection.sendPacket(new Packet100OpenWindow(this.containerCounter, 2, tileEntityFurnace.getName(), tileEntityFurnace.getSize(), tileEntityFurnace.c()));
        this.activeContainer = new ContainerFurnace(this.inventory, tileEntityFurnace);
        this.activeContainer.windowId = this.containerCounter;
        this.activeContainer.addSlotListener(this);
    }

    @Override
    public void openDispenser(TileEntityDispenser tileEntityDispenser) {
        this.nextContainerCounter();
        this.playerConnection.sendPacket(new Packet100OpenWindow(this.containerCounter, tileEntityDispenser instanceof TileEntityDropper ? 10 : 3, tileEntityDispenser.getName(), tileEntityDispenser.getSize(), tileEntityDispenser.c()));
        this.activeContainer = new ContainerDispenser(this.inventory, tileEntityDispenser);
        this.activeContainer.windowId = this.containerCounter;
        this.activeContainer.addSlotListener(this);
    }

    @Override
    public void openBrewingStand(TileEntityBrewingStand tileEntityBrewingStand) {
        this.nextContainerCounter();
        this.playerConnection.sendPacket(new Packet100OpenWindow(this.containerCounter, 5, tileEntityBrewingStand.getName(), tileEntityBrewingStand.getSize(), tileEntityBrewingStand.c()));
        this.activeContainer = new ContainerBrewingStand(this.inventory, tileEntityBrewingStand);
        this.activeContainer.windowId = this.containerCounter;
        this.activeContainer.addSlotListener(this);
    }

    @Override
    public void openBeacon(TileEntityBeacon tileEntityBeacon) {
        this.nextContainerCounter();
        this.playerConnection.sendPacket(new Packet100OpenWindow(this.containerCounter, 7, tileEntityBeacon.getName(), tileEntityBeacon.getSize(), tileEntityBeacon.c()));
        this.activeContainer = new ContainerBeacon(this.inventory, tileEntityBeacon);
        this.activeContainer.windowId = this.containerCounter;
        this.activeContainer.addSlotListener(this);
    }

    @Override
    public void openTrade(IMerchant iMerchant, String string) {
        this.nextContainerCounter();
        this.activeContainer = new ContainerMerchant(this.inventory, iMerchant, this.world);
        this.activeContainer.windowId = this.containerCounter;
        this.activeContainer.addSlotListener(this);
        InventoryMerchant inventoryMerchant = ((ContainerMerchant)this.activeContainer).getMerchantInventory();
        this.playerConnection.sendPacket(new Packet100OpenWindow(this.containerCounter, 6, string == null ? "" : string, inventoryMerchant.getSize(), string != null));
        MerchantRecipeList merchantRecipeList = iMerchant.getOffers(this);
        if (merchantRecipeList != null) {
            try {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
                dataOutputStream.writeInt(this.containerCounter);
                merchantRecipeList.a(dataOutputStream);
                this.playerConnection.sendPacket(new Packet250CustomPayload("MC|TrList", byteArrayOutputStream.toByteArray()));
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    @Override
    public void openHorseInventory(EntityHorse entityHorse, IInventory iInventory) {
        if (this.activeContainer != this.defaultContainer) {
            this.closeInventory();
        }
        this.nextContainerCounter();
        this.playerConnection.sendPacket(new Packet100OpenWindow(this.containerCounter, 11, iInventory.getName(), iInventory.getSize(), iInventory.c(), entityHorse.id));
        this.activeContainer = new ContainerHorse(this.inventory, iInventory, entityHorse);
        this.activeContainer.windowId = this.containerCounter;
        this.activeContainer.addSlotListener(this);
    }

    @Override
    public void a(Container container, int n, ItemStack itemStack) {
        if (container.getSlot(n) instanceof SlotResult) {
            return;
        }
        if (this.h) {
            return;
        }
        this.playerConnection.sendPacket(new Packet103SetSlot(container.windowId, n, itemStack));
    }

    public void updateInventory(Container container) {
        this.a(container, container.a());
    }

    @Override
    public void a(Container container, List list) {
        this.playerConnection.sendPacket(new Packet104WindowItems(container.windowId, list));
        this.playerConnection.sendPacket(new Packet103SetSlot(-1, -1, this.inventory.getCarried()));
    }

    @Override
    public void setContainerData(Container container, int n, int n2) {
        this.playerConnection.sendPacket(new Packet105CraftProgressBar(container.windowId, n, n2));
    }

    @Override
    public void closeInventory() {
        this.playerConnection.sendPacket(new Packet101CloseWindow(this.activeContainer.windowId));
        this.k();
    }

    public void broadcastCarriedItem() {
        if (this.h) {
            return;
        }
        this.playerConnection.sendPacket(new Packet103SetSlot(-1, -1, this.inventory.getCarried()));
    }

    public void k() {
        this.activeContainer.b(this);
        this.activeContainer = this.defaultContainer;
    }

    public void a(float f, float f2, boolean bl, boolean bl2) {
        if (this.vehicle != null) {
            if (f >= -1.0f && f <= 1.0f) {
                this.be = f;
            }
            if (f2 >= -1.0f && f2 <= 1.0f) {
                this.bf = f2;
            }
            this.bd = bl;
            this.setSneaking(bl2);
        }
    }

    @Override
    public void a(Statistic statistic, int n) {
        if (statistic == null) {
            return;
        }
        if (!statistic.f) {
            this.playerConnection.sendPacket(new Packet200Statistic(statistic.e, n));
        }
    }

    public void l() {
        if (this.passenger != null) {
            this.passenger.mount(this);
        }
        if (this.sleeping) {
            this.a(true, false, false);
        }
    }

    public void triggerHealthUpdate() {
        this.bP = -1.0E8f;
    }

    @Override
    public void a(String string) {
        this.playerConnection.sendPacket(new Packet3Chat(ChatMessage.e(string)));
    }

    @Override
    protected void n() {
        this.playerConnection.sendPacket(new Packet38EntityStatus(this.id, 9));
        super.n();
    }

    @Override
    public void a(ItemStack itemStack, int n) {
        super.a(itemStack, n);
        if (itemStack != null && itemStack.getItem() != null && itemStack.getItem().c_(itemStack) == EnumAnimation.EAT) {
            this.p().getTracker().sendPacketToEntity(this, new Packet18ArmAnimation(this, 5));
        }
    }

    @Override
    public void copyTo(EntityHuman entityHuman, boolean bl) {
        super.copyTo(entityHuman, bl);
        this.lastSentExp = -1;
        this.bP = -1.0f;
        this.bQ = -1;
        this.removeQueue.addAll(((EntityPlayer)entityHuman).removeQueue);
    }

    @Override
    protected void a(MobEffect mobEffect) {
        super.a(mobEffect);
        this.playerConnection.sendPacket(new Packet41MobEffect(this.id, mobEffect));
    }

    @Override
    protected void a(MobEffect mobEffect, boolean bl) {
        super.a(mobEffect, bl);
        this.playerConnection.sendPacket(new Packet41MobEffect(this.id, mobEffect));
    }

    @Override
    protected void b(MobEffect mobEffect) {
        super.b(mobEffect);
        this.playerConnection.sendPacket(new Packet42RemoveMobEffect(this.id, mobEffect));
    }

    @Override
    public void enderTeleportTo(double d, double d2, double d3) {
        this.playerConnection.a(d, d2, d3, this.yaw, this.pitch);
    }

    @Override
    public void b(Entity entity) {
        this.p().getTracker().sendPacketToEntity(this, new Packet18ArmAnimation(entity, 6));
    }

    @Override
    public void c(Entity entity) {
        this.p().getTracker().sendPacketToEntity(this, new Packet18ArmAnimation(entity, 7));
    }

    @Override
    public void updateAbilities() {
        if (this.playerConnection == null) {
            return;
        }
        this.playerConnection.sendPacket(new Packet202Abilities(this.abilities));
    }

    public WorldServer p() {
        return (WorldServer)this.world;
    }

    @Override
    public void a(EnumGamemode enumGamemode) {
        this.playerInteractManager.setGameMode(enumGamemode);
        this.playerConnection.sendPacket(new Packet70Bed(3, enumGamemode.a()));
    }

    @Override
    public void sendMessage(ChatMessage chatMessage) {
        this.playerConnection.sendPacket(new Packet3Chat(chatMessage));
    }

    @Override
    public boolean a(int n, String string) {
        if ("seed".equals(string) && !this.server.V()) {
            return true;
        }
        if ("tell".equals(string) || "help".equals(string) || "me".equals(string)) {
            return true;
        }
        if (this.server.getPlayerList().isOp(this.name)) {
            return this.server.k() >= n;
        }
        return false;
    }

    public String q() {
        String string = this.playerConnection.networkManager.getSocketAddress().toString();
        string = string.substring(string.indexOf("/") + 1);
        string = string.substring(0, string.indexOf(":"));
        return string;
    }

    public void a(Packet204LocaleAndViewDistance packet204LocaleAndViewDistance) {
        this.locale = packet204LocaleAndViewDistance.d();
        int n = 256 >> packet204LocaleAndViewDistance.f();
        if (n > 3 && n < 15) {
            this.bU = n;
        }
        this.bV = packet204LocaleAndViewDistance.g();
        this.bW = packet204LocaleAndViewDistance.h();
        if (this.server.K() && this.server.J().equals(this.name)) {
            this.server.c(packet204LocaleAndViewDistance.i());
        }
        this.b(1, !packet204LocaleAndViewDistance.j());
    }

    public int getChatFlags() {
        return this.bV;
    }

    public void a(String string, int n) {
        String string2 = string + "\u0000" + n;
        this.playerConnection.sendPacket(new Packet250CustomPayload("MC|TPack", string2.getBytes()));
    }

    @Override
    public ChunkCoordinates b() {
        return new ChunkCoordinates(MathHelper.floor(this.locX), MathHelper.floor(this.locY + 0.5), MathHelper.floor(this.locZ));
    }

    public void u() {
        this.bX = MinecraftServer.aq();
    }
}

