/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import java.util.List;
import java.util.UUID;
import net.minecraft.server.AttributeInstance;
import net.minecraft.server.AttributeModifier;
import net.minecraft.server.DamageSource;
import net.minecraft.server.Entity;
import net.minecraft.server.EntityHuman;
import net.minecraft.server.EntityZombie;
import net.minecraft.server.GenericAttributes;
import net.minecraft.server.GroupDataEntity;
import net.minecraft.server.Item;
import net.minecraft.server.ItemStack;
import net.minecraft.server.NBTTagCompound;
import net.minecraft.server.World;

public class EntityPigZombie
extends EntityZombie {
    private static final UUID bq = UUID.fromString("49455A49-7EC5-45BA-B886-3B90B23A1718");
    private static final AttributeModifier br = new AttributeModifier(bq, "Attacking speed boost", 0.45, 0).a(false);
    private int angerLevel;
    private int soundDelay;
    private Entity bu;

    public EntityPigZombie(World world) {
        super(world);
        this.fireProof = true;
    }

    @Override
    protected void az() {
        super.az();
        this.getAttributeInstance(bp).setValue(0.0);
        this.getAttributeInstance(GenericAttributes.d).setValue(0.5);
        this.getAttributeInstance(GenericAttributes.e).setValue(5.0);
    }

    @Override
    protected boolean bf() {
        return false;
    }

    @Override
    public void l_() {
        if (this.bu != this.target && !this.world.isStatic) {
            AttributeInstance attributeInstance = this.getAttributeInstance(GenericAttributes.d);
            attributeInstance.b(br);
            if (this.target != null) {
                attributeInstance.a(br);
            }
        }
        this.bu = this.target;
        if (this.soundDelay > 0 && --this.soundDelay == 0) {
            this.makeSound("mob.zombiepig.zpigangry", this.ba() * 2.0f, ((this.random.nextFloat() - this.random.nextFloat()) * 0.2f + 1.0f) * 1.8f);
        }
        super.l_();
    }

    @Override
    public boolean canSpawn() {
        return this.world.difficulty > 0 && this.world.b(this.boundingBox) && this.world.getCubes(this, this.boundingBox).isEmpty() && !this.world.containsLiquid(this.boundingBox);
    }

    @Override
    public void b(NBTTagCompound nBTTagCompound) {
        super.b(nBTTagCompound);
        nBTTagCompound.setShort("Anger", (short)this.angerLevel);
    }

    @Override
    public void a(NBTTagCompound nBTTagCompound) {
        super.a(nBTTagCompound);
        this.angerLevel = nBTTagCompound.getShort("Anger");
    }

    @Override
    protected Entity findTarget() {
        if (this.angerLevel == 0) {
            return null;
        }
        return super.findTarget();
    }

    @Override
    public boolean damageEntity(DamageSource damageSource, float f) {
        if (this.isInvulnerable()) {
            return false;
        }
        Entity entity = damageSource.getEntity();
        if (entity instanceof EntityHuman) {
            List list = this.world.getEntities(this, this.boundingBox.grow(32.0, 32.0, 32.0));
            for (int i = 0; i < list.size(); ++i) {
                Entity entity2 = (Entity)list.get(i);
                if (!(entity2 instanceof EntityPigZombie)) continue;
                EntityPigZombie entityPigZombie = (EntityPigZombie)entity2;
                entityPigZombie.c(entity);
            }
            this.c(entity);
        }
        return super.damageEntity(damageSource, f);
    }

    private void c(Entity entity) {
        this.target = entity;
        this.angerLevel = 400 + this.random.nextInt(400);
        this.soundDelay = this.random.nextInt(40);
    }

    @Override
    protected String r() {
        return "mob.zombiepig.zpig";
    }

    @Override
    protected String aO() {
        return "mob.zombiepig.zpighurt";
    }

    @Override
    protected String aP() {
        return "mob.zombiepig.zpigdeath";
    }

    @Override
    protected void dropDeathLoot(boolean bl, int n) {
        int n2;
        int n3 = this.random.nextInt(2 + n);
        for (n2 = 0; n2 < n3; ++n2) {
            this.b(Item.ROTTEN_FLESH.id, 1);
        }
        n3 = this.random.nextInt(2 + n);
        for (n2 = 0; n2 < n3; ++n2) {
            this.b(Item.GOLD_NUGGET.id, 1);
        }
    }

    @Override
    public boolean a(EntityHuman entityHuman) {
        return false;
    }

    @Override
    protected void l(int n) {
        this.b(Item.GOLD_INGOT.id, 1);
    }

    @Override
    protected int getLootId() {
        return Item.ROTTEN_FLESH.id;
    }

    @Override
    protected void bw() {
        this.setEquipment(0, new ItemStack(Item.GOLD_SWORD));
    }

    @Override
    public GroupDataEntity a(GroupDataEntity groupDataEntity) {
        super.a(groupDataEntity);
        this.setVillager(false);
        return groupDataEntity;
    }
}

