/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import net.minecraft.server.AchievementList;
import net.minecraft.server.EntityAgeable;
import net.minecraft.server.EntityAnimal;
import net.minecraft.server.EntityHuman;
import net.minecraft.server.EntityLightning;
import net.minecraft.server.EntityPigZombie;
import net.minecraft.server.GenericAttributes;
import net.minecraft.server.Item;
import net.minecraft.server.ItemStack;
import net.minecraft.server.NBTTagCompound;
import net.minecraft.server.PathfinderGoalBreed;
import net.minecraft.server.PathfinderGoalFloat;
import net.minecraft.server.PathfinderGoalFollowParent;
import net.minecraft.server.PathfinderGoalLookAtPlayer;
import net.minecraft.server.PathfinderGoalPanic;
import net.minecraft.server.PathfinderGoalPassengerCarrotStick;
import net.minecraft.server.PathfinderGoalRandomLookaround;
import net.minecraft.server.PathfinderGoalRandomStroll;
import net.minecraft.server.PathfinderGoalTempt;
import net.minecraft.server.World;

public class EntityPig
extends EntityAnimal {
    private final PathfinderGoalPassengerCarrotStick bp;

    public EntityPig(World world) {
        super(world);
        this.a(0.9f, 0.9f);
        this.getNavigation().a(true);
        this.goalSelector.a(0, new PathfinderGoalFloat(this));
        this.goalSelector.a(1, new PathfinderGoalPanic(this, 1.25));
        this.bp = new PathfinderGoalPassengerCarrotStick(this, 0.3f);
        this.goalSelector.a(2, this.bp);
        this.goalSelector.a(3, new PathfinderGoalBreed(this, 1.0));
        this.goalSelector.a(4, new PathfinderGoalTempt(this, 1.2, Item.CARROT_STICK.id, false));
        this.goalSelector.a(4, new PathfinderGoalTempt(this, 1.2, Item.CARROT.id, false));
        this.goalSelector.a(5, new PathfinderGoalFollowParent(this, 1.1));
        this.goalSelector.a(6, new PathfinderGoalRandomStroll(this, 1.0));
        this.goalSelector.a(7, new PathfinderGoalLookAtPlayer(this, EntityHuman.class, 6.0f));
        this.goalSelector.a(8, new PathfinderGoalRandomLookaround(this));
    }

    @Override
    public boolean bf() {
        return true;
    }

    @Override
    protected void az() {
        super.az();
        this.getAttributeInstance(GenericAttributes.a).setValue(10.0);
        this.getAttributeInstance(GenericAttributes.d).setValue(0.25);
    }

    @Override
    protected void bi() {
        super.bi();
    }

    @Override
    public boolean by() {
        ItemStack itemStack = ((EntityHuman)this.passenger).aZ();
        return itemStack != null && itemStack.id == Item.CARROT_STICK.id;
    }

    @Override
    protected void a() {
        super.a();
        this.datawatcher.a(16, (Object)0);
    }

    @Override
    public void b(NBTTagCompound nBTTagCompound) {
        super.b(nBTTagCompound);
        nBTTagCompound.setBoolean("Saddle", this.hasSaddle());
    }

    @Override
    public void a(NBTTagCompound nBTTagCompound) {
        super.a(nBTTagCompound);
        this.setSaddle(nBTTagCompound.getBoolean("Saddle"));
    }

    @Override
    protected String r() {
        return "mob.pig.say";
    }

    @Override
    protected String aO() {
        return "mob.pig.say";
    }

    @Override
    protected String aP() {
        return "mob.pig.death";
    }

    @Override
    protected void a(int n, int n2, int n3, int n4) {
        this.makeSound("mob.pig.step", 0.15f, 1.0f);
    }

    @Override
    public boolean a(EntityHuman entityHuman) {
        if (!super.a(entityHuman)) {
            if (this.hasSaddle() && !this.world.isStatic && (this.passenger == null || this.passenger == entityHuman)) {
                entityHuman.mount(this);
                return true;
            }
            return false;
        }
        return true;
    }

    @Override
    protected int getLootId() {
        if (this.isBurning()) {
            return Item.GRILLED_PORK.id;
        }
        return Item.PORK.id;
    }

    @Override
    protected void dropDeathLoot(boolean bl, int n) {
        int n2 = this.random.nextInt(3) + 1 + this.random.nextInt(1 + n);
        for (int i = 0; i < n2; ++i) {
            if (this.isBurning()) {
                this.b(Item.GRILLED_PORK.id, 1);
                continue;
            }
            this.b(Item.PORK.id, 1);
        }
        if (this.hasSaddle()) {
            this.b(Item.SADDLE.id, 1);
        }
    }

    public boolean hasSaddle() {
        return (this.datawatcher.getByte(16) & 1) != 0;
    }

    public void setSaddle(boolean bl) {
        if (bl) {
            this.datawatcher.watch(16, (byte)1);
        } else {
            this.datawatcher.watch(16, (byte)0);
        }
    }

    @Override
    public void a(EntityLightning entityLightning) {
        if (this.world.isStatic) {
            return;
        }
        EntityPigZombie entityPigZombie = new EntityPigZombie(this.world);
        entityPigZombie.setPositionRotation(this.locX, this.locY, this.locZ, this.yaw, this.pitch);
        this.world.addEntity(entityPigZombie);
        this.die();
    }

    @Override
    protected void b(float f) {
        super.b(f);
        if (f > 5.0f && this.passenger instanceof EntityHuman) {
            ((EntityHuman)this.passenger).a(AchievementList.u);
        }
    }

    public EntityPig b(EntityAgeable entityAgeable) {
        return new EntityPig(this.world);
    }

    @Override
    public boolean c(ItemStack itemStack) {
        return itemStack != null && itemStack.id == Item.CARROT.id;
    }

    public PathfinderGoalPassengerCarrotStick bU() {
        return this.bp;
    }

    @Override
    public /* synthetic */ EntityAgeable createChild(EntityAgeable entityAgeable) {
        return this.b(entityAgeable);
    }
}

