/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import net.minecraft.server.Block;
import net.minecraft.server.DamageSource;
import net.minecraft.server.Entity;
import net.minecraft.server.EntityAgeable;
import net.minecraft.server.EntityAnimal;
import net.minecraft.server.EntityChicken;
import net.minecraft.server.EntityHuman;
import net.minecraft.server.EntityTameableAnimal;
import net.minecraft.server.GenericAttributes;
import net.minecraft.server.GroupDataEntity;
import net.minecraft.server.Item;
import net.minecraft.server.ItemStack;
import net.minecraft.server.MathHelper;
import net.minecraft.server.NBTTagCompound;
import net.minecraft.server.PathfinderGoalAvoidPlayer;
import net.minecraft.server.PathfinderGoalBreed;
import net.minecraft.server.PathfinderGoalFloat;
import net.minecraft.server.PathfinderGoalFollowOwner;
import net.minecraft.server.PathfinderGoalJumpOnBlock;
import net.minecraft.server.PathfinderGoalLeapAtTarget;
import net.minecraft.server.PathfinderGoalLookAtPlayer;
import net.minecraft.server.PathfinderGoalOcelotAttack;
import net.minecraft.server.PathfinderGoalRandomStroll;
import net.minecraft.server.PathfinderGoalRandomTargetNonTamed;
import net.minecraft.server.PathfinderGoalTempt;
import net.minecraft.server.World;

public class EntityOcelot
extends EntityTameableAnimal {
    private PathfinderGoalTempt bq;

    public EntityOcelot(World world) {
        super(world);
        this.a(0.6f, 0.8f);
        this.getNavigation().a(true);
        this.goalSelector.a(1, new PathfinderGoalFloat(this));
        this.goalSelector.a(2, this.bp);
        this.bq = new PathfinderGoalTempt(this, 0.6, Item.RAW_FISH.id, true);
        this.goalSelector.a(3, this.bq);
        this.goalSelector.a(4, new PathfinderGoalAvoidPlayer(this, EntityHuman.class, 16.0f, 0.8, 1.33));
        this.goalSelector.a(5, new PathfinderGoalFollowOwner(this, 1.0, 10.0f, 5.0f));
        this.goalSelector.a(6, new PathfinderGoalJumpOnBlock(this, 1.33));
        this.goalSelector.a(7, new PathfinderGoalLeapAtTarget(this, 0.3f));
        this.goalSelector.a(8, new PathfinderGoalOcelotAttack(this));
        this.goalSelector.a(9, new PathfinderGoalBreed(this, 0.8));
        this.goalSelector.a(10, new PathfinderGoalRandomStroll(this, 0.8));
        this.goalSelector.a(11, new PathfinderGoalLookAtPlayer(this, EntityHuman.class, 10.0f));
        this.targetSelector.a(1, new PathfinderGoalRandomTargetNonTamed(this, EntityChicken.class, 750, false));
    }

    @Override
    protected void a() {
        super.a();
        this.datawatcher.a(18, (Object)0);
    }

    @Override
    public void bk() {
        if (this.getControllerMove().a()) {
            double d = this.getControllerMove().b();
            if (d == 0.6) {
                this.setSneaking(true);
                this.setSprinting(false);
            } else if (d == 1.33) {
                this.setSneaking(false);
                this.setSprinting(true);
            } else {
                this.setSneaking(false);
                this.setSprinting(false);
            }
        } else {
            this.setSneaking(false);
            this.setSprinting(false);
        }
    }

    @Override
    protected boolean isTypeNotPersistent() {
        return !this.isTamed() && this.ticksLived > 2400;
    }

    @Override
    public boolean bf() {
        return true;
    }

    @Override
    protected void az() {
        super.az();
        this.getAttributeInstance(GenericAttributes.a).setValue(10.0);
        this.getAttributeInstance(GenericAttributes.d).setValue(0.3f);
    }

    @Override
    protected void b(float f) {
    }

    @Override
    public void b(NBTTagCompound nBTTagCompound) {
        super.b(nBTTagCompound);
        nBTTagCompound.setInt("CatType", this.getCatType());
    }

    @Override
    public void a(NBTTagCompound nBTTagCompound) {
        super.a(nBTTagCompound);
        this.setCatType(nBTTagCompound.getInt("CatType"));
    }

    @Override
    protected String r() {
        if (this.isTamed()) {
            if (this.bY()) {
                return "mob.cat.purr";
            }
            if (this.random.nextInt(4) == 0) {
                return "mob.cat.purreow";
            }
            return "mob.cat.meow";
        }
        return "";
    }

    @Override
    protected String aO() {
        return "mob.cat.hitt";
    }

    @Override
    protected String aP() {
        return "mob.cat.hitt";
    }

    @Override
    protected float ba() {
        return 0.4f;
    }

    @Override
    protected int getLootId() {
        return Item.LEATHER.id;
    }

    @Override
    public boolean m(Entity entity) {
        return entity.damageEntity(DamageSource.mobAttack(this), 3.0f);
    }

    @Override
    public boolean damageEntity(DamageSource damageSource, float f) {
        if (this.isInvulnerable()) {
            return false;
        }
        this.bp.setSitting(false);
        return super.damageEntity(damageSource, f);
    }

    @Override
    protected void dropDeathLoot(boolean bl, int n) {
    }

    @Override
    public boolean a(EntityHuman entityHuman) {
        ItemStack itemStack = entityHuman.inventory.getItemInHand();
        if (this.isTamed()) {
            if (entityHuman.getName().equalsIgnoreCase(this.getOwnerName()) && !this.world.isStatic && !this.c(itemStack)) {
                this.bp.setSitting(!this.isSitting());
            }
        } else if (this.bq.f() && itemStack != null && itemStack.id == Item.RAW_FISH.id && entityHuman.e(this) < 9.0) {
            if (!entityHuman.abilities.canInstantlyBuild) {
                --itemStack.count;
            }
            if (itemStack.count <= 0) {
                entityHuman.inventory.setItem(entityHuman.inventory.itemInHandIndex, null);
            }
            if (!this.world.isStatic) {
                if (this.random.nextInt(3) == 0) {
                    this.setTamed(true);
                    this.setCatType(1 + this.world.random.nextInt(3));
                    this.setOwnerName(entityHuman.getName());
                    this.i(true);
                    this.bp.setSitting(true);
                    this.world.broadcastEntityEffect(this, (byte)7);
                } else {
                    this.i(false);
                    this.world.broadcastEntityEffect(this, (byte)6);
                }
            }
            return true;
        }
        return super.a(entityHuman);
    }

    public EntityOcelot b(EntityAgeable entityAgeable) {
        EntityOcelot entityOcelot = new EntityOcelot(this.world);
        if (this.isTamed()) {
            entityOcelot.setOwnerName(this.getOwnerName());
            entityOcelot.setTamed(true);
            entityOcelot.setCatType(this.getCatType());
        }
        return entityOcelot;
    }

    @Override
    public boolean c(ItemStack itemStack) {
        return itemStack != null && itemStack.id == Item.RAW_FISH.id;
    }

    @Override
    public boolean mate(EntityAnimal entityAnimal) {
        if (entityAnimal == this) {
            return false;
        }
        if (!this.isTamed()) {
            return false;
        }
        if (!(entityAnimal instanceof EntityOcelot)) {
            return false;
        }
        EntityOcelot entityOcelot = (EntityOcelot)entityAnimal;
        if (!entityOcelot.isTamed()) {
            return false;
        }
        return this.bY() && entityOcelot.bY();
    }

    public int getCatType() {
        return this.datawatcher.getByte(18);
    }

    public void setCatType(int n) {
        this.datawatcher.watch(18, (byte)n);
    }

    @Override
    public boolean canSpawn() {
        if (this.world.random.nextInt(3) == 0) {
            return false;
        }
        if (this.world.b(this.boundingBox) && this.world.getCubes(this, this.boundingBox).isEmpty() && !this.world.containsLiquid(this.boundingBox)) {
            int n = MathHelper.floor(this.locX);
            int n2 = MathHelper.floor(this.boundingBox.b);
            int n3 = MathHelper.floor(this.locZ);
            if (n2 < 63) {
                return false;
            }
            int n4 = this.world.getTypeId(n, n2 - 1, n3);
            if (n4 == Block.GRASS.id || n4 == Block.LEAVES.id) {
                return true;
            }
        }
        return false;
    }

    @Override
    public String getLocalizedName() {
        if (this.hasCustomName()) {
            return this.getCustomName();
        }
        if (this.isTamed()) {
            return "entity.Cat.name";
        }
        return super.getLocalizedName();
    }

    @Override
    public GroupDataEntity a(GroupDataEntity groupDataEntity) {
        groupDataEntity = super.a(groupDataEntity);
        if (this.world.random.nextInt(7) == 0) {
            for (int i = 0; i < 2; ++i) {
                EntityOcelot entityOcelot = new EntityOcelot(this.world);
                entityOcelot.setPositionRotation(this.locX, this.locY, this.locZ, this.yaw, 0.0f);
                entityOcelot.setAge(-24000);
                this.world.addEntity(entityOcelot);
            }
        }
        return groupDataEntity;
    }

    @Override
    public /* synthetic */ EntityAgeable createChild(EntityAgeable entityAgeable) {
        return this.b(entityAgeable);
    }
}

