/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import net.minecraft.server.Block;
import net.minecraft.server.BlockMinecartTrackAbstract;
import net.minecraft.server.DamageSource;
import net.minecraft.server.EntityMinecartAbstract;
import net.minecraft.server.Explosion;
import net.minecraft.server.ItemStack;
import net.minecraft.server.NBTTagCompound;
import net.minecraft.server.World;

public class EntityMinecartTNT
extends EntityMinecartAbstract {
    private int fuse = -1;

    public EntityMinecartTNT(World world) {
        super(world);
    }

    public EntityMinecartTNT(World world, double d, double d2, double d3) {
        super(world, d, d2, d3);
    }

    @Override
    public int getType() {
        return 3;
    }

    @Override
    public Block n() {
        return Block.TNT;
    }

    @Override
    public void l_() {
        double d;
        super.l_();
        if (this.fuse > 0) {
            --this.fuse;
            this.world.addParticle("smoke", this.locX, this.locY + 0.5, this.locZ, 0.0, 0.0, 0.0);
        } else if (this.fuse == 0) {
            this.c(this.motX * this.motX + this.motZ * this.motZ);
        }
        if (this.positionChanged && (d = this.motX * this.motX + this.motZ * this.motZ) >= (double)0.01f) {
            this.c(d);
        }
    }

    @Override
    public void a(DamageSource damageSource) {
        super.a(damageSource);
        double d = this.motX * this.motX + this.motZ * this.motZ;
        if (!damageSource.c()) {
            this.a(new ItemStack(Block.TNT, 1), 0.0f);
        }
        if (damageSource.m() || damageSource.c() || d >= (double)0.01f) {
            this.c(d);
        }
    }

    protected void c(double d) {
        if (!this.world.isStatic) {
            double d2 = Math.sqrt(d);
            if (d2 > 5.0) {
                d2 = 5.0;
            }
            this.world.explode(this, this.locX, this.locY, this.locZ, (float)(4.0 + this.random.nextDouble() * 1.5 * d2), true);
            this.die();
        }
    }

    @Override
    protected void b(float f) {
        if (f >= 3.0f) {
            float f2 = f / 10.0f;
            this.c(f2 * f2);
        }
        super.b(f);
    }

    @Override
    public void a(int n, int n2, int n3, boolean bl) {
        if (bl && this.fuse < 0) {
            this.d();
        }
    }

    public void d() {
        this.fuse = 80;
        if (!this.world.isStatic) {
            this.world.broadcastEntityEffect(this, (byte)10);
            this.world.makeSound(this, "random.fuse", 1.0f, 1.0f);
        }
    }

    public boolean u() {
        return this.fuse > -1;
    }

    @Override
    public float a(Explosion explosion, World world, int n, int n2, int n3, Block block) {
        if (this.u() && (BlockMinecartTrackAbstract.e_(block.id) || BlockMinecartTrackAbstract.d_(world, n, n2 + 1, n3))) {
            return 0.0f;
        }
        return super.a(explosion, world, n, n2, n3, block);
    }

    @Override
    public boolean a(Explosion explosion, World world, int n, int n2, int n3, int n4, float f) {
        if (this.u() && (BlockMinecartTrackAbstract.e_(n4) || BlockMinecartTrackAbstract.d_(world, n, n2 + 1, n3))) {
            return false;
        }
        return super.a(explosion, world, n, n2, n3, n4, f);
    }

    @Override
    protected void a(NBTTagCompound nBTTagCompound) {
        super.a(nBTTagCompound);
        if (nBTTagCompound.hasKey("TNTFuse")) {
            this.fuse = nBTTagCompound.getInt("TNTFuse");
        }
    }

    @Override
    protected void b(NBTTagCompound nBTTagCompound) {
        super.b(nBTTagCompound);
        nBTTagCompound.setInt("TNTFuse", this.fuse);
    }
}

