/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import net.minecraft.server.Container;
import net.minecraft.server.DamageSource;
import net.minecraft.server.EntityHuman;
import net.minecraft.server.EntityItem;
import net.minecraft.server.EntityMinecartAbstract;
import net.minecraft.server.IInventory;
import net.minecraft.server.ItemStack;
import net.minecraft.server.NBTTagCompound;
import net.minecraft.server.NBTTagList;
import net.minecraft.server.World;

public abstract class EntityMinecartContainer
extends EntityMinecartAbstract
implements IInventory {
    private ItemStack[] items = new ItemStack[36];
    private boolean b = true;

    public EntityMinecartContainer(World world) {
        super(world);
    }

    public EntityMinecartContainer(World world, double d, double d2, double d3) {
        super(world, d, d2, d3);
    }

    @Override
    public void a(DamageSource damageSource) {
        super.a(damageSource);
        for (int i = 0; i < this.getSize(); ++i) {
            ItemStack itemStack = this.getItem(i);
            if (itemStack == null) continue;
            float f = this.random.nextFloat() * 0.8f + 0.1f;
            float f2 = this.random.nextFloat() * 0.8f + 0.1f;
            float f3 = this.random.nextFloat() * 0.8f + 0.1f;
            while (itemStack.count > 0) {
                int n = this.random.nextInt(21) + 10;
                if (n > itemStack.count) {
                    n = itemStack.count;
                }
                itemStack.count -= n;
                EntityItem entityItem = new EntityItem(this.world, this.locX + (double)f, this.locY + (double)f2, this.locZ + (double)f3, new ItemStack(itemStack.id, n, itemStack.getData()));
                float f4 = 0.05f;
                entityItem.motX = (float)this.random.nextGaussian() * f4;
                entityItem.motY = (float)this.random.nextGaussian() * f4 + 0.2f;
                entityItem.motZ = (float)this.random.nextGaussian() * f4;
                this.world.addEntity(entityItem);
            }
        }
    }

    @Override
    public ItemStack getItem(int n) {
        return this.items[n];
    }

    @Override
    public ItemStack splitStack(int n, int n2) {
        if (this.items[n] != null) {
            if (this.items[n].count <= n2) {
                ItemStack itemStack = this.items[n];
                this.items[n] = null;
                return itemStack;
            }
            ItemStack itemStack = this.items[n].a(n2);
            if (this.items[n].count == 0) {
                this.items[n] = null;
            }
            return itemStack;
        }
        return null;
    }

    @Override
    public ItemStack splitWithoutUpdate(int n) {
        if (this.items[n] != null) {
            ItemStack itemStack = this.items[n];
            this.items[n] = null;
            return itemStack;
        }
        return null;
    }

    @Override
    public void setItem(int n, ItemStack itemStack) {
        this.items[n] = itemStack;
        if (itemStack != null && itemStack.count > this.getMaxStackSize()) {
            itemStack.count = this.getMaxStackSize();
        }
    }

    @Override
    public void update() {
    }

    @Override
    public boolean a(EntityHuman entityHuman) {
        if (this.dead) {
            return false;
        }
        return !(entityHuman.e(this) > 64.0);
    }

    @Override
    public void startOpen() {
    }

    @Override
    public void g() {
    }

    @Override
    public boolean b(int n, ItemStack itemStack) {
        return true;
    }

    @Override
    public String getName() {
        return this.c() ? this.t() : "container.minecart";
    }

    @Override
    public int getMaxStackSize() {
        return 64;
    }

    @Override
    public void b(int n) {
        this.b = false;
        super.b(n);
    }

    @Override
    public void die() {
        if (this.b) {
            for (int i = 0; i < this.getSize(); ++i) {
                ItemStack itemStack = this.getItem(i);
                if (itemStack == null) continue;
                float f = this.random.nextFloat() * 0.8f + 0.1f;
                float f2 = this.random.nextFloat() * 0.8f + 0.1f;
                float f3 = this.random.nextFloat() * 0.8f + 0.1f;
                while (itemStack.count > 0) {
                    int n = this.random.nextInt(21) + 10;
                    if (n > itemStack.count) {
                        n = itemStack.count;
                    }
                    itemStack.count -= n;
                    EntityItem entityItem = new EntityItem(this.world, this.locX + (double)f, this.locY + (double)f2, this.locZ + (double)f3, new ItemStack(itemStack.id, n, itemStack.getData()));
                    if (itemStack.hasTag()) {
                        entityItem.getItemStack().setTag((NBTTagCompound)itemStack.getTag().clone());
                    }
                    float f4 = 0.05f;
                    entityItem.motX = (float)this.random.nextGaussian() * f4;
                    entityItem.motY = (float)this.random.nextGaussian() * f4 + 0.2f;
                    entityItem.motZ = (float)this.random.nextGaussian() * f4;
                    this.world.addEntity(entityItem);
                }
            }
        }
        super.die();
    }

    @Override
    protected void b(NBTTagCompound nBTTagCompound) {
        super.b(nBTTagCompound);
        NBTTagList nBTTagList = new NBTTagList();
        for (int i = 0; i < this.items.length; ++i) {
            if (this.items[i] == null) continue;
            NBTTagCompound nBTTagCompound2 = new NBTTagCompound();
            nBTTagCompound2.setByte("Slot", (byte)i);
            this.items[i].save(nBTTagCompound2);
            nBTTagList.add(nBTTagCompound2);
        }
        nBTTagCompound.set("Items", nBTTagList);
    }

    @Override
    protected void a(NBTTagCompound nBTTagCompound) {
        super.a(nBTTagCompound);
        NBTTagList nBTTagList = nBTTagCompound.getList("Items");
        this.items = new ItemStack[this.getSize()];
        for (int i = 0; i < nBTTagList.size(); ++i) {
            NBTTagCompound nBTTagCompound2 = (NBTTagCompound)nBTTagList.get(i);
            int n = nBTTagCompound2.getByte("Slot") & 0xFF;
            if (n < 0 || n >= this.items.length) continue;
            this.items[n] = ItemStack.createStack(nBTTagCompound2);
        }
    }

    @Override
    public boolean c(EntityHuman entityHuman) {
        if (!this.world.isStatic) {
            entityHuman.openContainer(this);
        }
        return true;
    }

    @Override
    protected void h() {
        int n = 15 - Container.b(this);
        float f = 0.98f + (float)n * 0.001f;
        this.motX *= (double)f;
        this.motY *= 0.0;
        this.motZ *= (double)f;
    }
}

