/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import java.util.List;
import net.minecraft.server.AxisAlignedBB;
import net.minecraft.server.Block;
import net.minecraft.server.BlockMinecartTrackAbstract;
import net.minecraft.server.DamageSource;
import net.minecraft.server.Entity;
import net.minecraft.server.EntityHuman;
import net.minecraft.server.EntityIronGolem;
import net.minecraft.server.EntityLiving;
import net.minecraft.server.EntityMinecartChest;
import net.minecraft.server.EntityMinecartFurnace;
import net.minecraft.server.EntityMinecartHopper;
import net.minecraft.server.EntityMinecartMobSpawner;
import net.minecraft.server.EntityMinecartRideable;
import net.minecraft.server.EntityMinecartTNT;
import net.minecraft.server.IUpdatePlayerListBox;
import net.minecraft.server.Item;
import net.minecraft.server.ItemStack;
import net.minecraft.server.MathHelper;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.NBTTagCompound;
import net.minecraft.server.Vec3D;
import net.minecraft.server.World;
import net.minecraft.server.WorldServer;

public abstract class EntityMinecartAbstract
extends Entity {
    private boolean a;
    private final IUpdatePlayerListBox b;
    private String c;
    private static final int[][][] matrix = new int[][][]{new int[][]{{0, 0, -1}, {0, 0, 1}}, new int[][]{{-1, 0, 0}, {1, 0, 0}}, new int[][]{{-1, -1, 0}, {1, 0, 0}}, new int[][]{{-1, 0, 0}, {1, -1, 0}}, new int[][]{{0, 0, -1}, {0, -1, 1}}, new int[][]{{0, -1, -1}, {0, 0, 1}}, new int[][]{{0, 0, 1}, {1, 0, 0}}, new int[][]{{0, 0, 1}, {-1, 0, 0}}, new int[][]{{0, 0, -1}, {-1, 0, 0}}, new int[][]{{0, 0, -1}, {1, 0, 0}}};
    private int e;
    private double f;
    private double g;
    private double h;
    private double i;
    private double j;

    public EntityMinecartAbstract(World world) {
        super(world);
        this.m = true;
        this.a(0.98f, 0.7f);
        this.height = this.length / 2.0f;
        this.b = world != null ? world.a(this) : null;
    }

    public static EntityMinecartAbstract a(World world, double d, double d2, double d3, int n) {
        switch (n) {
            case 1: {
                return new EntityMinecartChest(world, d, d2, d3);
            }
            case 2: {
                return new EntityMinecartFurnace(world, d, d2, d3);
            }
            case 3: {
                return new EntityMinecartTNT(world, d, d2, d3);
            }
            case 4: {
                return new EntityMinecartMobSpawner(world, d, d2, d3);
            }
            case 5: {
                return new EntityMinecartHopper(world, d, d2, d3);
            }
        }
        return new EntityMinecartRideable(world, d, d2, d3);
    }

    @Override
    protected boolean e_() {
        return false;
    }

    @Override
    protected void a() {
        this.datawatcher.a(17, new Integer(0));
        this.datawatcher.a(18, new Integer(1));
        this.datawatcher.a(19, new Float(0.0f));
        this.datawatcher.a(20, new Integer(0));
        this.datawatcher.a(21, new Integer(6));
        this.datawatcher.a(22, (Object)0);
    }

    @Override
    public AxisAlignedBB g(Entity entity) {
        if (entity.M()) {
            return entity.boundingBox;
        }
        return null;
    }

    @Override
    public AxisAlignedBB E() {
        return null;
    }

    @Override
    public boolean M() {
        return true;
    }

    public EntityMinecartAbstract(World world, double d, double d2, double d3) {
        this(world);
        this.setPosition(d, d2, d3);
        this.motX = 0.0;
        this.motY = 0.0;
        this.motZ = 0.0;
        this.lastX = d;
        this.lastY = d2;
        this.lastZ = d3;
    }

    @Override
    public double Y() {
        return (double)this.length * 0.0 - (double)0.3f;
    }

    @Override
    public boolean damageEntity(DamageSource damageSource, float f) {
        boolean bl;
        if (this.world.isStatic || this.dead) {
            return true;
        }
        if (this.isInvulnerable()) {
            return false;
        }
        this.h(-this.k());
        this.c(10);
        this.K();
        this.setDamage(this.getDamage() + f * 10.0f);
        boolean bl2 = bl = damageSource.getEntity() instanceof EntityHuman && ((EntityHuman)damageSource.getEntity()).abilities.canInstantlyBuild;
        if (bl || this.getDamage() > 40.0f) {
            if (this.passenger != null) {
                this.passenger.mount(this);
            }
            if (!bl || this.c()) {
                this.a(damageSource);
            } else {
                this.die();
            }
        }
        return true;
    }

    public void a(DamageSource damageSource) {
        this.die();
        ItemStack itemStack = new ItemStack(Item.MINECART, 1);
        if (this.c != null) {
            itemStack.c(this.c);
        }
        this.a(itemStack, 0.0f);
    }

    @Override
    public boolean L() {
        return !this.dead;
    }

    @Override
    public void die() {
        super.die();
        if (this.b != null) {
            this.b.a();
        }
    }

    @Override
    public void l_() {
        double d;
        int n;
        int n2;
        if (this.b != null) {
            this.b.a();
        }
        if (this.j() > 0) {
            this.c(this.j() - 1);
        }
        if (this.getDamage() > 0.0f) {
            this.setDamage(this.getDamage() - 1.0f);
        }
        if (this.locY < -64.0) {
            this.C();
        }
        if (!this.world.isStatic && this.world instanceof WorldServer) {
            this.world.methodProfiler.a("portal");
            MinecraftServer minecraftServer = ((WorldServer)this.world).getMinecraftServer();
            n2 = this.z();
            if (this.ap) {
                if (minecraftServer.getAllowNether()) {
                    if (this.vehicle == null && this.aq++ >= n2) {
                        this.aq = n2;
                        this.portalCooldown = this.ac();
                        n = this.world.worldProvider.dimension == -1 ? 0 : -1;
                        this.b(n);
                    }
                    this.ap = false;
                }
            } else {
                if (this.aq > 0) {
                    this.aq -= 4;
                }
                if (this.aq < 0) {
                    this.aq = 0;
                }
            }
            if (this.portalCooldown > 0) {
                --this.portalCooldown;
            }
            this.world.methodProfiler.b();
        }
        if (this.world.isStatic) {
            if (this.e > 0) {
                double d2 = this.locX + (this.f - this.locX) / (double)this.e;
                double d3 = this.locY + (this.g - this.locY) / (double)this.e;
                double d4 = this.locZ + (this.h - this.locZ) / (double)this.e;
                double d5 = MathHelper.g(this.i - (double)this.yaw);
                this.yaw = (float)((double)this.yaw + d5 / (double)this.e);
                this.pitch = (float)((double)this.pitch + (this.j - (double)this.pitch) / (double)this.e);
                --this.e;
                this.setPosition(d2, d3, d4);
                this.b(this.yaw, this.pitch);
            } else {
                this.setPosition(this.locX, this.locY, this.locZ);
                this.b(this.yaw, this.pitch);
            }
            return;
        }
        this.lastX = this.locX;
        this.lastY = this.locY;
        this.lastZ = this.locZ;
        this.motY -= (double)0.04f;
        int n3 = MathHelper.floor(this.locX);
        if (BlockMinecartTrackAbstract.d_(this.world, n3, (n2 = MathHelper.floor(this.locY)) - 1, n = MathHelper.floor(this.locZ))) {
            --n2;
        }
        double d6 = 0.4;
        double d7 = 0.0078125;
        int n4 = this.world.getTypeId(n3, n2, n);
        if (BlockMinecartTrackAbstract.e_(n4)) {
            int n5 = this.world.getData(n3, n2, n);
            this.a(n3, n2, n, d6, d7, n4, n5);
            if (n4 == Block.ACTIVATOR_RAIL.id) {
                this.a(n3, n2, n, (n5 & 8) != 0);
            }
        } else {
            this.b(d6);
        }
        this.D();
        this.pitch = 0.0f;
        double d8 = this.lastX - this.locX;
        double d9 = this.lastZ - this.locZ;
        if (d8 * d8 + d9 * d9 > 0.001) {
            this.yaw = (float)(Math.atan2(d9, d8) * 180.0 / Math.PI);
            if (this.a) {
                this.yaw += 180.0f;
            }
        }
        if ((d = (double)MathHelper.g(this.yaw - this.lastYaw)) < -170.0 || d >= 170.0) {
            this.yaw += 180.0f;
            this.a = !this.a;
        }
        this.b(this.yaw, this.pitch);
        List list = this.world.getEntities(this, this.boundingBox.grow(0.2f, 0.0, 0.2f));
        if (list != null && !list.isEmpty()) {
            for (int i = 0; i < list.size(); ++i) {
                Entity entity = (Entity)list.get(i);
                if (entity == this.passenger || !entity.M() || !(entity instanceof EntityMinecartAbstract)) continue;
                entity.collide(this);
            }
        }
        if (this.passenger != null && this.passenger.dead) {
            if (this.passenger.vehicle == this) {
                this.passenger.vehicle = null;
            }
            this.passenger = null;
        }
    }

    public void a(int n, int n2, int n3, boolean bl) {
    }

    protected void b(double d) {
        if (this.motX < -d) {
            this.motX = -d;
        }
        if (this.motX > d) {
            this.motX = d;
        }
        if (this.motZ < -d) {
            this.motZ = -d;
        }
        if (this.motZ > d) {
            this.motZ = d;
        }
        if (this.onGround) {
            this.motX *= 0.5;
            this.motY *= 0.5;
            this.motZ *= 0.5;
        }
        this.move(this.motX, this.motY, this.motZ);
        if (!this.onGround) {
            this.motX *= (double)0.95f;
            this.motY *= (double)0.95f;
            this.motZ *= (double)0.95f;
        }
    }

    protected void a(int n, int n2, int n3, double d, double d2, int n4, int n5) {
        double d3;
        double d4;
        double d5;
        double d6;
        double d7;
        double d8;
        double d9;
        this.fallDistance = 0.0f;
        Vec3D vec3D = this.a(this.locX, this.locY, this.locZ);
        this.locY = n2;
        boolean bl = false;
        boolean bl2 = false;
        if (n4 == Block.GOLDEN_RAIL.id) {
            bl = (n5 & 8) != 0;
            boolean bl3 = bl2 = !bl;
        }
        if (((BlockMinecartTrackAbstract)Block.byId[n4]).e()) {
            n5 &= 7;
        }
        if (n5 >= 2 && n5 <= 5) {
            this.locY = n2 + 1;
        }
        if (n5 == 2) {
            this.motX -= d2;
        }
        if (n5 == 3) {
            this.motX += d2;
        }
        if (n5 == 4) {
            this.motZ += d2;
        }
        if (n5 == 5) {
            this.motZ -= d2;
        }
        int[][] nArray = matrix[n5];
        double d10 = nArray[1][0] - nArray[0][0];
        double d11 = nArray[1][2] - nArray[0][2];
        double d12 = Math.sqrt(d10 * d10 + d11 * d11);
        double d13 = this.motX * d10 + this.motZ * d11;
        if (d13 < 0.0) {
            d10 = -d10;
            d11 = -d11;
        }
        if ((d9 = Math.sqrt(this.motX * this.motX + this.motZ * this.motZ)) > 2.0) {
            d9 = 2.0;
        }
        this.motX = d9 * d10 / d12;
        this.motZ = d9 * d11 / d12;
        if (this.passenger != null && this.passenger instanceof EntityLiving && (d8 = (double)((EntityLiving)this.passenger).bf) > 0.0) {
            d7 = -Math.sin(this.passenger.yaw * (float)Math.PI / 180.0f);
            d6 = Math.cos(this.passenger.yaw * (float)Math.PI / 180.0f);
            d5 = this.motX * this.motX + this.motZ * this.motZ;
            if (d5 < 0.01) {
                this.motX += d7 * 0.1;
                this.motZ += d6 * 0.1;
                bl2 = false;
            }
        }
        if (bl2) {
            d8 = Math.sqrt(this.motX * this.motX + this.motZ * this.motZ);
            if (d8 < 0.03) {
                this.motX *= 0.0;
                this.motY *= 0.0;
                this.motZ *= 0.0;
            } else {
                this.motX *= 0.5;
                this.motY *= 0.0;
                this.motZ *= 0.5;
            }
        }
        d8 = 0.0;
        d7 = (double)n + 0.5 + (double)nArray[0][0] * 0.5;
        d6 = (double)n3 + 0.5 + (double)nArray[0][2] * 0.5;
        d5 = (double)n + 0.5 + (double)nArray[1][0] * 0.5;
        double d14 = (double)n3 + 0.5 + (double)nArray[1][2] * 0.5;
        d10 = d5 - d7;
        d11 = d14 - d6;
        if (d10 == 0.0) {
            this.locX = (double)n + 0.5;
            d8 = this.locZ - (double)n3;
        } else if (d11 == 0.0) {
            this.locZ = (double)n3 + 0.5;
            d8 = this.locX - (double)n;
        } else {
            d4 = this.locX - d7;
            d3 = this.locZ - d6;
            d8 = (d4 * d10 + d3 * d11) * 2.0;
        }
        this.locX = d7 + d10 * d8;
        this.locZ = d6 + d11 * d8;
        this.setPosition(this.locX, this.locY + (double)this.height, this.locZ);
        d4 = this.motX;
        d3 = this.motZ;
        if (this.passenger != null) {
            d4 *= 0.75;
            d3 *= 0.75;
        }
        if (d4 < -d) {
            d4 = -d;
        }
        if (d4 > d) {
            d4 = d;
        }
        if (d3 < -d) {
            d3 = -d;
        }
        if (d3 > d) {
            d3 = d;
        }
        this.move(d4, 0.0, d3);
        if (nArray[0][1] != 0 && MathHelper.floor(this.locX) - n == nArray[0][0] && MathHelper.floor(this.locZ) - n3 == nArray[0][2]) {
            this.setPosition(this.locX, this.locY + (double)nArray[0][1], this.locZ);
        } else if (nArray[1][1] != 0 && MathHelper.floor(this.locX) - n == nArray[1][0] && MathHelper.floor(this.locZ) - n3 == nArray[1][2]) {
            this.setPosition(this.locX, this.locY + (double)nArray[1][1], this.locZ);
        }
        this.h();
        Vec3D vec3D2 = this.a(this.locX, this.locY, this.locZ);
        if (vec3D2 != null && vec3D != null) {
            double d15 = (vec3D.d - vec3D2.d) * 0.05;
            d9 = Math.sqrt(this.motX * this.motX + this.motZ * this.motZ);
            if (d9 > 0.0) {
                this.motX = this.motX / d9 * (d9 + d15);
                this.motZ = this.motZ / d9 * (d9 + d15);
            }
            this.setPosition(this.locX, vec3D2.d, this.locZ);
        }
        int n6 = MathHelper.floor(this.locX);
        int n7 = MathHelper.floor(this.locZ);
        if (n6 != n || n7 != n3) {
            d9 = Math.sqrt(this.motX * this.motX + this.motZ * this.motZ);
            this.motX = d9 * (double)(n6 - n);
            this.motZ = d9 * (double)(n7 - n3);
        }
        if (bl) {
            double d16 = Math.sqrt(this.motX * this.motX + this.motZ * this.motZ);
            if (d16 > 0.01) {
                double d17 = 0.06;
                this.motX += this.motX / d16 * d17;
                this.motZ += this.motZ / d16 * d17;
            } else if (n5 == 1) {
                if (this.world.u(n - 1, n2, n3)) {
                    this.motX = 0.02;
                } else if (this.world.u(n + 1, n2, n3)) {
                    this.motX = -0.02;
                }
            } else if (n5 == 0) {
                if (this.world.u(n, n2, n3 - 1)) {
                    this.motZ = 0.02;
                } else if (this.world.u(n, n2, n3 + 1)) {
                    this.motZ = -0.02;
                }
            }
        }
    }

    protected void h() {
        if (this.passenger != null) {
            this.motX *= (double)0.997f;
            this.motY *= 0.0;
            this.motZ *= (double)0.997f;
        } else {
            this.motX *= (double)0.96f;
            this.motY *= 0.0;
            this.motZ *= (double)0.96f;
        }
    }

    public Vec3D a(double d, double d2, double d3) {
        int n;
        int n2;
        int n3;
        int n4 = MathHelper.floor(d);
        if (BlockMinecartTrackAbstract.d_(this.world, n4, (n3 = MathHelper.floor(d2)) - 1, n2 = MathHelper.floor(d3))) {
            --n3;
        }
        if (BlockMinecartTrackAbstract.e_(n = this.world.getTypeId(n4, n3, n2))) {
            int n5 = this.world.getData(n4, n3, n2);
            d2 = n3;
            if (((BlockMinecartTrackAbstract)Block.byId[n]).e()) {
                n5 &= 7;
            }
            if (n5 >= 2 && n5 <= 5) {
                d2 = n3 + 1;
            }
            int[][] nArray = matrix[n5];
            double d4 = 0.0;
            double d5 = (double)n4 + 0.5 + (double)nArray[0][0] * 0.5;
            double d6 = (double)n3 + 0.5 + (double)nArray[0][1] * 0.5;
            double d7 = (double)n2 + 0.5 + (double)nArray[0][2] * 0.5;
            double d8 = (double)n4 + 0.5 + (double)nArray[1][0] * 0.5;
            double d9 = (double)n3 + 0.5 + (double)nArray[1][1] * 0.5;
            double d10 = (double)n2 + 0.5 + (double)nArray[1][2] * 0.5;
            double d11 = d8 - d5;
            double d12 = (d9 - d6) * 2.0;
            double d13 = d10 - d7;
            if (d11 == 0.0) {
                d = (double)n4 + 0.5;
                d4 = d3 - (double)n2;
            } else if (d13 == 0.0) {
                d3 = (double)n2 + 0.5;
                d4 = d - (double)n4;
            } else {
                double d14 = d - d5;
                double d15 = d3 - d7;
                d4 = (d14 * d11 + d15 * d13) * 2.0;
            }
            d = d5 + d11 * d4;
            d2 = d6 + d12 * d4;
            d3 = d7 + d13 * d4;
            if (d12 < 0.0) {
                d2 += 1.0;
            }
            if (d12 > 0.0) {
                d2 += 0.5;
            }
            return this.world.getVec3DPool().create(d, d2, d3);
        }
        return null;
    }

    @Override
    protected void a(NBTTagCompound nBTTagCompound) {
        if (nBTTagCompound.getBoolean("CustomDisplayTile")) {
            this.i(nBTTagCompound.getInt("DisplayTile"));
            this.j(nBTTagCompound.getInt("DisplayData"));
            this.k(nBTTagCompound.getInt("DisplayOffset"));
        }
        if (nBTTagCompound.hasKey("CustomName") && nBTTagCompound.getString("CustomName").length() > 0) {
            this.c = nBTTagCompound.getString("CustomName");
        }
    }

    @Override
    protected void b(NBTTagCompound nBTTagCompound) {
        if (this.s()) {
            nBTTagCompound.setBoolean("CustomDisplayTile", true);
            nBTTagCompound.setInt("DisplayTile", this.m() == null ? 0 : this.m().id);
            nBTTagCompound.setInt("DisplayData", this.o());
            nBTTagCompound.setInt("DisplayOffset", this.q());
        }
        if (this.c != null && this.c.length() > 0) {
            nBTTagCompound.setString("CustomName", this.c);
        }
    }

    @Override
    public void collide(Entity entity) {
        double d;
        double d2;
        double d3;
        if (this.world.isStatic) {
            return;
        }
        if (entity == this.passenger) {
            return;
        }
        if (entity instanceof EntityLiving && !(entity instanceof EntityHuman) && !(entity instanceof EntityIronGolem) && this.getType() == 0 && this.motX * this.motX + this.motZ * this.motZ > 0.01 && this.passenger == null && entity.vehicle == null) {
            entity.mount(this);
        }
        if ((d3 = (d2 = entity.locX - this.locX) * d2 + (d = entity.locZ - this.locZ) * d) >= (double)1.0E-4f) {
            d3 = MathHelper.sqrt(d3);
            d2 /= d3;
            d /= d3;
            double d4 = 1.0 / d3;
            if (d4 > 1.0) {
                d4 = 1.0;
            }
            d2 *= d4;
            d *= d4;
            d2 *= (double)0.1f;
            d *= (double)0.1f;
            d2 *= (double)(1.0f - this.aa);
            d *= (double)(1.0f - this.aa);
            d2 *= 0.5;
            d *= 0.5;
            if (entity instanceof EntityMinecartAbstract) {
                Vec3D vec3D;
                double d5 = entity.locX - this.locX;
                double d6 = entity.locZ - this.locZ;
                Vec3D vec3D2 = this.world.getVec3DPool().create(d5, 0.0, d6).a();
                double d7 = Math.abs(vec3D2.b(vec3D = this.world.getVec3DPool().create(MathHelper.cos(this.yaw * (float)Math.PI / 180.0f), 0.0, MathHelper.sin(this.yaw * (float)Math.PI / 180.0f)).a()));
                if (d7 < (double)0.8f) {
                    return;
                }
                double d8 = entity.motX + this.motX;
                double d9 = entity.motZ + this.motZ;
                if (((EntityMinecartAbstract)entity).getType() == 2 && this.getType() != 2) {
                    this.motX *= (double)0.2f;
                    this.motZ *= (double)0.2f;
                    this.g(entity.motX - d2, 0.0, entity.motZ - d);
                    entity.motX *= (double)0.95f;
                    entity.motZ *= (double)0.95f;
                } else if (((EntityMinecartAbstract)entity).getType() != 2 && this.getType() == 2) {
                    entity.motX *= (double)0.2f;
                    entity.motZ *= (double)0.2f;
                    entity.g(this.motX + d2, 0.0, this.motZ + d);
                    this.motX *= (double)0.95f;
                    this.motZ *= (double)0.95f;
                } else {
                    this.motX *= (double)0.2f;
                    this.motZ *= (double)0.2f;
                    this.g((d8 /= 2.0) - d2, 0.0, (d9 /= 2.0) - d);
                    entity.motX *= (double)0.2f;
                    entity.motZ *= (double)0.2f;
                    entity.g(d8 + d2, 0.0, d9 + d);
                }
            } else {
                this.g(-d2, 0.0, -d);
                entity.g(d2 / 4.0, 0.0, d / 4.0);
            }
        }
    }

    public void setDamage(float f) {
        this.datawatcher.watch(19, Float.valueOf(f));
    }

    public float getDamage() {
        return this.datawatcher.getFloat(19);
    }

    public void c(int n) {
        this.datawatcher.watch(17, n);
    }

    public int j() {
        return this.datawatcher.getInt(17);
    }

    public void h(int n) {
        this.datawatcher.watch(18, n);
    }

    public int k() {
        return this.datawatcher.getInt(18);
    }

    public abstract int getType();

    public Block m() {
        if (!this.s()) {
            return this.n();
        }
        int n = this.getDataWatcher().getInt(20) & 0xFFFF;
        return n > 0 && n < Block.byId.length ? Block.byId[n] : null;
    }

    public Block n() {
        return null;
    }

    public int o() {
        if (!this.s()) {
            return this.p();
        }
        return this.getDataWatcher().getInt(20) >> 16;
    }

    public int p() {
        return 0;
    }

    public int q() {
        if (!this.s()) {
            return this.r();
        }
        return this.getDataWatcher().getInt(21);
    }

    public int r() {
        return 6;
    }

    public void i(int n) {
        this.getDataWatcher().watch(20, n & 0xFFFF | this.o() << 16);
        this.a(true);
    }

    public void j(int n) {
        Block block = this.m();
        int n2 = block == null ? 0 : block.id;
        this.getDataWatcher().watch(20, n2 & 0xFFFF | n << 16);
        this.a(true);
    }

    public void k(int n) {
        this.getDataWatcher().watch(21, n);
        this.a(true);
    }

    public boolean s() {
        return this.getDataWatcher().getByte(22) == 1;
    }

    public void a(boolean bl) {
        this.getDataWatcher().watch(22, (byte)(bl ? 1 : 0));
    }

    public void a(String string) {
        this.c = string;
    }

    @Override
    public String getLocalizedName() {
        if (this.c != null) {
            return this.c;
        }
        return super.getLocalizedName();
    }

    public boolean c() {
        return this.c != null;
    }

    public String t() {
        return this.c;
    }
}

