/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import net.minecraft.server.AttributeInstance;
import net.minecraft.server.AttributeMapBase;
import net.minecraft.server.AttributeMapServer;
import net.minecraft.server.AttributeModifier;
import net.minecraft.server.AxisAlignedBB;
import net.minecraft.server.Block;
import net.minecraft.server.CombatTracker;
import net.minecraft.server.DamageSource;
import net.minecraft.server.EnchantmentManager;
import net.minecraft.server.Entity;
import net.minecraft.server.EntityArrow;
import net.minecraft.server.EntityExperienceOrb;
import net.minecraft.server.EntityHuman;
import net.minecraft.server.EntityItem;
import net.minecraft.server.EntityTracker;
import net.minecraft.server.EntityWolf;
import net.minecraft.server.EntityZombie;
import net.minecraft.server.EnumMonsterType;
import net.minecraft.server.GenericAttributes;
import net.minecraft.server.IAttribute;
import net.minecraft.server.ItemArmor;
import net.minecraft.server.ItemStack;
import net.minecraft.server.Material;
import net.minecraft.server.MathHelper;
import net.minecraft.server.MobEffect;
import net.minecraft.server.MobEffectList;
import net.minecraft.server.NBTBase;
import net.minecraft.server.NBTTagCompound;
import net.minecraft.server.NBTTagFloat;
import net.minecraft.server.NBTTagList;
import net.minecraft.server.NBTTagShort;
import net.minecraft.server.Packet18ArmAnimation;
import net.minecraft.server.Packet22Collect;
import net.minecraft.server.Packet5EntityEquipment;
import net.minecraft.server.PotionBrewer;
import net.minecraft.server.ScoreboardTeamBase;
import net.minecraft.server.StepSound;
import net.minecraft.server.Vec3D;
import net.minecraft.server.World;
import net.minecraft.server.WorldServer;

public abstract class EntityLiving
extends Entity {
    private static final UUID b = UUID.fromString("662A6B8D-DA3E-4C1C-8813-96EA6097278D");
    private static final AttributeModifier c = new AttributeModifier(b, "Sprinting speed boost", 0.3f, 2).a(false);
    private AttributeMapBase d;
    private final CombatTracker combatTracker = new CombatTracker(this);
    private final HashMap effects = new HashMap();
    private final ItemStack[] g = new ItemStack[5];
    public boolean au;
    public int av;
    public int aw;
    public float ax;
    public int hurtTicks;
    public int az;
    public float aA;
    public int deathTicks;
    public int attackTicks;
    public float aD;
    public float aE;
    public float aF;
    public float aG;
    public float aH;
    public int maxNoDamageTicks = 20;
    public float aJ;
    public float aK;
    public float aL;
    public float aM;
    public float aN;
    public float aO;
    public float aP;
    public float aQ;
    public float aR = 0.02f;
    protected EntityHuman killer;
    protected int lastDamageByPlayerTime;
    protected boolean aU;
    protected int aV;
    protected float aW;
    protected float aX;
    protected float aY;
    protected float aZ;
    protected float ba;
    protected int bb;
    protected float lastDamage;
    protected boolean bd;
    public float be;
    public float bf;
    protected float bg;
    protected int bh;
    protected double bi;
    protected double bj;
    protected double bk;
    protected double bl;
    protected double bm;
    private boolean updateEffects = true;
    private EntityLiving lastDamager;
    private int j;
    private EntityLiving bn;
    private int bo;
    private float bp;
    private int bq;
    private float br;

    public EntityLiving(World world) {
        super(world);
        this.az();
        this.setHealth(this.getMaxHealth());
        this.m = true;
        this.aM = (float)(Math.random() + 1.0) * 0.01f;
        this.setPosition(this.locX, this.locY, this.locZ);
        this.aL = (float)Math.random() * 12398.0f;
        this.aP = this.yaw = (float)(Math.random() * 3.1415927410125732 * 2.0);
        this.Y = 0.5f;
    }

    @Override
    protected void a() {
        this.datawatcher.a(7, (Object)0);
        this.datawatcher.a(8, (Object)0);
        this.datawatcher.a(9, (Object)0);
        this.datawatcher.a(6, Float.valueOf(1.0f));
    }

    protected void az() {
        this.aX().b(GenericAttributes.a);
        this.aX().b(GenericAttributes.c);
        this.aX().b(GenericAttributes.d);
        if (!this.bf()) {
            this.getAttributeInstance(GenericAttributes.d).setValue(0.1f);
        }
    }

    @Override
    protected void a(double d, boolean bl) {
        if (!this.H()) {
            this.I();
        }
        if (bl && this.fallDistance > 0.0f) {
            int n;
            int n2;
            int n3;
            int n4 = MathHelper.floor(this.locX);
            int n5 = this.world.getTypeId(n4, n3 = MathHelper.floor(this.locY - (double)0.2f - (double)this.height), n2 = MathHelper.floor(this.locZ));
            if (n5 == 0 && ((n = this.world.e(n4, n3 - 1, n2)) == 11 || n == 32 || n == 21)) {
                n5 = this.world.getTypeId(n4, n3 - 1, n2);
            }
            if (n5 > 0) {
                Block.byId[n5].a(this.world, n4, n3, n2, (Entity)this, this.fallDistance);
            }
        }
        super.a(d, bl);
    }

    public boolean aA() {
        return false;
    }

    @Override
    public void y() {
        boolean bl;
        this.aD = this.aE;
        super.y();
        this.world.methodProfiler.a("livingEntityBaseTick");
        if (this.isAlive() && this.inBlock()) {
            this.damageEntity(DamageSource.STUCK, 1.0f);
        }
        if (this.isFireproof() || this.world.isStatic) {
            this.extinguish();
        }
        boolean bl2 = bl = this instanceof EntityHuman && ((EntityHuman)this).abilities.isInvulnerable;
        if (this.isAlive() && this.a(Material.WATER)) {
            if (!(this.aA() || this.hasEffect(MobEffectList.WATER_BREATHING.id) || bl)) {
                this.setAirTicks(this.h(this.getAirTicks()));
                if (this.getAirTicks() == -20) {
                    this.setAirTicks(0);
                    for (int i = 0; i < 8; ++i) {
                        float f = this.random.nextFloat() - this.random.nextFloat();
                        float f2 = this.random.nextFloat() - this.random.nextFloat();
                        float f3 = this.random.nextFloat() - this.random.nextFloat();
                        this.world.addParticle("bubble", this.locX + (double)f, this.locY + (double)f2, this.locZ + (double)f3, this.motX, this.motY, this.motZ);
                    }
                    this.damageEntity(DamageSource.DROWN, 2.0f);
                }
            }
            this.extinguish();
            if (!this.world.isStatic && this.ag() && this.vehicle instanceof EntityLiving) {
                this.mount(null);
            }
        } else {
            this.setAirTicks(300);
        }
        this.aJ = this.aK;
        if (this.attackTicks > 0) {
            --this.attackTicks;
        }
        if (this.hurtTicks > 0) {
            --this.hurtTicks;
        }
        if (this.noDamageTicks > 0) {
            --this.noDamageTicks;
        }
        if (this.getHealth() <= 0.0f) {
            this.aB();
        }
        if (this.lastDamageByPlayerTime > 0) {
            --this.lastDamageByPlayerTime;
        } else {
            this.killer = null;
        }
        if (this.bn != null && !this.bn.isAlive()) {
            this.bn = null;
        }
        if (this.lastDamager != null && !this.lastDamager.isAlive()) {
            this.b((EntityLiving)null);
        }
        this.aJ();
        this.aZ = this.aY;
        this.aO = this.aN;
        this.aQ = this.aP;
        this.lastYaw = this.yaw;
        this.lastPitch = this.pitch;
        this.world.methodProfiler.b();
    }

    public boolean isBaby() {
        return false;
    }

    protected void aB() {
        ++this.deathTicks;
        if (this.deathTicks == 20) {
            int n;
            if (!this.world.isStatic && (this.lastDamageByPlayerTime > 0 || this.alwaysGivesExp()) && !this.isBaby() && this.world.getGameRules().getBoolean("doMobLoot")) {
                int n2;
                for (n = this.getExpValue(this.killer); n > 0; n -= n2) {
                    n2 = EntityExperienceOrb.getOrbValue(n);
                    this.world.addEntity(new EntityExperienceOrb(this.world, this.locX, this.locY, this.locZ, n2));
                }
            }
            this.die();
            for (n = 0; n < 20; ++n) {
                double d = this.random.nextGaussian() * 0.02;
                double d2 = this.random.nextGaussian() * 0.02;
                double d3 = this.random.nextGaussian() * 0.02;
                this.world.addParticle("explode", this.locX + (double)(this.random.nextFloat() * this.width * 2.0f) - (double)this.width, this.locY + (double)(this.random.nextFloat() * this.length), this.locZ + (double)(this.random.nextFloat() * this.width * 2.0f) - (double)this.width, d, d2, d3);
            }
        }
    }

    protected int h(int n) {
        int n2 = EnchantmentManager.getOxygenEnchantmentLevel(this);
        if (n2 > 0 && this.random.nextInt(n2 + 1) > 0) {
            return n;
        }
        return n - 1;
    }

    protected int getExpValue(EntityHuman entityHuman) {
        return 0;
    }

    protected boolean alwaysGivesExp() {
        return false;
    }

    public Random aD() {
        return this.random;
    }

    public EntityLiving getLastDamager() {
        return this.lastDamager;
    }

    public int aF() {
        return this.j;
    }

    public void b(EntityLiving entityLiving) {
        this.lastDamager = entityLiving;
        this.j = this.ticksLived;
    }

    public EntityLiving aG() {
        return this.bn;
    }

    public int aH() {
        return this.bo;
    }

    public void k(Entity entity) {
        this.bn = entity instanceof EntityLiving ? (EntityLiving)entity : null;
        this.bo = this.ticksLived;
    }

    public int aI() {
        return this.aV;
    }

    @Override
    public void b(NBTTagCompound nBTTagCompound) {
        nBTTagCompound.setFloat("HealF", this.getHealth());
        nBTTagCompound.setShort("Health", (short)Math.ceil(this.getHealth()));
        nBTTagCompound.setShort("HurtTime", (short)this.hurtTicks);
        nBTTagCompound.setShort("DeathTime", (short)this.deathTicks);
        nBTTagCompound.setShort("AttackTime", (short)this.attackTicks);
        nBTTagCompound.setFloat("AbsorptionAmount", this.bn());
        for (ItemStack itemStack : this.getEquipment()) {
            if (itemStack == null) continue;
            this.d.a(itemStack.D());
        }
        nBTTagCompound.set("Attributes", GenericAttributes.a(this.aX()));
        for (ItemStack itemStack : this.getEquipment()) {
            if (itemStack == null) continue;
            this.d.b(itemStack.D());
        }
        if (!this.effects.isEmpty()) {
            NBTTagList nBTTagList = new NBTTagList();
            for (MobEffect mobEffect : this.effects.values()) {
                nBTTagList.add(mobEffect.a(new NBTTagCompound()));
            }
            nBTTagCompound.set("ActiveEffects", nBTTagList);
        }
    }

    @Override
    public void a(NBTTagCompound nBTTagCompound) {
        NBTBase nBTBase;
        this.m(nBTTagCompound.getFloat("AbsorptionAmount"));
        if (nBTTagCompound.hasKey("Attributes") && this.world != null && !this.world.isStatic) {
            GenericAttributes.a(this.aX(), nBTTagCompound.getList("Attributes"), this.world == null ? null : this.world.getLogger());
        }
        if (nBTTagCompound.hasKey("ActiveEffects")) {
            nBTBase = nBTTagCompound.getList("ActiveEffects");
            for (int i = 0; i < ((NBTTagList)nBTBase).size(); ++i) {
                NBTTagCompound nBTTagCompound2 = (NBTTagCompound)((NBTTagList)nBTBase).get(i);
                MobEffect mobEffect = MobEffect.b(nBTTagCompound2);
                this.effects.put(mobEffect.getEffectId(), mobEffect);
            }
        }
        if (nBTTagCompound.hasKey("HealF")) {
            this.setHealth(nBTTagCompound.getFloat("HealF"));
        } else {
            nBTBase = nBTTagCompound.get("Health");
            if (nBTBase == null) {
                this.setHealth(this.getMaxHealth());
            } else if (nBTBase.getTypeId() == 5) {
                this.setHealth(((NBTTagFloat)nBTBase).data);
            } else if (nBTBase.getTypeId() == 2) {
                this.setHealth(((NBTTagShort)nBTBase).data);
            }
        }
        this.hurtTicks = nBTTagCompound.getShort("HurtTime");
        this.deathTicks = nBTTagCompound.getShort("DeathTime");
        this.attackTicks = nBTTagCompound.getShort("AttackTime");
    }

    protected void aJ() {
        boolean bl;
        Iterator iterator = this.effects.keySet().iterator();
        while (iterator.hasNext()) {
            Integer n = (Integer)iterator.next();
            MobEffect mobEffect = (MobEffect)this.effects.get(n);
            if (!mobEffect.tick(this)) {
                if (this.world.isStatic) continue;
                iterator.remove();
                this.b(mobEffect);
                continue;
            }
            if (mobEffect.getDuration() % 600 != 0) continue;
            this.a(mobEffect, false);
        }
        if (this.updateEffects) {
            if (!this.world.isStatic) {
                if (this.effects.isEmpty()) {
                    this.datawatcher.watch(8, (byte)0);
                    this.datawatcher.watch(7, 0);
                    this.setInvisible(false);
                } else {
                    int n = PotionBrewer.a(this.effects.values());
                    this.datawatcher.watch(8, PotionBrewer.b(this.effects.values()) ? (byte)1 : 0);
                    this.datawatcher.watch(7, n);
                    this.setInvisible(this.hasEffect(MobEffectList.INVISIBILITY.id));
                }
            }
            this.updateEffects = false;
        }
        int n = this.datawatcher.getInt(7);
        boolean bl2 = bl = this.datawatcher.getByte(8) > 0;
        if (n > 0) {
            boolean bl3 = false;
            if (!this.isInvisible()) {
                bl3 = this.random.nextBoolean();
            } else {
                boolean bl4 = bl3 = this.random.nextInt(15) == 0;
            }
            if (bl) {
                bl3 &= this.random.nextInt(5) == 0;
            }
            if (bl3 && n > 0) {
                double d = (double)(n >> 16 & 0xFF) / 255.0;
                double d2 = (double)(n >> 8 & 0xFF) / 255.0;
                double d3 = (double)(n >> 0 & 0xFF) / 255.0;
                this.world.addParticle(bl ? "mobSpellAmbient" : "mobSpell", this.locX + (this.random.nextDouble() - 0.5) * (double)this.width, this.locY + this.random.nextDouble() * (double)this.length - (double)this.height, this.locZ + (this.random.nextDouble() - 0.5) * (double)this.width, d, d2, d3);
            }
        }
    }

    public void aK() {
        Iterator iterator = this.effects.keySet().iterator();
        while (iterator.hasNext()) {
            Integer n = (Integer)iterator.next();
            MobEffect mobEffect = (MobEffect)this.effects.get(n);
            if (this.world.isStatic) continue;
            iterator.remove();
            this.b(mobEffect);
        }
    }

    public Collection getEffects() {
        return this.effects.values();
    }

    public boolean hasEffect(int n) {
        return this.effects.containsKey(n);
    }

    public boolean hasEffect(MobEffectList mobEffectList) {
        return this.effects.containsKey(mobEffectList.id);
    }

    public MobEffect getEffect(MobEffectList mobEffectList) {
        return (MobEffect)this.effects.get(mobEffectList.id);
    }

    public void addEffect(MobEffect mobEffect) {
        if (!this.d(mobEffect)) {
            return;
        }
        if (this.effects.containsKey(mobEffect.getEffectId())) {
            ((MobEffect)this.effects.get(mobEffect.getEffectId())).a(mobEffect);
            this.a((MobEffect)this.effects.get(mobEffect.getEffectId()), true);
        } else {
            this.effects.put(mobEffect.getEffectId(), mobEffect);
            this.a(mobEffect);
        }
    }

    public boolean d(MobEffect mobEffect) {
        int n;
        return this.getMonsterType() != EnumMonsterType.UNDEAD || (n = mobEffect.getEffectId()) != MobEffectList.REGENERATION.id && n != MobEffectList.POISON.id;
    }

    public boolean aM() {
        return this.getMonsterType() == EnumMonsterType.UNDEAD;
    }

    public void k(int n) {
        MobEffect mobEffect = (MobEffect)this.effects.remove(n);
        if (mobEffect != null) {
            this.b(mobEffect);
        }
    }

    protected void a(MobEffect mobEffect) {
        this.updateEffects = true;
        if (!this.world.isStatic) {
            MobEffectList.byId[mobEffect.getEffectId()].b(this, this.aX(), mobEffect.getAmplifier());
        }
    }

    protected void a(MobEffect mobEffect, boolean bl) {
        this.updateEffects = true;
        if (bl && !this.world.isStatic) {
            MobEffectList.byId[mobEffect.getEffectId()].a(this, this.aX(), mobEffect.getAmplifier());
            MobEffectList.byId[mobEffect.getEffectId()].b(this, this.aX(), mobEffect.getAmplifier());
        }
    }

    protected void b(MobEffect mobEffect) {
        this.updateEffects = true;
        if (!this.world.isStatic) {
            MobEffectList.byId[mobEffect.getEffectId()].a(this, this.aX(), mobEffect.getAmplifier());
        }
    }

    public void heal(float f) {
        float f2 = this.getHealth();
        if (f2 > 0.0f) {
            this.setHealth(f2 + f);
        }
    }

    public final float getHealth() {
        return this.datawatcher.getFloat(6);
    }

    public void setHealth(float f) {
        this.datawatcher.watch(6, Float.valueOf(MathHelper.a(f, 0.0f, this.getMaxHealth())));
    }

    @Override
    public boolean damageEntity(DamageSource damageSource, float f) {
        if (this.isInvulnerable()) {
            return false;
        }
        if (this.world.isStatic) {
            return false;
        }
        this.aV = 0;
        if (this.getHealth() <= 0.0f) {
            return false;
        }
        if (damageSource.m() && this.hasEffect(MobEffectList.FIRE_RESISTANCE)) {
            return false;
        }
        if ((damageSource == DamageSource.ANVIL || damageSource == DamageSource.FALLING_BLOCK) && this.getEquipment(4) != null) {
            this.getEquipment(4).damage((int)(f * 4.0f + this.random.nextFloat() * f * 2.0f), this);
            f *= 0.75f;
        }
        this.aG = 1.5f;
        boolean bl = true;
        if ((float)this.noDamageTicks > (float)this.maxNoDamageTicks / 2.0f) {
            if (f <= this.lastDamage) {
                return false;
            }
            this.d(damageSource, f - this.lastDamage);
            this.lastDamage = f;
            bl = false;
        } else {
            this.lastDamage = f;
            this.ax = this.getHealth();
            this.noDamageTicks = this.maxNoDamageTicks;
            this.d(damageSource, f);
            this.az = 10;
            this.hurtTicks = 10;
        }
        this.aA = 0.0f;
        Entity entity = damageSource.getEntity();
        if (entity != null) {
            EntityWolf entityWolf;
            if (entity instanceof EntityLiving) {
                this.b((EntityLiving)entity);
            }
            if (entity instanceof EntityHuman) {
                this.lastDamageByPlayerTime = 100;
                this.killer = (EntityHuman)entity;
            } else if (entity instanceof EntityWolf && (entityWolf = (EntityWolf)entity).isTamed()) {
                this.lastDamageByPlayerTime = 100;
                this.killer = null;
            }
        }
        if (bl) {
            this.world.broadcastEntityEffect(this, (byte)2);
            if (damageSource != DamageSource.DROWN) {
                this.K();
            }
            if (entity != null) {
                double d = entity.locX - this.locX;
                double d2 = entity.locZ - this.locZ;
                while (d * d + d2 * d2 < 1.0E-4) {
                    d = (Math.random() - Math.random()) * 0.01;
                    d2 = (Math.random() - Math.random()) * 0.01;
                }
                this.aA = (float)(Math.atan2(d2, d) * 180.0 / 3.1415927410125732) - this.yaw;
                this.a(entity, f, d, d2);
            } else {
                this.aA = (int)(Math.random() * 2.0) * 180;
            }
        }
        if (this.getHealth() <= 0.0f) {
            if (bl) {
                this.makeSound(this.aP(), this.ba(), this.bb());
            }
            this.die(damageSource);
        } else if (bl) {
            this.makeSound(this.aO(), this.ba(), this.bb());
        }
        return true;
    }

    public void a(ItemStack itemStack) {
        this.makeSound("random.break", 0.8f, 0.8f + this.world.random.nextFloat() * 0.4f);
        for (int i = 0; i < 5; ++i) {
            Vec3D vec3D = this.world.getVec3DPool().create(((double)this.random.nextFloat() - 0.5) * 0.1, Math.random() * 0.1 + 0.1, 0.0);
            vec3D.a(-this.pitch * (float)Math.PI / 180.0f);
            vec3D.b(-this.yaw * (float)Math.PI / 180.0f);
            Vec3D vec3D2 = this.world.getVec3DPool().create(((double)this.random.nextFloat() - 0.5) * 0.3, (double)(-this.random.nextFloat()) * 0.6 - 0.3, 0.6);
            vec3D2.a(-this.pitch * (float)Math.PI / 180.0f);
            vec3D2.b(-this.yaw * (float)Math.PI / 180.0f);
            vec3D2 = vec3D2.add(this.locX, this.locY + (double)this.getHeadHeight(), this.locZ);
            this.world.addParticle("iconcrack_" + itemStack.getItem().id, vec3D2.c, vec3D2.d, vec3D2.e, vec3D.c, vec3D.d + 0.05, vec3D.e);
        }
    }

    public void die(DamageSource damageSource) {
        Entity entity = damageSource.getEntity();
        EntityLiving entityLiving = this.aS();
        if (this.bb >= 0 && entityLiving != null) {
            entityLiving.b(this, this.bb);
        }
        if (entity != null) {
            entity.a(this);
        }
        this.aU = true;
        if (!this.world.isStatic) {
            int n = 0;
            if (entity instanceof EntityHuman) {
                n = EnchantmentManager.getBonusMonsterLootEnchantmentLevel((EntityLiving)entity);
            }
            if (!this.isBaby() && this.world.getGameRules().getBoolean("doMobLoot")) {
                int n2;
                this.dropDeathLoot(this.lastDamageByPlayerTime > 0, n);
                this.dropEquipment(this.lastDamageByPlayerTime > 0, n);
                if (this.lastDamageByPlayerTime > 0 && (n2 = this.random.nextInt(200) - n) < 5) {
                    this.l(n2 <= 0 ? 1 : 0);
                }
            }
        }
        this.world.broadcastEntityEffect(this, (byte)3);
    }

    protected void dropEquipment(boolean bl, int n) {
    }

    public void a(Entity entity, float f, double d, double d2) {
        if (this.random.nextDouble() < this.getAttributeInstance(GenericAttributes.c).getValue()) {
            return;
        }
        this.an = true;
        float f2 = MathHelper.sqrt(d * d + d2 * d2);
        float f3 = 0.4f;
        this.motX /= 2.0;
        this.motY /= 2.0;
        this.motZ /= 2.0;
        this.motX -= d / (double)f2 * (double)f3;
        this.motY += (double)f3;
        this.motZ -= d2 / (double)f2 * (double)f3;
        if (this.motY > (double)0.4f) {
            this.motY = 0.4f;
        }
    }

    protected String aO() {
        return "damage.hit";
    }

    protected String aP() {
        return "damage.hit";
    }

    protected void l(int n) {
    }

    protected void dropDeathLoot(boolean bl, int n) {
    }

    public boolean e() {
        int n;
        int n2;
        int n3 = MathHelper.floor(this.locX);
        int n4 = this.world.getTypeId(n3, n2 = MathHelper.floor(this.boundingBox.b), n = MathHelper.floor(this.locZ));
        return n4 == Block.LADDER.id || n4 == Block.VINE.id;
    }

    @Override
    public boolean isAlive() {
        return !this.dead && this.getHealth() > 0.0f;
    }

    @Override
    protected void b(float f) {
        super.b(f);
        MobEffect mobEffect = this.getEffect(MobEffectList.JUMP);
        float f2 = mobEffect != null ? (float)(mobEffect.getAmplifier() + 1) : 0.0f;
        int n = MathHelper.f(f - 3.0f - f2);
        if (n > 0) {
            if (n > 4) {
                this.makeSound("damage.fallbig", 1.0f, 1.0f);
            } else {
                this.makeSound("damage.fallsmall", 1.0f, 1.0f);
            }
            this.damageEntity(DamageSource.FALL, n);
            int n2 = this.world.getTypeId(MathHelper.floor(this.locX), MathHelper.floor(this.locY - (double)0.2f - (double)this.height), MathHelper.floor(this.locZ));
            if (n2 > 0) {
                StepSound stepSound = Block.byId[n2].stepSound;
                this.makeSound(stepSound.getStepSound(), stepSound.getVolume1() * 0.5f, stepSound.getVolume2() * 0.75f);
            }
        }
    }

    public int aQ() {
        int n = 0;
        for (ItemStack itemStack : this.getEquipment()) {
            if (itemStack == null || !(itemStack.getItem() instanceof ItemArmor)) continue;
            int n2 = ((ItemArmor)itemStack.getItem()).c;
            n += n2;
        }
        return n;
    }

    protected void h(float f) {
    }

    protected float b(DamageSource damageSource, float f) {
        if (!damageSource.ignoresArmor()) {
            int n = 25 - this.aQ();
            float f2 = f * (float)n;
            this.h(f);
            f = f2 / 25.0f;
        }
        return f;
    }

    protected float c(DamageSource damageSource, float f) {
        float f2;
        int n;
        int n2;
        if (this instanceof EntityZombie) {
            // empty if block
        }
        if (this.hasEffect(MobEffectList.RESISTANCE) && damageSource != DamageSource.OUT_OF_WORLD) {
            n2 = (this.getEffect(MobEffectList.RESISTANCE).getAmplifier() + 1) * 5;
            n = 25 - n2;
            f2 = f * (float)n;
            f = f2 / 25.0f;
        }
        if (f <= 0.0f) {
            return 0.0f;
        }
        n2 = EnchantmentManager.a(this.getEquipment(), damageSource);
        if (n2 > 20) {
            n2 = 20;
        }
        if (n2 > 0 && n2 <= 20) {
            n = 25 - n2;
            f2 = f * (float)n;
            f = f2 / 25.0f;
        }
        return f;
    }

    protected void d(DamageSource damageSource, float f) {
        if (this.isInvulnerable()) {
            return;
        }
        f = this.b(damageSource, f);
        float f2 = f = this.c(damageSource, f);
        f = Math.max(f - this.bn(), 0.0f);
        this.m(this.bn() - (f2 - f));
        if (f == 0.0f) {
            return;
        }
        float f3 = this.getHealth();
        this.setHealth(f3 - f);
        this.aR().a(damageSource, f3, f);
        this.m(this.bn() - f);
    }

    public CombatTracker aR() {
        return this.combatTracker;
    }

    public EntityLiving aS() {
        if (this.combatTracker.c() != null) {
            return this.combatTracker.c();
        }
        if (this.killer != null) {
            return this.killer;
        }
        if (this.lastDamager != null) {
            return this.lastDamager;
        }
        return null;
    }

    public final float getMaxHealth() {
        return (float)this.getAttributeInstance(GenericAttributes.a).getValue();
    }

    public final int aU() {
        return this.datawatcher.getByte(9);
    }

    public final void m(int n) {
        this.datawatcher.watch(9, (byte)n);
    }

    private int h() {
        if (this.hasEffect(MobEffectList.FASTER_DIG)) {
            return 6 - (1 + this.getEffect(MobEffectList.FASTER_DIG).getAmplifier()) * 1;
        }
        if (this.hasEffect(MobEffectList.SLOWER_DIG)) {
            return 6 + (1 + this.getEffect(MobEffectList.SLOWER_DIG).getAmplifier()) * 2;
        }
        return 6;
    }

    public void aV() {
        if (!this.au || this.av >= this.h() / 2 || this.av < 0) {
            this.av = -1;
            this.au = true;
            if (this.world instanceof WorldServer) {
                ((WorldServer)this.world).getTracker().a(this, new Packet18ArmAnimation(this, 1));
            }
        }
    }

    @Override
    protected void C() {
        this.damageEntity(DamageSource.OUT_OF_WORLD, 4.0f);
    }

    protected void aW() {
        int n = this.h();
        if (this.au) {
            ++this.av;
            if (this.av >= n) {
                this.av = 0;
                this.au = false;
            }
        } else {
            this.av = 0;
        }
        this.aE = (float)this.av / (float)n;
    }

    public AttributeInstance getAttributeInstance(IAttribute iAttribute) {
        return this.aX().a(iAttribute);
    }

    public AttributeMapBase aX() {
        if (this.d == null) {
            this.d = new AttributeMapServer();
        }
        return this.d;
    }

    public EnumMonsterType getMonsterType() {
        return EnumMonsterType.UNDEFINED;
    }

    public abstract ItemStack aZ();

    public abstract ItemStack getEquipment(int var1);

    @Override
    public abstract void setEquipment(int var1, ItemStack var2);

    @Override
    public void setSprinting(boolean bl) {
        super.setSprinting(bl);
        AttributeInstance attributeInstance = this.getAttributeInstance(GenericAttributes.d);
        if (attributeInstance.a(b) != null) {
            attributeInstance.b(c);
        }
        if (bl) {
            attributeInstance.a(c);
        }
    }

    @Override
    public abstract ItemStack[] getEquipment();

    protected float ba() {
        return 1.0f;
    }

    protected float bb() {
        if (this.isBaby()) {
            return (this.random.nextFloat() - this.random.nextFloat()) * 0.2f + 1.5f;
        }
        return (this.random.nextFloat() - this.random.nextFloat()) * 0.2f + 1.0f;
    }

    protected boolean bc() {
        return this.getHealth() <= 0.0f;
    }

    public void enderTeleportTo(double d, double d2, double d3) {
        this.setPositionRotation(d, d2, d3, this.yaw, this.pitch);
    }

    public void l(Entity entity) {
        double d = entity.locX;
        double d2 = entity.boundingBox.b + (double)entity.length;
        double d3 = entity.locZ;
        for (double d4 = -1.5; d4 < 2.0; d4 += 1.5) {
            for (double d5 = -1.5; d5 < 2.0; d5 += 1.5) {
                if (d4 == 0.0 && d5 == 0.0) continue;
                int n = (int)(this.locX + d4);
                int n2 = (int)(this.locZ + d5);
                AxisAlignedBB axisAlignedBB = this.boundingBox.c(d4, 1.0, d5);
                if (!this.world.a(axisAlignedBB).isEmpty()) continue;
                if (this.world.w(n, (int)this.locY, n2)) {
                    this.enderTeleportTo(this.locX + d4, this.locY + 1.0, this.locZ + d5);
                    return;
                }
                if (!this.world.w(n, (int)this.locY - 1, n2) && this.world.getMaterial(n, (int)this.locY - 1, n2) != Material.WATER) continue;
                d = this.locX + d4;
                d2 = this.locY + 1.0;
                d3 = this.locZ + d5;
            }
        }
        this.enderTeleportTo(d, d2, d3);
    }

    protected void be() {
        this.motY = 0.42f;
        if (this.hasEffect(MobEffectList.JUMP)) {
            this.motY += (double)((float)(this.getEffect(MobEffectList.JUMP).getAmplifier() + 1) * 0.1f);
        }
        if (this.isSprinting()) {
            float f = this.yaw * ((float)Math.PI / 180);
            this.motX -= (double)(MathHelper.sin(f) * 0.2f);
            this.motZ += (double)(MathHelper.cos(f) * 0.2f);
        }
        this.an = true;
    }

    public void e(float f, float f2) {
        double d;
        if (!(!this.H() || this instanceof EntityHuman && ((EntityHuman)this).abilities.isFlying)) {
            d = this.locY;
            this.a(f, f2, this.bf() ? 0.04f : 0.02f);
            this.move(this.motX, this.motY, this.motZ);
            this.motX *= (double)0.8f;
            this.motY *= (double)0.8f;
            this.motZ *= (double)0.8f;
            this.motY -= 0.02;
            if (this.positionChanged && this.c(this.motX, this.motY + (double)0.6f - this.locY + d, this.motZ)) {
                this.motY = 0.3f;
            }
        } else if (!(!this.J() || this instanceof EntityHuman && ((EntityHuman)this).abilities.isFlying)) {
            d = this.locY;
            this.a(f, f2, 0.02f);
            this.move(this.motX, this.motY, this.motZ);
            this.motX *= 0.5;
            this.motY *= 0.5;
            this.motZ *= 0.5;
            this.motY -= 0.02;
            if (this.positionChanged && this.c(this.motX, this.motY + (double)0.6f - this.locY + d, this.motZ)) {
                this.motY = 0.3f;
            }
        } else {
            float f3 = 0.91f;
            if (this.onGround) {
                f3 = 0.54600006f;
                int n = this.world.getTypeId(MathHelper.floor(this.locX), MathHelper.floor(this.boundingBox.b) - 1, MathHelper.floor(this.locZ));
                if (n > 0) {
                    f3 = Block.byId[n].frictionFactor * 0.91f;
                }
            }
            float f4 = 0.16277136f / (f3 * f3 * f3);
            float f5 = this.onGround ? this.bg() * f4 : this.aR;
            this.a(f, f2, f5);
            f3 = 0.91f;
            if (this.onGround) {
                f3 = 0.54600006f;
                int n = this.world.getTypeId(MathHelper.floor(this.locX), MathHelper.floor(this.boundingBox.b) - 1, MathHelper.floor(this.locZ));
                if (n > 0) {
                    f3 = Block.byId[n].frictionFactor * 0.91f;
                }
            }
            if (this.e()) {
                boolean bl;
                float f6 = 0.15f;
                if (this.motX < (double)(-f6)) {
                    this.motX = -f6;
                }
                if (this.motX > (double)f6) {
                    this.motX = f6;
                }
                if (this.motZ < (double)(-f6)) {
                    this.motZ = -f6;
                }
                if (this.motZ > (double)f6) {
                    this.motZ = f6;
                }
                this.fallDistance = 0.0f;
                if (this.motY < -0.15) {
                    this.motY = -0.15;
                }
                boolean bl2 = bl = this.isSneaking() && this instanceof EntityHuman;
                if (bl && this.motY < 0.0) {
                    this.motY = 0.0;
                }
            }
            this.move(this.motX, this.motY, this.motZ);
            if (this.positionChanged && this.e()) {
                this.motY = 0.2;
            }
            this.motY = !this.world.isStatic || this.world.isLoaded((int)this.locX, 0, (int)this.locZ) && this.world.getChunkAtWorldCoords((int)((int)this.locX), (int)((int)this.locZ)).d ? (this.motY -= 0.08) : (this.locY > 0.0 ? -0.1 : 0.0);
            this.motY *= (double)0.98f;
            this.motX *= (double)f3;
            this.motZ *= (double)f3;
        }
        this.aF = this.aG;
        d = this.locX - this.lastX;
        double d2 = this.locZ - this.lastZ;
        float f7 = MathHelper.sqrt(d * d + d2 * d2) * 4.0f;
        if (f7 > 1.0f) {
            f7 = 1.0f;
        }
        this.aG += (f7 - this.aG) * 0.4f;
        this.aH += this.aG;
    }

    protected boolean bf() {
        return false;
    }

    public float bg() {
        if (this.bf()) {
            return this.bp;
        }
        return 0.1f;
    }

    public void i(float f) {
        this.bp = f;
    }

    public boolean m(Entity entity) {
        this.k(entity);
        return false;
    }

    public boolean isSleeping() {
        return false;
    }

    @Override
    public void l_() {
        super.l_();
        if (!this.world.isStatic) {
            int n = this.aU();
            if (n > 0) {
                if (this.aw <= 0) {
                    this.aw = 20 * (30 - n);
                }
                --this.aw;
                if (this.aw <= 0) {
                    this.m(n - 1);
                }
            }
            for (int i = 0; i < 5; ++i) {
                ItemStack itemStack = this.g[i];
                ItemStack itemStack2 = this.getEquipment(i);
                if (ItemStack.matches(itemStack2, itemStack)) continue;
                ((WorldServer)this.world).getTracker().a(this, new Packet5EntityEquipment(this.id, i, itemStack2));
                if (itemStack != null) {
                    this.d.a(itemStack.D());
                }
                if (itemStack2 != null) {
                    this.d.b(itemStack2.D());
                }
                this.g[i] = itemStack2 == null ? null : itemStack2.cloneItemStack();
            }
        }
        this.c();
        double d = this.locX - this.lastX;
        double d2 = this.locZ - this.lastZ;
        float f = (float)(d * d + d2 * d2);
        float f2 = this.aN;
        float f3 = 0.0f;
        this.aW = this.aX;
        float f4 = 0.0f;
        if (f > 0.0025000002f) {
            f4 = 1.0f;
            f3 = (float)Math.sqrt(f) * 3.0f;
            f2 = (float)Math.atan2(d2, d) * 180.0f / (float)Math.PI - 90.0f;
        }
        if (this.aE > 0.0f) {
            f2 = this.yaw;
        }
        if (!this.onGround) {
            f4 = 0.0f;
        }
        this.aX += (f4 - this.aX) * 0.3f;
        this.world.methodProfiler.a("headTurn");
        f3 = this.f(f2, f3);
        this.world.methodProfiler.b();
        this.world.methodProfiler.a("rangeChecks");
        while (this.yaw - this.lastYaw < -180.0f) {
            this.lastYaw -= 360.0f;
        }
        while (this.yaw - this.lastYaw >= 180.0f) {
            this.lastYaw += 360.0f;
        }
        while (this.aN - this.aO < -180.0f) {
            this.aO -= 360.0f;
        }
        while (this.aN - this.aO >= 180.0f) {
            this.aO += 360.0f;
        }
        while (this.pitch - this.lastPitch < -180.0f) {
            this.lastPitch -= 360.0f;
        }
        while (this.pitch - this.lastPitch >= 180.0f) {
            this.lastPitch += 360.0f;
        }
        while (this.aP - this.aQ < -180.0f) {
            this.aQ -= 360.0f;
        }
        while (this.aP - this.aQ >= 180.0f) {
            this.aQ += 360.0f;
        }
        this.world.methodProfiler.b();
        this.aY += f3;
    }

    protected float f(float f, float f2) {
        boolean bl;
        float f3 = MathHelper.g(f - this.aN);
        this.aN += f3 * 0.3f;
        float f4 = MathHelper.g(this.yaw - this.aN);
        boolean bl2 = bl = f4 < -90.0f || f4 >= 90.0f;
        if (f4 < -75.0f) {
            f4 = -75.0f;
        }
        if (f4 >= 75.0f) {
            f4 = 75.0f;
        }
        this.aN = this.yaw - f4;
        if (f4 * f4 > 2500.0f) {
            this.aN += f4 * 0.2f;
        }
        if (bl) {
            f2 *= -1.0f;
        }
        return f2;
    }

    public void c() {
        if (this.bq > 0) {
            --this.bq;
        }
        if (this.bh > 0) {
            double d = this.locX + (this.bi - this.locX) / (double)this.bh;
            double d2 = this.locY + (this.bj - this.locY) / (double)this.bh;
            double d3 = this.locZ + (this.bk - this.locZ) / (double)this.bh;
            double d4 = MathHelper.g(this.bl - (double)this.yaw);
            this.yaw = (float)((double)this.yaw + d4 / (double)this.bh);
            this.pitch = (float)((double)this.pitch + (this.bm - (double)this.pitch) / (double)this.bh);
            --this.bh;
            this.setPosition(d, d2, d3);
            this.b(this.yaw, this.pitch);
        } else if (!this.bm()) {
            this.motX *= 0.98;
            this.motY *= 0.98;
            this.motZ *= 0.98;
        }
        if (Math.abs(this.motX) < 0.005) {
            this.motX = 0.0;
        }
        if (Math.abs(this.motY) < 0.005) {
            this.motY = 0.0;
        }
        if (Math.abs(this.motZ) < 0.005) {
            this.motZ = 0.0;
        }
        this.world.methodProfiler.a("ai");
        if (this.bc()) {
            this.bd = false;
            this.be = 0.0f;
            this.bf = 0.0f;
            this.bg = 0.0f;
        } else if (this.bm()) {
            if (this.bf()) {
                this.world.methodProfiler.a("newAi");
                this.bi();
                this.world.methodProfiler.b();
            } else {
                this.world.methodProfiler.a("oldAi");
                this.bl();
                this.world.methodProfiler.b();
                this.aP = this.yaw;
            }
        }
        this.world.methodProfiler.b();
        this.world.methodProfiler.a("jump");
        if (this.bd) {
            if (this.H() || this.J()) {
                this.motY += (double)0.04f;
            } else if (this.onGround && this.bq == 0) {
                this.be();
                this.bq = 10;
            }
        } else {
            this.bq = 0;
        }
        this.world.methodProfiler.b();
        this.world.methodProfiler.a("travel");
        this.be *= 0.98f;
        this.bf *= 0.98f;
        this.bg *= 0.9f;
        this.e(this.be, this.bf);
        this.world.methodProfiler.b();
        this.world.methodProfiler.a("push");
        if (!this.world.isStatic) {
            this.bj();
        }
        this.world.methodProfiler.b();
    }

    protected void bi() {
    }

    protected void bj() {
        List list = this.world.getEntities(this, this.boundingBox.grow(0.2f, 0.0, 0.2f));
        if (list != null && !list.isEmpty()) {
            for (int i = 0; i < list.size(); ++i) {
                Entity entity = (Entity)list.get(i);
                if (!entity.M()) continue;
                this.n(entity);
            }
        }
    }

    protected void n(Entity entity) {
        entity.collide(this);
    }

    @Override
    public void V() {
        super.V();
        this.aW = this.aX;
        this.aX = 0.0f;
        this.fallDistance = 0.0f;
    }

    protected void bk() {
    }

    protected void bl() {
        ++this.aV;
    }

    public void f(boolean bl) {
        this.bd = bl;
    }

    public void receive(Entity entity, int n) {
        if (!entity.dead && !this.world.isStatic) {
            EntityTracker entityTracker = ((WorldServer)this.world).getTracker();
            if (entity instanceof EntityItem) {
                entityTracker.a(entity, new Packet22Collect(entity.id, this.id));
            }
            if (entity instanceof EntityArrow) {
                entityTracker.a(entity, new Packet22Collect(entity.id, this.id));
            }
            if (entity instanceof EntityExperienceOrb) {
                entityTracker.a(entity, new Packet22Collect(entity.id, this.id));
            }
        }
    }

    public boolean o(Entity entity) {
        return this.world.a(this.world.getVec3DPool().create(this.locX, this.locY + (double)this.getHeadHeight(), this.locZ), this.world.getVec3DPool().create(entity.locX, entity.locY + (double)entity.getHeadHeight(), entity.locZ)) == null;
    }

    @Override
    public Vec3D aa() {
        return this.j(1.0f);
    }

    public Vec3D j(float f) {
        if (f == 1.0f) {
            float f2 = MathHelper.cos(-this.yaw * ((float)Math.PI / 180) - (float)Math.PI);
            float f3 = MathHelper.sin(-this.yaw * ((float)Math.PI / 180) - (float)Math.PI);
            float f4 = -MathHelper.cos(-this.pitch * ((float)Math.PI / 180));
            float f5 = MathHelper.sin(-this.pitch * ((float)Math.PI / 180));
            return this.world.getVec3DPool().create(f3 * f4, f5, f2 * f4);
        }
        float f6 = this.lastPitch + (this.pitch - this.lastPitch) * f;
        float f7 = this.lastYaw + (this.yaw - this.lastYaw) * f;
        float f8 = MathHelper.cos(-f7 * ((float)Math.PI / 180) - (float)Math.PI);
        float f9 = MathHelper.sin(-f7 * ((float)Math.PI / 180) - (float)Math.PI);
        float f10 = -MathHelper.cos(-f6 * ((float)Math.PI / 180));
        float f11 = MathHelper.sin(-f6 * ((float)Math.PI / 180));
        return this.world.getVec3DPool().create(f9 * f10, f11, f8 * f10);
    }

    public boolean bm() {
        return !this.world.isStatic;
    }

    @Override
    public boolean L() {
        return !this.dead;
    }

    @Override
    public boolean M() {
        return !this.dead;
    }

    @Override
    public float getHeadHeight() {
        return this.length * 0.85f;
    }

    @Override
    protected void K() {
        this.velocityChanged = this.random.nextDouble() >= this.getAttributeInstance(GenericAttributes.c).getValue();
    }

    @Override
    public float getHeadRotation() {
        return this.aP;
    }

    public float bn() {
        return this.br;
    }

    public void m(float f) {
        if (f < 0.0f) {
            f = 0.0f;
        }
        this.br = f;
    }

    public ScoreboardTeamBase getScoreboardTeam() {
        return null;
    }

    public boolean c(EntityLiving entityLiving) {
        return this.a(entityLiving.getScoreboardTeam());
    }

    public boolean a(ScoreboardTeamBase scoreboardTeamBase) {
        if (this.getScoreboardTeam() != null) {
            return this.getScoreboardTeam().isAlly(scoreboardTeamBase);
        }
        return false;
    }
}

