/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import java.util.List;
import net.minecraft.server.AxisAlignedBB;
import net.minecraft.server.Block;
import net.minecraft.server.Entity;
import net.minecraft.server.EntityWeather;
import net.minecraft.server.MathHelper;
import net.minecraft.server.NBTTagCompound;
import net.minecraft.server.World;

public class EntityLightning
extends EntityWeather {
    private int lifeTicks;
    public long a;
    private int c;

    public EntityLightning(World world, double d, double d2, double d3) {
        super(world);
        this.setPositionRotation(d, d2, d3, 0.0f, 0.0f);
        this.lifeTicks = 2;
        this.a = this.random.nextLong();
        this.c = this.random.nextInt(3) + 1;
        if (!world.isStatic && world.getGameRules().getBoolean("doFireTick") && world.difficulty >= 2 && world.areChunksLoaded(MathHelper.floor(d), MathHelper.floor(d2), MathHelper.floor(d3), 10)) {
            int n;
            int n2;
            int n3 = MathHelper.floor(d);
            if (world.getTypeId(n3, n2 = MathHelper.floor(d2), n = MathHelper.floor(d3)) == 0 && Block.FIRE.canPlace(world, n3, n2, n)) {
                world.setTypeIdUpdate(n3, n2, n, Block.FIRE.id);
            }
            for (n3 = 0; n3 < 4; ++n3) {
                int n4;
                n2 = MathHelper.floor(d) + this.random.nextInt(3) - 1;
                if (world.getTypeId(n2, n = MathHelper.floor(d2) + this.random.nextInt(3) - 1, n4 = MathHelper.floor(d3) + this.random.nextInt(3) - 1) != 0 || !Block.FIRE.canPlace(world, n2, n, n4)) continue;
                world.setTypeIdUpdate(n2, n, n4, Block.FIRE.id);
            }
        }
    }

    @Override
    public void l_() {
        super.l_();
        if (this.lifeTicks == 2) {
            this.world.makeSound(this.locX, this.locY, this.locZ, "ambient.weather.thunder", 10000.0f, 0.8f + this.random.nextFloat() * 0.2f);
            this.world.makeSound(this.locX, this.locY, this.locZ, "random.explode", 2.0f, 0.5f + this.random.nextFloat() * 0.2f);
        }
        --this.lifeTicks;
        if (this.lifeTicks < 0) {
            if (this.c == 0) {
                this.die();
            } else if (this.lifeTicks < -this.random.nextInt(10)) {
                int n;
                int n2;
                int n3;
                --this.c;
                this.lifeTicks = 1;
                this.a = this.random.nextLong();
                if (!this.world.isStatic && this.world.getGameRules().getBoolean("doFireTick") && this.world.areChunksLoaded(MathHelper.floor(this.locX), MathHelper.floor(this.locY), MathHelper.floor(this.locZ), 10) && this.world.getTypeId(n3 = MathHelper.floor(this.locX), n2 = MathHelper.floor(this.locY), n = MathHelper.floor(this.locZ)) == 0 && Block.FIRE.canPlace(this.world, n3, n2, n)) {
                    this.world.setTypeIdUpdate(n3, n2, n, Block.FIRE.id);
                }
            }
        }
        if (this.lifeTicks >= 0) {
            if (this.world.isStatic) {
                this.world.q = 2;
            } else {
                double d = 3.0;
                List list = this.world.getEntities(this, AxisAlignedBB.a().a(this.locX - d, this.locY - d, this.locZ - d, this.locX + d, this.locY + 6.0 + d, this.locZ + d));
                for (int i = 0; i < list.size(); ++i) {
                    Entity entity = (Entity)list.get(i);
                    entity.a(this);
                }
            }
        }
    }

    @Override
    protected void a() {
    }

    @Override
    protected void a(NBTTagCompound nBTTagCompound) {
    }

    @Override
    protected void b(NBTTagCompound nBTTagCompound) {
    }
}

