/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import net.minecraft.server.DamageSource;
import net.minecraft.server.EntityFireball;
import net.minecraft.server.EntityLiving;
import net.minecraft.server.MovingObjectPosition;
import net.minecraft.server.NBTTagCompound;
import net.minecraft.server.World;

public class EntityLargeFireball
extends EntityFireball {
    public int yield = 1;

    public EntityLargeFireball(World world) {
        super(world);
    }

    public EntityLargeFireball(World world, EntityLiving entityLiving, double d, double d2, double d3) {
        super(world, entityLiving, d, d2, d3);
    }

    @Override
    protected void a(MovingObjectPosition movingObjectPosition) {
        if (!this.world.isStatic) {
            if (movingObjectPosition.entity != null) {
                movingObjectPosition.entity.damageEntity(DamageSource.fireball(this, this.shooter), 6.0f);
            }
            this.world.createExplosion(null, this.locX, this.locY, this.locZ, this.yield, true, this.world.getGameRules().getBoolean("mobGriefing"));
            this.die();
        }
    }

    @Override
    public void b(NBTTagCompound nBTTagCompound) {
        super.b(nBTTagCompound);
        nBTTagCompound.setInt("ExplosionPower", this.yield);
    }

    @Override
    public void a(NBTTagCompound nBTTagCompound) {
        super.a(nBTTagCompound);
        if (nBTTagCompound.hasKey("ExplosionPower")) {
            this.yield = nBTTagCompound.getInt("ExplosionPower");
        }
    }
}

