/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import net.minecraft.server.Entity;
import net.minecraft.server.EntityHanging;
import net.minecraft.server.EntityHuman;
import net.minecraft.server.Item;
import net.minecraft.server.ItemStack;
import net.minecraft.server.ItemWorldMap;
import net.minecraft.server.NBTTagCompound;
import net.minecraft.server.World;
import net.minecraft.server.WorldMap;

public class EntityItemFrame
extends EntityHanging {
    private float e = 1.0f;

    public EntityItemFrame(World world) {
        super(world);
    }

    public EntityItemFrame(World world, int n, int n2, int n3, int n4) {
        super(world, n, n2, n3, n4);
        this.setDirection(n4);
    }

    @Override
    protected void a() {
        this.getDataWatcher().a(2, 5);
        this.getDataWatcher().a(3, (Object)0);
    }

    @Override
    public int d() {
        return 9;
    }

    @Override
    public int e() {
        return 9;
    }

    @Override
    public void b(Entity entity) {
        ItemStack itemStack = this.getItem();
        if (entity instanceof EntityHuman) {
            EntityHuman entityHuman = (EntityHuman)entity;
            if (entityHuman.abilities.canInstantlyBuild) {
                this.b(itemStack);
                return;
            }
        }
        this.a(new ItemStack(Item.ITEM_FRAME), 0.0f);
        if (itemStack != null && this.random.nextFloat() < this.e) {
            itemStack = itemStack.cloneItemStack();
            this.b(itemStack);
            this.a(itemStack, 0.0f);
        }
    }

    private void b(ItemStack itemStack) {
        if (itemStack == null) {
            return;
        }
        if (itemStack.id == Item.MAP.id) {
            WorldMap worldMap = ((ItemWorldMap)itemStack.getItem()).getSavedMap(itemStack, this.world);
            worldMap.g.remove("frame-" + this.id);
        }
        itemStack.a((EntityItemFrame)null);
    }

    public ItemStack getItem() {
        return this.getDataWatcher().getItemStack(2);
    }

    public void setItem(ItemStack itemStack) {
        itemStack = itemStack.cloneItemStack();
        itemStack.count = 1;
        itemStack.a(this);
        this.getDataWatcher().watch(2, itemStack);
        this.getDataWatcher().h(2);
    }

    public int getRotation() {
        return this.getDataWatcher().getByte(3);
    }

    public void setRotation(int n) {
        this.getDataWatcher().watch(3, (byte)(n % 4));
    }

    @Override
    public void b(NBTTagCompound nBTTagCompound) {
        if (this.getItem() != null) {
            nBTTagCompound.setCompound("Item", this.getItem().save(new NBTTagCompound()));
            nBTTagCompound.setByte("ItemRotation", (byte)this.getRotation());
            nBTTagCompound.setFloat("ItemDropChance", this.e);
        }
        super.b(nBTTagCompound);
    }

    @Override
    public void a(NBTTagCompound nBTTagCompound) {
        NBTTagCompound nBTTagCompound2 = nBTTagCompound.getCompound("Item");
        if (nBTTagCompound2 != null && !nBTTagCompound2.isEmpty()) {
            this.setItem(ItemStack.createStack(nBTTagCompound2));
            this.setRotation(nBTTagCompound.getByte("ItemRotation"));
            if (nBTTagCompound.hasKey("ItemDropChance")) {
                this.e = nBTTagCompound.getFloat("ItemDropChance");
            }
        }
        super.a(nBTTagCompound);
    }

    @Override
    public boolean c(EntityHuman entityHuman) {
        if (this.getItem() == null) {
            ItemStack itemStack = entityHuman.aZ();
            if (itemStack != null && !this.world.isStatic) {
                this.setItem(itemStack);
                if (!entityHuman.abilities.canInstantlyBuild && --itemStack.count <= 0) {
                    entityHuman.inventory.setItem(entityHuman.inventory.itemInHandIndex, null);
                }
            }
        } else if (!this.world.isStatic) {
            this.setRotation(this.getRotation() + 1);
        }
        return true;
    }
}

